/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation.acceptor;

import com.streamscape.Trace;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.runtime.mf.operation.acceptor.AbstractSingleAcceptorOperation;
import com.streamscape.runtime.mf.operation.acceptor.AlterAcceptorOperation;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sef.network.http.acceptor.HTTPAcceptor;
import com.streamscape.sef.network.http.acceptor.HTTPAcceptorApplicationsUtils;
import com.streamscape.sef.network.mf.admin.AbstractAcceptorFactory;
import com.streamscape.sef.network.mf.admin.Acceptor;
import com.streamscape.sef.network.mf.admin.AcceptorFactory;
import com.streamscape.sef.network.mf.admin.AcceptorFactoryManager;
import com.streamscape.sef.utils.RepositoryUtils;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.DSLStatementSyntax;
import com.streamscape.slex.lang.modifier.Modifier;
import java.util.List;

public class RegisterAcceptorOperation
extends AbstractSingleAcceptorOperation {
    public static final String NAME = "register acceptor";

    public RegisterAcceptorOperation() {
        super(NAME, "Loads the specified acceptor configuration from the repository and registers this acceptor in the current node.\nCreates and registers a new acceptor with default parameters if the configuration does not exist in the repository.\nIf system option is specified, default rules for OS and RTAI applications will be added to HTTP acceptor configuration.");
    }

    @Override
    void setSyntax(String operationName) {
        this.syntax.setAction(operationName.toUpperCase());
        this.addActionParameter();
        this.syntax.addModifier(new Modifier("system", false));
    }

    @Override
    protected void doFillCompletionsList(DSLStatementSyntax.DSLStatementCompletion comp, MFSession session, List<String> completions) {
        try {
            AcceptorFactoryManager manager = ((RuntimeContext)this.callable).getAcceptorManager();
            for (String factoryName : manager.listRegisteredFactories()) {
                AcceptorFactory factory = manager.lookupFactory(factoryName);
                for (String objectName : RepositoryUtils.listObjects(factory.getNamespace())) {
                    if (factory.isAcceptorRegistered(objectName)) continue;
                    completions.add(factory.getAcceptorProtocol().name() + "." + objectName);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public SLResponse invoke(SLStatement statement, MFSession session, long timeout) throws Exception {
        Definition definition = (Definition)statement;
        AbstractAcceptorFactory factory = (AbstractAcceptorFactory)this.getFactory(definition);
        if (factory.existsObject(definition.getAcceptorName())) {
            factory.registerAcceptor(definition.getAcceptorName());
        } else {
            Acceptor acceptor = factory.createAcceptor(definition.getAcceptorName());
            if (acceptor instanceof HTTPAcceptor && definition.isSystem()) {
                try {
                    HTTPAcceptorApplicationsUtils.addRulesForOsAndDash(((HTTPAcceptor)acceptor).getConfiguration());
                }
                catch (Exception exception) {
                    Trace.logException(AlterAcceptorOperation.class, exception, true);
                }
            }
            factory.registerAcceptor(acceptor);
        }
        return new SLResponse();
    }

    @Override
    public Definition createDefinition(AbstractSingleAcceptorOperation.Definition.Protocol protocol, String acceptorName, DSLStatement statement) {
        return new Definition(NAME, protocol, acceptorName, statement.existsModifier("system"));
    }

    public static class Definition
    extends AbstractSingleAcceptorOperation.Definition {
        private final boolean system;

        Definition(String name, AbstractSingleAcceptorOperation.Definition.Protocol protocol, String acceptorName, boolean system) {
            super(name, protocol, acceptorName);
            this.system = system;
        }

        public boolean isSystem() {
            return this.system;
        }
    }
}

