/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation.acceptor;

import com.streamscape.runtime.RuntimeContext;
import com.streamscape.runtime.mf.operation.acceptor.AbstractAcceptorOperation;
import com.streamscape.sdo.operation.AbstractSLStatement;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sdo.rowset.RowMetaData;
import com.streamscape.sdo.rowset.RowSet;
import com.streamscape.sef.network.LinkAddress;
import com.streamscape.sef.network.LinkProtocol;
import com.streamscape.sef.network.http.acceptor.HTTPAcceptor;
import com.streamscape.sef.network.http.server.utils.HTTPSUtils;
import com.streamscape.sef.network.mf.admin.Acceptor;
import com.streamscape.sef.network.mf.admin.AcceptorFactory;
import com.streamscape.sef.network.mf.admin.AcceptorFactoryManager;
import com.streamscape.sef.network.mf.admin.CertificatesFactory;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.DSLStatement;
import java.security.cert.X509Certificate;

public class ListAcceptorsOperation
extends AbstractAcceptorOperation {
    public static final String NAME = "list acceptors";

    public ListAcceptorsOperation() {
        super(false);
        this.createDSLSyntax(NAME);
        this.syntax.setAction("LIST ACCEPTORS");
        this.syntax.setDescription("Returns a list of acceptors in the current node.");
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        return new Definition();
    }

    @Override
    public SLResponse invoke(SLStatement statement, MFSession session, long timeout) throws Exception {
        RowSet result = new RowSet(ListAcceptorsOperation.createResultDescriptor());
        AcceptorFactoryManager manager = ((RuntimeContext)this.callable).getAcceptorManager();
        for (String factoryName : manager.listRegisteredFactories()) {
            AcceptorFactory factory = manager.lookupFactory(factoryName);
            for (Acceptor acceptor : factory.getAcceptors()) {
                LinkAddress address = acceptor.getAddress();
                String certStr = "";
                if (acceptor.getProtocol().equals((Object)LinkProtocol.HTTP) || acceptor.getProtocol().equals((Object)LinkProtocol.HTTPS)) {
                    try {
                        X509Certificate cert = this.getCertificate((HTTPAcceptor)acceptor, CertificatesFactory.StoreType.KEYSTORE);
                        if (cert != null) {
                            certStr = HTTPSUtils.retrieveCertDescription(cert);
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                result.addToRowSet(new Object[]{acceptor.getProtocol().name(), acceptor.getName(), address != null ? address.getAddress().getHostName() : null, address != null ? Integer.valueOf(address.getAddress().getPort()) : null, certStr, acceptor.isValid(), acceptor.isStarted()});
            }
        }
        return new SLResponse(result);
    }

    static RowMetaData createResultDescriptor() {
        RowMetaData result = new RowMetaData();
        ListAcceptorsOperation.addColumn(result, "Protocol");
        ListAcceptorsOperation.addColumn(result, "Name");
        ListAcceptorsOperation.addColumn(result, "Host");
        ListAcceptorsOperation.addColumn(result, "Port");
        ListAcceptorsOperation.addColumn(result, "Certificate");
        ListAcceptorsOperation.addColumn(result, "Valid");
        ListAcceptorsOperation.addColumn(result, "Started");
        return result;
    }

    public static class Definition
    extends AbstractSLStatement {
        public Definition() {
            super(ListAcceptorsOperation.NAME);
        }
    }
}

