/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation.acceptor;

import com.streamscape.runtime.RuntimeContext;
import com.streamscape.runtime.mf.operation.acceptor.AbstractAlterDescribeOperation;
import com.streamscape.runtime.mf.operation.acceptor.AlterAcceptorOperation;
import com.streamscape.runtime.mf.operation.acceptor.describer.RuleDescriber;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sdo.rowset.RowMetaData;
import com.streamscape.sdo.rowset.RowSet;
import com.streamscape.sef.network.LinkProtocol;
import com.streamscape.sef.network.http.acceptor.HTTPAcceptor;
import com.streamscape.sef.network.http.acceptor.HTTPAcceptorApplication;
import com.streamscape.sef.network.http.acceptor.HTTPAcceptorApplicationsUtils;
import com.streamscape.sef.network.http.acceptor.HTTPAcceptorConfiguration;
import com.streamscape.sef.network.http.server.apicustomizer.APICustomizerConfiguration;
import com.streamscape.sef.network.http.server.apicustomizer.APICustomizerException;
import com.streamscape.sef.network.http.server.apicustomizer.APICustomizerImporterExporter;
import com.streamscape.sef.network.http.server.apicustomizer.AbstractRule;
import com.streamscape.sef.network.http.server.apicustomizer.CustomizerRuleCreator;
import com.streamscape.sef.network.http.server.config.RealmInfo;
import com.streamscape.sef.network.http.server.config.ServletInfo;
import com.streamscape.sef.network.http.server.cors.Origin;
import com.streamscape.sef.network.http.server.cors.OriginAccessControlConfiguration;
import com.streamscape.sef.network.http.server.jetty.JettyAdvancedProperties;
import com.streamscape.sef.network.http.server.utils.HTTPSUtils;
import com.streamscape.sef.network.mf.admin.Acceptor;
import com.streamscape.sef.network.mf.admin.AcceptorFactory;
import com.streamscape.sef.network.mf.admin.CertificatesFactory;
import com.streamscape.sef.network.tlp.IncomingConnectionChannel;
import com.streamscape.sef.network.tlp.OutgoingConnectionChannel;
import com.streamscape.sef.network.tlp.SocketConfiguration;
import com.streamscape.sef.network.tlp.acceptor.TLPAcceptor;
import com.streamscape.sef.network.xmpp.acceptor.XMPPAcceptor;
import com.streamscape.sef.network.xmpp.acceptor.XMPPAcceptorConfiguration;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.file.SLFileUtils;
import com.streamscape.slex.file.SLFileUtilsFactory;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.completion.CompletionAdviser;
import com.streamscape.slex.lang.modifier.AbstractModifier;
import com.streamscape.slex.lang.modifier.ChoiceModifier;
import com.streamscape.slex.lang.modifier.CompoundModifier;
import com.streamscape.slex.lang.modifier.Modifier;
import com.streamscape.slex.lang.parameter.IdentifierParameter;
import com.streamscape.slex.lang.parameter.LocalPathParameter;
import com.streamscape.slex.lang.parameter.SetParameter;
import com.streamscape.slex.lang.parameter.StringParameter;
import com.streamscape.slex.lang.parameter.SyntaxParameter;
import java.math.BigInteger;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.sql.SQLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import sun.security.rsa.RSAPublicKeyImpl;

public class DescribeAcceptorOperation
extends AbstractAlterDescribeOperation {
    public static final String NAME = "describe acceptor";

    public DescribeAcceptorOperation() {
        super(NAME, "Shows information about the specified acceptor.");
    }

    @Override
    protected void setSyntax(String operationName) {
        super.setSyntax(operationName);
        ChoiceModifier choiceModifier = new ChoiceModifier("DescribeAcceptorChoiceModifier");
        choiceModifier.addModifier(DescribeAcceptorOperation.createAcceptorNameModifier(LinkProtocol.TLP));
        choiceModifier.addModifier(DescribeAcceptorOperation.createAcceptorNameModifier(LinkProtocol.HTTP).addModifier((AbstractModifier)((ChoiceModifier)((ChoiceModifier)((ChoiceModifier)((ChoiceModifier)((ChoiceModifier)((ChoiceModifier)((ChoiceModifier)((ChoiceModifier)((ChoiceModifier)((ChoiceModifier)((ChoiceModifier)((ChoiceModifier)((ChoiceModifier)((ChoiceModifier)((ChoiceModifier)new ChoiceModifier("httpAdditionalOptions", false).addModifier(new Modifier("realms"))).addModifier(new Modifier("servlets"))).addModifier(new Modifier("url aliases"))).addModifier(new Modifier("origins"))).addModifier(new Modifier("oauth delegates"))).addModifier(new Modifier("advanced properties"))).addModifier(new CompoundModifier("API_CUSTOMIZER_EXPORT_COMPOUND").addModifier(new Modifier("export customizer")).addModifier((AbstractModifier)((Modifier)new Modifier("TO FILE").addParameter(new StringParameter("jsonFilePath"))).setRequired(false)).addModifier((AbstractModifier)((Modifier)new Modifier("INCLUDE RULE IDS").addParameter(new SetParameter("RULE_IDS_SET").addParameter(new StringParameter("ruleId")))).setRequired(false)).addModifier((AbstractModifier)((Modifier)new Modifier("INCLUDE RULE TYPES").addParameter(new SetParameter("RULE_TYPES_SET").addParameter(new StringParameter("ruleType")))).setRequired(false)))).addModifier((AbstractModifier)new Modifier("customizer rule id").addParameter(new StringParameter("id")))).addModifier(new Modifier("customizer rule types"))).addModifier((AbstractModifier)new Modifier("customizer rule type").addParameter(new RuleTypeParameter()))).addModifier(new Modifier("customizer"))).addModifier(new Modifier("keystore"))).addModifier(new Modifier("truststore"))).addModifier(new CompoundModifier("exportStore").addModifier(new Modifier("EXPORT")).addModifier(new ChoiceModifier("exportStoreChoiceModifier").addPossibleValues("keystore TO", "truststore TO")).addParameter(new LocalPathParameter("storePath")))).addModifier((AbstractModifier)new Modifier("app").addParameter((SyntaxParameter)((StringParameter)new StringParameter("app name").setName("appName")).setCompletionAdviser(new AlterAcceptorOperation.AcceptorApplicationNameCompletionAdviser())))).addModifier(new Modifier("apps"))));
        choiceModifier.addModifier(DescribeAcceptorOperation.createAcceptorNameModifier(LinkProtocol.XMPP));
        this.syntax.addModifier(choiceModifier);
        this.syntax.setExamples("describe acceptor HTTP.Default customizer\ndescribe acceptor HTTP.Default customizer rule id 'GET-myos'\ndescribe acceptor HTTP.Default customizer rule types\ndescribe acceptor HTTP.Default customizer rule type AnyRule\n\ndescribe acceptor HTTP.Default export customizer\ndescribe acceptor HTTP.Default export customizer to file 'myrules.json'\ndescribe acceptor HTTP.Default export customizer to 'myrules.json' include types('AnyRyle')\ndescribe acceptor HTTP.Default export customizer to 'myrules.json' include ids('POST-/myurl')\n");
    }

    @Override
    protected AbstractAlterDescribeOperation.Definition createDefinition(LinkProtocol protocol, String acceptorName, DSLStatement statement) {
        return new AbstractAlterDescribeOperation.Definition(NAME, protocol, acceptorName, statement);
    }

    @Override
    public SLResponse invoke(SLStatement statement, MFSession session, long timeout) throws Exception {
        RowSet result;
        AbstractAlterDescribeOperation.Definition definition = (AbstractAlterDescribeOperation.Definition)statement;
        AcceptorFactory factory = ((RuntimeContext)this.callable).getAcceptorManager().lookupFactory(DescribeAcceptorOperation.getFactoryName(definition.getProtocol()));
        if (factory == null) {
            throw new Exception("Protocol not found.");
        }
        Acceptor acceptor = factory.lookupAcceptor(definition.getAcceptorName());
        if (acceptor == null) {
            throw new Exception("Acceptor not found.");
        }
        String modifier = DescribeAcceptorOperation.getPropertyModifier(definition);
        if ((acceptor.getProtocol().equals((Object)LinkProtocol.HTTP) || acceptor.getProtocol().equals((Object)LinkProtocol.HTTPS)) && !"basic".equals(modifier)) {
            result = new RowSet(DescribeAcceptorOperation.createResultDescriptor(modifier));
            HTTPAcceptor httpAcceptor = (HTTPAcceptor)acceptor;
            switch (modifier) {
                case "realms": {
                    DescribeAcceptorOperation.addRealmsPropertyToResult(result, httpAcceptor);
                    break;
                }
                case "servlets": {
                    DescribeAcceptorOperation.addServletsPropertyToResult(result, httpAcceptor);
                    break;
                }
                case "url aliases": {
                    DescribeAcceptorOperation.addUrlToPathAliasesPropertyToResult(result, httpAcceptor);
                    break;
                }
                case "origins": {
                    DescribeAcceptorOperation.addOriginsPropertyToResult(result, httpAcceptor);
                    break;
                }
                case "advanced properties": {
                    DescribeAcceptorOperation.addAdvancedPropertyToResult(result, httpAcceptor);
                    break;
                }
                case "oauth delegates": {
                    DescribeAcceptorOperation.addOAuthDelegatesPropertyToResult(result, httpAcceptor);
                    break;
                }
                case "customizer": {
                    DescribeAcceptorOperation.addApiCustomizerPropertyToResult(result, httpAcceptor);
                    break;
                }
                case "export customizer": {
                    Set<String> includeRuleIds = definition.getStatement().getSet("RULE_IDS_SET").getElements().stream().map(e -> e.getParameter("ruleId").getValue()).collect(Collectors.toSet());
                    Set<String> includeRuleTypes = definition.getStatement().getSet("RULE_TYPES_SET").getElements().stream().map(e -> e.getParameter("ruleType").getValue()).collect(Collectors.toSet());
                    return this.exportCustomizerConfiguration(session, httpAcceptor, definition.getStatement().getParameter("jsonFilePath").getValue(), includeRuleIds, includeRuleTypes);
                }
                case "customizer rule types": {
                    DescribeAcceptorOperation.addApiCustomizerTypesToResult(result, httpAcceptor);
                    break;
                }
                case "customizer rule id": {
                    String ruleId = definition.getStatement().getParameter("id").getValue();
                    DescribeAcceptorOperation.addDetailedApiCustomizerPropertyToResult(result, ruleId, httpAcceptor);
                    break;
                }
                case "customizer rule type": {
                    String typeName = definition.getStatement().getParameter("type").getValue();
                    DescribeAcceptorOperation.addApiCustomizerTypeToResult(result, typeName, httpAcceptor);
                    break;
                }
                case "keystore": {
                    this.addStorePropertyToResult(result, httpAcceptor, CertificatesFactory.StoreType.KEYSTORE);
                    break;
                }
                case "truststore": {
                    this.addStorePropertyToResult(result, httpAcceptor, CertificatesFactory.StoreType.TRUSTSTORE);
                    break;
                }
                case "exportStore": {
                    String storeTo = definition.getStatement().getModifier("exportStoreChoiceModifier").getToken();
                    CertificatesFactory.StoreType type = CertificatesFactory.StoreType.KEYSTORE;
                    if (storeTo.startsWith("truststore")) {
                        type = CertificatesFactory.StoreType.TRUSTSTORE;
                    }
                    String storePath = definition.getStatement().getParameter("storePath").getValue();
                    this.exportStore(session, httpAcceptor, type, storePath);
                    result = null;
                    break;
                }
                case "apps": {
                    this.describeApps(result, httpAcceptor);
                    break;
                }
                case "app": {
                    this.describeApp(result, httpAcceptor, definition.getStatement().getParameter("appName").getValue());
                    break;
                }
                default: {
                    throw new Exception("Unknown modifier.");
                }
            }
        } else {
            result = new RowSet(DescribeAcceptorOperation.createResultDescriptor("basic"));
            DescribeAcceptorOperation.addGeneralPropertyToResult(result, acceptor);
            switch (acceptor.getProtocol()) {
                case TLP: 
                case TLPS: {
                    DescribeAcceptorOperation.addTLPPropertyToResult(result, (TLPAcceptor)acceptor);
                    break;
                }
                case HTTP: 
                case HTTPS: {
                    DescribeAcceptorOperation.addHTTPPropertyToResult(result, (HTTPAcceptor)acceptor);
                    break;
                }
                case XMPP: 
                case XMPPS: {
                    DescribeAcceptorOperation.addXMPPPropertyToResult(result, (XMPPAcceptor)acceptor);
                    break;
                }
                default: {
                    return new SLResponse("Unknown acceptor protocol.", false);
                }
            }
        }
        return new SLResponse(result);
    }

    private static String getPropertyModifier(AbstractAlterDescribeOperation.Definition definition) {
        String modifier = "basic";
        if (definition.getStatement().existsModifier("realms")) {
            modifier = "realms";
        } else if (definition.getStatement().existsModifier("servlets")) {
            modifier = "servlets";
        } else if (definition.getStatement().existsModifier("url aliases")) {
            modifier = "url aliases";
        } else if (definition.getStatement().existsModifier("origins")) {
            modifier = "origins";
        } else if (definition.getStatement().existsModifier("oauth delegates")) {
            modifier = "oauth delegates";
        } else if (definition.getStatement().existsModifier("advanced properties")) {
            modifier = "advanced properties";
        } else if (definition.getStatement().existsModifier("customizer")) {
            modifier = "customizer";
        } else if (definition.getStatement().existsModifier("customizer rule types")) {
            modifier = "customizer rule types";
        } else if (definition.getStatement().existsModifier("customizer rule id")) {
            modifier = "customizer rule id";
        } else if (definition.getStatement().existsModifier("customizer rule type")) {
            modifier = "customizer rule type";
        } else if (definition.getStatement().existsModifier("export customizer")) {
            modifier = "export customizer";
        } else if (definition.getStatement().existsModifier("keystore")) {
            modifier = "keystore";
        } else if (definition.getStatement().existsModifier("truststore")) {
            modifier = "truststore";
        } else if (definition.getStatement().existsModifier("exportStoreChoiceModifier")) {
            modifier = "exportStore";
        } else if (definition.getStatement().existsModifier("apps")) {
            modifier = "apps";
        } else if (definition.getStatement().existsModifier("app")) {
            modifier = "app";
        }
        return modifier;
    }

    private static RowMetaData createResultDescriptor(String modifier) {
        RowMetaData result = new RowMetaData();
        switch (modifier) {
            case "realms": {
                DescribeAcceptorOperation.addColumn(result, "Path");
                DescribeAcceptorOperation.addColumn(result, "Name");
                DescribeAcceptorOperation.addColumn(result, "Users");
                DescribeAcceptorOperation.addColumn(result, "Groups");
                break;
            }
            case "servlets": {
                DescribeAcceptorOperation.addColumn(result, "Path");
                DescribeAcceptorOperation.addColumn(result, "Class");
                DescribeAcceptorOperation.addColumn(result, "Params");
                break;
            }
            case "url aliases": {
                DescribeAcceptorOperation.addColumn(result, "URL");
                DescribeAcceptorOperation.addColumn(result, "Path");
                break;
            }
            case "origins": {
                DescribeAcceptorOperation.addColumn(result, "Origin");
                DescribeAcceptorOperation.addColumn(result, "Enabled");
                DescribeAcceptorOperation.addColumn(result, "Allow Credentials");
                DescribeAcceptorOperation.addColumn(result, "Allowed Headers");
                DescribeAcceptorOperation.addColumn(result, "Allowed Methods");
                DescribeAcceptorOperation.addColumn(result, "Exposed Headers");
                DescribeAcceptorOperation.addColumn(result, "Max Age");
                break;
            }
            case "oauth delegates": {
                DescribeAcceptorOperation.addColumn(result, "Delegate");
                break;
            }
            case "customizer": {
                DescribeAcceptorOperation.addColumn(result, "Rule Type");
                DescribeAcceptorOperation.addColumn(result, "External URI");
                DescribeAcceptorOperation.addColumn(result, "HTTP Method");
                DescribeAcceptorOperation.addColumn(result, "ID");
                break;
            }
            case "customizer rule types": {
                DescribeAcceptorOperation.addColumn(result, "Rule Type");
                break;
            }
            case "customizer rule id": {
                DescribeAcceptorOperation.addColumn(result, "Property");
                DescribeAcceptorOperation.addColumn(result, "Property Name");
                DescribeAcceptorOperation.addColumn(result, "Value");
                break;
            }
            case "customizer rule type": {
                DescribeAcceptorOperation.addColumn(result, "Property");
                DescribeAcceptorOperation.addColumn(result, "Property Name");
                break;
            }
            case "advanced properties": {
                DescribeAcceptorOperation.addColumn(result, "Property Name");
                DescribeAcceptorOperation.addColumn(result, "Description");
                DescribeAcceptorOperation.addColumn(result, "Value");
                DescribeAcceptorOperation.addColumn(result, "Units");
                break;
            }
            case "keystore": 
            case "truststore": {
                DescribeAcceptorOperation.addColumn(result, "Property");
                DescribeAcceptorOperation.addColumn(result, "Value");
                break;
            }
            case "apps": {
                DescribeAcceptorOperation.addColumn(result, "Name");
                DescribeAcceptorOperation.addColumn(result, "CID");
                DescribeAcceptorOperation.addColumn(result, "URI");
                DescribeAcceptorOperation.addColumn(result, "Full URI");
                DescribeAcceptorOperation.addColumn(result, "Default URI");
                DescribeAcceptorOperation.addColumn(result, "Customizer Rules Errors");
                break;
            }
            case "app": {
                DescribeAcceptorOperation.addColumn(result, "Property");
                DescribeAcceptorOperation.addColumn(result, "Value");
                break;
            }
            default: {
                DescribeAcceptorOperation.addColumn(result, "Property");
                DescribeAcceptorOperation.addColumn(result, "Value");
                DescribeAcceptorOperation.addColumn(result, "Editable");
            }
        }
        return result;
    }

    private static void addToResult(RowSet result, String propertyName, Object propertyValue, String editName) throws Exception {
        result.addToRowSet(new Object[]{propertyName, propertyValue, editName != null ? editName : "-"});
    }

    private static void addToResult(RowSet result, String propertyName, Object propertyValue) throws Exception {
        DescribeAcceptorOperation.addToResult(result, propertyName, propertyValue, null);
    }

    private static void addGeneralPropertyToResult(RowSet result, Acceptor acceptor) throws Exception {
        DescribeAcceptorOperation.addToResult(result, "Protocol", (Object)acceptor.getProtocol());
        DescribeAcceptorOperation.addToResult(result, "Name", acceptor.getName());
        DescribeAcceptorOperation.addToResult(result, "Description", acceptor.getDescription(), "description");
        DescribeAcceptorOperation.addToResult(result, "URL", acceptor.getURL(), "url");
        DescribeAcceptorOperation.addToResult(result, "Auto Start", acceptor.autoStart(), "autoStart");
        DescribeAcceptorOperation.addToResult(result, "Abort On Failure", acceptor.abortOnFailure(), "abortOnFailure");
        DescribeAcceptorOperation.addToResult(result, "Anonymous Registration", acceptor.anonymousRegistration(), "anonymousRegistration");
    }

    private static void addTLPPropertyToResult(RowSet result, TLPAcceptor acceptor) throws Exception {
        DescribeAcceptorOperation.addToResult(result, "Keep Alive", acceptor.keepAlive(), "keepAlive");
        DescribeAcceptorOperation.addToResult(result, "Enable SSL", acceptor.enableSSL(), "enableSSL");
        OutgoingConnectionChannel out = acceptor.getOutgoingConnectionChannel();
        DescribeAcceptorOperation.addToResult(result, "Outgoing Channel: Type", (Object)out.getChannelType());
        DescribeAcceptorOperation.addToResult(result, "Outgoing Channel: Writer Flush Delay", out.getWriterFlushDelay(), "outgoingChannel.writerFlushDelay");
        DescribeAcceptorOperation.addToResult(result, "Outgoing Channel: Writer Buffer Size", out.getWriterBufferSize(), "outgoingChannel.writerBufferSize");
        DescribeAcceptorOperation.addToResult(result, "Outgoing Channel: Streaming Threshold", out.getWriterBufferSize(), "outgoingChannel.streamingThreshold");
        SocketConfiguration outSocketConfig = out.getSocketConfiguration();
        DescribeAcceptorOperation.addToResult(result, "Outgoing Channel Socket: Receive Buffer Size", outSocketConfig.receiveBufferSize, "outgoingChannel.socketConfiguration.receiveBufferSize");
        DescribeAcceptorOperation.addToResult(result, "Outgoing Channel Socket: Send Buffer Size", outSocketConfig.sendBufferSize, "outgoingChannel.socketConfiguration.sendBufferSize");
        DescribeAcceptorOperation.addToResult(result, "Outgoing Channel Socket: Traffic Class", outSocketConfig.trafficClass, "outgoingChannel.socketConfiguration.trafficClass");
        DescribeAcceptorOperation.addToResult(result, "Outgoing Channel Socket: Tcp No Delay", outSocketConfig.tcpNoDelay, "outgoingChannel.socketConfiguration.tcpNoDelay");
        IncomingConnectionChannel in = acceptor.getIncomingConnectionChannel();
        DescribeAcceptorOperation.addToResult(result, "Incoming Channel: Type", (Object)in.getChannelType());
        DescribeAcceptorOperation.addToResult(result, "Incoming Channel: Reader Buffer Size", in.getReaderBufferSize(), "incomingChannel.readerBufferSize");
        SocketConfiguration inSocketConfig = in.getSocketConfiguration();
        DescribeAcceptorOperation.addToResult(result, "Incoming Channel Socket: Receive Buffer Size", inSocketConfig.receiveBufferSize, "incomingChannel.socketConfiguration.receiveBufferSize");
        DescribeAcceptorOperation.addToResult(result, "Incoming Channel Socket: Send Buffer Size", inSocketConfig.sendBufferSize, "incomingChannel.socketConfiguration.sendBufferSize");
        DescribeAcceptorOperation.addToResult(result, "Incoming Channel Socket: Traffic Class", inSocketConfig.trafficClass, "incomingChannel.socketConfiguration.trafficClass");
        DescribeAcceptorOperation.addToResult(result, "Incoming Channel Socket: Tcp No Delay", inSocketConfig.tcpNoDelay, "incomingChannel.socketConfiguration.tcpNoDelay");
        DescribeAcceptorOperation.addToResult(result, "Modified On", DescribeAcceptorOperation.formatDate(acceptor.getTimestamp()));
    }

    private static void addHTTPPropertyToResult(RowSet result, HTTPAcceptor acceptor) throws Exception {
        HTTPAcceptorConfiguration configuration = acceptor.getConfiguration();
        DescribeAcceptorOperation.addToResult(result, "Log Each Request", configuration.getLogEachRequest(), "logEachRequest");
        DescribeAcceptorOperation.addToResult(result, "Log Extended", configuration.getLogExtended(), "logExtended");
        DescribeAcceptorOperation.addToResult(result, "Log Date Format", configuration.getLogDateFormat(), "logDateFormat");
        DescribeAcceptorOperation.addToResult(result, "Compress Response", configuration.getCompressResponse(), "compressResponse");
        DescribeAcceptorOperation.addToResult(result, "Store Session", configuration.getStoreSessions(), "storeSessions");
        DescribeAcceptorOperation.addToResult(result, "Web Application Directory", configuration.getWebApplicationDir(), "webApplicationDir");
        DescribeAcceptorOperation.addToResult(result, "Web Archive Directory", configuration.getWebArchiveDir(), "webArchiveDir");
        DescribeAcceptorOperation.addToResult(result, "Keep Alive Timeout", configuration.getKeepAliveTimeout(), "keepAliveTimeout");
        DescribeAcceptorOperation.addToResult(result, "Session Timeout", configuration.getSessionTimeout(), "sessionTimeout");
        DescribeAcceptorOperation.addToResult(result, "Maximum Number of Active Sessions", configuration.getMaxActiveSessionsNumber(), "maxActiveSessionsNumber");
        DescribeAcceptorOperation.addToResult(result, "Authentication Type", (Object)configuration.getAuthenticationType(), "authenticationType");
        DescribeAcceptorOperation.addToResult(result, "Session Authentication", configuration.getSessionAuthentication(), "sessionAuthentication");
        DescribeAcceptorOperation.addToResult(result, "Enable SSL", configuration.getEnableSSL(), "enableSSL");
        DescribeAcceptorOperation.addToResult(result, "Key Store Password", "********", "keyStorePassword");
        DescribeAcceptorOperation.addToResult(result, "Request Trigger Enabled", configuration.isRequestTriggerEnabled(), "requestTriggerEnabled");
        DescribeAcceptorOperation.addToResult(result, "Enable Dropbox", configuration.isEnableDropBox(), "enableDropBox");
        String realms = Optional.ofNullable(configuration.getRealms()).map(HashMap::keySet).map(s -> s.stream().collect(Collectors.joining("\n"))).orElse("");
        String servlets = Optional.ofNullable(configuration.getServlets()).map(l -> l.stream().map(ServletInfo::getServletPath).collect(Collectors.joining("\n"))).orElse("");
        String urlToPathAliases = Optional.ofNullable(configuration.getUrlToPathAliases()).map(HashMap::keySet).map(s -> s.stream().collect(Collectors.joining("\n"))).orElse("");
        boolean crossOriginEnabled = Optional.ofNullable(configuration.getOriginAccessControlConfiguration()).map(OriginAccessControlConfiguration::getOrigins).map(l -> l.stream().anyMatch(Origin::isEnabled)).orElse(false);
        String apiCustomizer = Optional.ofNullable(configuration.getAPICustomizerConfiguration()).map(APICustomizerConfiguration::listAllRules).filter(l -> !l.isEmpty()).map(l -> "...").orElse("");
        String oAuthDelegates = Optional.ofNullable(configuration.getOAuthDelegates()).filter(l -> !l.isEmpty()).map(l -> "...").orElse("");
        String advancedProperties = Optional.ofNullable(configuration.getAdvancedProperties()).filter(p -> !p.isEmpty()).map(p -> "...").orElse("");
        DescribeAcceptorOperation.addToResult(result, "Realms", realms);
        DescribeAcceptorOperation.addToResult(result, "Servlets", servlets);
        DescribeAcceptorOperation.addToResult(result, "URL to Path Aliases", urlToPathAliases);
        DescribeAcceptorOperation.addToResult(result, "Cross Origins Enabled", crossOriginEnabled);
        DescribeAcceptorOperation.addToResult(result, "API Customizer", apiCustomizer);
        DescribeAcceptorOperation.addToResult(result, "OAuth Delegates", oAuthDelegates);
        DescribeAcceptorOperation.addToResult(result, "Advanced Properties", advancedProperties);
        DescribeAcceptorOperation.addToResult(result, "Modified On", DescribeAcceptorOperation.formatDate(configuration.getTimestamp()));
    }

    private static void addXMPPPropertyToResult(RowSet result, XMPPAcceptor acceptor) throws Exception {
        XMPPAcceptorConfiguration configuration = acceptor.getConfiguration();
        DescribeAcceptorOperation.addToResult(result, "Event Scope", (Object)configuration.getEventScope(), "eventScope");
        DescribeAcceptorOperation.addToResult(result, "Maximum Threads in Pool", configuration.getMaxThreadsInPool(), "maxThreadsInPool");
        DescribeAcceptorOperation.addToResult(result, "BackLog Size", configuration.getBacklogSize(), "backlogSize");
        DescribeAcceptorOperation.addToResult(result, "Modified On", DescribeAcceptorOperation.formatDate(configuration.getTimestamp()));
    }

    private static void addAdvancedPropertyToResult(RowSet result, HTTPAcceptor acceptor) {
        Properties advancedProperties = acceptor.getConfiguration().getAdvancedProperties();
        JettyAdvancedProperties.getDefaultPropertiesInfo().entrySet().forEach(entry -> {
            String key = (String)entry.getKey();
            JettyAdvancedProperties.PropertyInfo info = (JettyAdvancedProperties.PropertyInfo)entry.getValue();
            String value = advancedProperties.getProperty(key);
            try {
                result.addToRowSet(new Object[]{key, info.getDescription(), value, info.getUnits()});
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        });
    }

    private static void addRealmsPropertyToResult(RowSet result, HTTPAcceptor acceptor) {
        acceptor.getConfiguration().getRealms().entrySet().forEach(entry -> {
            String path = (String)entry.getKey();
            RealmInfo info = (RealmInfo)entry.getValue();
            try {
                result.addToRowSet(new Object[]{path, info.getRealmName(), info.listUsers() != null ? info.listUsers().stream().collect(Collectors.joining(", ")) : "", info.listGroups() != null ? info.listGroups().stream().collect(Collectors.joining(", ")) : ""});
            }
            catch (SQLException exception) {
                throw new RuntimeException(exception);
            }
        });
    }

    private void addStorePropertyToResult(RowSet result, HTTPAcceptor acceptor, CertificatesFactory.StoreType type) throws Exception {
        X509Certificate cert = this.getCertificate(acceptor, type);
        result.addToRowSet(new Object[]{"Version", cert.getVersion()});
        result.addToRowSet(new Object[]{"Subject", cert.getSubjectDN()});
        result.addToRowSet(new Object[]{"Issuer", cert.getIssuerDN()});
        result.addToRowSet(new Object[]{"Serial Number", cert.getSerialNumber()});
        result.addToRowSet(new Object[]{"Valid From", cert.getNotBefore()});
        result.addToRowSet(new Object[]{"Valid Until", cert.getNotAfter()});
        PublicKey pub = cert.getPublicKey();
        String pubStr = "Sun " + pub.getAlgorithm();
        if (pub != null && pub instanceof RSAPublicKeyImpl) {
            BigInteger n = ((RSAPublicKeyImpl)cert.getPublicKey()).getModulus();
            pubStr = pubStr + " public key, " + n.bitLength() + " bits";
        }
        result.addToRowSet(new Object[]{"Public Key", pubStr});
        result.addToRowSet(new Object[]{"Signature Algorithm", cert.getSigAlgName()});
    }

    private void exportStore(MFSession session, HTTPAcceptor acceptor, CertificatesFactory.StoreType type, String storePath) throws Exception {
        String storeFile = storePath + "/" + HTTPSUtils.getStoreFilename(acceptor, type);
        SLFileUtils file = (SLFileUtils)new SLFileUtilsFactory().create(session, storeFile);
        file.createFile(storeFile, this.getRepoStoreBytes(acceptor, type), true);
    }

    private SLResponse exportCustomizerConfiguration(MFSession session, HTTPAcceptor acceptor, String jsonFilePath, Set<String> includeRuleIds, Set<String> includeRuleTypes) throws Exception {
        String json = APICustomizerImporterExporter.exportToJson(acceptor.getConfiguration().getAPICustomizerConfiguration(), includeRuleIds, includeRuleTypes);
        if (jsonFilePath != null) {
            SLFileUtils file = (SLFileUtils)new SLFileUtilsFactory().create(session, jsonFilePath);
            file.createFile(jsonFilePath, json.getBytes(), true);
            return new SLResponse();
        }
        return new SLResponse(json);
    }

    private static void addServletsPropertyToResult(RowSet result, HTTPAcceptor acceptor) {
        acceptor.getConfiguration().getServlets().forEach(servletInfo -> {
            try {
                result.addToRowSet(new Object[]{servletInfo.getServletPath(), servletInfo.getClassName(), servletInfo.getParameters().entrySet().stream().map(entry -> (String)entry.getKey() + "=" + (String)entry.getValue()).collect(Collectors.joining("\n"))});
            }
            catch (SQLException exception) {
                throw new RuntimeException(exception);
            }
        });
    }

    private static void addUrlToPathAliasesPropertyToResult(RowSet result, HTTPAcceptor acceptor) {
        acceptor.getConfiguration().getUrlToPathAliases().entrySet().forEach(entry -> {
            try {
                result.addToRowSet(new Object[]{entry.getKey(), entry.getValue()});
            }
            catch (SQLException exception) {
                throw new RuntimeException(exception);
            }
        });
    }

    private static void addOriginsPropertyToResult(RowSet result, HTTPAcceptor acceptor) {
        acceptor.getConfiguration().getOriginAccessControlConfiguration().getOrigins().forEach(origin -> {
            try {
                result.addToRowSet(new Object[]{origin.getOrigin(), origin.isEnabled(), origin.isAllowCredentials(), origin.getAllowedHeaders(), origin.getAllowedMethods(), origin.getExposedHeaders(), origin.getMaxAge()});
            }
            catch (SQLException exception) {
                throw new RuntimeException(exception);
            }
        });
    }

    private static void addOAuthDelegatesPropertyToResult(RowSet result, HTTPAcceptor acceptor) {
        acceptor.getConfiguration().getOAuthDelegates().forEach(delegate -> {
            try {
                result.addToRowSet(new Object[]{delegate});
            }
            catch (SQLException exception) {
                throw new RuntimeException(exception);
            }
        });
    }

    private static void addApiCustomizerPropertyToResult(RowSet result, HTTPAcceptor acceptor) throws Exception {
        acceptor.getConfiguration().getAPICustomizerConfiguration().listAllRules().forEach(rule -> {
            try {
                result.addToRowSet(new Object[]{DescribeAcceptorOperation.getApiCustomizerRuleType(rule), rule.getExternalURI(), rule.getHttpMethod(), rule.getRuleId()});
            }
            catch (SQLException exception) {
                throw new RuntimeException(exception);
            }
        });
    }

    private static void addApiCustomizerTypesToResult(RowSet result, HTTPAcceptor acceptor) throws Exception {
        for (String ruleType : CustomizerRuleCreator.listRuleTypes()) {
            result.addToRowSet(new Object[]{ruleType});
        }
    }

    private static String getApiCustomizerRuleType(AbstractRule rule) {
        return rule.getClass().getSimpleName();
    }

    private static void addApiCustomizerTypeToResult(RowSet result, String typeName, HTTPAcceptor acceptor) throws Exception {
        RuleDescriber describer = RuleDescriber.createRuleDescriber(CustomizerRuleCreator.createRule(typeName, new HashMap<String, String>()));
        List<Object> properties = describer != null ? describer.getRuleProperties() : Collections.emptyList();
        properties.forEach(info -> {
            try {
                result.addToRowSet(new Object[]{info.getAlias(), info.getName()});
            }
            catch (SQLException exception) {
                throw new RuntimeException(exception);
            }
        });
    }

    private static void addDetailedApiCustomizerPropertyToResult(RowSet result, String ruleId, HTTPAcceptor acceptor) throws Exception {
        Optional<AbstractRule> ruleOption = acceptor.getConfiguration().getAPICustomizerConfiguration().listAllRules().stream().filter(r -> r.getRuleId().equals(ruleId)).findFirst();
        if (!ruleOption.isPresent()) {
            throw new Exception("Rule with id '" + ruleId + "' not found");
        }
        AbstractRule rule = ruleOption.get();
        RuleDescriber describer = RuleDescriber.createRuleDescriber(rule);
        List<Object> properties = describer != null ? describer.getRuleProperties() : Collections.emptyList();
        properties.forEach(info -> {
            try {
                result.addToRowSet(new Object[]{info.getAlias(), info.getName(), info.getValue() != null ? info.getValue() : ""});
            }
            catch (SQLException exception) {
                throw new RuntimeException(exception);
            }
        });
    }

    private void describeApps(RowSet result, HTTPAcceptor httpAcceptor) throws APICustomizerException, SQLException {
        for (HTTPAcceptorApplication application : httpAcceptor.getConfiguration().getApplications()) {
            List<String> errors = HTTPAcceptorApplicationsUtils.checkApplicationRules(httpAcceptor.getConfiguration(), application);
            result.addToRowSet(new Object[]{application.getName(), application.getCid(), application.getUrl(), "/" + application.getRelativeUrl("dashboard"), "/rtai/?rtai=" + application.getCid(), errors.size() > 0 ? errors.stream().collect(Collectors.joining("\n")) : ""});
        }
    }

    private void describeApp(RowSet result, HTTPAcceptor httpAcceptor, String applicationName) throws Exception {
        HTTPAcceptorApplication application = httpAcceptor.getConfiguration().getApplications().stream().filter(a -> a.getName().equals(applicationName)).findAny().orElse(null);
        if (application == null) {
            throw new Exception("Application with name " + applicationName + " not found");
        }
        List<String> errors = HTTPAcceptorApplicationsUtils.checkApplicationRules(httpAcceptor.getConfiguration(), application);
        result.addToRowSet(new Object[]{"Name", application.getName()});
        result.addToRowSet(new Object[]{"CID", application.getCid()});
        result.addToRowSet(new Object[]{"URI", application.getUrl()});
        result.addToRowSet(new Object[]{"Full URI", "/" + application.getRelativeUrl("dashboard")});
        result.addToRowSet(new Object[]{"Default URI", "/rtai/?rtai=" + application.getCid()});
        result.addToRowSet(new Object[]{"Customizer Rules", HTTPAcceptorApplicationsUtils.listApplicationRules(httpAcceptor.getConfiguration(), application).stream().map(r -> r.getExternalURI()).collect(Collectors.joining("\n"))});
        result.addToRowSet(new Object[]{"Customizer Rules Errors", errors.size() > 0 ? errors.stream().collect(Collectors.joining("\n")) : ""});
    }

    public static class RuleTypeParameter
    extends IdentifierParameter {
        public RuleTypeParameter() {
            super("type");
            this.setCompletionAdviser(new CompletionAdviser<Object>(this){

                @Override
                public List<String> getCompletions(String script, String processedScript, Object callable, MFSession session) {
                    return CustomizerRuleCreator.listRuleTypes();
                }

                @Override
                public boolean isCaseSensitive() {
                    return true;
                }
            });
        }
    }
}

