/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation.acceptor;

import com.streamscape.Trace;
import com.streamscape.lib.utils.FileIOUtils;
import com.streamscape.lib.utils.Pair;
import com.streamscape.lib.utils.StringUtils;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.runtime.mf.operation.AtModifier;
import com.streamscape.runtime.mf.operation.acceptor.AbstractAlterDescribeOperation;
import com.streamscape.runtime.mf.operation.acceptor.DescribeAcceptorOperation;
import com.streamscape.runtime.mf.operation.acceptor.describer.RuleDescriber;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sef.enums.EventScope;
import com.streamscape.sef.network.LinkProtocol;
import com.streamscape.sef.network.http.acceptor.HTTPAcceptor;
import com.streamscape.sef.network.http.acceptor.HTTPAcceptorApplication;
import com.streamscape.sef.network.http.acceptor.HTTPAcceptorApplicationsUtils;
import com.streamscape.sef.network.http.server.apicustomizer.APICustomizerException;
import com.streamscape.sef.network.http.server.apicustomizer.APICustomizerImporterExporter;
import com.streamscape.sef.network.http.server.apicustomizer.AbstractRule;
import com.streamscape.sef.network.http.server.apicustomizer.CustomizerRuleCreator;
import com.streamscape.sef.network.http.server.apicustomizer.UriMatcher;
import com.streamscape.sef.network.http.server.config.HTTPAuthenticationType;
import com.streamscape.sef.network.http.server.config.RealmInfo;
import com.streamscape.sef.network.http.server.cors.Origin;
import com.streamscape.sef.network.http.server.cors.OriginAccessControlConfiguration;
import com.streamscape.sef.network.http.server.jetty.JettyAdvancedProperties;
import com.streamscape.sef.network.http.server.utils.HTTPSUtils;
import com.streamscape.sef.network.mf.admin.Acceptor;
import com.streamscape.sef.network.mf.admin.AcceptorFactory;
import com.streamscape.sef.network.mf.admin.AcceptorFactoryException;
import com.streamscape.sef.network.mf.admin.CertificatesFactory;
import com.streamscape.sef.network.tlp.acceptor.TLPAcceptor;
import com.streamscape.sef.network.xmpp.acceptor.XMPPAcceptor;
import com.streamscape.sef.security.SecurityManagerException;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.file.SLFileInputStream;
import com.streamscape.slex.file.SLFileUtils;
import com.streamscape.slex.file.SLFileUtilsFactory;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.SyntaxHint;
import com.streamscape.slex.lang.completion.CompletionAdviser;
import com.streamscape.slex.lang.modifier.AbstractModifier;
import com.streamscape.slex.lang.modifier.BlockModifier;
import com.streamscape.slex.lang.modifier.ChoiceModifier;
import com.streamscape.slex.lang.modifier.CompoundModifier;
import com.streamscape.slex.lang.modifier.Modifier;
import com.streamscape.slex.lang.modifier.RepeatableModifier;
import com.streamscape.slex.lang.parameter.AbstractParameter;
import com.streamscape.slex.lang.parameter.BooleanParameter;
import com.streamscape.slex.lang.parameter.EnumParameter;
import com.streamscape.slex.lang.parameter.IdentifierParameter;
import com.streamscape.slex.lang.parameter.IntegerParameter;
import com.streamscape.slex.lang.parameter.LocalPathParameter;
import com.streamscape.slex.lang.parameter.LongParameter;
import com.streamscape.slex.lang.parameter.StringParameter;
import com.streamscape.slex.lang.parameter.SyntaxParameter;
import com.streamscape.slex.lang.value.StatementBlockValue;
import com.streamscape.slex.lang.value.StatementValueList;
import com.streamscape.tools.lexer.BufferUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.io.FilenameUtils;

public class AlterAcceptorOperation
extends AbstractAlterDescribeOperation {
    public static final String NAME = "alter acceptor";

    public AlterAcceptorOperation() {
        super(NAME, "Alters specified acceptor configuration.\nAcceptor should be restarted to apply changes.");
        this.setAdministrative(true);
    }

    @Override
    protected void setSyntax(String operationName) {
        super.setSyntax(operationName);
        ChoiceModifier choiceModifier = new ChoiceModifier("AlterAcceptorChoiceModifier");
        AlterAcceptorOperation.addAcceptorProtocolChoice(choiceModifier, LinkProtocol.TLP, LinkProtocol.HTTP, LinkProtocol.XMPP);
        this.syntax.addModifier(choiceModifier);
    }

    @Override
    protected void setExamples(String operationNAme) {
        this.syntax.setExamples("alter acceptor TLP.Acceptor1 set properties (url = 'localhost:5000')\nalter acceptor TLP.Acceptor1 set properties (anonymousRegistration = false, autoStart=true)\nalter acceptor HTTP.Acceptor1 set properties (abortOnFailure = true, description='Test acceptor.')\n\nalter acceptor HTTP.Default add rule AnyRule (externalURI='myos', httpMethod='GET', returnCode='200', customizedUri='/quilt/', customizedMethod='GET', redirect='true')\nalter acceptor HTTP.Default set rule 'GET-myos'  (externalURI='myos-1', redirect='false')\nalter acceptor HTTP.Default remove rule 'GET-myos-1'\n\nalter acceptor HTTP.Default import rules from file 'myrules.json' replace\nalter acceptor HTTP.Default import rules from file 'myrules.json' replace\nalter acceptor HTTP.Default import rules from file 'myrules.json' merge\n");
    }

    @Override
    protected AbstractAlterDescribeOperation.Definition createDefinition(LinkProtocol protocol, String acceptorName, DSLStatement statement) {
        return new AbstractAlterDescribeOperation.Definition(NAME, protocol, acceptorName, statement);
    }

    @Override
    public SLResponse invoke(SLStatement statement, MFSession session, long timeout) throws Exception {
        AbstractAlterDescribeOperation.Definition definition = (AbstractAlterDescribeOperation.Definition)statement;
        AcceptorFactory factory = ((RuntimeContext)this.callable).getAcceptorManager().lookupFactory(AlterAcceptorOperation.getFactoryName(definition.getProtocol()));
        if (factory == null) {
            throw new Exception("Protocol not found.");
        }
        Acceptor acceptor = factory.lookupAcceptor(definition.getAcceptorName());
        if (acceptor == null) {
            throw new Exception("Acceptor not found.");
        }
        if (definition.getStatement().existsModifier("httpSetAdvancedPropertiesBlock")) {
            AlterAcceptorOperation.setProperties(definition, "httpSetAdvancedPropertiesBlock", AlterAcceptorOperation.getHTTPAdvancedProperty((HTTPAcceptor)acceptor));
        } else if (definition.getStatement().existsModifier("realmAddModifier")) {
            AlterAcceptorOperation.addRealm(definition, "realmAddModifier", (HTTPAcceptor)acceptor);
        } else if (definition.getStatement().existsModifier("realmRemoveModifier")) {
            AlterAcceptorOperation.removeRealm(definition, (HTTPAcceptor)acceptor);
        } else if (definition.getStatement().existsModifier("realmSetModifierChoice")) {
            AlterAcceptorOperation.setRealm(definition, (HTTPAcceptor)acceptor);
        } else if (definition.getStatement().existsModifier("addUrlAliasModifier")) {
            AlterAcceptorOperation.addUrlAlias((HTTPAcceptor)acceptor, definition);
        } else if (definition.getStatement().existsModifier("removeUrlAliasModifier")) {
            AlterAcceptorOperation.removeUrlAlias((HTTPAcceptor)acceptor, definition);
        } else if (definition.getStatement().existsModifier("setSystem")) {
            AlterAcceptorOperation.setSystem((HTTPAcceptor)acceptor, definition);
        } else if (definition.getStatement().existsParameter("addAppName")) {
            AlterAcceptorOperation.addApplication((HTTPAcceptor)acceptor, definition);
        } else if (definition.getStatement().existsParameter("removeAppName")) {
            AlterAcceptorOperation.removeApplication((HTTPAcceptor)acceptor, definition);
        } else if (definition.getStatement().existsModifier("originAddModifier")) {
            AlterAcceptorOperation.addOrigin(definition, "originAddModifier", (HTTPAcceptor)acceptor);
        } else if (definition.getStatement().existsModifier("originRemoveModifier")) {
            AlterAcceptorOperation.removeOrigin(definition, (HTTPAcceptor)acceptor);
        } else if (definition.getStatement().existsModifier("originSetBlockModifier")) {
            AlterAcceptorOperation.setOrigin(definition, "originSetBlockModifier", (HTTPAcceptor)acceptor);
        } else if (definition.getStatement().existsModifier("ENABLE DROPBOX") || definition.getStatement().existsModifier("DISABLE DROPBOX")) {
            this.setEnableDisableDropBox(definition, factory, (HTTPAcceptor)acceptor);
        } else if (definition.getStatement().existsModifier("certTypeModifier")) {
            this.setStore(session, definition, (HTTPAcceptor)acceptor);
        } else if (definition.getStatement().existsModifier("addRuleModifierBlock")) {
            AlterAcceptorOperation.addRule(definition, (HTTPAcceptor)acceptor);
        } else if (definition.getStatement().existsModifier("setRuleModifierBlock")) {
            AlterAcceptorOperation.setRule(definition, (HTTPAcceptor)acceptor);
        } else if (definition.getStatement().existsParameter("removeRuleID")) {
            AlterAcceptorOperation.removeRule(definition, (HTTPAcceptor)acceptor);
        } else if (definition.getStatement().existsParameter("rulesJsonFile") || definition.getStatement().existsParameter("rulesJson")) {
            AlterAcceptorOperation.importRules(session, definition, (HTTPAcceptor)acceptor);
        } else {
            AlterAcceptorOperation.setAcceptorProperties(definition, acceptor);
        }
        if (acceptor instanceof HTTPAcceptor) {
            ((HTTPAcceptor)acceptor).getConfiguration().touch();
        }
        factory.saveAcceptor(acceptor);
        return new SLResponse();
    }

    private static void addAcceptorProtocolChoice(ChoiceModifier choiceModifier, LinkProtocol ... protocols) {
        for (LinkProtocol protocol : protocols) {
            AbstractModifier setPropertiesModifier;
            BlockModifier protocolSetPropertiesSyntax = new BlockModifier("SET PROPERTIES", String.valueOf((Object)protocol) + "SetPropertiesBlock");
            AlterAcceptorOperation.addGeneralProperties(protocolSetPropertiesSyntax);
            AlterAcceptorOperation.addProtocolSpecificProperties(protocolSetPropertiesSyntax, protocol);
            if (protocol == LinkProtocol.HTTP) {
                BlockModifier httpSetAdvancedPropertiesSyntax = new BlockModifier("SET ADVANCED PROPERTIES", "httpSetAdvancedPropertiesBlock");
                AlterAcceptorOperation.addHTTPAdvancedProperties(httpSetAdvancedPropertiesSyntax);
                BlockModifier realmAddModifier = AlterAcceptorOperation.createRealmPropertiesBlock("add realm", "realmAddModifier", true, 4);
                CompoundModifier realmSetModifier = new CompoundModifier("realmSetModifierCompound").addModifier((AbstractModifier)((Modifier)new Modifier("set realm").setName("realmSetModifier")).addParameter((SyntaxParameter)new StringParameter("name").setName("realmSetNameParam"))).addModifier((AbstractModifier)((ChoiceModifier)((ChoiceModifier)((ChoiceModifier)((ChoiceModifier)new ChoiceModifier("realmSetModifierChoice").addModifier(AlterAcceptorOperation.createRealmPropertiesBlock("", "realmSetBlockModifier", false, 4))).addModifier((AbstractModifier)((Modifier)new Modifier("add user").setName("addUserModifier")).addParameter((SyntaxParameter)((IdentifierParameter)new IdentifierParameter("user").setName("addUserParam")).setCompletionAdviser(new UserCompletionAdviser())))).addModifier((AbstractModifier)((Modifier)new Modifier("remove user").setName("removeUserModifier")).addParameter((SyntaxParameter)((IdentifierParameter)new IdentifierParameter("user").setName("removeUserParam")).setCompletionAdviser(new UserCompletionAdviser())))).addModifier((AbstractModifier)((Modifier)new Modifier("add group").setName("addGroupModifier")).addParameter((SyntaxParameter)((IdentifierParameter)new IdentifierParameter("group").setName("addGroupParam")).setCompletionAdviser(new GroupCompletionAdviser())))).addModifier((AbstractModifier)((Modifier)new Modifier("remove group").setName("removeGroupModifier")).addParameter((SyntaxParameter)((IdentifierParameter)new IdentifierParameter("group").setName("removeGroupParam")).setCompletionAdviser(new GroupCompletionAdviser()))));
                Modifier realmRemoveModifier = (Modifier)((Modifier)new Modifier("remove realm").setName("realmRemoveModifier")).addParameter((SyntaxParameter)new StringParameter("name").setName("realmRemoveNameParam"));
                CompoundModifier addUrlAliasModifier = new CompoundModifier("addUrlPathAliasModifier").addModifier((AbstractModifier)((Modifier)new Modifier("add url alias").setName("addUrlAliasModifier")).addParameter((SyntaxParameter)new StringParameter("url").setName("addUrlAliasParam"))).addModifier((AbstractModifier)((Modifier)new Modifier("path").setName("pathAliasModifier")).addParameter((SyntaxParameter)new StringParameter("path").setName("pathAliasParam")));
                Modifier removeUrlAliasModifier = (Modifier)((Modifier)new Modifier("remove url alias").setName("removeUrlAliasModifier")).addParameter((SyntaxParameter)new StringParameter("url").setName("removeUrlAliasParam"));
                CompoundModifier setStoreModifier = (CompoundModifier)new CompoundModifier("setStoreModifier").addModifier(new Modifier("set")).addModifier(new ChoiceModifier("certTypeModifier").addPossibleValues("keystore", "truststore")).addModifier(new AtModifier("pathAt")).addParameter(new LocalPathParameter("storeFile")).addModifier((AbstractModifier)((Modifier)new Modifier("password").addParameter((SyntaxParameter)new StringParameter("storePassword").setName("storePassword"))).setRequired(false)).setSyntaxHint(SyntaxHint.SPACE);
                ChoiceModifier enableDisableDropBoxModifier = (ChoiceModifier)((ChoiceModifier)new ChoiceModifier("ENABLE_DISABLE_DROPBOX_CHOICE").addModifier(new Modifier("ENABLE DROPBOX"))).addModifier(new Modifier("DISABLE DROPBOX"));
                BlockModifier originAddModifier = AlterAcceptorOperation.createXOriginPropertiesBlock("add cross origin", "originAddModifier", 4);
                CompoundModifier originSetModifier = new CompoundModifier("originSetModifierCompound").addModifier((AbstractModifier)((Modifier)new Modifier("set cross origin").setName("originSetModifier")).addParameter((SyntaxParameter)new StringParameter("name").setName("originSetNameParam"))).addModifier(AlterAcceptorOperation.createXOriginPropertiesBlock("", "originSetBlockModifier", 4));
                Modifier originRemoveModifier = (Modifier)((Modifier)new Modifier("remove cross origin").setName("originRemoveModifier")).addParameter((SyntaxParameter)new StringParameter("name").setName("originRemoveNameParam"));
                Modifier setSystem = (Modifier)((Modifier)new Modifier("set system").setName("setSystem")).addParameter((SyntaxParameter)new BooleanParameter("system or not").setName("isSystem"));
                CompoundModifier addApp = new CompoundModifier("ADD_APP_COMP").addModifier((AbstractModifier)((Modifier)new Modifier("add app").setName("addApp")).addParameter((SyntaxParameter)new StringParameter("app name").setName("addAppName"))).addModifier((AbstractModifier)new Modifier("cid").addParameter((SyntaxParameter)new StringParameter("app cid").setName("appCid"))).addModifier((AbstractModifier)new Modifier("uri").addParameter((SyntaxParameter)new StringParameter("app uri").setName("appUri")));
                Modifier removeApp = (Modifier)((Modifier)new Modifier("remove app").setName("removeApp")).addParameter((SyntaxParameter)((StringParameter)new StringParameter("app name").setName("removeAppName")).setCompletionAdviser(new AcceptorApplicationNameCompletionAdviser()));
                CompoundModifier ruleAddModifier = AlterAcceptorOperation.createAddRuleModifier(4);
                CompoundModifier ruleSetModifier = AlterAcceptorOperation.createSetRuleModifier(4);
                Modifier ruleRemoveModifier = AlterAcceptorOperation.createRemoveRuleModifier();
                CompoundModifier importRulesModifier = AlterAcceptorOperation.createImportRulesModifier();
                protocolSetPropertiesSyntax.setSyntaxHint(AlterAcceptorOperation.createSyntaxHint(3, false));
                httpSetAdvancedPropertiesSyntax.setSyntaxHint(AlterAcceptorOperation.createSyntaxHint(3, true));
                realmAddModifier.setSyntaxHint(AlterAcceptorOperation.createSyntaxHint(3, true));
                realmSetModifier.setSyntaxHint(AlterAcceptorOperation.createSyntaxHint(3, false));
                realmRemoveModifier.setSyntaxHint(AlterAcceptorOperation.createSyntaxHint(3, false));
                addUrlAliasModifier.setSyntaxHint(AlterAcceptorOperation.createSyntaxHint(3, true));
                removeUrlAliasModifier.setSyntaxHint(AlterAcceptorOperation.createSyntaxHint(3, false));
                enableDisableDropBoxModifier.setSyntaxHint(AlterAcceptorOperation.createSyntaxHint(3, true));
                originAddModifier.setSyntaxHint(AlterAcceptorOperation.createSyntaxHint(3, true));
                originSetModifier.setSyntaxHint(AlterAcceptorOperation.createSyntaxHint(3, false));
                originRemoveModifier.setSyntaxHint(AlterAcceptorOperation.createSyntaxHint(3, false));
                setSystem.setSyntaxHint(AlterAcceptorOperation.createSyntaxHint(3, true));
                addApp.setSyntaxHint(AlterAcceptorOperation.createSyntaxHint(3, true));
                removeApp.setSyntaxHint(AlterAcceptorOperation.createSyntaxHint(3, true));
                ruleAddModifier.setSyntaxHint(AlterAcceptorOperation.createSyntaxHint(3, true));
                ruleSetModifier.setSyntaxHint(AlterAcceptorOperation.createSyntaxHint(3, false));
                ruleRemoveModifier.setSyntaxHint(AlterAcceptorOperation.createSyntaxHint(3, false));
                importRulesModifier.setSyntaxHint(AlterAcceptorOperation.createSyntaxHint(3, false));
                setPropertiesModifier = (AbstractModifier)((ChoiceModifier)((ChoiceModifier)((ChoiceModifier)((ChoiceModifier)((ChoiceModifier)((ChoiceModifier)((ChoiceModifier)((ChoiceModifier)((ChoiceModifier)((ChoiceModifier)((ChoiceModifier)((ChoiceModifier)((ChoiceModifier)((ChoiceModifier)((ChoiceModifier)((ChoiceModifier)((ChoiceModifier)((ChoiceModifier)new ChoiceModifier("httpSetPropertiesChoice").addModifier(protocolSetPropertiesSyntax)).addModifier(httpSetAdvancedPropertiesSyntax)).addModifier(realmAddModifier)).addModifier(realmSetModifier)).addModifier(realmRemoveModifier)).addModifier(addUrlAliasModifier)).addModifier(removeUrlAliasModifier)).addModifier(enableDisableDropBoxModifier)).addModifier(originAddModifier)).addModifier(originSetModifier)).addModifier(originRemoveModifier)).addModifier(setStoreModifier)).addModifier(setSystem)).addModifier(addApp)).addModifier(removeApp)).addModifier(ruleAddModifier)).addModifier(ruleSetModifier)).addModifier(ruleRemoveModifier)).addModifier(importRulesModifier);
            } else {
                setPropertiesModifier = protocolSetPropertiesSyntax;
            }
            CompoundModifier acceptorNameModifier = AlterAcceptorOperation.createAcceptorNameModifier(protocol);
            choiceModifier.setSyntaxHint(AlterAcceptorOperation.createSyntaxHint(1, false));
            acceptorNameModifier.setSyntaxHint(AlterAcceptorOperation.createSyntaxHint(2, true));
            setPropertiesModifier.setSyntaxHint(AlterAcceptorOperation.createSyntaxHint(3, false));
            choiceModifier.addModifier(acceptorNameModifier.addModifier(setPropertiesModifier));
        }
    }

    private static SyntaxHint createSyntaxHint(int level, boolean emptyLine) {
        StringBuilder shift = new StringBuilder();
        if (emptyLine) {
            shift.append("\n");
        }
        for (int i = 0; i < level; ++i) {
            shift.append("  ");
        }
        return new SyntaxHint(shift.toString(), true);
    }

    private static void addProtocolSpecificProperties(BlockModifier block, LinkProtocol protocol) {
        switch (protocol) {
            case TLP: 
            case TLPS: {
                AlterAcceptorOperation.addTLPProperties(block);
                break;
            }
            case HTTP: 
            case HTTPS: {
                AlterAcceptorOperation.addHTTPProperties(block);
                break;
            }
            case XMPP: 
            case XMPPS: {
                AlterAcceptorOperation.addXMPPProperties(block);
                break;
            }
            default: {
                throw new RuntimeException("Invalid LinkProtocol!");
            }
        }
    }

    private static AbstractModifier<?> createSetPropertyModifier(String propertyName, AbstractParameter<?> parameter) {
        return AlterAcceptorOperation.createSetPropertyModifier(propertyName, parameter, 4);
    }

    private static AbstractModifier<?> createSetPropertyModifier(String propertyName, AbstractParameter<?> parameter, int level) {
        return AlterAcceptorOperation.createSetPropertyModifier(propertyName, parameter, false, level);
    }

    private static AbstractModifier<?> createSetPropertyModifier(String propertyName, AbstractParameter<?> parameter, boolean required, int level) {
        CompoundModifier syntax = new CompoundModifier(propertyName + "setcompound");
        syntax.addModifier((AbstractModifier)((Modifier)new Modifier(propertyName).setDisplayInLowerCase(false)).setName("PropertyName"));
        syntax.addModifier(new Modifier("=", "equals")).addParameter((AbstractParameter)parameter.setName("value"));
        syntax.setRequired(required);
        syntax.setSyntaxHint(AlterAcceptorOperation.createSyntaxHint(level, false));
        return syntax;
    }

    private static void addGeneralProperties(BlockModifier block) {
        block.addModifier(AlterAcceptorOperation.createSetPropertyModifier("description", new StringParameter("description")));
        block.addModifier(AlterAcceptorOperation.createSetPropertyModifier("url", new StringParameter("url")));
        block.addModifier(AlterAcceptorOperation.createSetPropertyModifier("autoStart", new BooleanParameter("true | false")));
        block.addModifier(AlterAcceptorOperation.createSetPropertyModifier("abortOnFailure", new BooleanParameter("true | false")));
        block.addModifier(AlterAcceptorOperation.createSetPropertyModifier("anonymousRegistration", new BooleanParameter("true | false")));
    }

    private static void addTLPProperties(BlockModifier block) {
        block.addModifier(AlterAcceptorOperation.createSetPropertyModifier("keepAlive", new BooleanParameter("true | false")));
        block.addModifier(AlterAcceptorOperation.createSetPropertyModifier("enableSSL", new BooleanParameter("true | false")));
        block.addModifier(AlterAcceptorOperation.createSetPropertyModifier("outgoingChannel.writerFlushDelay", new IntegerParameter("seconds")));
        block.addModifier(AlterAcceptorOperation.createSetPropertyModifier("outgoingChannel.writerBufferSize", new IntegerParameter("bytes")));
        block.addModifier(AlterAcceptorOperation.createSetPropertyModifier("outgoingChannel.streamingThreshold", new IntegerParameter("bytes")));
        block.addModifier(AlterAcceptorOperation.createSetPropertyModifier("outgoingChannel.socketConfiguration.receiveBufferSize", new IntegerParameter("bytes")));
        block.addModifier(AlterAcceptorOperation.createSetPropertyModifier("outgoingChannel.socketConfiguration.sendBufferSize", new IntegerParameter("bytes")));
        block.addModifier(AlterAcceptorOperation.createSetPropertyModifier("outgoingChannel.socketConfiguration.trafficClass", new IntegerParameter("class")));
        block.addModifier(AlterAcceptorOperation.createSetPropertyModifier("outgoingChannel.socketConfiguration.tcpNoDelay", new BooleanParameter("true | false")));
        block.addModifier(AlterAcceptorOperation.createSetPropertyModifier("incomingChannel.readerBufferSize", new IntegerParameter("bytes")));
        block.addModifier(AlterAcceptorOperation.createSetPropertyModifier("incomingChannel.socketConfiguration.receiveBufferSize", new IntegerParameter("bytes")));
        block.addModifier(AlterAcceptorOperation.createSetPropertyModifier("incomingChannel.socketConfiguration.sendBufferSize", new IntegerParameter("bytes")));
        block.addModifier(AlterAcceptorOperation.createSetPropertyModifier("incomingChannel.socketConfiguration.trafficClass", new IntegerParameter("class")));
        block.addModifier(AlterAcceptorOperation.createSetPropertyModifier("incomingChannel.socketConfiguration.tcpNoDelay", new BooleanParameter("true | false")));
    }

    private static void addHTTPProperties(BlockModifier block) {
        block.addModifier(AlterAcceptorOperation.createSetPropertyModifier("logEachRequest", new BooleanParameter("true | false")));
        block.addModifier(AlterAcceptorOperation.createSetPropertyModifier("logExtended", new BooleanParameter("true | false")));
        block.addModifier(AlterAcceptorOperation.createSetPropertyModifier("logDateFormat", new StringParameter("dd/MMM/yyyy:HH:mm:ss Z")));
        block.addModifier(AlterAcceptorOperation.createSetPropertyModifier("compressResponse", new BooleanParameter("true | false")));
        block.addModifier(AlterAcceptorOperation.createSetPropertyModifier("storeSessions", new BooleanParameter("true | false")));
        block.addModifier(AlterAcceptorOperation.createSetPropertyModifier("webApplicationDir", new StringParameter("path")));
        block.addModifier(AlterAcceptorOperation.createSetPropertyModifier("webArchiveDir", new StringParameter("path")));
        block.addModifier(AlterAcceptorOperation.createSetPropertyModifier("keepAliveTimeout", new IntegerParameter("seconds")));
        block.addModifier(AlterAcceptorOperation.createSetPropertyModifier("sessionTimeout", new IntegerParameter("seconds")));
        block.addModifier(AlterAcceptorOperation.createSetPropertyModifier("maxActiveSessionsNumber", new IntegerParameter("-1 means infinite")));
        block.addModifier(AlterAcceptorOperation.createSetPropertyModifier("authenticationType", new EnumParameter("auth type", HTTPAuthenticationType.class)));
        block.addModifier(AlterAcceptorOperation.createSetPropertyModifier("sessionAuthentication", new BooleanParameter("true | false")));
        block.addModifier(AlterAcceptorOperation.createSetPropertyModifier("enableSSL", new BooleanParameter("true | false")));
        block.addModifier(AlterAcceptorOperation.createSetPropertyModifier("keyStorePassword", new StringParameter("password")));
        block.addModifier(AlterAcceptorOperation.createSetPropertyModifier("requestTriggerEnabled", new BooleanParameter("true | false")));
        block.addModifier(AlterAcceptorOperation.createSetPropertyModifier("enableDropBox", new BooleanParameter("true | false")));
    }

    private static void addXMPPProperties(BlockModifier block) {
        block.addModifier(AlterAcceptorOperation.createSetPropertyModifier("eventScope", new EnumParameter("event scope", EventScope.class)));
        block.addModifier(AlterAcceptorOperation.createSetPropertyModifier("maxThreadsInPool", new IntegerParameter("number of threads")));
        block.addModifier(AlterAcceptorOperation.createSetPropertyModifier("backlogSize", new IntegerParameter("backlog size")));
    }

    private static AbstractParameter<?> createAdvancedParameter(JettyAdvancedProperties.PropertyInfo info) {
        AbstractParameter parameter;
        Object defaultValue = info.getValue();
        String units = info.getUnits();
        if (defaultValue instanceof String) {
            parameter = new StringParameter(units);
        } else if (defaultValue instanceof Integer) {
            parameter = new IntegerParameter(units);
        } else if (defaultValue instanceof Long) {
            parameter = new LongParameter(units);
        } else if (defaultValue instanceof Boolean) {
            parameter = new BooleanParameter(units);
        } else {
            throw new RuntimeException("Unexpected class of property value.");
        }
        return parameter;
    }

    private static void addHTTPAdvancedProperties(BlockModifier block) {
        JettyAdvancedProperties.getDefaultPropertiesInfo().forEach((name, info) -> block.addModifier(AlterAcceptorOperation.createSetPropertyModifier(name, AlterAcceptorOperation.createAdvancedParameter(info))));
    }

    private static BlockModifier createXOriginPropertiesBlock(String token, String name, int level) {
        BlockModifier block = new BlockModifier(token, name);
        block.addModifier(AlterAcceptorOperation.createSetPropertyModifier("enabled", new BooleanParameter("true | false"), level));
        block.addModifier(AlterAcceptorOperation.createSetPropertyModifier("origin", new StringParameter("name"), level));
        block.addModifier(AlterAcceptorOperation.createSetPropertyModifier("allowCredentials", new BooleanParameter("true | false"), level));
        block.addModifier(AlterAcceptorOperation.createSetPropertyModifier("allowedHeaders", new StringParameter("comma separated list"), level));
        block.addModifier(AlterAcceptorOperation.createSetPropertyModifier("allowedMethods", new StringParameter("comma separated list"), level));
        block.addModifier(AlterAcceptorOperation.createSetPropertyModifier("exposedHeaders", new StringParameter("comma separated list"), level));
        block.addModifier(AlterAcceptorOperation.createSetPropertyModifier("maxAge", new LongParameter("0 means that no need to set Access-Control-Max-Age header"), level));
        return block;
    }

    private static BlockModifier createRealmPropertiesBlock(String token, String name, boolean create, int level) {
        BlockModifier block = new BlockModifier(token, name);
        block.addModifier(AlterAcceptorOperation.createSetPropertyModifier("name", new StringParameter("name"), level));
        if (create) {
            block.addModifier(AlterAcceptorOperation.createSetPropertyModifier("path", new StringParameter("path"), level));
        }
        block.addModifier(AlterAcceptorOperation.createSetPropertyModifier("users", new StringParameter("comma separated user names"), level));
        block.addModifier(AlterAcceptorOperation.createSetPropertyModifier("groups", new StringParameter("comma separated group names"), level));
        return block;
    }

    private static CompoundModifier createAddRuleModifier(int level) {
        CompoundModifier modifier = new CompoundModifier("addRuleModifier");
        modifier.addModifier((AbstractModifier)new Modifier("add rule").addParameter((SyntaxParameter)new DescribeAcceptorOperation.RuleTypeParameter().setName("ruleType")));
        modifier.addModifier(new BlockModifier("", "addRuleModifierBlock").addModifier((AbstractModifier)new RepeatableModifier().addModifier(AlterAcceptorOperation.createSetRulePropertyModifier("addRuleSetProperty", new StringParameter("value"), true, level))));
        return modifier;
    }

    private static CompoundModifier createSetRuleModifier(int level) {
        CompoundModifier modifier = new CompoundModifier("setRuleModifier");
        modifier.addModifier((AbstractModifier)new Modifier("set rule").addParameter((SyntaxParameter)new StringParameter("id").setName("setRuleID")));
        modifier.addModifier(new BlockModifier("", "setRuleModifierBlock").addModifier((AbstractModifier)new RepeatableModifier().addModifier(AlterAcceptorOperation.createSetRulePropertyModifier("setRuleSetProperty", new StringParameter("value"), true, level))));
        return modifier;
    }

    private static Modifier createRemoveRuleModifier() {
        return (Modifier)new Modifier("remove rule").addParameter((SyntaxParameter)new StringParameter("id").setName("removeRuleID"));
    }

    private static CompoundModifier createImportRulesModifier() {
        return new CompoundModifier("IMPORT_RULES_COMPOUND").addModifier(new Modifier("import rules from")).addModifier((AbstractModifier)((ChoiceModifier)new ChoiceModifier("IMPORT_RULES_FILE_CHOICE").addModifier((AbstractModifier)new Modifier("FILE").addParameter((SyntaxParameter)new StringParameter("rulesJsonFile").setName("rulesJsonFile")))).addParameter((AbstractParameter)new StringParameter("rulesJson").setName("rulesJson"))).addModifier(new ChoiceModifier("IMPORT_RULES_CHOICE").addPossibleValues("REPLACE", "MERGE"));
    }

    private static AbstractModifier<?> createSetRulePropertyModifier(String propertyName, AbstractParameter<?> parameter, boolean required, int level) {
        CompoundModifier syntax = new CompoundModifier(propertyName + "setcompound");
        syntax.addParameter((AbstractParameter)((IdentifierParameter)((IdentifierParameter)new IdentifierParameter("name").setName("PropertyName")).setExcludedDelimiters(".")).setCompletionAdviser(new CompletionAdviser<Object>(){

            @Override
            public List<String> getCompletions(String script, String processedScript, Object callable, MFSession session) {
                int pos = (processedScript = processedScript.trim()).indexOf("(");
                if (pos == -1) {
                    pos = processedScript.length();
                }
                if ((pos = (processedScript = processedScript.substring(0, pos).trim()).lastIndexOf(" ")) != -1) {
                    String ruleType = processedScript.substring(pos).trim();
                    try {
                        return RuleDescriber.createRuleDescriber(CustomizerRuleCreator.createRule(ruleType, new HashMap<String, String>())).getRuleProperties().stream().map(RuleDescriber.PropertyInfo::getName).collect(Collectors.toList());
                    }
                    catch (APICustomizerException aPICustomizerException) {
                        // empty catch block
                    }
                }
                return new ArrayList<String>();
            }

            @Override
            public boolean isCaseSensitive() {
                return true;
            }
        }));
        syntax.addModifier(new Modifier("=", "equals")).addParameter((AbstractParameter)parameter.setName("value"));
        syntax.setRequired(required);
        syntax.setSyntaxHint(AlterAcceptorOperation.createSyntaxHint(level, false));
        return syntax;
    }

    private static void addRule(AbstractAlterDescribeOperation.Definition definition, HTTPAcceptor acceptor) throws Exception {
        String ruleType = definition.getStatement().getParameter("ruleType").getValue();
        StatementBlockValue addPropertiesBlock = definition.getStatement().getBlock("addRuleModifierBlock");
        HashMap<String, String> properties = new HashMap<String, String>();
        AlterAcceptorOperation.parsePropertiesBlock(addPropertiesBlock, properties::put);
        AbstractRule rule = CustomizerRuleCreator.createRule(ruleType, properties);
        acceptor.getConfiguration().getAPICustomizerConfiguration().addRule(rule);
    }

    private static void setRule(AbstractAlterDescribeOperation.Definition definition, HTTPAcceptor acceptor) throws Exception {
        String ruleId = definition.getStatement().getParameter("setRuleID").getValue();
        StatementBlockValue setPropertiesBlock = definition.getStatement().getBlock("setRuleModifierBlock");
        HashMap<String, String> properties = new HashMap<String, String>();
        AlterAcceptorOperation.parsePropertiesBlock(setPropertiesBlock, properties::put);
        AbstractRule rule = acceptor.getConfiguration().getAPICustomizerConfiguration().listAllRules().stream().filter(r -> r.getRuleId().equalsIgnoreCase(ruleId)).findAny().orElse(null);
        if (rule == null) {
            throw new Exception("Rule with ID " + ruleId + " doesn't exist.");
        }
        CustomizerRuleCreator.alterRule(rule, properties);
    }

    private static void removeRule(AbstractAlterDescribeOperation.Definition definition, HTTPAcceptor acceptor) throws Exception {
        String ruleId = definition.getStatement().getParameter("removeRuleID").getValue();
        acceptor.getConfiguration().getAPICustomizerConfiguration().removeRuleById(ruleId);
    }

    private static void importRules(MFSession session, AbstractAlterDescribeOperation.Definition definition, HTTPAcceptor acceptor) throws Exception {
        String rulesJson = definition.getStatement().getParameter("rulesJson").getValue();
        if (rulesJson == null) {
            String rulesJsonFile = definition.getStatement().getParameter("rulesJsonFile").getValue();
            SLFileUtils file = (SLFileUtils)new SLFileUtilsFactory().create(session, rulesJsonFile);
            try (SLFileInputStream inputStream = file.createSLFileInputStream(rulesJsonFile);){
                inputStream.open();
                rulesJson = new String(FileIOUtils.getStreamContent(inputStream, 8192L));
            }
        }
        AlterAcceptorOperation.importRulesFromJson(definition, acceptor, rulesJson);
    }

    private static void importRulesFromJson(AbstractAlterDescribeOperation.Definition definition, HTTPAcceptor acceptor, String json) throws Exception {
        APICustomizerImporterExporter.ImportRulesMethod importRulesMethod = definition.getStatement().existsModifier("REPLACE") ? APICustomizerImporterExporter.ImportRulesMethod.REPLACE : APICustomizerImporterExporter.ImportRulesMethod.MERGE;
        APICustomizerImporterExporter.importFromJson(acceptor.getConfiguration().getAPICustomizerConfiguration(), json, importRulesMethod);
    }

    private static void parsePropertiesBlock(StatementBlockValue body, PropertyObserver observer) throws Exception {
        for (int index = 0; index < body.getLinesCount(); ++index) {
            StatementValueList line = body.getLineByIndex(index);
            String propertyValue = null;
            try {
                String propertyName;
                if (line.existsModifier("PropertyName")) {
                    propertyName = line.getModifier("PropertyName").getToken();
                } else if (line.existsParameter("PropertyName")) {
                    propertyName = line.getParameter("PropertyName").getValue();
                } else {
                    throw new Exception("No property name specified.");
                }
                if (line.existsParameter("value")) {
                    propertyValue = line.getParameter("value").getValue();
                }
                observer.onProperty(propertyName, propertyValue);
                continue;
            }
            catch (Exception exception) {
                throw new Exception("Error while processing line '" + line.toString() + "'. " + exception.getMessage());
            }
        }
    }

    private static PropertyObserver getGeneralPropertyObserver(Acceptor acceptor) {
        return (name, value) -> {
            if (name.equalsIgnoreCase("description")) {
                acceptor.setDescription(value);
            } else if (name.equalsIgnoreCase("url")) {
                acceptor.setURL(value);
            } else if (name.equalsIgnoreCase("autoStart")) {
                acceptor.setAutoStart(Boolean.parseBoolean(value));
            } else if (name.equalsIgnoreCase("abortOnFailure")) {
                acceptor.setAbortOnFailure(Boolean.parseBoolean(value));
            } else if (name.equalsIgnoreCase("anonymousRegistration")) {
                acceptor.setAnonymousRegistration(Boolean.parseBoolean(value));
            }
        };
    }

    private static PropertyObserver getTLPPropertyObserver(TLPAcceptor acceptor) {
        return (name, value) -> {
            if (name.equalsIgnoreCase("keepAlive")) {
                acceptor.setKeepAlive(Boolean.parseBoolean(value));
            }
            if (name.equalsIgnoreCase("enableSSL")) {
                acceptor.setEnableSSL(Boolean.parseBoolean(value));
            } else if (name.equalsIgnoreCase("outgoingChannel.writerFlushDelay")) {
                acceptor.getOutgoingConnectionChannel().setWriterFlushDelay(Integer.parseInt(value));
            } else if (name.equalsIgnoreCase("outgoingChannel.writerBufferSize")) {
                acceptor.getOutgoingConnectionChannel().setWriterBufferSize(Integer.parseInt(value));
            } else if (name.equalsIgnoreCase("outgoingChannel.streamingThreshold")) {
                acceptor.getOutgoingConnectionChannel().setStreamingThreshold(Integer.parseInt(value));
            } else if (name.equalsIgnoreCase("outgoingChannel.socketConfiguration.receiveBufferSize")) {
                acceptor.getOutgoingConnectionChannel().getSocketConfiguration().receiveBufferSize = Integer.parseInt(value);
            } else if (name.equalsIgnoreCase("outgoingChannel.socketConfiguration.sendBufferSize")) {
                acceptor.getOutgoingConnectionChannel().getSocketConfiguration().sendBufferSize = Integer.parseInt(value);
            } else if (name.equalsIgnoreCase("outgoingChannel.socketConfiguration.trafficClass")) {
                acceptor.getOutgoingConnectionChannel().getSocketConfiguration().trafficClass = Integer.parseInt(value);
            } else if (name.equalsIgnoreCase("outgoingChannel.socketConfiguration.tcpNoDelay")) {
                acceptor.getOutgoingConnectionChannel().getSocketConfiguration().tcpNoDelay = Boolean.parseBoolean(value);
            } else if (name.equalsIgnoreCase("incomingChannel.readerBufferSize")) {
                acceptor.getIncomingConnectionChannel().setReaderBufferSize(Integer.parseInt(value));
            } else if (name.equalsIgnoreCase("incomingChannel.socketConfiguration.receiveBufferSize")) {
                acceptor.getIncomingConnectionChannel().getSocketConfiguration().receiveBufferSize = Integer.parseInt(value);
            } else if (name.equalsIgnoreCase("incomingChannel.socketConfiguration.sendBufferSize")) {
                acceptor.getIncomingConnectionChannel().getSocketConfiguration().sendBufferSize = Integer.parseInt(value);
            } else if (name.equalsIgnoreCase("incomingChannel.socketConfiguration.trafficClass")) {
                acceptor.getIncomingConnectionChannel().getSocketConfiguration().trafficClass = Integer.parseInt(value);
            } else if (name.equalsIgnoreCase("incomingChannel.socketConfiguration.tcpNoDelay")) {
                acceptor.getIncomingConnectionChannel().getSocketConfiguration().tcpNoDelay = Boolean.parseBoolean(value);
            }
        };
    }

    private static PropertyObserver getHTTPPropertyObserver(HTTPAcceptor acceptor) {
        return (name, value) -> {
            if (name.equalsIgnoreCase("logEachRequest")) {
                acceptor.getConfiguration().setLogEachRequest(Boolean.parseBoolean(value));
            } else if (name.equalsIgnoreCase("logExtended")) {
                acceptor.getConfiguration().setLogExtended(Boolean.parseBoolean(value));
            } else if (name.equalsIgnoreCase("logDateFormat")) {
                acceptor.getConfiguration().setLogDateFormat(value);
            } else if (name.equalsIgnoreCase("compressResponse")) {
                acceptor.getConfiguration().setCompressResponse(Boolean.parseBoolean(value));
            } else if (name.equalsIgnoreCase("storeSessions")) {
                acceptor.getConfiguration().setStoreSessions(Boolean.parseBoolean(value));
            } else if (name.equalsIgnoreCase("webApplicationDir")) {
                acceptor.getConfiguration().setWebApplicationDir(value);
            } else if (name.equalsIgnoreCase("webArchiveDir")) {
                acceptor.getConfiguration().setWebArchiveDir(value);
            } else if (name.equalsIgnoreCase("keepAliveTimeout")) {
                acceptor.getConfiguration().setKeepAliveTimeout(Integer.parseInt(value));
            } else if (name.equalsIgnoreCase("sessionTimeout")) {
                acceptor.getConfiguration().setSessionTimeout(Integer.parseInt(value));
            } else if (name.equalsIgnoreCase("maxActiveSessionsNumber")) {
                acceptor.getConfiguration().setMaxActiveSessionsNumber(Integer.parseInt(value));
            } else if (name.equalsIgnoreCase("authenticationType")) {
                acceptor.getConfiguration().setAuthenticationType(HTTPAuthenticationType.valueOf(value));
            } else if (name.equalsIgnoreCase("sessionAuthentication")) {
                acceptor.getConfiguration().setSessionAuthentication(Boolean.parseBoolean(value));
            } else if (name.equalsIgnoreCase("enableSSL")) {
                acceptor.setEnableSSL(Boolean.parseBoolean(value));
            } else if (name.equalsIgnoreCase("keyStorePassword")) {
                acceptor.getConfiguration().setKeyStorePassword(value);
            } else if (name.equalsIgnoreCase("requestTriggerEnabled")) {
                acceptor.getConfiguration().setRequestTriggerEnabled(Boolean.parseBoolean(value));
            } else if (name.equalsIgnoreCase("enableDropBox")) {
                acceptor.getConfiguration().setEnableDropBox(Boolean.parseBoolean(value));
            }
        };
    }

    private static PropertyObserver getHTTPAdvancedProperty(HTTPAcceptor acceptor) {
        return (name, value) -> {
            if (JettyAdvancedProperties.existsDefaultProperty(name)) {
                acceptor.getConfiguration().getAdvancedProperties().setProperty(name, value);
            }
        };
    }

    private static PropertyObserver getXMPPPropertyObserver(XMPPAcceptor acceptor) {
        return (name, value) -> {
            if (name.equalsIgnoreCase("eventScope")) {
                acceptor.getConfiguration().setEventScope(EventScope.valueOf(value));
            } else if (name.equalsIgnoreCase("maxThreadsInPool")) {
                acceptor.getConfiguration().setMaxThreadsInPool(Integer.parseInt(value));
            } else if (name.equalsIgnoreCase("backlogSize")) {
                acceptor.getConfiguration().setBacklogSize(Integer.parseInt(value));
            }
        };
    }

    private static PropertyObserver getOriginObserver(Origin origin) {
        return (name, value) -> {
            if (name.equalsIgnoreCase("enabled")) {
                origin.setEnabled(Boolean.parseBoolean(value));
            } else if (name.equalsIgnoreCase("origin")) {
                origin.setOrigin(value);
            } else if (name.equalsIgnoreCase("allowCredentials")) {
                origin.setAllowCredentials(Boolean.parseBoolean(value));
            } else if (name.equalsIgnoreCase("allowedHeaders")) {
                origin.setAllowedHeaders(value);
            } else if (name.equalsIgnoreCase("allowedMethods")) {
                origin.setAllowedMethods(value);
            } else if (name.equalsIgnoreCase("exposedHeaders")) {
                origin.setExposedHeaders(value);
            } else if (name.equalsIgnoreCase("maxAge")) {
                origin.setMaxAge(Long.parseLong(value));
            }
        };
    }

    private static PropertyObserver getRealmObserver(Pair<String, RealmInfo> pair) {
        return (name, value) -> {
            if (name.equalsIgnoreCase("name")) {
                ((RealmInfo)pair.second).setRealmName(value);
            } else if (name.equalsIgnoreCase("path")) {
                pair.first = value;
            } else if (name.equalsIgnoreCase("users")) {
                ((RealmInfo)pair.second).setUsers(StringUtils.split(value, ',').stream().map(String::trim).collect(Collectors.toList()));
            } else if (name.equalsIgnoreCase("groups")) {
                ((RealmInfo)pair.second).setGroups(StringUtils.split(value, ',').stream().map(String::trim).collect(Collectors.toList()));
            }
        };
    }

    private static void setAcceptorProperties(AbstractAlterDescribeOperation.Definition definition, Acceptor acceptor) throws Exception {
        StatementBlockValue setPropertiesBlock = definition.getStatement().getBlock(String.valueOf((Object)definition.getProtocol()) + "SetPropertiesBlock");
        PropertyObserver generalObserver = AlterAcceptorOperation.getGeneralPropertyObserver(acceptor);
        AlterAcceptorOperation.parsePropertiesBlock(setPropertiesBlock, (arg_0, arg_1) -> AlterAcceptorOperation.lambda$setAcceptorProperties$9(generalObserver, switch (definition.getProtocol()) {
            case LinkProtocol.TLP, LinkProtocol.TLPS -> AlterAcceptorOperation.getTLPPropertyObserver((TLPAcceptor)acceptor);
            case LinkProtocol.HTTP, LinkProtocol.HTTPS -> AlterAcceptorOperation.getHTTPPropertyObserver((HTTPAcceptor)acceptor);
            case LinkProtocol.XMPP, LinkProtocol.XMPPS -> AlterAcceptorOperation.getXMPPPropertyObserver((XMPPAcceptor)acceptor);
            default -> throw new Exception("Unsupported acceptor protocol.");
        }, arg_0, arg_1));
    }

    private static void addRealm(AbstractAlterDescribeOperation.Definition definition, String blockName, HTTPAcceptor acceptor) throws Exception {
        StatementBlockValue setPropertiesBlock = definition.getStatement().getBlock(blockName);
        Pair<Object, RealmInfo> pair = new Pair<Object, RealmInfo>(null, new RealmInfo(acceptor.getRuntimeContext()));
        AlterAcceptorOperation.parsePropertiesBlock(setPropertiesBlock, AlterAcceptorOperation.getRealmObserver(pair));
        if (((RealmInfo)pair.second).getRealmName() == null || ((RealmInfo)pair.second).getRealmName().trim().length() == 0) {
            throw new Exception("Realm name not set.");
        }
        if (pair.first == null || ((String)pair.first).trim().length() == 0) {
            throw new Exception("Realm path not set.");
        }
        pair.first = ((String)pair.first).trim();
        pair.first = UriMatcher.normalizeUriWithLastSlashRemove((String)pair.first);
        if (acceptor.getConfiguration().getRealms().containsKey(pair.first)) {
            throw new Exception("Realm with path '" + (String)pair.first + "' already exists.");
        }
        if (acceptor.getConfiguration().getRealms().entrySet().stream().anyMatch(e -> ((RealmInfo)e.getValue()).getRealmName().equalsIgnoreCase(((RealmInfo)pair.second).getRealmName()))) {
            throw new Exception("Realm with name '" + ((RealmInfo)pair.second).getRealmName() + "' already exists.");
        }
        acceptor.getConfiguration().getRealms().put((String)pair.first, (RealmInfo)pair.second);
    }

    private static void removeRealm(AbstractAlterDescribeOperation.Definition definition, HTTPAcceptor acceptor) throws Exception {
        HashMap<String, RealmInfo> realms = acceptor.getConfiguration().getRealms();
        String realmName = definition.getStatement().getParameter("realmRemoveNameParam").getValue();
        Optional<Map.Entry> realmOption = realms.entrySet().stream().filter(e -> ((RealmInfo)e.getValue()).getRealmName().equalsIgnoreCase(realmName)).findFirst();
        if (!realmOption.isPresent()) {
            throw new Exception("Realm with name '" + realmName + "' does not exist");
        }
        realms.remove(realmOption.get().getKey());
    }

    private static void setRealm(AbstractAlterDescribeOperation.Definition definition, HTTPAcceptor acceptor) throws Exception {
        HashMap<String, RealmInfo> realms = acceptor.getConfiguration().getRealms();
        String realmName = definition.getStatement().getParameter("realmSetNameParam").getValue();
        Optional<Map.Entry> realmOption = realms.entrySet().stream().filter(e -> ((RealmInfo)e.getValue()).getRealmName().equalsIgnoreCase(realmName)).findFirst();
        if (realmOption.isPresent()) {
            RealmInfo realm = (RealmInfo)realmOption.get().getValue();
            StatementBlockValue setPropertiesBlock = definition.getStatement().getBlock("realmSetBlockModifier");
            if (setPropertiesBlock.isPresent()) {
                AlterAcceptorOperation.parsePropertiesBlock(setPropertiesBlock, AlterAcceptorOperation.getRealmObserver(new Pair<Object, RealmInfo>(null, realm)));
            } else if (definition.getStatement().existsParameter("addUserParam")) {
                realm.addUser(definition.getStatement().getParameter("addUserParam").getValue());
            } else if (definition.getStatement().existsParameter("removeUserParam")) {
                realm.removeUser(definition.getStatement().getParameter("removeUserParam").getValue());
            } else if (definition.getStatement().existsParameter("addGroupParam")) {
                realm.addGroup(definition.getStatement().getParameter("addGroupParam").getValue());
            } else if (definition.getStatement().existsParameter("removeGroupParam")) {
                realm.removeGroup(definition.getStatement().getParameter("removeGroupParam").getValue());
            }
        } else {
            throw new Exception("Realm with name '" + realmName + "' does not exist");
        }
    }

    private static void addUrlAlias(HTTPAcceptor acceptor, AbstractAlterDescribeOperation.Definition definition) throws Exception {
        String url = definition.getStatement().getParameter("addUrlAliasParam").getValue();
        String path = definition.getStatement().getParameter("pathAliasParam").getValue();
        HashMap<String, String> urlToPathAliases = acceptor.getConfiguration().getUrlToPathAliases();
        if (urlToPathAliases.containsKey(url)) {
            throw new Exception("URL already exists");
        }
        urlToPathAliases.put(url, path);
    }

    private static void removeUrlAlias(HTTPAcceptor acceptor, AbstractAlterDescribeOperation.Definition definition) throws Exception {
        String url = definition.getStatement().getParameter("removeUrlAliasParam").getValue();
        HashMap<String, String> urlToPathAliases = acceptor.getConfiguration().getUrlToPathAliases();
        if (!urlToPathAliases.containsKey(url)) {
            throw new Exception("URL does not exist");
        }
        urlToPathAliases.remove(url);
    }

    private static void setSystem(HTTPAcceptor acceptor, AbstractAlterDescribeOperation.Definition definition) throws Exception {
        if (definition.getStatement().getParameter("isSystem").isPresent()) {
            try {
                if (definition.getStatement().getParameter("isSystem").getValue().equalsIgnoreCase("true")) {
                    HTTPAcceptorApplicationsUtils.addRulesForOsAndDash(acceptor.getConfiguration());
                } else {
                    HTTPAcceptorApplicationsUtils.removeRulesForOsAndDash(acceptor.getConfiguration());
                }
            }
            catch (Exception exception) {
                Trace.logException(AlterAcceptorOperation.class, exception, true);
                throw exception;
            }
        }
    }

    private static void addApplication(HTTPAcceptor acceptor, AbstractAlterDescribeOperation.Definition definition) throws Exception {
        if (definition.getStatement().getParameter("addAppName").isPresent()) {
            try {
                HTTPAcceptorApplication application = new HTTPAcceptorApplication(definition.getStatement().getParameter("addAppName").getValue(), definition.getStatement().getParameter("appCid").getValue(), definition.getStatement().getParameter("appUri").getValue());
                HTTPAcceptorApplicationsUtils.addAcceptorApplication(acceptor.getConfiguration(), application);
            }
            catch (Exception exception) {
                Trace.logException(AlterAcceptorOperation.class, exception, true);
                throw exception;
            }
        }
    }

    private static void removeApplication(HTTPAcceptor acceptor, AbstractAlterDescribeOperation.Definition definition) throws Exception {
        if (definition.getStatement().getParameter("removeAppName").isPresent()) {
            try {
                HTTPAcceptorApplicationsUtils.removeAcceptorApplication(acceptor.getConfiguration(), definition.getStatement().getParameter("removeAppName").getValue());
            }
            catch (Exception exception) {
                Trace.logException(AlterAcceptorOperation.class, exception, true);
                throw exception;
            }
        }
    }

    private static void setProperties(AbstractAlterDescribeOperation.Definition definition, String blockName, PropertyObserver propertyObserver) throws Exception {
        StatementBlockValue setPropertiesBlock = definition.getStatement().getBlock(blockName);
        AlterAcceptorOperation.parsePropertiesBlock(setPropertiesBlock, propertyObserver);
    }

    private static void addOrigin(AbstractAlterDescribeOperation.Definition definition, String blockName, HTTPAcceptor acceptor) throws Exception {
        StatementBlockValue setPropertiesBlock = definition.getStatement().getBlock(blockName);
        Origin origin = new Origin();
        AlterAcceptorOperation.parsePropertiesBlock(setPropertiesBlock, AlterAcceptorOperation.getOriginObserver(origin));
        acceptor.getConfiguration().getOriginAccessControlConfiguration().setOrigin(origin);
    }

    private static void removeOrigin(AbstractAlterDescribeOperation.Definition definition, HTTPAcceptor acceptor) throws Exception {
        String name = definition.getStatement().getParameter("originRemoveNameParam").getValue();
        OriginAccessControlConfiguration configuration = acceptor.getConfiguration().getOriginAccessControlConfiguration();
        if (configuration.lookupOrigin(name) == null) {
            throw new Exception("Origin does not exist");
        }
        configuration.removeOrigin(name);
    }

    private static void setOrigin(AbstractAlterDescribeOperation.Definition definition, String blockName, HTTPAcceptor acceptor) throws Exception {
        StatementBlockValue setPropertiesBlock = definition.getStatement().getBlock(blockName);
        String name = definition.getStatement().getParameter("originSetNameParam").getValue();
        Origin origin = acceptor.getConfiguration().getOriginAccessControlConfiguration().lookupOrigin(name);
        if (origin == null) {
            throw new Exception("Origin does not exist");
        }
        AlterAcceptorOperation.parsePropertiesBlock(setPropertiesBlock, AlterAcceptorOperation.getOriginObserver(origin));
    }

    private void setStore(MFSession session, AbstractAlterDescribeOperation.Definition definition, HTTPAcceptor acceptor) throws Exception {
        String typeToken = definition.getStatement().getModifier("certTypeModifier").getToken();
        String storeFile = definition.getStatement().getParameter("storeFile").getValue();
        String storePassword = definition.getStatement().getParameter("storePassword").getValue(null);
        byte[] storeFileBytes = AlterAcceptorOperation.getStoreBytes(session, storeFile, storePassword);
        CertificatesFactory.StoreType type = null;
        type = typeToken.equals("keystore") ? CertificatesFactory.StoreType.KEYSTORE : CertificatesFactory.StoreType.TRUSTSTORE;
        String repoPath = HTTPSUtils.getStoreRepoPath(acceptor, type);
        if (((RuntimeContext)this.callable).getRepositoryAccessor().isFile(repoPath)) {
            ((RuntimeContext)this.callable).getRepositoryAccessor().updateFile(repoPath, storeFileBytes);
        } else {
            ((RuntimeContext)this.callable).getRepositoryAccessor().createFile(repoPath, storeFileBytes, -1L);
        }
    }

    private static byte[] getStoreBytes(MFSession session, String storeFile, String password) throws Exception {
        SLFileUtils file = (SLFileUtils)new SLFileUtilsFactory().create(session, storeFile);
        String ext = FilenameUtils.getExtension(storeFile);
        if (ext.equals(JKS_EXT)) {
            return file.getFileContent();
        }
        if (ext.equals(P12_EXT)) {
            if (password == null) {
                throw new RuntimeException("Password phase must be specified for PKCS12 format.");
            }
            try (SLFileInputStream is = file.createSLFileInputStream();){
                is.open();
                byte[] byArray = HTTPSUtils.convertP12toJKS(file.createSLFileInputStream(), password);
                return byArray;
            }
        }
        throw new RuntimeException("'" + ext + "' file is not supported.");
    }

    private void setEnableDisableDropBox(AbstractAlterDescribeOperation.Definition definition, AcceptorFactory factory, HTTPAcceptor acceptor) throws AcceptorFactoryException {
        if (definition.getStatement().existsModifier("ENABLE DROPBOX")) {
            acceptor.getConfiguration().setEnableDropBox(true);
        } else if (definition.getStatement().existsModifier("DISABLE DROPBOX")) {
            acceptor.getConfiguration().setEnableDropBox(false);
        }
    }

    private static /* synthetic */ void lambda$setAcceptorProperties$9(PropertyObserver generalObserver, PropertyObserver specificObserver, String name, String value) throws Exception {
        generalObserver.onProperty(name, value);
        specificObserver.onProperty(name, value);
    }

    @FunctionalInterface
    public static interface PropertyObserver {
        public void onProperty(String var1, String var2) throws Exception;
    }

    public static class UserCompletionAdviser
    implements CompletionAdviser<RuntimeContext> {
        @Override
        public List<String> getCompletions(String script, String processedScript, RuntimeContext callable, MFSession session) {
            try {
                return callable.getSecurityManager().getUsers().stream().map(u -> u.getName().toString()).collect(Collectors.toList());
            }
            catch (SecurityManagerException e) {
                return Collections.emptyList();
            }
        }

        @Override
        public boolean isCaseSensitive() {
            return true;
        }
    }

    public static class GroupCompletionAdviser
    implements CompletionAdviser<RuntimeContext> {
        @Override
        public List<String> getCompletions(String script, String processedScript, RuntimeContext callable, MFSession session) {
            try {
                return callable.getSecurityManager().getGroups().stream().map(g -> g.getName().toString()).collect(Collectors.toList());
            }
            catch (SecurityManagerException e) {
                return Collections.emptyList();
            }
        }

        @Override
        public boolean isCaseSensitive() {
            return true;
        }
    }

    public static class AcceptorApplicationNameCompletionAdviser
    implements CompletionAdviser<RuntimeContext> {
        @Override
        public List<String> getCompletions(String script, String processedScript, RuntimeContext callable, MFSession session) {
            Acceptor acceptor;
            String c = BufferUtils.normalizeCommand(processedScript).toLowerCase();
            int pos = c.startsWith("alter") ? AlterAcceptorOperation.NAME.length() + 1 : "describe acceptor".length() + 1;
            String acceptorName = BufferUtils.normalizeCommand(processedScript).substring(pos, c.indexOf(32, pos + 1));
            AcceptorFactory factory = callable.getAcceptorManager().lookupFactory("HTTPAcceptorFactory");
            if (factory != null && (acceptor = factory.lookupAcceptor(acceptorName.substring(acceptorName.indexOf(".") + 1))) != null) {
                return ((HTTPAcceptor)acceptor).getConfiguration().getApplications().stream().map(a -> "'" + a.getName() + "'").filter(n -> n.startsWith(script)).collect(Collectors.toList());
            }
            return new ArrayList<String>();
        }

        @Override
        public boolean isCaseSensitive() {
            return true;
        }
    }
}

