/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation.acceptor;

import com.streamscape.Trace;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.runtime.mf.operation.acceptor.AbstractAcceptorOperation;
import com.streamscape.sdo.operation.AbstractSLStatement;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sdo.rowset.RowSet;
import com.streamscape.sef.network.mf.admin.Acceptor;
import com.streamscape.sef.network.mf.admin.AcceptorFactory;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.parameter.AbstractParameter;
import com.streamscape.slex.lang.parameter.CompoundParameter;
import com.streamscape.slex.lang.parameter.IdentifierParameter;
import com.streamscape.slex.lang.parameter.RegexpValidator;
import java.util.List;

abstract class AbstractSingleAcceptorOperation
extends AbstractAcceptorOperation {
    public AbstractSingleAcceptorOperation(String operationName, String description) {
        super(true);
        this.createDSLSyntax(operationName);
        this.setSyntax(operationName);
        this.syntax.setDescription(description);
        this.syntax.addCompletionCommand("list acceptors");
        this.setExamples(operationName);
    }

    public AbstractSingleAcceptorOperation() {
        super(true);
    }

    void setSyntax(String operationName) {
        this.syntax.setAction(operationName.toUpperCase());
        this.addActionParameter();
    }

    void addActionParameter() {
        this.syntax.addActionParameter(new CompoundParameter().setParametersDelimiter('.').addParameter((AbstractParameter)((IdentifierParameter)new IdentifierParameter("TLP | HTTP | XMPP").setName("AcceptorType")).setValueValidator(new RegexpValidator("(TLP|HTTP|HTTPS|XMPP)", false))).addParameter(new IdentifierParameter("AcceptorName")));
    }

    void setExamples(String operationName) {
        this.syntax.setExamples(operationName + " tlp.Acceptor1");
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        return this.createDefinition(Definition.Protocol.valueOf(statement.getParameter("AcceptorType").getValue().toUpperCase()), statement.getParameter("AcceptorName").getValue(), statement);
    }

    @Override
    protected void doInternalParseCompletionResponse(SLResponse response, List<String> completions) {
        RowSet rowSet = response.getRowSet();
        try {
            rowSet.beforeFirst();
            while (rowSet.next()) {
                try {
                    String protocol = rowSet.getString(1);
                    String acceptorName = rowSet.getString(2);
                    String started = rowSet.getString(6);
                    if (protocol == null || acceptorName == null || started == null || !this.useAllInCompletion() && !(started.equalsIgnoreCase("true") ^ this.skipStartedAcceptorsInCompletionList())) continue;
                    completions.add(protocol.trim() + "." + acceptorName.trim());
                }
                catch (Exception exception) {
                    Trace.logException(this, exception, false);
                }
            }
        }
        catch (Exception exception) {
            Trace.logException(this, exception, false);
        }
    }

    boolean skipStartedAcceptorsInCompletionList() {
        return true;
    }

    boolean useAllInCompletion() {
        return false;
    }

    @Override
    public SLResponse invoke(SLStatement statement, MFSession session, long timeout) throws Exception {
        Definition definition = (Definition)statement;
        AcceptorFactory factory = this.getFactory(definition);
        Acceptor acceptor = factory.lookupAcceptor(definition.acceptorName);
        if (acceptor == null) {
            return new SLResponse("Acceptor not found.", false);
        }
        this.doOperation(definition, factory, acceptor);
        return new SLResponse();
    }

    AcceptorFactory getFactory(Definition definition) throws Exception {
        AcceptorFactory factory = ((RuntimeContext)this.callable).getAcceptorManager().lookupFactory(AbstractSingleAcceptorOperation.getFactoryName(definition.protocol));
        if (factory == null) {
            throw new Exception("Protocol not found.");
        }
        return factory;
    }

    void doOperation(Definition definition, AcceptorFactory factory, Acceptor acceptor) throws Exception {
    }

    static String getFactoryName(Definition.Protocol protocol) {
        switch (protocol.ordinal()) {
            case 0: {
                return "TLPAcceptorFactory";
            }
            case 1: 
            case 2: {
                return "HTTPAcceptorFactory";
            }
            case 3: {
                return "XMPPAcceptorFactory";
            }
        }
        throw new RuntimeException("Invalid Definition.Protocol!");
    }

    public abstract Definition createDefinition(Definition.Protocol var1, String var2, DSLStatement var3);

    public static class Definition
    extends AbstractSLStatement {
        private Protocol protocol;
        private String acceptorName;

        Definition(String name, Protocol protocol, String acceptorName) {
            super(name);
            this.protocol = protocol;
            this.acceptorName = acceptorName;
        }

        public Protocol getProtocol() {
            return this.protocol;
        }

        public String getAcceptorName() {
            return this.acceptorName;
        }

        public static enum Protocol {
            TLP,
            HTTP,
            HTTPS,
            XMPP;

        }
    }
}

