/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation.acceptor;

import com.streamscape.lib.utils.Base64Encoder;
import com.streamscape.lib.utils.StringUtils;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.runtime.mf.operation.AbstractDiagnosticOperation;
import com.streamscape.sef.network.http.acceptor.HTTPAcceptor;
import com.streamscape.sef.network.http.server.utils.HTTPSUtils;
import com.streamscape.sef.network.mf.admin.CertificatesFactory;
import com.streamscape.slex.lang.OperationTag;
import java.io.ByteArrayInputStream;
import java.security.cert.X509Certificate;

abstract class AbstractAcceptorOperation
extends AbstractDiagnosticOperation<RuntimeContext> {
    AbstractAcceptorOperation(boolean isAdministrative) {
        super(isAdministrative);
    }

    @Override
    protected void createDSLSyntax(String name) {
        super.createDSLSyntax(name);
        this.syntax.addTag(OperationTag.acceptor);
    }

    protected byte[] getRepoStoreBytes(HTTPAcceptor acceptor, CertificatesFactory.StoreType type) throws Exception {
        String repoPath = HTTPSUtils.getStoreRepoPath(acceptor, type);
        if (!((RuntimeContext)this.callable).getRepositoryAccessor().existsFile(repoPath)) {
            throw new Exception(StringUtils.toCapitalized(type.name().toLowerCase()) + " does not exist.");
        }
        return ((RuntimeContext)this.callable).getRepositoryAccessor().getFileContentBytes(repoPath);
    }

    protected X509Certificate getCertificate(HTTPAcceptor acceptor, CertificatesFactory.StoreType type) throws Exception {
        String pass = null;
        if (type.equals((Object)CertificatesFactory.StoreType.KEYSTORE)) {
            pass = new String(new Base64Encoder().decode(acceptor.getConfiguration().getKeyStorePassword()));
        }
        ByteArrayInputStream is = new ByteArrayInputStream(this.getRepoStoreBytes(acceptor, type));
        return HTTPSUtils.getCertificate(is, pass);
    }
}

