/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation;

import com.streamscape.sef.FabricException;
import com.streamscape.slex.lang.modifier.Modifier;
import com.streamscape.slex.lang.parameter.AbstractParameter;
import com.streamscape.slex.lang.parameter.IdentifierParameter;
import com.streamscape.slex.lang.parameter.SetParameter;
import com.streamscape.slex.lang.parameter.StringParameter;
import com.streamscape.slex.lang.value.StatementSetValue;
import com.streamscape.slex.lang.value.StatementValueList;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class SetParametersModifier
extends Modifier {
    public SetParametersModifier(String modifierName, String parameterName) {
        this(modifierName, parameterName, true);
    }

    public SetParametersModifier(String modifierName, String parameterName, boolean required) {
        this(modifierName, parameterName, new IdentifierParameter("Name"), new StringParameter("Value"), required);
    }

    public SetParametersModifier(String modifierName, String parameterName, AbstractParameter name, AbstractParameter value, boolean required) {
        super(modifierName, required);
        this.addParameter(new SetParameter(parameterName, name, value).setDelimiter(new Modifier("=")));
    }

    public static Map<String, String> getValue(StatementValueList statement, String parameterName) {
        return SetParametersModifier.getValue(statement, parameterName, "Name", "Value");
    }

    public static Map<String, String> getValue(StatementValueList statement, String parameterName, String nameName, String valueName) {
        StatementSetValue parameter = statement.getSet(parameterName);
        return IntStream.range(0, parameter.size()).mapToObj(parameter::getElement).collect(Collectors.toMap(p -> p.getParameter(nameName).getValue(), p -> p.getParameter(valueName).getValue(), (a, b) -> b));
    }

    public static boolean getBoolean(String name, String value) throws Exception {
        try {
            return Boolean.parseBoolean(value);
        }
        catch (Exception exception) {
            throw new FabricException("Invalid boolean value '" + value + "' for property '" + name + "'.");
        }
    }

    public static int getInt(String name, String value) throws Exception {
        try {
            return Integer.parseInt(value);
        }
        catch (Exception exception) {
            throw new FabricException("Invalid integer value '" + value + "' for property '" + name + "'.");
        }
    }

    public static long getLong(String name, String value) throws Exception {
        try {
            return Long.parseLong(value);
        }
        catch (Exception exception) {
            throw new FabricException("Invalid long value '" + value + "' for property '" + name + "'.");
        }
    }
}

