/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation;

import com.streamscape.lib.fs.client.BinaryFileCodec;
import com.streamscape.lib.fs.client.FileCodec;
import com.streamscape.lib.fs.client.FileSystem;
import com.streamscape.lib.fs.client.FileSystemProvider;
import com.streamscape.lib.fs.client.NodeTmpDirectory;
import com.streamscape.lib.utils.ClassUtils;
import com.streamscape.lib.utils.FileIOUtils;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.sdo.operation.AbstractSLStatement;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sef.dispatcher.AbstractOperation;
import com.streamscape.sef.dispatcher.SLOperationLogger;
import com.streamscape.sef.dropbox.dsl.MergeFilesDropBoxOperation;
import com.streamscape.sef.network.http.server.dropbox.DropBoxException;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.file.SLFileOutputStream;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.modifier.AbstractModifier;
import com.streamscape.slex.lang.modifier.Modifier;
import com.streamscape.slex.lang.parameter.SLFilePathParameter;
import com.streamscape.slex.lang.parameter.SetParameter;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;

public class MergeFilesOperation
extends AbstractOperation<RuntimeContext> {
    public static final String NAME = "merge files";
    public static final String MERGE_FILES_DIRECTORY = "mergefiles";

    public MergeFilesOperation() {
        this.createDSLSyntax(NAME);
        this.syntax.setAction("MERGE FILES").addActionParameter(new SetParameter("inputFilesSet").addParameter(new SLFilePathParameter("input file")));
        this.syntax.addModifier((AbstractModifier)new Modifier("TO").addParameter(new SLFilePathParameter("output file")));
        this.syntax.addModifier(MergeFilesDropBoxOperation.createCodecCompound());
        this.syntax.addModifier((AbstractModifier)((Modifier)new Modifier("DELETE SOURCE").setName("deleteSource")).setRequired(false));
        this.syntax.setDescription("Merges file into single one using specified file.\n\nParameters:\n\n   input file     - path to input files in dropbox\n   output file    - path to output files in dropbox\n   codec          - one of binary or audio\n                    - binary - simple append files\n                    - audio  - merge files using ffmpeg library\n   args           - codec args\n   delete source  - delete all input files\n");
        this.syntax.setExamples("merge files ('dropbox://mydropbopx/$myfolder/text1.txt', 'dropbox://mydropbopx/$myfolder/text2.txt') to 'dropbox://mydropbopx/$myfolder/mergedtext.txt' codec binary\nmerge files ('dropbox://mydropbopx/$myfolder/audio1.webm', 'dropbox://mydropbopx/$myfolder/audio2.webm') to 'dropbox://mydropbopx/$myfolder/mergedaudio.webm' codec audio\n");
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        return new Definition(statement);
    }

    @Override
    public SLResponse invoke(SLStatement definition, MFSession session, long timeout) throws Exception {
        DSLStatement statement = ((Definition)definition).statement;
        List<String> inputFiles = statement.getSet("inputFilesSet").getElements().stream().map(element -> element.getParameter("input file").getValue()).collect(Collectors.toList());
        String outputFile = statement.getParameter("output file").getValue();
        MergeFilesDropBoxOperation.CodecCompound codecCompound = MergeFilesDropBoxOperation.parseCodecCompound(statement);
        boolean deleteSource = statement.existsModifier("deleteSource");
        SLOperationLogger.setCurrentSession(session);
        MergeFilesOperation.mergeFiles(f -> new FileSystemProvider((RuntimeContext)this.callable).createFileSystem(session, (String)f), inputFiles, outputFile, codecCompound.codecType, codecCompound.args, deleteSource);
        return new SLResponse();
    }

    public static void mergeFiles(Function<String, FileSystem> fileSystemProducer, List<String> inputFiles, String outputFile, FileCodec.FileCodecType codecType, String args, boolean deleteSource) throws Exception {
        FileCodec fileCodec = null;
        switch (codecType) {
            case AUDIO: {
                try {
                    Class audioFileCodecClass;
                    try {
                        audioFileCodecClass = ClassUtils.loadClass("com.streamscape.codec.AudioFileCodec", RuntimeContext.getInstance().getSystemClassLoaderChain());
                    }
                    catch (ClassNotFoundException e) {
                        audioFileCodecClass = ClassUtils.loadClass("com.streamscape.codec.AudioFileCodec", null);
                    }
                    fileCodec = (FileCodec)audioFileCodecClass.newInstance();
                    break;
                }
                catch (Exception exception) {
                    throw new DropBoxException("Audio codec is not available.");
                }
            }
            case BINARY: {
                fileCodec = new BinaryFileCodec();
            }
        }
        try (FileSystem fileSystem = fileSystemProducer.apply(outputFile);){
            if (fileSystem.exists(outputFile)) {
                throw new Exception("Output file " + outputFile + " already exist.");
            }
        }
        List<String> inputFilesLocal = inputFiles.stream().map(file -> {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 33[DOLOOP]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1050)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }).collect(Collectors.toList());
        File outputFileLocal = NodeTmpDirectory.createNodeTmpFile(MERGE_FILES_DIRECTORY, "merge", outputFile.substring(outputFile.lastIndexOf(".") != -1 ? outputFile.lastIndexOf(".") : 0));
        outputFileLocal.delete();
        SLOperationLogger.log("Merging files to local temporary  file " + NodeTmpDirectory.getRelativeFilePathOfNodeRoot(outputFileLocal) + " ...\n");
        fileCodec.mergeFiles(outputFileLocal.getAbsolutePath(), inputFilesLocal, args);
        SLOperationLogger.log("Copying local temporary  file " + NodeTmpDirectory.getRelativeFilePathOfNodeRoot(outputFileLocal) + " to " + outputFile + " ...\n");
        try (FileSystem fileSystem = fileSystemProducer.apply(outputFile);
             OutputStream fileOutputStream = fileSystem.openForWrite(outputFile);
             BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream);){
            if (fileOutputStream instanceof SLFileOutputStream) {
                ((SLFileOutputStream)fileOutputStream).setVerbose(false);
                ((SLFileOutputStream)fileOutputStream).open();
            }
            FileIOUtils.copy((InputStream)new FileInputStream(outputFileLocal), fileOutputStream);
        }
        if (deleteSource) {
            SLOperationLogger.log("Deleting source files ...\n");
            inputFiles.forEach(file -> {
                try (FileSystem fileSystem = (FileSystem)fileSystemProducer.apply((String)file);){
                    fileSystem.delete((String)file, false);
                }
                catch (Exception e) {
                    throw new RuntimeException("Failed to delete file " + file, e);
                }
            });
        }
    }

    public static class Definition
    extends AbstractSLStatement {
        private DSLStatement statement;

        public Definition(DSLStatement statement) {
            super(MergeFilesOperation.NAME);
            this.statement = statement;
        }
    }
}

