/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation;

import com.streamscape.runtime.RuntimeContext;
import com.streamscape.runtime.mf.operation.AbstractDiagnosticOperation;
import com.streamscape.runtime.mf.operation.AtNodeOrAtDomainModifier;
import com.streamscape.sdo.operation.AbstractSLStatement;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sdo.rowset.RowMetaData;
import com.streamscape.sdo.rowset.RowSet;
import com.streamscape.sef.moderator.FabricNodeReference;
import com.streamscape.slex.AbstractMFSession;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.modifier.AbstractModifier;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class ListWorkingDirectoryOperation<T extends RuntimeContext>
extends AbstractDiagnosticOperation<T> {
    private static final String NAME = "list working directory";
    private static final Set<String> EXCLUDED_DIRECTORIES = new HashSet<String>(Arrays.asList(".tfcache", ".dscache", ".htcache"));
    private static final String JUNK_DIRECTORY = ".junk";

    public ListWorkingDirectoryOperation() {
        this.createDSLSyntax(NAME);
        this.syntax.setAction("LIST WORKING DIRECTORY");
        this.addAtNodeOrAtDomainModifier();
        this.syntax.setDescription("Shows a list of files and directories in the working directory.\nSize of file is specified in bytes.");
        this.syntax.setSyntaxDescription("list working directory                    - Shows a list of files in the working directory of the current node.\nlist working directory at node <NodeName> - Shows a list of files in the working directory of the specified node.");
    }

    protected void addAtNodeOrAtDomainModifier() {
        this.syntax.addModifier((AbstractModifier)new AtNodeOrAtDomainModifier(false).setSyntaxHintSpace());
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        return new Definition(AtNodeOrAtDomainModifier.getValue(statement));
    }

    @Override
    public SLResponse invoke(SLStatement statement, MFSession session, long timeout) throws Exception {
        return this.invoke(((Definition)statement).nodeName, statement, session, timeout);
    }

    @Override
    public SLResponse invokeLocal(FabricNodeReference node, SLStatement statement, AbstractMFSession session, long timeout) throws Exception {
        return this.doInvokeLocal(((RuntimeContext)this.callable).getStartupDir());
    }

    protected SLResponse doInvokeLocal(String workingDir) throws Exception {
        RowSet result = new RowSet(ListWorkingDirectoryOperation.createResultDescriptor());
        File workingDirFile = new File(workingDir);
        workingDir = workingDirFile.getCanonicalPath();
        ArrayList<File> files = new ArrayList<File>();
        this.getFiles(workingDirFile, files);
        for (File file : files) {
            result.addToRowSet(new Object[]{this.formatPath(file, workingDir), file.isFile() ? Long.valueOf(file.length()) : ""});
        }
        return new SLResponse(result);
    }

    private void getFiles(File dir, List<File> result) {
        for (File file : dir.listFiles()) {
            if (file.getName().equals(JUNK_DIRECTORY)) continue;
            result.add(file);
            if (!file.isDirectory() || EXCLUDED_DIRECTORIES.contains(file.getName())) continue;
            this.getFiles(file, result);
        }
    }

    private String formatPath(File file, String workingDir) throws Exception {
        String result = file.getCanonicalPath();
        result = result.substring(workingDir.length() + 1);
        return result.replace(File.separatorChar, '/') + (file.isDirectory() ? "/" : "");
    }

    private static RowMetaData createResultDescriptor() {
        RowMetaData result = new RowMetaData();
        ListWorkingDirectoryOperation.addColumn(result, "File");
        ListWorkingDirectoryOperation.addColumn(result, "Size");
        return result;
    }

    public static class Definition
    extends AbstractSLStatement {
        private String nodeName;

        public Definition(String nodeName) {
            super(ListWorkingDirectoryOperation.NAME);
            this.nodeName = nodeName;
        }

        public String getNodeName() {
            return this.nodeName;
        }
    }
}

