/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation;

import com.streamscape.Trace;
import com.streamscape.lib.fs.client.FileSystem;
import com.streamscape.lib.fs.client.FileSystemProvider;
import com.streamscape.lib.utils.FileIOUtils;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.runtime.mf.operation.LocationModifier;
import com.streamscape.sdo.operation.AbstractSLStatement;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sef.dispatcher.AbstractOperation;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.file.SLFileUtils;
import com.streamscape.slex.file.SLFileUtilsFactory;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.modifier.AbstractModifier;
import com.streamscape.slex.lang.parameter.SLFilePathCompleter;
import com.streamscape.tools.slang.model.MlmUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ImportMlmOperation
extends AbstractOperation<RuntimeContext> {
    public static final String NAME = "import mlm";

    public ImportMlmOperation() {
        this.createDSLSyntax(NAME);
        this.syntax.setAction("IMPORT MLM").addModifier((AbstractModifier)new LocationModifier(true, new SLFilePathCompleter()).setSyntaxHintSpace());
        this.syntax.setDescription("Imports MLM model file to .mlcache for corresponding service. Service should be registered in node.");
        this.syntax.setExamples("import mlm at './mymodel.mlm'");
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        return new Definition(NAME, statement.getParameter("Location").getValue());
    }

    @Override
    public SLResponse invoke(SLStatement statement, MFSession session, long timeout) throws Exception {
        Definition definition = (Definition)statement;
        File sourceModelFile = new File(definition.location);
        try (FileSystem sourceFileSystem = new FileSystemProvider(RuntimeContext.getInstance()).createFileSystem(session, definition.location);){
            String serviceType;
            if (!sourceFileSystem.exists(definition.location)) {
                throw new Exception("Model with specified path doesn't exist.");
            }
            Map<String, Object> info = MlmUtils.getModelInfoFromMlm((SLFileUtils)new SLFileUtilsFactory().create(session, definition.location));
            if (info == null) {
                throw new Exception("Failed to read model or model not found.");
            }
            MlmUtils.setModelMissingProperties(info);
            Object serviceTypeObject = info.getOrDefault("serviceType", "");
            String string = serviceType = serviceTypeObject != null ? serviceTypeObject.toString() : null;
            if (serviceType == null) {
                throw new Exception("Model service is not defined.");
            }
            if (((RuntimeContext)this.callable).getServiceManager().listRegisteredServices().stream().filter(s -> s.startsWith(serviceType)).count() == 0L) {
                throw new Exception("Warning: Service Type " + serviceType + " for Model Archive " + sourceModelFile.getName() + " is not installed. Install the service and retry the import.");
            }
            File mlcacheDir = new File(".mlcache/sys/models/" + serviceType);
            if (!mlcacheDir.exists()) {
                mlcacheDir.mkdirs();
            }
            File targetFile = new File(mlcacheDir, sourceModelFile.getName());
            List<Map<String, Object>> existingInfos = MlmUtils.getModelInfos(serviceType);
            if (existingInfos.stream().filter(i -> Objects.equals(info.get("name"), i.get("name"))).count() > 0L) {
                throw new Exception("Model with name '" + String.valueOf(info.get("name")) + "' already exists in mlcache.");
            }
            if (targetFile.exists()) {
                throw new Exception("Model with filename '" + targetFile.getName() + "' already exists in mlcache.");
            }
            long sourceFileSize = sourceFileSystem.getSize(definition.location);
            try (InputStream inputStream = sourceFileSystem.open(definition.location);
                 FileOutputStream outputStream = new FileOutputStream(targetFile);){
                FileIOUtils.copy(inputStream, (OutputStream)outputStream);
            }
            catch (Exception exception) {
                Trace.logError(this, "Failed to import model: " + exception.toString());
                targetFile.delete();
                throw exception;
            }
            long targetFileSize = targetFile.length();
            if (sourceFileSize != 0L && targetFileSize != sourceFileSize) {
                Trace.logError(this, "Failed to import model from " + definition.location + ", size mismatch.");
                targetFile.delete();
                throw new Exception("Failed to import model from " + definition.location + ", size mismatch.");
            }
        }
        return new SLResponse();
    }

    public static class Definition
    extends AbstractSLStatement {
        private final String location;

        Definition(String name, String location) {
            super(name);
            this.location = location;
        }
    }
}

