/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation;

import com.streamscape.runtime.RuntimeContext;
import com.streamscape.runtime.mf.operation.LocationModifier;
import com.streamscape.sdo.operation.AbstractSLStatement;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sef.dispatcher.AbstractOperation;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.file.SLFileUtils;
import com.streamscape.slex.file.SLFileUtilsFactory;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.completion.DSLCompletion;
import com.streamscape.slex.lang.completion.ScriptCompleter;
import com.streamscape.slex.lang.completion.SuggestionGroup;
import com.streamscape.slex.lang.completion.TokenSuggestion;
import com.streamscape.slex.lang.modifier.AbstractModifier;
import com.streamscape.slex.lang.modifier.ChoiceModifier;
import com.streamscape.slex.lang.modifier.Modifier;
import com.streamscape.slex.lang.parameter.SLFilePathCompleter;
import com.streamscape.tools.console.autocompletion.CompoundCompleter;
import com.streamscape.tools.slang.model.DescribeMlmSessionOperation;
import com.streamscape.tools.slang.model.MlmUtils;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Map;
import java.util.stream.Collectors;

public class DescribeMlmRuntimeOperation
extends AbstractOperation<RuntimeContext> {
    public static final String NAME = "describe mlm";

    public DescribeMlmRuntimeOperation() {
        this.createDSLSyntax(NAME);
        this.syntax.setAction("DESCRIBE MLM").addModifier((AbstractModifier)new LocationModifier(true, new LocalMlmPathCompleter()).setSyntaxHintSpace());
        this.syntax.addModifier((AbstractModifier)((ChoiceModifier)((ChoiceModifier)((ChoiceModifier)new ChoiceModifier().addModifier(new Modifier("README"))).addModifier(new Modifier("LICENSE"))).addModifier(new Modifier("CONF"))).setRequired(false));
        this.syntax.setDescription("Shows information about the mlm file .");
        this.syntax.setExamples("describe mlm at './mymodel.mlm'\n");
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        return new Definition(NAME, statement.getParameter("Location").getValue(), statement.existsModifier("README"), statement.existsModifier("LICENSE"), statement.existsModifier("CONF"));
    }

    @Override
    public SLResponse invoke(SLStatement statement, MFSession session, long timeout) throws Exception {
        Map<String, Object> info;
        Definition definition = (Definition)statement;
        if (definition.location.startsWith("sys/models")) {
            File file = new File(".mlcache/" + definition.location);
            if (!file.exists()) {
                throw new Exception("Model with specified path doesn't exist.");
            }
            info = MlmUtils.getModelInfoFromMlm(file.getPath(), new File(file.getParent()).getName());
        } else {
            SLFileUtils file = (SLFileUtils)new SLFileUtilsFactory().create(session, definition.location);
            if (!file.exists()) {
                throw new Exception("Model with specified path doesn't exist.");
            }
            info = MlmUtils.getModelInfoFromMlm(file);
        }
        if (info == null) {
            throw new Exception("Failed to read model or model not found.");
        }
        return DescribeMlmSessionOperation.doInvoke(info, definition.conf, definition.license, definition.readme);
    }

    static class LocalMlmPathCompleter<T>
    implements ScriptCompleter<T> {
        LocalMlmPathCompleter() {
        }

        @Override
        public DSLCompletion complete(String script, String processedScript, T callable, MFSession session) {
            DSLCompletion localCompletion = this.completeLocal(script, processedScript, callable, session);
            DSLCompletion slCompletion = new SLFilePathCompleter<T>(true).complete(script, processedScript, callable, session);
            return CompoundCompleter.mergeCompletions(processedScript, localCompletion, slCompletion);
        }

        public DSLCompletion completeLocal(String script, String processedScript, T callable, MFSession session) {
            if (!script.startsWith("'") || script.length() > 1 && script.endsWith("'")) {
                return null;
            }
            String namePrefix = script.substring(1);
            ArrayList<String> suggestions = new ArrayList<String>();
            File mlcacheModels = new File(".mlcache/sys/models");
            try {
                suggestions.addAll(Files.walk(mlcacheModels.toPath(), 2, FileVisitOption.FOLLOW_LINKS).filter(p -> p.toString().endsWith(".mlm")).map(p -> "sys/models/" + String.valueOf(p.getParent().getFileName()) + "/" + String.valueOf(p.getFileName())).filter(p -> p.startsWith(namePrefix)).collect(Collectors.toList()));
            }
            catch (IOException iOException) {
                // empty catch block
            }
            DSLCompletion completion = DSLCompletion.buildPrefixAndCompletion(namePrefix, suggestions);
            if (completion != null) {
                for (String suggestion : suggestions) {
                    completion.addSuggestion(new TokenSuggestion(suggestion, SuggestionGroup.PATH).setOffset(namePrefix));
                }
                completion.checkAndCompress();
                completion.moveSingleSuggestionToCompletion();
            }
            return completion;
        }
    }

    public static class Definition
    extends AbstractSLStatement {
        private final String location;
        private final boolean readme;
        private final boolean license;
        private final boolean conf;

        Definition(String name, String location, boolean readme, boolean license, boolean conf) {
            super(name);
            this.location = location;
            this.readme = readme;
            this.license = license;
            this.conf = conf;
        }
    }
}

