/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation;

import com.streamscape.runtime.RuntimeContext;
import com.streamscape.runtime.mf.operation.AbstractHostOperation;
import com.streamscape.runtime.stats.RuntimeStats;
import com.streamscape.runtime.stats.SystemEnvironment;
import com.streamscape.sdo.operation.AbstractSLStatement;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sdo.rowset.RowSet;
import com.streamscape.sef.dispatcher.AbstractOperation;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.DSLStatement;
import java.util.Date;

public class DescribeHostOperation
extends AbstractHostOperation {
    public static final String NAME = "describe host";

    public DescribeHostOperation() {
        this.createDSLSyntax(NAME);
        this.syntax.setAction("DESCRIBE HOST");
        this.syntax.setDescription("Shows extended information about the host.");
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        return new Definition();
    }

    @Override
    public SLResponse invoke(SLStatement statement, MFSession session, long timeout) throws Exception {
        RowSet rowSet = this.addBasicFields();
        SystemEnvironment env = ((RuntimeContext)this.callable).getStatsMonitor().getSystemEnvironment();
        RuntimeStats stats = ((RuntimeContext)this.callable).getStatsMonitor().getRuntimeStats();
        DescribeHostOperation.add(rowSet, new Object[]{"OS Name", env.getOsName()});
        DescribeHostOperation.add(rowSet, new Object[]{"OS Architecture", env.getOsArchitecture()});
        DescribeHostOperation.add(rowSet, new Object[]{"OS Version", env.getOsVersion()});
        DescribeHostOperation.add(rowSet, new Object[]{"Processors Number", env.getProcessorsNumber()});
        DescribeHostOperation.add(rowSet, new Object[]{"Current Time", DescribeHostOperation.formatDate(new Date())});
        DescribeHostOperation.add(rowSet, new Object[]{"Total Physical Memory", AbstractOperation.Scale.MB.format(env.getTotalPhysicalMemorySize())});
        DescribeHostOperation.add(rowSet, new Object[]{"Free Physical Memory", AbstractOperation.Scale.MB.format(stats.getFreePhysicalMemorySize())});
        DescribeHostOperation.add(rowSet, new Object[]{"Used Physical Memory", AbstractOperation.Scale.MB.format(env.getTotalPhysicalMemorySize() - stats.getFreePhysicalMemorySize())});
        DescribeHostOperation.add(rowSet, new Object[]{"Total Swap Space", AbstractOperation.Scale.MB.format(env.getTotalSwapSpaceSize())});
        DescribeHostOperation.add(rowSet, new Object[]{"Free Swap Space", AbstractOperation.Scale.MB.format(stats.getFreeSwapSpaceSize())});
        DescribeHostOperation.add(rowSet, new Object[]{"Used Swap Space", AbstractOperation.Scale.MB.format(env.getTotalSwapSpaceSize() - stats.getFreeSwapSpaceSize())});
        DescribeHostOperation.add(rowSet, new Object[]{"Total Disk Space", AbstractOperation.Scale.MB.format(stats.getTotalDiskSpace())});
        DescribeHostOperation.add(rowSet, new Object[]{"Free Disk Space", AbstractOperation.Scale.MB.format(stats.getFreeDiskSpace())});
        DescribeHostOperation.add(rowSet, new Object[]{"Used Disk Space", AbstractOperation.Scale.MB.format(stats.getUsedDiskSpace())});
        DescribeHostOperation.add(rowSet, new Object[]{"JVM Name", env.getJvmName()});
        DescribeHostOperation.add(rowSet, new Object[]{"JVM Vendor", env.getJvmVendor()});
        DescribeHostOperation.add(rowSet, new Object[]{"JVM Version", env.getJvmVersion()});
        return new SLResponse(rowSet);
    }

    public static class Definition
    extends AbstractSLStatement {
        public Definition() {
            super(DescribeHostOperation.NAME);
        }
    }
}

