/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation;

import com.streamscape.runtime.RuntimeContext;
import com.streamscape.runtime.mf.operation.AtNodeOrAtDomainModifier;
import com.streamscape.runtime.mf.operation.EventScopeModifier;
import com.streamscape.sdo.operation.AbstractSLStatement;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sdo.rowset.RowMetaData;
import com.streamscape.sdo.rowset.RowSet;
import com.streamscape.sef.dispatcher.AbstractOperation;
import com.streamscape.sef.enums.EventScope;
import com.streamscape.sef.moderator.FabricNodeReference;
import com.streamscape.slex.AbstractMFSession;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.DSLStatementSyntax;
import com.streamscape.slex.lang.modifier.AbstractModifier;
import com.streamscape.slex.lang.modifier.Modifier;
import com.streamscape.slex.lang.parameter.AbstractParameter;
import java.util.regex.Pattern;

public abstract class AbstractListServicesDataspacesOperation
extends AbstractOperation<RuntimeContext> {
    protected AbstractListServicesDataspacesOperation(String name) {
        this.createDSLSyntax(name);
        this.syntax.setAction(name.toUpperCase());
        this.addSelectionModifiers();
        this.syntax.addModifier(AbstractListServicesDataspacesOperation.createLikeModifier());
        this.syntax.addModifier((AbstractModifier)new Modifier("TYPE", false).addParameter(this.createTypeParameter()));
        this.syntax.addModifier(new EventScopeModifier(false));
        this.syntax.addModifier(new AtNodeOrAtDomainModifier());
        this.syntax.setDescription("Returns a list of user " + this.getEntityName() + "s.");
        String entitiesName = this.getEntityName() + "s";
        this.syntax.setSyntaxDescription(name + "           - Returns a list of " + entitiesName + " in the current node.\n" + name + " at node   - Returns a list of " + entitiesName + " in the specified node.\n" + name + " at domain - Returns a list of " + entitiesName + " in all nodes of the sysplex.\n\nParameters:\n\n   all         - Returns a list of all (system and user) " + entitiesName + ".\n" + this.getSelectionParametersDescription() + this.getLikeParameterDescription(entitiesName) + "   type        - Returns a list of " + entitiesName + " of the specified type.\n   event scope - Returns a list of " + entitiesName + " of the specified event scope.");
        this.syntax.setExamples(name + "\n" + name + " at node Node1\n" + name + " at domain\n" + name + " like 'Test%'\n" + name + " type " + this.getTypeForExamples() + "\n" + name + " type " + this.getTypeForExamples() + " event scope global\n" + name + " all event scope observable at node Node1\n" + name + " type " + this.getTypeForExamples() + " event scope global at domain" + this.getOtherExamples());
    }

    protected void addSelectionModifiers() {
        this.syntax.addModifier((AbstractModifier)AbstractListServicesDataspacesOperation.createAllModifier().setRequired(false));
    }

    protected static Modifier createAllModifier() {
        return (Modifier)new Modifier("ALL").setAlias("*");
    }

    protected abstract AbstractParameter createTypeParameter();

    protected abstract String getEntityName();

    protected String getSelectionParametersDescription() {
        return "";
    }

    protected String getLikeParameterDescription(String entitiesName) {
        return "   like        - Returns a list of " + entitiesName + " whose name matches the specified pattern.\n" + AbstractListServicesDataspacesOperation.getLikeModifierDescription("                 ", "\n");
    }

    protected abstract String getTypeForExamples();

    protected String getOtherExamples() {
        return "";
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        return new Definition(this.getName(), this.syntax, statement);
    }

    @Override
    public SLResponse invoke(SLStatement statement, MFSession session, long timeout) throws Exception {
        return this.invoke(((Definition)statement).nodeName, statement, session, timeout, true, false);
    }

    @Override
    public SLResponse invokeLocal(FabricNodeReference node, SLStatement statement, AbstractMFSession session, long timeout) throws Exception {
        RowSet result = new RowSet(AbstractListServicesDataspacesOperation.createResultDescriptor());
        this.fillResult((Definition)statement, session, AbstractListServicesDataspacesOperation.compileExtendedPattern(((Definition)statement).pattern), result);
        return new SLResponse(result);
    }

    protected abstract void fillResult(Definition var1, MFSession var2, Pattern var3, RowSet var4) throws Exception;

    protected boolean isSuitable(String type, String name, EventScope eventScope, Definition definition, MFSession session, Pattern pattern) {
        return this.matchesSelection(type, name, definition, session) && this.matchesType(type, definition) && this.matchesEventScope(eventScope, definition) && this.matchesPattern(name, definition, pattern);
    }

    protected boolean matchesSelection(String type, String name, Definition definition, MFSession session) {
        return AbstractListServicesDataspacesOperation.isAll(definition.all, session) || !this.isSystem(type, name);
    }

    protected boolean matchesType(String type, Definition definition) {
        return true;
    }

    protected boolean matchesEventScope(EventScope eventScope, Definition definition) {
        return definition.eventScope == null || definition.eventScope.equals((Object)eventScope);
    }

    protected boolean matchesPattern(String name, Definition definition, Pattern pattern) {
        return pattern == null || pattern.matcher(name).matches();
    }

    protected abstract boolean isSystem(String var1, String var2);

    private static RowMetaData createResultDescriptor() {
        RowMetaData result = new RowMetaData();
        AbstractListServicesDataspacesOperation.addColumn(result, "Node");
        AbstractListServicesDataspacesOperation.addColumn(result, "Type");
        AbstractListServicesDataspacesOperation.addColumn(result, "Name");
        AbstractListServicesDataspacesOperation.addColumn(result, "Event Scope");
        AbstractListServicesDataspacesOperation.addColumn(result, "State");
        return result;
    }

    protected static class Definition
    extends AbstractSLStatement {
        public boolean all;
        public ModelType modelType;
        public String pattern;
        public String type;
        public EventScope eventScope;
        public String nodeName;

        protected Definition(String name, DSLStatementSyntax syntax, DSLStatement statement) throws ParsingException {
            super(name);
            this.all = statement.existsModifier("ALL");
            if (statement.existsModifier("MODEL")) {
                this.modelType = ModelType.MODEL;
            }
            if (statement.existsModifier("AND")) {
                this.modelType = ModelType.AND_MODEL;
            }
            this.pattern = AbstractListServicesDataspacesOperation.getLikeParameterValue(statement);
            if (statement.existsParameter("Type")) {
                this.type = statement.getParameter("Type").getValue();
            }
            this.eventScope = EventScopeModifier.getValue(syntax, statement);
            this.nodeName = AtNodeOrAtDomainModifier.getValue(statement);
        }
    }

    protected static enum ModelType {
        MODEL,
        AND_MODEL;

    }
}

