/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.admin.xmpp;

import com.streamscape.cli.xmpp.XMPPClientException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.rowset.RowSet;
import com.streamscape.sdo.xmpp.Roster;
import com.streamscape.sdo.xmpp.RosterEntry;
import com.streamscape.sef.dispatcher.AbstractSystemStore;
import java.sql.SQLException;

public class XMPPEntityStore
extends AbstractSystemStore {
    public static final String PROTOTYPE = "prototype";
    public static final String SHOW_CONFIGURATION_PANEL = "wizard.xmpp.configuration.panel.show";
    public static final String DEFAULT_OBJECT = "wizard.xmpp.default";
    public static final String XMPP_GROUP = "XMPP";
    public static final String XMPP_ROSTER_TABLE_NAME = "PRESENCE_ROSTER";
    private static XMPPEntityStore instance = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static XMPPEntityStore getInstance() throws Exception {
        if (instance != null) return instance;
        Class<XMPPEntityStore> clazz = XMPPEntityStore.class;
        synchronized (XMPPEntityStore.class) {
            if (instance != null) return instance;
            instance = new XMPPEntityStore();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    XMPPEntityStore() throws Exception {
    }

    @Override
    protected void initAccessor() throws Exception {
        if (this.accessor.lookupCollection(XMPP_ROSTER_TABLE_NAME) == null) {
            SLResponse response = this.invokeStatement("CREATE PERSISTENT TABLE PRESENCE_ROSTER(USER_NAME varchar(255), USER_NAME_TO varchar(255), SUBSCRIPTION varchar(8), ROSTER_NAME varchar(255), GROUP_NAME varchar(255), COMPONENT_TYPE varchar(255), ASK varchar(16))");
            this.checkWithException(response, "Creation of table 'PRESENCE_ROSTER'");
        }
    }

    SLResponse getRosterEntryResponse(String user, String userTo) throws Exception {
        return this.accessor.invokeLanguageRequest("SELECT * FROM PRESENCE_ROSTER WHERE USER_NAME='" + user + "' AND USER_NAME_TO='" + userTo + "'");
    }

    public synchronized RosterEntry getRosterEntry(String user, String userTo) throws Exception {
        SLResponse response = this.getRosterEntryResponse(user, userTo);
        if (response == null || !response.isOK() || !response.getRowSet().first()) {
            this.throwException(response, XMPPClientException.class, 6102, "Obtaining Roster entry <user=" + user + ", userTo=" + userTo + ">");
        }
        return XMPPEntityStore.getRosterEntry(response.getRowSet());
    }

    public synchronized void dropRosterEntry(String user, String userTo) throws Exception {
        SLResponse response = this.invokeStatement("DELETE FROM PRESENCE_ROSTER WHERE USER_NAME='" + user + "' AND USER_NAME_TO='" + userTo + "'");
        this.checkWithException(response, "Dropping of Roster entry <user=" + user + ", userTo=" + userTo + ">");
    }

    public synchronized void dropRoster(String user) throws Exception {
        SLResponse response = this.invokeStatement("DELETE FROM PRESENCE_ROSTER WHERE USER_NAME='" + user + "'");
        this.checkWithException(response, "Dropping of Roster <user=" + user + ">");
    }

    public synchronized void createRosterEntry(RosterEntry re) throws Exception {
        SLResponse response = this.invokeStatement("INSERT INTO PRESENCE_ROSTER VALUES('" + re.getUser() + "', '" + re.getUserTo() + "', '" + re.getSubscription() + "', '" + re.getName() + "', '" + re.getGroup() + "', '" + re.getComponentType() + "', '" + re.getAsk() + "')");
        this.checkWithException(response, "Creation of Roster entry <user=" + re.getUser() + ", userTo=" + re.getUserTo() + ">");
    }

    public synchronized RosterEntry getOrCreateRosterEntry(String user, String userTo) throws Exception {
        SLResponse response = this.getRosterEntryResponse(user, userTo);
        if (response.isOK() && response.getRowSet() != null && response.getRowSet().first()) {
            return XMPPEntityStore.getRosterEntry(response.getRowSet());
        }
        RosterEntry result = new RosterEntry();
        result.setUser(user);
        result.setUserTo(userTo);
        result.setSubscription("none");
        result.setName(userTo);
        result.setGroup("General");
        result.setAsk("");
        result.setComponentType("Component_XMPP");
        this.createRosterEntry(result);
        return result;
    }

    public synchronized void setRosterEntry(RosterEntry re) throws Exception {
        SLResponse response = this.invokeStatement("UPDATE PRESENCE_ROSTER SET SUBSCRIPTION='" + re.getSubscription() + "', ROSTER_NAME='" + re.getName() + "', GROUP_NAME='" + re.getGroup() + "', COMPONENT_TYPE='" + re.getComponentType() + "', ASK='" + re.getAsk() + "' WHERE USER_NAME='" + re.getUser() + "' AND USER_NAME_TO='" + re.getUserTo() + "'");
        this.checkWithException(response, "Update Roster entry <user=" + re.getUser() + ", userTo=" + re.getUserTo() + ">");
    }

    public synchronized Roster getRoster(String user) throws Exception {
        SLResponse response = this.invokeStatement("SELECT * FROM PRESENCE_ROSTER WHERE USER_NAME='" + user + "'");
        this.checkWithException(response, "Obtaining Roster <user=" + user + ">");
        Roster roster = new Roster();
        response.getRowSet().beforeFirst();
        while (response.getRowSet().next()) {
            roster.add(XMPPEntityStore.getRosterEntry(response.getRowSet()));
        }
        return roster;
    }

    private static RosterEntry getRosterEntry(RowSet rowset) throws SQLException {
        RosterEntry result = new RosterEntry();
        result.setUser(rowset.getObject("USER_NAME").toString());
        result.setUserTo(rowset.getObject("USER_NAME_TO").toString());
        result.setSubscription(rowset.getObject("SUBSCRIPTION").toString());
        result.setName(rowset.getObject("ROSTER_NAME").toString());
        result.setGroup(rowset.getObject("GROUP_NAME").toString());
        result.setComponentType(rowset.getObject("COMPONENT_TYPE").toString());
        result.setAsk(rowset.getObject("ASK").toString());
        return result;
    }

    @Override
    protected Class getExceptionClass() {
        return XMPPClientException.class;
    }

    @Override
    protected int getErrorCode() {
        return 6102;
    }
}

