/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.admin.tfo;

import com.streamscape.Trace;
import com.streamscape.lib.utils.Base64;
import com.streamscape.lib.utils.ClassUtils;
import com.streamscape.lib.utils.MacroProcessor;
import com.streamscape.lib.utils.UtilitiesException;
import com.streamscape.runtime.mf.admin.tfo.TransportConfigurationException;
import com.streamscape.runtime.mf.admin.tfo.TransportConfigurationFactory;
import com.streamscape.runtime.mf.admin.tfo.TransportConnectionImpl;
import com.streamscape.sdo.excp.TransportException;
import com.streamscape.sef.FabricComponent;
import com.streamscape.service.osf.transports.TransportConnection;
import com.streamscape.service.osf.transports.TransportFactory;
import com.streamscape.service.osf.transports.TransportURL;
import java.lang.constant.Constable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.jms.ConnectionFactory;
import javax.naming.NamingException;
import javax.naming.Reference;

public class TransportFactoryObject
implements TransportFactory {
    private String dfltUserId = "";
    private String dfltPassword = "";
    private boolean isReliable = true;
    private boolean isManaged = false;
    private String factoryType = "";
    private String factoryName = "";
    private String factoryDesc = "";
    private long checkInterval = 10000L;
    private long reconnectInterval = 10000L;
    private int reconnectRetries = 3;
    private int loginTimeout = 3;
    private String className = "";
    private String validatorClassName = "";
    private String url = "";
    private int minorVersion = 1;
    private int majorVersion = 0;
    private String vendorString = "Transport Factory Version ";
    private Properties factoryProperties = new Properties();
    private transient ConnectionFactory connectionFactory = null;
    private transient Hashtable<String, TransportConnection> connectionPool = new Hashtable();
    protected transient boolean useTransientClassLoader = false;
    protected transient FabricComponent component = null;
    public static final String URL_SEPARATOR = ",";
    private static final Pattern URL_PATTERN = Pattern.compile("(\\w+)://([^:]+):(\\d+)");

    private Object readResolve() {
        this.useTransientClassLoader = false;
        this.connectionPool = new Hashtable();
        return this;
    }

    protected TransportFactoryObject() {
    }

    protected ClassLoader getClassLoader() throws TransportConfigurationException, RuntimeException {
        return TransportConfigurationFactory.lookupClassLoader(this);
    }

    protected void setTransient(boolean useTransient) {
        this.useTransientClassLoader = useTransient;
    }

    public boolean isTransient() {
        return this.useTransientClassLoader;
    }

    @Override
    public TransportConnection createConnection(String connectionName, String userName, String password) throws TransportException {
        if (this.connectionFactory == null) {
            this.initFactory(false);
        }
        TransportConnectionImpl con = new TransportConnectionImpl(connectionName, userName, password, this);
        this.connectionPool.put(connectionName, con);
        return con;
    }

    @Override
    public TransportConnection createConnection() throws TransportException {
        return this.createConnection("Sys$Default." + this.getFullName(), this.getDefaultUser(), this.getDefaultPassword());
    }

    ConnectionFactory getConnectionFactory() {
        return this.connectionFactory;
    }

    @Override
    public String getDescription() {
        return this.factoryDesc;
    }

    @Override
    public void setDescription(String desc) {
        this.factoryDesc = desc;
    }

    @Override
    public String getDefaultPassword() {
        if (MacroProcessor.isMacro(this.dfltPassword)) {
            return this.dfltPassword;
        }
        return new String(Base64.decode(this.dfltPassword));
    }

    @Override
    public void setDefaultPassword(String password) {
        this.dfltPassword = MacroProcessor.isMacro(password) ? password : Base64.encodeBytes(password.getBytes());
    }

    @Override
    public String getDefaultUser() {
        return this.dfltUserId;
    }

    @Override
    public int getMajorVersion() {
        return this.majorVersion;
    }

    @Override
    public int getMinorVersion() {
        return this.minorVersion;
    }

    @Override
    public String getFactoryName() {
        return this.factoryName;
    }

    @Override
    public Reference getReference() throws NamingException {
        return null;
    }

    @Override
    public void setDefaultUrl(String dfltURL) {
        if (this.url == null || this.url.length() == 0) {
            this.url = dfltURL;
        } else if (this.url.contains(dfltURL)) {
            this.url = dfltURL;
            StringTokenizer tokenizer = new StringTokenizer(this.url, URL_SEPARATOR);
            while (tokenizer.hasMoreTokens()) {
                String temp = tokenizer.nextToken();
                if (temp.trim().equals(dfltURL)) continue;
                this.url = this.url + URL_SEPARATOR + temp;
            }
        } else {
            this.url = dfltURL + URL_SEPARATOR + this.url;
        }
    }

    @Override
    public String getDefaultUrl() {
        int index;
        if (this.url != null && (index = this.url.indexOf(URL_SEPARATOR)) != -1) {
            return this.url.substring(0, index);
        }
        return this.url;
    }

    @Override
    public int getTransportReconnectRetries() {
        return this.reconnectRetries;
    }

    @Override
    public String getVendorString() {
        return this.vendorString;
    }

    @Override
    public boolean isLifeCycleManaged() {
        return this.isManaged;
    }

    @Override
    public boolean isReliableConnection() {
        return this.isReliable;
    }

    @Override
    public void setDefaultUser(String userName) {
        this.dfltUserId = userName;
    }

    @Override
    public void setLifeCycleManaged(boolean isManaged) {
        this.isManaged = isManaged;
    }

    @Override
    public void setFactoryName(String name) {
        this.factoryName = name;
    }

    @Override
    public void setReliableConnection(boolean reliable) {
        this.isReliable = reliable;
    }

    @Override
    public void setTransportReconnectRetries(int retries) {
        this.reconnectRetries = retries;
    }

    @Override
    public void setConnectionTimeout(int seconds) {
        this.loginTimeout = seconds;
    }

    @Override
    public String getFactoryType() {
        return this.factoryType;
    }

    @Override
    public void setFactoryType(String type) {
        this.factoryType = type;
    }

    @Override
    public void pingConnection() throws TransportException {
    }

    protected void initFactory(boolean noParms) throws RuntimeException {
        try {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(this.getClassLoader());
            this.connectionFactory = (ConnectionFactory)ClassUtils.createFromClassName((Object)this, this.getConnectionFactoryClass(), this.getClassLoader());
            Thread.currentThread().setContextClassLoader(loader);
            if (!noParms) {
                this.setParameters();
            }
        }
        catch (TransportConfigurationException error) {
            throw new RuntimeException(error);
        }
        catch (UtilitiesException ex) {
            ex.printStackTrace();
            throw new RuntimeException(ex);
        }
    }

    private void setParameters() {
        if (this.connectionFactory != null) {
            HashMap<String, Method> setters = TransportFactoryObject.getSetters(this.connectionFactory.getClass());
            Set<String> keys = setters.keySet();
            for (String param : keys) {
                String value = this.factoryProperties.getProperty(param);
                if (value == null || value.length() <= 0) continue;
                try {
                    Method method = setters.get(param);
                    Class<?> paramClass = method.getParameterTypes()[0];
                    method.invoke((Object)this.connectionFactory, TransportFactoryObject.convertValue(value, paramClass));
                }
                catch (InvocationTargetException error) {
                    Trace.logError(this, "Unable to set Transport Factory parameter: " + error.getMessage());
                }
                catch (IllegalAccessException error) {
                    Trace.logError(this, "Unable to set Transport Factory parameter: " + error.getMessage());
                }
            }
        }
    }

    protected void initParameterList() throws TransportConfigurationException {
        if (this.connectionFactory != null) {
            HashMap<String, Method> setters = TransportFactoryObject.getSetters(this.connectionFactory.getClass());
            Set<String> keys = setters.keySet();
            for (String param : keys) {
                this.factoryProperties.put(param, "");
            }
        }
    }

    private static HashMap<String, Method> getSetters(Class clazz) {
        HashMap<String, Method> setters = new HashMap<String, Method>();
        Method[] allMeths = clazz.getMethods();
        for (int i = 0; i < allMeths.length; ++i) {
            if (!allMeths[i].getName().startsWith("set") || allMeths[i].getParameterTypes().length != 1) continue;
            setters.put(allMeths[i].getName().substring("set".length()), allMeths[i]);
        }
        return setters;
    }

    private static Object convertValue(String value, Class toClass) {
        Constable result = null;
        if (String.class.equals((Object)toClass)) {
            return value;
        }
        if (Integer.TYPE.equals(toClass) || Integer.class.equals((Object)toClass)) {
            result = new Integer(value);
        } else if (Boolean.TYPE.equals(toClass) || Boolean.class.equals((Object)toClass)) {
            result = new Boolean(value);
        } else if (Double.TYPE.equals(toClass) || Double.class.equals((Object)toClass)) {
            result = new Double(value);
        } else if (Long.TYPE.equals(toClass) || Long.class.equals((Object)toClass)) {
            result = new Long(value);
        } else if (Byte.TYPE.equals(toClass) || Byte.class.equals((Object)toClass)) {
            result = new Byte(value);
        } else if (Float.TYPE.equals(toClass) || Float.class.equals((Object)toClass)) {
            result = new Float(value);
        }
        return result;
    }

    @Override
    public void destroyAll() throws TransportConfigurationException {
    }

    @Override
    public TransportConnection lookupConnection(String connectionName) throws TransportConfigurationException {
        if (!this.connectionPool.containsKey(connectionName)) {
            throw new TransportConfigurationException("Connection '" + connectionName + "' is not in pool");
        }
        return this.connectionPool.get(connectionName);
    }

    @Override
    public void removeConnection(String connectionName) throws TransportConfigurationException {
        if (!this.connectionPool.containsKey(connectionName)) {
            throw new TransportConfigurationException("Connection '" + connectionName + "' is not in pool");
        }
        TransportConnection con = this.connectionPool.remove(connectionName);
        try {
            con.disconnect();
            con = null;
        }
        catch (TransportException ex) {
            throw new TransportConfigurationException(ex);
        }
    }

    @Override
    public String getProperty(String name) throws TransportConfigurationException {
        return this.factoryProperties.getProperty(name);
    }

    @Override
    public void setProperty(String name, String value) throws TransportConfigurationException {
        if (!this.factoryProperties.containsKey(name)) {
            Trace.logError(this, "WARNING: Factory Property '" + name + "' does not exist.");
        }
        this.factoryProperties.setProperty(name, value);
    }

    @Override
    public Properties getProperties() {
        return this.factoryProperties;
    }

    @Override
    public long getConnectionCheckInterval() {
        return this.checkInterval;
    }

    @Override
    public void setConnectionCheckInterval(long millis) {
        this.checkInterval = millis;
    }

    @Override
    public long getReconnectInterval() {
        return this.reconnectInterval;
    }

    @Override
    public void setReconnectInterval(long millis) {
        this.reconnectInterval = millis;
    }

    @Override
    public int getConnectionTimeout() {
        return this.loginTimeout;
    }

    @Override
    public String getConnectionFactoryClass() {
        return this.className;
    }

    @Override
    public void setConnectionFactoryClass(String factoryClassName) {
        this.className = factoryClassName.trim();
    }

    @Override
    public Vector<String> listFactoryProperties() throws TransportConfigurationException {
        Vector<String> plist = new Vector<String>();
        TreeSet<String> set = new TreeSet<String>();
        Enumeration<Object> e = this.factoryProperties.keys();
        while (e.hasMoreElements()) {
            set.add(e.nextElement().toString());
        }
        Iterator props = set.iterator();
        while (props.hasNext()) {
            plist.add(props.next().toString());
        }
        Collections.sort(plist);
        return plist;
    }

    @Override
    public Vector<String> listConnections() {
        Enumeration<String> cons = this.connectionPool.keys();
        Vector<String> clist = new Vector<String>();
        while (cons.hasMoreElements()) {
            clist.add(cons.nextElement().toString());
        }
        Collections.sort(clist);
        return clist;
    }

    public String toString() {
        return this.getFullName() + ".tfo";
    }

    public String getFullName() {
        return this.factoryType + "." + this.factoryName;
    }

    @Override
    public void setURLs(List<TransportURL> urls) {
        StringBuilder buffer = new StringBuilder();
        boolean first = true;
        for (TransportURL temp : urls) {
            if (!first) {
                buffer.append(URL_SEPARATOR);
            } else {
                first = false;
            }
            buffer.append(temp.toString());
        }
        this.url = buffer.toString();
    }

    @Override
    public List<TransportURL> getURLs() {
        ArrayList<TransportURL> result = new ArrayList<TransportURL>();
        if (this.url != null) {
            StringTokenizer tokenizer = new StringTokenizer(this.url, URL_SEPARATOR);
            while (tokenizer.hasMoreTokens()) {
                String temp = tokenizer.nextToken();
                Matcher matcher = URL_PATTERN.matcher(temp);
                if (!matcher.find()) continue;
                result.add(new TransportURL(matcher.group(1), matcher.group(2), Integer.parseInt(matcher.group(3))));
            }
        }
        return result;
    }

    @Override
    public void setConnectionStateValidatorClass(String validatorClassName) {
        this.validatorClassName = validatorClassName;
    }

    @Override
    public String getConnectionStateValidatorClass() {
        return this.validatorClassName;
    }

    protected void setFabricComponent(FabricComponent component) {
        this.component = component;
    }

    public FabricComponent getFabricComponent() {
        return this.component;
    }
}

