/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.admin.tfo;

import com.streamscape.Logger;
import com.streamscape.Trace;
import com.streamscape.runtime.mf.admin.tfo.TransportConfigurationException;
import com.streamscape.runtime.mf.admin.tfo.TransportFactoryObject;
import com.streamscape.sdo.advisory.ConnectionStateChangeAdvisory;
import com.streamscape.sdo.enums.ConnectionState;
import com.streamscape.sdo.enums.Severity;
import com.streamscape.sdo.excp.TransportException;
import com.streamscape.service.osf.transports.ExceptionEventListener;
import com.streamscape.service.osf.transports.StateNotificationEventListener;
import com.streamscape.service.osf.transports.TransportConnection;
import com.streamscape.service.osf.transports.TransportConnectionObserver;
import javax.jms.Connection;
import javax.jms.ConnectionConsumer;
import javax.jms.ConnectionMetaData;
import javax.jms.Destination;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.jms.ServerSessionPool;
import javax.jms.Session;
import javax.jms.Topic;

public class TransportConnectionImpl
implements TransportConnection,
ExceptionListener {
    private String name = "";
    private boolean primary = true;
    private Connection connection = null;
    private TransportConnectionObserver observer = null;
    private Logger logger = null;
    private ConnectionState state = ConnectionState.CLOSED;
    private StateNotificationEventListener sneListener = null;
    private ExceptionEventListener excpListener = null;
    private TransportFactoryObject factory = null;
    private String username = "";
    private String password = "";

    TransportConnectionImpl(String name, String username, String password, TransportFactoryObject factory) {
        this.name = name;
        this.username = username;
        this.password = password;
        this.factory = factory;
    }

    @Override
    public void connect() throws TransportException {
        if (this.factory.isReliableConnection() && this.observer == null) {
            Trace.logInfo(this, "Starting reliable connection observer thread..");
            this.observer = new TransportConnectionObserver(this.factory, this);
            this.observer.start();
            return;
        }
        try {
            this.setState(ConnectionState.CONNECTING);
            Trace.logInfo(this, "Opening new connection '" + this.getName() + "'.");
            Trace.logDebug(this, "\nBroker URL: " + this.factory.getDefaultUrl() + "\n");
            this.connection = this.factory.getConnectionFactory().createConnection(this.username, this.password);
            this.connection.start();
            this.connection.setExceptionListener(this);
            this.setState(ConnectionState.CONNECTED);
            Trace.logInfo(this, "Connection open.");
            this.logInfo("Opened new connection '" + this.getName() + "'.");
        }
        catch (JMSException exception) {
            TransportException error = new TransportException(exception);
            error.setSeverity(Severity.SEVERE);
            error.setErrorCode("047");
            this.raiseException(error);
            this.logError("Connection Open Error: 047, Reason: " + exception.getMessage());
            Exception linkedException = exception.getLinkedException();
            if (linkedException != null) {
                this.logError("Linked Error: " + linkedException.getMessage());
            }
            throw error;
        }
    }

    @Override
    public void disconnect() throws TransportException {
        if (this.factory.isReliableConnection() && this.observer.isActive()) {
            Trace.logInfo(this, "Stopping reliable connection observer thread...");
            this.observer.stop();
            return;
        }
        try {
            if (this.connection != null) {
                this.setState(ConnectionState.CLOSING);
                this.connection.stop();
                this.connection.close();
                this.connection = null;
                this.setState(ConnectionState.CLOSED);
                Trace.logInfo(this, "Closed connection '" + this.getName() + "'.");
                this.logInfo("Closed connection '" + this.getName() + "'.");
            } else {
                this.setState(ConnectionState.CLOSED);
                Trace.logInfo(this, "Closed connection '" + this.getName() + "'.");
                this.logInfo("Closed connection '" + this.getName() + "'.");
            }
            this.factory.removeConnection(this.getName());
        }
        catch (JMSException ex) {
            TransportException error = new TransportException(ex);
            Trace.logError(this, "Exception disconnecting '" + this.getName() + "': " + ex.getMessage());
            this.raiseException(error);
            this.setState(ConnectionState.CLOSED);
        }
        catch (TransportConfigurationException ex) {
            Trace.logError(this, "Exception removing connection '" + this.getName() + "': " + ex.getMessage());
            TransportException excp = new TransportException(1025, ex.getMessage());
            excp.setConnectionName(this.getName());
            excp.setSeverity(Severity.SEVERE);
            this.raiseException(excp);
            this.logError("Connection remove error: " + ex.getMessage());
        }
    }

    @Override
    public void suspend() {
        block3: {
            this.setState(ConnectionState.RECONNECTING);
            try {
                if (this.connection != null) {
                    this.connection.close();
                }
                this.connection = null;
                Trace.logInfo(this, "Suspended active connection '" + this.getName() + "'.");
                this.logInfo("Suspended active connection '" + this.getName() + "'.");
            }
            catch (JMSException ex) {
                this.raiseException(new TransportException(ex));
                this.logError("Connection Suspend Error: " + ex.getErrorCode() + ", Reason: " + ex.getMessage());
                Exception exl = ex.getLinkedException();
                if (exl == null) break block3;
                this.logError("Linked Error: " + ex.getMessage());
            }
        }
    }

    @Override
    public void resume() {
        block2: {
            try {
                this.connection = this.factory.getConnectionFactory().createConnection(this.username, this.password);
                this.connection.start();
                this.connection.setExceptionListener(this);
                this.setState(ConnectionState.CONNECTED);
                Trace.logInfo(this, "Resumed active connection '" + this.getName() + "'.");
                this.logInfo("Resumed active connection '" + this.getName() + "'.");
            }
            catch (JMSException ex) {
                Trace.logError(this, "Exception resuming connection '" + this.getName() + "': " + ex.getMessage());
                TransportException excp = new TransportException(ex);
                excp.setSeverity(Severity.SEVERE);
                excp.setErrorCode("048");
                this.raiseException(excp);
                this.logError("Connection Resume Error: 048, Reason: " + ex.getMessage());
                Exception exl = ex.getLinkedException();
                if (exl == null) break block2;
                this.logError("Linked Error: " + ex.getMessage());
            }
        }
    }

    @Override
    public void forceStateCheck() {
        if (this.factory.isReliableConnection() && this.observer != null) {
            this.observer.forceStateCheck();
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Logger getServiceLogger() {
        return this.logger;
    }

    @Override
    public ConnectionState getState() {
        return this.state;
    }

    @Override
    public boolean isActive() {
        return true;
    }

    @Override
    public void setPrimary(boolean primary) {
        this.primary = primary;
    }

    @Override
    public void setServiceLogger(Logger logger) {
        this.logger = logger;
    }

    @Override
    public boolean isPrimary() {
        return this.primary;
    }

    @Override
    public void setStateNotificationEventListener(StateNotificationEventListener listener) {
        this.sneListener = listener;
    }

    @Override
    public StateNotificationEventListener getStateNotificationEventListener() {
        return this.sneListener;
    }

    protected void logDebug(String msg) {
        if (this.logger != null) {
            this.logger.logDebug(msg);
        }
    }

    protected void logInfo(String msg) {
        if (this.logger != null) {
            this.logger.logInfo(msg);
        }
    }

    protected void logError(String msg) {
        if (this.logger != null) {
            this.logger.logError(msg);
        }
    }

    @Override
    public void setExceptionEventListener(ExceptionEventListener listener) {
        this.excpListener = listener;
    }

    @Override
    public ExceptionEventListener getExceptionEventListener() {
        return this.excpListener;
    }

    @Override
    public void raiseException(TransportException error) {
        if (this.excpListener != null) {
            error.setConnectionName(this.getName());
            this.excpListener.onEvent(error);
        }
    }

    protected void setState(ConnectionState state) {
        this.state = state;
        if (this.sneListener != null) {
            ConnectionStateChangeAdvisory e = new ConnectionStateChangeAdvisory();
            e.setConnectionName(this.getName());
            e.setMessage("Connection State Changed to " + state.name());
            e.setState(state);
            e.setConnectionUrl(this.factory.getDefaultUrl());
            this.sneListener.onEvent(e);
        }
    }

    @Override
    public String getClientID() throws JMSException {
        if (this.connection == null) {
            throw new JMSException("Connection not open (Illegal State).");
        }
        return this.connection.getClientID();
    }

    @Override
    public ExceptionListener getExceptionListener() throws JMSException {
        if (this.connection == null) {
            throw new JMSException("Connection not open (Illegal State).");
        }
        return this.connection.getExceptionListener();
    }

    @Override
    public ConnectionMetaData getMetaData() throws JMSException {
        if (this.connection == null) {
            throw new JMSException("Connection not open (Illegal State).");
        }
        return this.connection.getMetaData();
    }

    @Override
    public void setClientID(String string) throws JMSException {
        if (this.connection == null) {
            throw new JMSException("Connection not open (Illegal State).");
        }
        this.connection.setClientID(string);
    }

    @Override
    public void setExceptionListener(ExceptionListener exceptionListener) throws JMSException {
        if (this.connection == null) {
            throw new JMSException("Connection not open (Illegal State).");
        }
        this.connection.setExceptionListener(exceptionListener);
    }

    @Override
    public void start() throws JMSException {
        if (this.connection == null) {
            throw new JMSException("Connection not open (Illegal State).");
        }
        this.connection.start();
    }

    @Override
    public void stop() throws JMSException {
        throw new JMSException("Fabric error: Operation not supported.  Use disconnect() instead.");
    }

    @Override
    public void close() throws JMSException {
        throw new JMSException("Fabric error: Operation not supported.  Use disconnect() instead.");
    }

    @Override
    public ConnectionConsumer createConnectionConsumer(Destination destination, String messageSelector, ServerSessionPool sessionPool, int maxMessages) throws JMSException {
        if (this.connection == null) {
            throw new JMSException("Connection not open (Illegal State).");
        }
        return this.connection.createConnectionConsumer(destination, messageSelector, sessionPool, maxMessages);
    }

    @Override
    public ConnectionConsumer createDurableConnectionConsumer(Topic topic, String subscriptionName, String messageSelector, ServerSessionPool sessionPool, int maxMessages) throws JMSException {
        if (this.connection == null) {
            throw new JMSException("Connection not open (Illegal State).");
        }
        return this.connection.createDurableConnectionConsumer(topic, subscriptionName, messageSelector, sessionPool, maxMessages);
    }

    @Override
    public Session createSession(boolean transacted, int acknowledgeMode) throws JMSException {
        if (this.connection == null) {
            throw new JMSException("Connection not open (Illegal State).");
        }
        return this.connection.createSession(transacted, acknowledgeMode);
    }

    @Override
    public void onException(JMSException exception) {
        this.raiseException(new TransportException(exception));
        this.suspend();
    }
}

