/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.admin.tfo;

import com.streamscape.Trace;
import com.streamscape.lib.utils.FileIOUtils;
import com.streamscape.omf.xml.XSerializer;
import com.streamscape.repository.RepositoryContext;
import com.streamscape.repository.RepositoryException;
import com.streamscape.repository.enums.PackageType;
import com.streamscape.runtime.RuntimeContextException;
import com.streamscape.runtime.mf.admin.tfo.TransportConfigurationException;
import com.streamscape.runtime.mf.admin.tfo.TransportFactoryObject;
import com.streamscape.sef.FabricComponent;
import com.streamscape.sef.dispatcher.AbstractRuntimeFactory;
import com.streamscape.service.osf.config.TransportFactoryPropertyValue;
import com.streamscape.service.osf.transports.TransportFactory;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;

public class TransportConfigurationFactory
extends AbstractRuntimeFactory {
    public static final String PROTOTYPE = "prototype";
    public static final String SHOW_CONNECTION_PANEL = "wizard.transport.connection.panel.show";
    public static final String DEFAULT_CONNECTION_FACTORY = "wizard.transport.connection.factory.default";
    public static final String CONFIG_EXISTS = "wizard.transport.config.exists";
    private static RepositoryContext repositoryContext = null;

    public TransportConfigurationFactory(RepositoryContext repositoryContext) {
        TransportConfigurationFactory.repositoryContext = repositoryContext;
    }

    public static TransportFactory createDefaultFactory(FabricComponent component, String factoryType, String className, String url) throws TransportConfigurationException {
        return TransportConfigurationFactory.createFactory(component, factoryType, PROTOTYPE, className, url, true);
    }

    public static TransportFactory createFactory(FabricComponent component, String factoryType, String factoryName, String providerClass, String url, boolean isTransient, boolean withLoad) throws TransportConfigurationException {
        TransportConfigurationFactory.checkContext();
        TransportFactoryObject factory = new TransportFactoryObject();
        factory.setFactoryType(factoryType);
        factory.setFactoryName(factoryName);
        factory.setConnectionFactoryClass(providerClass);
        factory.setDefaultUrl(url);
        factory.setTransient(isTransient);
        factory.setFabricComponent(component);
        if (withLoad) {
            factory.initFactory(true);
        }
        factory.initParameterList();
        return factory;
    }

    public static TransportFactory createFactory(FabricComponent component, String factoryType, String factoryName, String providerClass, String url, boolean isTransient) throws TransportConfigurationException {
        return TransportConfigurationFactory.createFactory(component, factoryType, factoryName, providerClass, url, isTransient, true);
    }

    public static boolean existsTransportFactory(String factoryName, String factoryType) throws RepositoryException, TransportConfigurationException {
        TransportConfigurationFactory.checkContext();
        TransportConfigurationFactory.checkBoundRepository(TransportConfigurationFactory.getContext());
        try {
            repositoryContext.beginXact(TransportConfigurationFactory.getContext(), TransportConfigurationFactory.getContext().getRepositoryContextTxTimeout());
            boolean exists = repositoryContext.existsTransportFactory(factoryName, factoryType);
            repositoryContext.commitXact();
            return exists;
        }
        catch (Exception ex) {
            repositoryContext.abortXactSafe();
            throw new TransportConfigurationException(ex);
        }
    }

    public static TransportFactory loadFactoryObject(FabricComponent component, String factoryName, String factoryType, boolean isTransient) throws RepositoryException, TransportConfigurationException {
        Trace.logDebug(TransportConfigurationFactory.class, "Loading Transport Factory '" + factoryType + "." + factoryName + "'...");
        TransportConfigurationFactory.checkContext();
        TransportConfigurationFactory.checkBoundRepository(TransportConfigurationFactory.getContext());
        try {
            repositoryContext.beginXact(TransportConfigurationFactory.getContext(), TransportConfigurationFactory.getContext().getRepositoryContextTxTimeout());
            TransportFactoryObject factory = (TransportFactoryObject)repositoryContext.loadTransportFactory(factoryName, factoryType);
            factory.setTransient(isTransient);
            factory.setFabricComponent(component);
            repositoryContext.commitXact();
            Trace.logInfo(TransportConfigurationFactory.class, "Transport Factory '" + factoryType + "." + factoryName + "' loaded.");
            return factory;
        }
        catch (Exception ex) {
            repositoryContext.abortXactSafe();
            throw new TransportConfigurationException(ex);
        }
    }

    public static TransportFactory loadFactoryObject(FabricComponent component, String workingDir, String factoryType, String factoryName, boolean isTransient) throws TransportConfigurationException {
        Trace.logDebug(TransportConfigurationFactory.class, "Loading Transport Factory '" + factoryType + "." + factoryName + "'...");
        try {
            TransportConfigurationFactory.checkContext();
            XSerializer xf = context.getXSerializer();
            File tfoFile = FileIOUtils.openFile(workingDir + System.getProperty("file.separator") + factoryType + "." + factoryName + ".tfo");
            RandomAccessFile artifact = new RandomAccessFile(tfoFile, "rw");
            FileChannel afc = artifact.getChannel();
            FileLock flock = afc.lock();
            BufferedInputStream bis = new BufferedInputStream(new FileInputStream(artifact.getFD()));
            byte[] bytes = new byte[(int)tfoFile.length()];
            bis.read(bytes);
            flock.release();
            bis.close();
            artifact.close();
            TransportFactoryObject tfo = (TransportFactoryObject)xf.deserialize("TransportFactory", bytes);
            tfo.setTransient(isTransient);
            tfo.setFabricComponent(component);
            Trace.logInfo(TransportConfigurationFactory.class, "Transport Factory '" + tfo.getFactoryType() + "." + tfo.getFactoryName() + "' loaded.");
            return tfo;
        }
        catch (Exception ex) {
            throw new TransportConfigurationException(ex);
        }
    }

    public static TransportFactory loadTransportFactory(FabricComponent component, TransportFactoryPropertyValue scoParameterValue) throws TransportConfigurationException, RuntimeContextException {
        if (scoParameterValue == null) {
            throw new TransportConfigurationException("Null factory parameter specified.");
        }
        TransportConfigurationFactory.checkContext();
        TransportConfigurationFactory.checkBoundRepository(TransportConfigurationFactory.getContext());
        try {
            repositoryContext.beginXact(TransportConfigurationFactory.getContext(), TransportConfigurationFactory.getContext().getRepositoryContextTxTimeout());
            TransportFactory factory = repositoryContext.loadTransportFactory(scoParameterValue);
            ((TransportFactoryObject)factory).setFabricComponent(component);
            repositoryContext.commitXact();
            return factory;
        }
        catch (Exception ex) {
            repositoryContext.abortXactSafe();
            throw new TransportConfigurationException(ex);
        }
    }

    protected static ClassLoader lookupClassLoader(TransportFactoryObject tfo) throws RuntimeException, TransportConfigurationException {
        if (tfo.getFactoryType() == null) {
            throw new TransportConfigurationException("Invalid or null parameter specified.");
        }
        TransportConfigurationFactory.checkContext();
        String pkgName = PackageType.transport.name() + "." + tfo.getFactoryType();
        ClassLoader loader = tfo.getFabricComponent().getPackageManifestManager().getLoaderRegistry().lookupClassLoader(pkgName, tfo.isTransient());
        if (loader == null) {
            Trace.logDebug(TransportConfigurationFactory.class, "System class loader will be used for Transport Factory '" + tfo.getFullName() + "'.");
            loader = TransportConfigurationFactory.getContext().getSystemClassLoaderChain();
        }
        return loader;
    }

    public static void saveFactoryObject(TransportFactory tfo) throws TransportConfigurationException, RuntimeContextException {
        TransportConfigurationFactory.checkContext();
        TransportConfigurationFactory.checkBoundRepository(TransportConfigurationFactory.getContext());
        Trace.logDebug(TransportConfigurationFactory.class, "Saving Transport Factory '" + tfo.getFactoryType() + "." + tfo.getFactoryName() + "'...");
        try {
            repositoryContext.beginXact(TransportConfigurationFactory.getContext(), TransportConfigurationFactory.getContext().getRepositoryContextTxTimeout());
            repositoryContext.saveTransportFactory(tfo);
            repositoryContext.commitXact();
        }
        catch (Exception ex) {
            repositoryContext.abortXactSafe();
            throw new TransportConfigurationException(ex);
        }
        Trace.logInfo(TransportConfigurationFactory.class, "Transport Factory '" + tfo.getFactoryType() + "." + tfo.getFactoryName() + "' saved");
    }

    public static void saveFactoryObject(String workingDir, TransportFactory tfo) throws TransportConfigurationException, RuntimeContextException {
        TransportConfigurationFactory.checkContext();
        Trace.logDebug(TransportConfigurationFactory.class, "Saving Transport Factory '" + tfo.getFactoryType() + "." + tfo.getFactoryName() + "' to '" + workingDir + "'...");
        try {
            XSerializer xf = context.getXSerializer();
            String fileName = workingDir + System.getProperty("file.separator") + tfo.getFactoryType() + "." + tfo.getFactoryName() + ".tfo";
            String xdoc = xf.serialize(tfo);
            File tfoFile = FileIOUtils.newFile(fileName);
            RandomAccessFile artifact = new RandomAccessFile(tfoFile, "rw");
            FileChannel afc = artifact.getChannel();
            FileLock flock = afc.lock();
            artifact.writeBytes(xdoc);
            artifact.getFD().sync();
            flock.release();
            artifact.close();
        }
        catch (Exception ex) {
            throw new TransportConfigurationException(ex);
        }
        Trace.logInfo(TransportConfigurationFactory.class, "Transport Factory '" + tfo.getFactoryType() + "." + tfo.getFactoryName() + "' saved to '" + workingDir + "'.");
    }
}

