/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.admin.sco;

import com.streamscape.Trace;
import com.streamscape.runtime.RuntimeContextException;
import com.streamscape.runtime.mf.admin.sco.ServiceConfigurationFactory;
import com.streamscape.sef.ConfigurationProperty;
import com.streamscape.sef.FabricComponent;
import com.streamscape.sef.FabricComponentProperties;
import com.streamscape.sef.enums.EventScope;
import com.streamscape.service.osf.config.AbstractServiceConfigurationObject;
import com.streamscape.service.osf.config.ServiceConfigurationException;
import com.streamscape.service.osf.evh.EventHandler;

public class ServiceConfigurationObject
extends AbstractServiceConfigurationObject {
    public static final String SERVICE_POOL_SIZE = "servicePoolSize";
    public static final String ENABLE_SERVICE_STATS = "enableServiceStats";
    public static final String SERVICE_STOP_TIMEOUT = "serviceStopTimeout";
    public static final String DAEMON_SERVICE_MAX_WORK_TIME = "daemonServiceMaxWorkTime";
    public static final String SESSION_DATASPACE_NAME = "sessionDataspace";
    public static final int DEFAULT_SERVICE_POOL_SIZE = 1;
    public static final long DEFAULT_SERVICE_STOP_TIMEOUT = 15L;
    public static final int DEFAULT_DAEMON_SERVICE_MAX_WORK_TIME = 3600;
    protected transient boolean useTransientClassLoader = false;
    protected transient FabricComponent component = null;

    protected ServiceConfigurationObject() throws ServiceConfigurationException {
        this.addPropertyGroup(this.getDefaultPropertyGroup());
        this.addAdvancedProperty(FabricComponentProperties.getProperty("tlpLinkSolicitAllow"));
        this.addAdvancedProperty(FabricComponentProperties.getProperty("tlpLinkMaxSessions"));
        this.addAdvancedProperty(FabricComponentProperties.getProperty("tlpForceConnection"));
        this.addAdvancedProperty(FabricComponentProperties.getProperty("tlpSessionFlushDelay"));
        this.addAdvancedProperty(FabricComponentProperties.getProperty("tlpSessionExchangeMode"));
        this.addAdvancedProperty(FabricComponentProperties.getProperty("tlpEventScope"));
        this.addAdvancedProperty(FabricComponentProperties.getProperty("producerMfLeaseInterval"));
        this.addAdvancedProperty(FabricComponentProperties.getProperty("componentRefNamespace"));
        this.addAdvancedProperty(FabricComponentProperties.getProperty("exceptionSuppressStacktrace"));
        this.getAdvancedProperty("componentRefNamespace").setTextValue("/service");
        ConfigurationProperty prop = new ConfigurationProperty(SERVICE_POOL_SIZE, "Service Pool Size", "Specifies service pool size in the service component.");
        prop.setNumericValue(1L);
        this.addAdvancedProperty(prop);
        prop = new ConfigurationProperty(ENABLE_SERVICE_STATS, "Enable Service Stats", "Enables statistics collecting for service, such as method execution time.");
        prop.setBooleanValue(false);
        this.addAdvancedProperty(prop);
        prop = new ConfigurationProperty(SERVICE_STOP_TIMEOUT, "Service Stop Timeout", "Specifies the wait time (in seconds) for completion of pending operations during service stopping. Non-positive value means that service will not wait for completion of pending operations. Default is 15 seconds.");
        prop.setNumericValue(15L);
        this.addAdvancedProperty(prop);
        prop = new ConfigurationProperty(DAEMON_SERVICE_MAX_WORK_TIME, "Daemon Service Max Work Time", "This timeout in seconds is used by Service Watcher thread to check if the service is alive and doesn't hang.\nDefault max work time is 3600 seconds(60 minutes). Max time for one service iterations is a sum of passive iteration\ninterval and max work time.Check is performed every 30 seconds. [advisory.service.blocked] advisory is sent every 5 minutes.");
        prop.setNumericValue(3600L);
        this.addAdvancedProperty(prop);
        prop = ServiceConfigurationObject.createSessionDataspaceProperty();
        prop.setTextValue("SDS");
        this.addAdvancedProperty(prop);
        this.addException("exception.service.Framework");
        this.addAdvisory("advisory.component.StateChange");
        Trace.logDebug(ServiceConfigurationObject.class, "Created a new Service Configuration Object instance.");
    }

    public static ConfigurationProperty createSessionDataspaceProperty() {
        return new ConfigurationProperty(SESSION_DATASPACE_NAME, "Default Dataspace Name", "Name of dataspace to establish default dataspace session from user service session.");
    }

    protected void setFabricComponent(FabricComponent component) {
        this.component = component;
    }

    public FabricComponent getFabricComponent() {
        return this.component;
    }

    protected ClassLoader getClassLoader() throws ServiceConfigurationException, RuntimeContextException {
        return ServiceConfigurationFactory.lookupClassLoader(this);
    }

    protected void setTransient(boolean useTransient) {
        this.useTransientClassLoader = useTransient;
    }

    public boolean isTransient() {
        return this.useTransientClassLoader;
    }

    public EventScope getEventScope() {
        EventScope result = EventScope.GLOBAL;
        ConfigurationProperty scope = this.getAdvancedProperty("tlpEventScope");
        if (scope != null && scope.getValue() != null) {
            result = EventScope.valueOf(scope.getValue().toString().toUpperCase());
        }
        return result;
    }

    public void setEventScope(EventScope eventScope) {
        ConfigurationProperty eventScopeProperty = FabricComponentProperties.getProperty("tlpEventScope");
        eventScopeProperty.setTextValue(eventScope.toString());
        this.addAdvancedProperty(eventScopeProperty);
    }

    private Object readResolve() {
        this.useTransientClassLoader = false;
        for (EventHandler evh : this.getEventHandlers()) {
            evh.setServiceConfigurationObject(this);
        }
        return this;
    }

    public String toString() {
        return this.getServiceType() + "." + this.getServiceName() + ".sco";
    }

    @Override
    public Object clone() {
        return super.clone();
    }
}

