/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.admin.sco;

import com.streamscape.Trace;
import com.streamscape.lib.utils.FileIOUtils;
import com.streamscape.repository.RepositoryContext;
import com.streamscape.repository.enums.PackageType;
import com.streamscape.runtime.mf.admin.sco.ServiceConfigurationObject;
import com.streamscape.sef.FabricComponent;
import com.streamscape.sef.dispatcher.AbstractRuntimeFactory;
import com.streamscape.service.osf.config.ServiceConfigurationException;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.util.List;

public class ServiceConfigurationFactory
extends AbstractRuntimeFactory {
    public static final String PROTOTYPE = "prototype";
    private static RepositoryContext repositoryContext = null;

    public ServiceConfigurationFactory(RepositoryContext repositoryContext) {
        ServiceConfigurationFactory.repositoryContext = repositoryContext;
    }

    public static ServiceConfigurationObject createDefaultServiceConfiguration(FabricComponent component, String serviceTypeName) throws ServiceConfigurationException {
        return ServiceConfigurationFactory.createServiceConfiguration(component, PROTOTYPE, serviceTypeName, true);
    }

    public static ServiceConfigurationObject createServiceConfiguration(FabricComponent component, String serviceName, String serviceTypeName, boolean isTransient) throws ServiceConfigurationException {
        ServiceConfigurationObject sco = new ServiceConfigurationObject();
        sco.setServiceName(serviceName);
        sco.setServiceType(serviceTypeName);
        sco.setTransient(isTransient);
        sco.setFabricComponent(component);
        return sco;
    }

    public static void saveConfigurationObject(ServiceConfigurationObject sco) throws ServiceConfigurationException {
        ServiceConfigurationFactory.checkContext();
        ServiceConfigurationFactory.checkBoundRepository(ServiceConfigurationFactory.getContext());
        ServiceConfigurationFactory.logDebug("Saving Service Configuration '" + sco.getServiceType() + "." + sco.getServiceName() + "'...");
        try {
            repositoryContext.beginXact(ServiceConfigurationFactory.getContext(), ServiceConfigurationFactory.getContext().getRepositoryContextTxTimeout());
            repositoryContext.saveServiceConfiguration(sco);
            repositoryContext.commitXact();
        }
        catch (Exception ex) {
            repositoryContext.abortXactSafe();
            throw new ServiceConfigurationException(ex);
        }
        ServiceConfigurationFactory.logInfo("Service Configuration '" + sco.getServiceType() + "." + sco.getServiceName() + "' saved.");
    }

    public static void saveConfigurationObject(String workingDir, ServiceConfigurationObject sco) throws ServiceConfigurationException {
        ServiceConfigurationFactory.checkContext();
        ServiceConfigurationFactory.logDebug("Saving Service Configuration '" + sco.getServiceType() + "." + sco.getServiceName() + "' to '" + workingDir + "'...");
        try {
            String fileName = workingDir + System.getProperty("file.separator") + sco.toString();
            RandomAccessFile artifact = new RandomAccessFile(FileIOUtils.newFile(fileName), "rw");
            FileChannel afc = artifact.getChannel();
            FileLock flock = afc.lock();
            artifact.write(ServiceConfigurationFactory.getContext().getXSerializer().serialize(sco).getBytes());
            artifact.getFD().sync();
            flock.release();
            artifact.close();
        }
        catch (Exception ex) {
            throw new ServiceConfigurationException(ex);
        }
        ServiceConfigurationFactory.logInfo("Service Configuration '" + sco.getServiceType() + "." + sco.getServiceName() + "' saved to '" + workingDir + "'...");
    }

    public static ServiceConfigurationObject loadConfigurationObject(FabricComponent component, String serviceName, String serviceType, boolean isTransient) throws ServiceConfigurationException {
        ServiceConfigurationFactory.logDebug("Loading Service Configuration '" + serviceType + "." + serviceName + "'...");
        ServiceConfigurationFactory.checkContext();
        ServiceConfigurationFactory.checkBoundRepository(ServiceConfigurationFactory.getContext());
        try {
            repositoryContext.beginXact(ServiceConfigurationFactory.getContext(), ServiceConfigurationFactory.getContext().getRepositoryContextTxTimeout());
            ServiceConfigurationObject sco = repositoryContext.loadServiceConfiguration(serviceName, serviceType);
            sco.setTransient(isTransient);
            sco.setFabricComponent(component);
            repositoryContext.commitXact();
            ServiceConfigurationFactory.logInfo("Service Configuration '" + serviceType + "." + serviceName + "' loaded.");
            return sco;
        }
        catch (Exception ex) {
            repositoryContext.abortXactSafe();
            throw new ServiceConfigurationException(ex);
        }
    }

    public static boolean existsConfigurationObject(String serviceName, String serviceType) throws ServiceConfigurationException {
        ServiceConfigurationFactory.checkContext();
        ServiceConfigurationFactory.checkBoundRepository(ServiceConfigurationFactory.getContext());
        try {
            repositoryContext.beginXact(ServiceConfigurationFactory.getContext(), ServiceConfigurationFactory.getContext().getRepositoryContextTxTimeout());
            boolean exists = repositoryContext.existsService(serviceName, serviceType);
            repositoryContext.commitXact();
            return exists;
        }
        catch (Exception ex) {
            repositoryContext.abortXactSafe();
            throw new ServiceConfigurationException(ex);
        }
    }

    public static boolean existsServicePrototype(String serviceType) throws ServiceConfigurationException {
        return ServiceConfigurationFactory.existsConfigurationObject(PROTOTYPE, serviceType);
    }

    public static boolean existsServiceInstances(String serviceType) throws ServiceConfigurationException {
        ServiceConfigurationFactory.checkContext();
        ServiceConfigurationFactory.checkBoundRepository(ServiceConfigurationFactory.getContext());
        try {
            repositoryContext.beginXact(ServiceConfigurationFactory.getContext(), ServiceConfigurationFactory.getContext().getRepositoryContextTxTimeout());
            List<String> names = repositoryContext.listServicesByType(serviceType);
            boolean exists = names.size() != 0 && (names.size() != 1 || !names.get(0).equalsIgnoreCase(PROTOTYPE));
            repositoryContext.commitXact();
            return exists;
        }
        catch (Exception ex) {
            repositoryContext.abortXactSafe();
            throw new ServiceConfigurationException(ex);
        }
    }

    public static ServiceConfigurationObject loadConfigurationObject(FabricComponent component, String workingDir, String serviceName, String serviceType, boolean isTransient) throws ServiceConfigurationException {
        ServiceConfigurationFactory.checkContext();
        ServiceConfigurationFactory.logDebug("Loading Service Configuration '" + serviceType + "." + serviceName + "' from '" + workingDir + "'...");
        try {
            File scoFile = FileIOUtils.openFile(workingDir + System.getProperty("file.separator") + serviceType + "." + serviceName + ".sco");
            RandomAccessFile artifact = new RandomAccessFile(scoFile, "rw");
            FileChannel afc = artifact.getChannel();
            FileLock flock = afc.lock();
            BufferedInputStream bis = new BufferedInputStream(new FileInputStream(artifact.getFD()));
            byte[] bytes = new byte[(int)scoFile.length()];
            bis.read(bytes);
            flock.release();
            bis.close();
            artifact.close();
            ServiceConfigurationObject sco = (ServiceConfigurationObject)ServiceConfigurationFactory.getContext().getXSerializer().deserialize("ServiceConfiguration", bytes);
            sco.setTransient(isTransient);
            sco.setFabricComponent(component);
            ServiceConfigurationFactory.logInfo("Service Configuration '" + serviceType + "." + serviceName + "' loaded from '" + workingDir + "'...");
            return sco;
        }
        catch (Exception ex) {
            throw new ServiceConfigurationException(ex);
        }
    }

    public static void removeConfigurationObject(String serviceName, String serviceType) throws ServiceConfigurationException {
        if (serviceName == null) {
            throw new ServiceConfigurationException("Null service name specified.");
        }
        if (serviceType == null) {
            throw new ServiceConfigurationException("Null service type specified.");
        }
        ServiceConfigurationFactory.checkContext();
        ServiceConfigurationFactory.checkBoundRepository(ServiceConfigurationFactory.getContext());
        ServiceConfigurationFactory.logDebug("Removing Service Configuration '" + serviceType + "." + serviceName + "'...");
        try {
            repositoryContext.beginXact(ServiceConfigurationFactory.getContext(), ServiceConfigurationFactory.getContext().getRepositoryContextTxTimeout());
            repositoryContext.removeService(serviceName, serviceType);
            repositoryContext.commitXact();
        }
        catch (Exception ex) {
            repositoryContext.abortXactSafe();
            throw new ServiceConfigurationException(ex);
        }
        ServiceConfigurationFactory.logInfo("Service Configuration '" + serviceType + "." + serviceName + "' removed.");
    }

    protected static ClassLoader lookupClassLoader(ServiceConfigurationObject sco) throws ServiceConfigurationException {
        if (sco.getServiceType() == null) {
            throw new ServiceConfigurationException("Invalid or null parameter specified.");
        }
        ServiceConfigurationFactory.checkContext();
        String pkgName = PackageType.service.name() + "." + sco.getServiceType();
        ClassLoader loader = sco.getFabricComponent().getPackageManifestManager().getLoaderRegistry().lookupClassLoader(pkgName, sco.isTransient());
        if (loader == null) {
            throw new ServiceConfigurationException("Invalid loader for package '" + pkgName + "'. Make sure package is properly loaded.");
        }
        return loader;
    }

    protected static void logError(String message) {
        Trace.logError(ServiceConfigurationFactory.class, message);
    }

    protected static void logInfo(String message) {
        Trace.logInfo(ServiceConfigurationFactory.class, message);
    }

    protected static void logDebug(String message) {
        Trace.logDebug(ServiceConfigurationFactory.class, message);
    }
}

