/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.admin.pkg;

import com.streamscape.Trace;
import com.streamscape.lib.utils.FileIOUtils;
import com.streamscape.omf.xml.XSerializer;
import com.streamscape.repository.RepositoryContext;
import com.streamscape.repository.enums.PackageType;
import com.streamscape.repository.pkg.Package;
import com.streamscape.runtime.mf.admin.pkg.PackageConfigurationException;
import com.streamscape.sef.FabricComponent;
import com.streamscape.sef.dispatcher.AbstractRuntimeFactory;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.RandomAccessFile;
import java.net.URL;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.util.ArrayList;

public class PackageStore
extends AbstractRuntimeFactory {
    private static RepositoryContext repositoryContext = null;

    public PackageStore(RepositoryContext repositoryContext) {
        PackageStore.repositoryContext = repositoryContext;
    }

    public static synchronized void beginXact() throws PackageConfigurationException {
        PackageStore.beginXact(PackageStore.getContext());
    }

    public static synchronized void beginXact(FabricComponent component) throws PackageConfigurationException {
        PackageStore.checkContext();
        PackageStore.checkBoundRepository(PackageStore.getContext());
        try {
            repositoryContext.beginXact(PackageStore.getContext(), PackageStore.getContext().getRepositoryContextTxTimeout());
        }
        catch (Exception ex) {
            repositoryContext.abortXactSafe();
            throw new PackageConfigurationException(ex);
        }
    }

    public static synchronized void commitXact() throws PackageConfigurationException {
        PackageStore.checkContext();
        PackageStore.checkBoundRepository(PackageStore.getContext());
        try {
            repositoryContext.commitXact();
        }
        catch (Exception ex) {
            repositoryContext.abortXactSafe();
            throw new PackageConfigurationException(ex);
        }
    }

    public static synchronized void abortXact() {
        PackageStore.checkContext();
        PackageStore.checkBoundRepository(PackageStore.getContext());
        repositoryContext.abortXact();
    }

    public static Package createJDBCFactoryPackage(String name) throws PackageConfigurationException {
        if (name == null) {
            throw new PackageConfigurationException("Null package type name specified.");
        }
        PackageStore.checkContext();
        return Package.create(PackageType.jdbc, name);
    }

    public static Package createTransportFactoryPackage(String name) throws PackageConfigurationException {
        if (name == null) {
            throw new PackageConfigurationException("Null package type name specified.");
        }
        PackageStore.checkContext();
        return Package.create(PackageType.transport, name);
    }

    public static Package createClientFactoryPackage(String name) throws PackageConfigurationException {
        if (name == null) {
            throw new PackageConfigurationException("Null package type name specified.");
        }
        PackageStore.checkContext();
        return Package.create(PackageType.client, name);
    }

    public static Package createServicePackage(String name) throws PackageConfigurationException {
        if (name == null) {
            throw new PackageConfigurationException("Null package type name specified.");
        }
        PackageStore.checkContext();
        return Package.create(PackageType.service, name);
    }

    public static Package createCollectionPackage(String name) throws PackageConfigurationException {
        if (name == null) {
            throw new PackageConfigurationException("Null package type name specified.");
        }
        PackageStore.checkContext();
        return Package.create(PackageType.collection, name);
    }

    public static Package createSDOPackage(String name) throws PackageConfigurationException {
        if (name == null) {
            throw new PackageConfigurationException("Null package type name specified.");
        }
        PackageStore.checkContext();
        return Package.create(PackageType.sdo, name);
    }

    public static boolean existsArchive(String jarName) throws PackageConfigurationException {
        PackageStore.checkContext();
        PackageStore.checkBoundRepository(PackageStore.getContext());
        try {
            return repositoryContext.existsArchive(jarName);
        }
        catch (Exception ex) {
            repositoryContext.abortXactSafe();
            throw new PackageConfigurationException(ex);
        }
    }

    public static boolean existsPackage(PackageType pkgType, String pkgName) {
        PackageStore.checkContext();
        PackageStore.checkBoundRepository(PackageStore.getContext());
        try {
            return repositoryContext.existsPackage(pkgType, pkgName);
        }
        catch (Exception ex) {
            repositoryContext.abortXactSafe();
            throw new RuntimeException(ex);
        }
    }

    public static URL[] loadPackageURLs(Package pkg) throws PackageConfigurationException {
        if (pkg == null) {
            throw new PackageConfigurationException("Null package specified.");
        }
        PackageStore.logDebug("Loading Package '" + pkg.toString() + "' URL list...");
        PackageStore.checkContext();
        PackageStore.checkBoundRepository(PackageStore.getContext());
        try {
            ArrayList<URL> urls = new ArrayList<URL>();
            for (String jar : pkg.listJARs()) {
                URL url = repositoryContext.getArchiveURL(jar);
                urls.add(url);
            }
            URL[] urlArray = new URL[urls.size()];
            urls.toArray(urlArray);
            return urlArray;
        }
        catch (Exception ex) {
            try {
                throw new PackageConfigurationException(ex);
            }
            catch (Exception ex2) {
                repositoryContext.abortXactSafe();
                throw new PackageConfigurationException(ex2);
            }
        }
    }

    public static URL[] loadPackageURLs(String workingDir, Package pkg) throws PackageConfigurationException {
        PackageStore.checkContext();
        PackageStore.checkBoundRepository(PackageStore.getContext());
        if (pkg == null) {
            throw new PackageConfigurationException("Null package specified.");
        }
        PackageStore.logDebug("Loading Package '" + pkg.toString() + "' URL runtime...");
        try {
            ArrayList<URL> urls = new ArrayList<URL>();
            for (String lib : pkg.listJARs()) {
                String arch = workingDir + System.getProperty("file.separator") + lib;
                if (!FileIOUtils.fileAvailable(arch)) {
                    throw new PackageConfigurationException("Package Collection load error: Archive '" + lib + "' not found.");
                }
                URL url = new URL((arch.startsWith("/") ? "file:" : "file:/") + arch);
                urls.add(url);
            }
            URL[] urlArray = new URL[urls.size()];
            urls.toArray(urlArray);
            return urlArray;
        }
        catch (Exception ex) {
            throw new PackageConfigurationException(ex);
        }
    }

    public static void savePackageObject(String workingDir, Package pkg) throws PackageConfigurationException {
        if (pkg == null) {
            throw new PackageConfigurationException("Null package specified.");
        }
        PackageStore.checkContext();
        String fileName = workingDir + System.getProperty("file.separator") + pkg.getArtifactName();
        PackageStore.logDebug("Saving Package Configuration '" + fileName + "'...");
        try {
            XSerializer xf = PackageStore.getContext().getXSerializer();
            String xdoc = xf.serialize(pkg);
            File pkgFile = FileIOUtils.newFile(fileName);
            RandomAccessFile artifact = new RandomAccessFile(pkgFile, "rw");
            FileChannel afc = artifact.getChannel();
            FileLock flock = afc.lock();
            artifact.writeBytes(xdoc);
            artifact.getFD().sync();
            flock.release();
            artifact.close();
        }
        catch (Exception ex) {
            throw new PackageConfigurationException(ex);
        }
    }

    public static Package loadPackage(PackageType type, String name) throws PackageConfigurationException {
        if (type == null) {
            throw new PackageConfigurationException("Null package type specified.");
        }
        if (name == null) {
            throw new PackageConfigurationException("Null package type name specified.");
        }
        PackageStore.logDebug("Loading Package Configuration '" + type.name() + "." + name + ".pkg'...");
        PackageStore.checkContext();
        PackageStore.checkBoundRepository(PackageStore.getContext());
        try {
            return repositoryContext.loadPackage(type, name);
        }
        catch (Exception ex) {
            repositoryContext.abortXactSafe();
            throw new PackageConfigurationException(ex);
        }
    }

    public static Package loadPackage(String workingDir, PackageType type, String name) throws PackageConfigurationException {
        if (type == null) {
            throw new PackageConfigurationException("Null package type specified.");
        }
        if (name == null) {
            throw new PackageConfigurationException("Null package type name specified.");
        }
        PackageStore.checkContext();
        String pkgName = type.name() + "." + name + ".pkg";
        PackageStore.logDebug("Loading Package Configuration '" + pkgName + "' from " + workingDir + "...");
        if (!FileIOUtils.fileAvailable(workingDir + System.getProperty("file.separator") + pkgName)) {
            throw new PackageConfigurationException("Package artifact '" + workingDir + System.getProperty("file.separator") + pkgName + "' not found.");
        }
        try {
            File pkgFile = FileIOUtils.openFile(workingDir + System.getProperty("file.separator") + pkgName);
            RandomAccessFile artifact = new RandomAccessFile(pkgFile, "rw");
            FileChannel afc = artifact.getChannel();
            FileLock flock = afc.lock();
            BufferedInputStream bis = new BufferedInputStream(new FileInputStream(artifact.getFD()));
            byte[] bytes = new byte[(int)pkgFile.length()];
            bis.read(bytes);
            flock.release();
            bis.close();
            artifact.close();
            return (Package)PackageStore.getContext().getXSerializer().deserialize("Package", bytes);
        }
        catch (Exception ex) {
            throw new PackageConfigurationException(ex);
        }
    }

    public static void exportPackage(String workingDir, PackageType type, String name) throws PackageConfigurationException {
        if (type == null) {
            throw new PackageConfigurationException("Null package type specified.");
        }
        if (name == null) {
            throw new PackageConfigurationException("Null package type name specified.");
        }
        PackageStore.checkContext();
        try {
            if (!FileIOUtils.fileAvailable(workingDir)) {
                FileIOUtils.newFileDir(workingDir);
            }
        }
        catch (Exception ex) {
            throw new PackageConfigurationException(ex);
        }
        PackageStore.checkBoundRepository(PackageStore.getContext());
        PackageStore.logDebug("Exporting Package Configuration '" + type.name() + "." + name + "'...");
        try {
            repositoryContext.exportPackage(workingDir, type, name);
        }
        catch (Exception ex) {
            repositoryContext.abortXactSafe();
            throw new PackageConfigurationException(ex);
        }
    }

    public static void importPackage(String workingDir, Package pkg) throws PackageConfigurationException {
        if (pkg == null) {
            throw new PackageConfigurationException("Null package specified.");
        }
        PackageStore.checkContext();
        PackageStore.checkBoundRepository(PackageStore.getContext());
        PackageStore.logDebug("Importing Package Configuration '" + pkg.toString() + "'...");
        try {
            repositoryContext.importPackage(workingDir, pkg.getType(), pkg.getName());
        }
        catch (Exception ex) {
            repositoryContext.abortXactSafe();
            throw new PackageConfigurationException(ex);
        }
    }

    public static void removePackage(PackageType type, String name, boolean withJars) throws PackageConfigurationException {
        if (name == null) {
            throw new PackageConfigurationException("Null package type name specified.");
        }
        PackageStore.checkContext();
        PackageStore.checkBoundRepository(PackageStore.getContext());
        PackageStore.logDebug("Removing Package Configuration '" + type.name() + "." + name + "'...");
        try {
            repositoryContext.removePackage(type, name, withJars);
        }
        catch (Exception ex) {
            repositoryContext.abortXactSafe();
            throw new PackageConfigurationException(ex);
        }
    }

    protected static void logError(String message) {
        Trace.logError(PackageStore.class, message);
    }

    protected static void logInfo(String message) {
        Trace.logInfo(PackageStore.class, message);
    }

    protected static void logDebug(String message) {
        Trace.logDebug(PackageStore.class, message);
    }
}

