/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.admin.obj;

import com.streamscape.Trace;
import com.streamscape.repository.RepositoryContext;
import com.streamscape.repository.cache.MFContext;
import com.streamscape.repository.object.ReferenceContext;
import com.streamscape.runtime.mf.admin.obj.ObjectConfigurationException;
import com.streamscape.sef.FabricComponent;
import com.streamscape.sef.dispatcher.AbstractRuntimeFactory;
import com.streamscape.service.osf.config.ObjectPropertyValue;
import java.util.List;

public class SemanticObjectReferenceStore
extends AbstractRuntimeFactory {
    public static final String PROTOTYPE = "prototype";
    public static final String SHOW_CONFIGURATION_PANEL = "wizard.object.configuration.panel.show";
    public static final String DEFAULT_OBJECT = "wizard.object.default";
    private static RepositoryContext repositoryContext = null;
    private static ReferenceContext rootReferenceContext = null;
    private static FabricComponent ctxComponent = null;

    public SemanticObjectReferenceStore(RepositoryContext repositoryContext) {
        SemanticObjectReferenceStore.repositoryContext = repositoryContext;
    }

    public static synchronized void beginXact() throws ObjectConfigurationException {
        SemanticObjectReferenceStore.beginXact(SemanticObjectReferenceStore.getContext());
    }

    public static synchronized void beginXact(FabricComponent component) throws ObjectConfigurationException {
        SemanticObjectReferenceStore.checkContext();
        SemanticObjectReferenceStore.checkBoundRepository(SemanticObjectReferenceStore.getContext());
        ctxComponent = component;
        try {
            repositoryContext.beginXact(component, SemanticObjectReferenceStore.getContext().getRepositoryContextTxTimeout());
            rootReferenceContext = repositoryContext.getReferenceContext();
        }
        catch (Throwable exception) {
            SemanticObjectReferenceStore.processException(repositoryContext, exception);
        }
    }

    public static synchronized void commitXact() throws ObjectConfigurationException {
        SemanticObjectReferenceStore.checkContext();
        SemanticObjectReferenceStore.checkBoundRepository(SemanticObjectReferenceStore.getContext());
        try {
            repositoryContext.setReferenceContext(rootReferenceContext);
            ctxComponent = null;
            repositoryContext.commitXact();
        }
        catch (Throwable exception) {
            SemanticObjectReferenceStore.processException(repositoryContext, exception);
        }
    }

    public static synchronized void abortXact() {
        SemanticObjectReferenceStore.checkContext();
        SemanticObjectReferenceStore.checkBoundRepository(SemanticObjectReferenceStore.getContext());
        SemanticObjectReferenceStore.doAbortXact();
    }

    public static synchronized void abortXactSafe() {
        SemanticObjectReferenceStore.checkContext();
        SemanticObjectReferenceStore.checkBoundRepository(SemanticObjectReferenceStore.getContext());
        if (repositoryContext.inXactByCurrentThread()) {
            SemanticObjectReferenceStore.doAbortXact();
        }
    }

    private static void doAbortXact() {
        try {
            repositoryContext.setReferenceContext(rootReferenceContext);
        }
        catch (Throwable exception) {
            throw new RuntimeException("Restoring of root Reference Context failed.", exception);
        }
        repositoryContext.abortXactSafe();
        ctxComponent = null;
    }

    public static synchronized boolean inXact() {
        SemanticObjectReferenceStore.checkContext();
        SemanticObjectReferenceStore.checkBoundRepository(SemanticObjectReferenceStore.getContext());
        return repositoryContext.inXact();
    }

    public static synchronized boolean inXactByCurrentThread() {
        SemanticObjectReferenceStore.checkContext();
        SemanticObjectReferenceStore.checkBoundRepository(SemanticObjectReferenceStore.getContext());
        return repositoryContext.inXactByCurrentThread();
    }

    public static synchronized boolean existsBinding(String name) throws ObjectConfigurationException {
        if (name == null || name.length() == 0) {
            throw new ObjectConfigurationException("Null semantic type name specified.");
        }
        SemanticObjectReferenceStore.checkContext();
        SemanticObjectReferenceStore.checkBoundRepository(SemanticObjectReferenceStore.getContext());
        try {
            return repositoryContext.existsBinding(name);
        }
        catch (Throwable exception) {
            SemanticObjectReferenceStore.processException(exception);
            return false;
        }
    }

    public static synchronized void setReferenceContext(ReferenceContext refCtx) throws ObjectConfigurationException {
        SemanticObjectReferenceStore.checkContext();
        SemanticObjectReferenceStore.checkBoundRepository(SemanticObjectReferenceStore.getContext());
        try {
            repositoryContext.setReferenceContext(refCtx);
        }
        catch (Throwable exception) {
            SemanticObjectReferenceStore.processException(exception);
        }
    }

    public static synchronized ReferenceContext getReferenceContext() throws ObjectConfigurationException {
        SemanticObjectReferenceStore.checkContext();
        SemanticObjectReferenceStore.checkBoundRepository(SemanticObjectReferenceStore.getContext());
        try {
            return repositoryContext.getReferenceContext();
        }
        catch (Throwable exception) {
            SemanticObjectReferenceStore.processException(exception);
            return null;
        }
    }

    public static synchronized ReferenceContext getRootContext() throws ObjectConfigurationException {
        SemanticObjectReferenceStore.checkContext();
        SemanticObjectReferenceStore.checkBoundRepository(SemanticObjectReferenceStore.getContext());
        try {
            return repositoryContext.getRootContext();
        }
        catch (Throwable exception) {
            SemanticObjectReferenceStore.processException(exception);
            return null;
        }
    }

    public static synchronized ReferenceContext createSubcontextFromNamespace(String ctxNamespace) throws ObjectConfigurationException {
        if (ctxNamespace == null || ctxNamespace.length() == 0) {
            throw new ObjectConfigurationException("Null or empty reference context Namespace specified.");
        }
        SemanticObjectReferenceStore.checkContext();
        SemanticObjectReferenceStore.checkBoundRepository(SemanticObjectReferenceStore.getContext());
        try {
            return repositoryContext.createSubcontext(ctxNamespace);
        }
        catch (Throwable exception) {
            SemanticObjectReferenceStore.processException(exception);
            return null;
        }
    }

    public static synchronized ReferenceContext createSubcontext(ReferenceContext parentContext, String subName) throws ObjectConfigurationException {
        if (subName == null) {
            throw new ObjectConfigurationException("Null reference context Namespace specified.");
        }
        SemanticObjectReferenceStore.checkContext();
        SemanticObjectReferenceStore.checkBoundRepository(SemanticObjectReferenceStore.getContext());
        try {
            return repositoryContext.createSubcontext(parentContext, subName);
        }
        catch (Throwable exception) {
            SemanticObjectReferenceStore.processException(exception);
            return null;
        }
    }

    public static synchronized void destroySubcontext(ReferenceContext refCtx) throws ObjectConfigurationException {
        if (refCtx == null) {
            throw new ObjectConfigurationException("Null reference context specified.");
        }
        SemanticObjectReferenceStore.checkContext();
        SemanticObjectReferenceStore.checkBoundRepository(SemanticObjectReferenceStore.getContext());
        try {
            repositoryContext.destroySubcontext(refCtx);
        }
        catch (Throwable exception) {
            SemanticObjectReferenceStore.processException(exception);
        }
    }

    public static List<String> listBoundNames(String typeFilter) throws ObjectConfigurationException {
        SemanticObjectReferenceStore.checkContext();
        SemanticObjectReferenceStore.checkBoundRepository(SemanticObjectReferenceStore.getContext());
        try {
            return repositoryContext.listBoundNames(typeFilter);
        }
        catch (Throwable exception) {
            SemanticObjectReferenceStore.processException(exception);
            return null;
        }
    }

    public static List<String> listSubcontexts() throws ObjectConfigurationException {
        SemanticObjectReferenceStore.checkContext();
        SemanticObjectReferenceStore.checkBoundRepository(SemanticObjectReferenceStore.getContext());
        try {
            return repositoryContext.listSubcontexts();
        }
        catch (Throwable exception) {
            SemanticObjectReferenceStore.processException(exception);
            return null;
        }
    }

    public static synchronized Object lookup(String name) throws ObjectConfigurationException {
        if (name == null || name.length() == 0) {
            throw new ObjectConfigurationException("Null object name specified.");
        }
        SemanticObjectReferenceStore.checkContext();
        SemanticObjectReferenceStore.checkBoundRepository(SemanticObjectReferenceStore.getContext());
        try {
            return repositoryContext.lookup(name);
        }
        catch (Throwable exception) {
            SemanticObjectReferenceStore.processException(exception);
            return null;
        }
    }

    public static synchronized ReferenceContext lookupReferenceContext(String ctxNamespace) throws ObjectConfigurationException {
        if (ctxNamespace == null || ctxNamespace.length() == 0) {
            throw new ObjectConfigurationException("Null Namespace specified.");
        }
        SemanticObjectReferenceStore.checkContext();
        SemanticObjectReferenceStore.checkBoundRepository(SemanticObjectReferenceStore.getContext());
        try {
            return repositoryContext.lookupReferenceContext(ctxNamespace);
        }
        catch (Throwable exception) {
            SemanticObjectReferenceStore.processException(exception);
            return null;
        }
    }

    public static synchronized void bind(String name, Object obj) throws ObjectConfigurationException {
        if (name == null || name.length() == 0) {
            throw new ObjectConfigurationException("Null binding name specified.");
        }
        if (obj == null) {
            throw new ObjectConfigurationException("Null binding object specified.");
        }
        SemanticObjectReferenceStore.checkContext();
        SemanticObjectReferenceStore.checkBoundRepository(SemanticObjectReferenceStore.getContext());
        Trace.logDebug(SemanticObjectReferenceStore.class, "Binding object '" + name + "' to repository...");
        try {
            repositoryContext.bind(name, obj);
        }
        catch (Throwable exception) {
            SemanticObjectReferenceStore.processException(exception);
        }
    }

    public static synchronized void rebind(String name, Object obj) throws ObjectConfigurationException {
        if (name == null || name.length() == 0) {
            throw new ObjectConfigurationException("Null re-binding name specified.");
        }
        if (obj == null) {
            throw new ObjectConfigurationException("Null re-binding object specified.");
        }
        SemanticObjectReferenceStore.checkContext();
        SemanticObjectReferenceStore.checkBoundRepository(SemanticObjectReferenceStore.getContext());
        Trace.logDebug(SemanticObjectReferenceStore.class, "Re-binding object '" + name + "' to repository...");
        try {
            repositoryContext.rebind(name, obj);
        }
        catch (Throwable exception) {
            SemanticObjectReferenceStore.processException(exception);
        }
    }

    public static synchronized void rename(String oldName, String newName) throws ObjectConfigurationException {
        if (oldName == null || oldName.length() == 0) {
            throw new ObjectConfigurationException("Null old name specified.");
        }
        if (newName == null || newName.length() == 0) {
            throw new ObjectConfigurationException("Null new name specified.");
        }
        SemanticObjectReferenceStore.checkContext();
        SemanticObjectReferenceStore.checkBoundRepository(SemanticObjectReferenceStore.getContext());
        try {
            repositoryContext.rename(oldName, newName);
        }
        catch (Throwable exception) {
            SemanticObjectReferenceStore.processException(exception);
        }
    }

    public static synchronized void unbind(String name) throws ObjectConfigurationException {
        if (name == null || name.length() == 0) {
            throw new ObjectConfigurationException("Null name specified.");
        }
        SemanticObjectReferenceStore.checkContext();
        SemanticObjectReferenceStore.checkBoundRepository(SemanticObjectReferenceStore.getContext());
        Trace.logDebug(SemanticObjectReferenceStore.class, "Unbinding repository object '" + name + "' from context '" + String.valueOf(SemanticObjectReferenceStore.getReferenceContext()) + "'...");
        try {
            repositoryContext.unbind(name);
        }
        catch (Throwable exception) {
            SemanticObjectReferenceStore.processException(exception);
        }
    }

    public static synchronized Object loadObject(ObjectPropertyValue scoParameterValue) throws ObjectConfigurationException {
        if (scoParameterValue == null) {
            throw new ObjectConfigurationException("Null configuration parameter specified.");
        }
        SemanticObjectReferenceStore.checkContext();
        try {
            return repositoryContext.loadObject(scoParameterValue);
        }
        catch (Throwable exception) {
            SemanticObjectReferenceStore.processException(exception);
            return null;
        }
    }

    public static synchronized void moveObjectToJunk(String objectName) throws ObjectConfigurationException {
        SemanticObjectReferenceStore.checkContext();
        SemanticObjectReferenceStore.checkBoundRepository(SemanticObjectReferenceStore.getContext());
        try {
            ((MFContext)repositoryContext).moveObjectToJunk(objectName);
        }
        catch (Throwable exception) {
            SemanticObjectReferenceStore.processException(exception);
        }
    }

    private static void processException(Throwable exception) throws ObjectConfigurationException {
        SemanticObjectReferenceStore.abortXactSafe();
        throw new ObjectConfigurationException(exception);
    }

    private static void processException(RepositoryContext context, Throwable exception) throws ObjectConfigurationException {
        context.abortXactSafe();
        throw new ObjectConfigurationException(exception);
    }
}

