/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.admin.dfo;

import com.streamscape.Trace;
import com.streamscape.runtime.mf.admin.dfo.Observer;
import com.streamscape.sdo.enums.ConnectionState;
import com.streamscape.sdo.enums.Severity;
import com.streamscape.sdo.excp.DatabaseSQLException;
import com.streamscape.service.osf.jdbc.DatabaseConnection;
import com.streamscape.service.osf.jdbc.JDBCFactory;
import java.sql.SQLException;
import java.sql.Statement;

public class SingleConnectionObserver
implements Observer {
    private JDBCFactory factory = null;
    private DatabaseConnection connection;
    private int reconnectCounter = 0;

    public SingleConnectionObserver(JDBCFactory factory, DatabaseConnection connection) {
        this.factory = factory;
        this.connection = connection;
    }

    @Override
    public void execute() {
        block11: {
            if (this.isReconnectRetriesExceeded()) {
                this.log(Trace.Level.DEBUG, "Number of reconnect retries exceeded. Closing connection.", new Object[0]);
                return;
            }
            try {
                if (this.connection.getState() == ConnectionState.CLOSED) {
                    this.log(Trace.Level.DEBUG, "Initializing Database Connection.", new Object[0]);
                    this.connection.connect();
                    this.reconnectCounter = 0;
                    break block11;
                }
                if (this.connection.getState() == ConnectionState.RECONNECTING) {
                    this.log(Trace.Level.DEBUG, "Attempting to re-establish Database Connection...", new Object[0]);
                    ++this.reconnectCounter;
                    this.connection.resume();
                    break block11;
                }
                if (this.connection.getState() != ConnectionState.CONNECTED) break block11;
                if (this.factory.getPollingQuery() != null && this.factory.getPollingQuery().trim().length() > 0) {
                    try (Statement stmt = this.connection.createStatement();){
                        stmt.execute(this.factory.getPollingQuery());
                    }
                    this.log(Trace.Level.DEBUG, "Connection observer query execution OK.", new Object[0]);
                }
                this.reconnectCounter = 0;
            }
            catch (SQLException ex) {
                this.log(Trace.Level.DEBUG, "Exception: " + ex.getMessage() + " Suspending Connection...", new Object[0]);
                this.connection.raiseException(new DatabaseSQLException(ex));
                this.connection.suspend();
            }
            catch (DatabaseSQLException ex) {
                this.log(Trace.Level.DEBUG, "Initial Connection Exception: " + ex.getMessage() + ", Suspending Connection...", new Object[0]);
                this.connection.suspend();
            }
            catch (Throwable ex) {
                this.log(Trace.Level.DEBUG, "Initial Connection Exception, Suspending Connection...", new Object[0]);
                Trace.logException(this, ex, true);
                this.connection.suspend();
            }
        }
    }

    @Override
    public void disconnect() {
        try {
            this.connection.disconnect();
        }
        catch (DatabaseSQLException ex) {
            this.log(Trace.Level.DEBUG, "Observer Thread Exception: " + ex.getMessage() + ", Closing Connection...", new Object[0]);
            DatabaseSQLException e = new DatabaseSQLException("999", ex.getMessage(), -1, Severity.SEVERE);
            this.connection.raiseException(e);
            this.log(Trace.Level.ERROR, "Disconnect in Observer Thread Exception: " + ex.getMessage(), new Object[0]);
        }
    }

    @Override
    public boolean isReconnectRetriesExceeded() {
        return this.factory.getReconnectRetries() > 0 && this.factory.getReconnectRetries() == this.reconnectCounter;
    }

    @Override
    public boolean isConnected() {
        return this.connection.getState() == ConnectionState.CONNECTED;
    }

    @Override
    public String getName() {
        return this.connection.getName();
    }

    private void log(Trace.Level level, String message, Object ... args) {
        if (!Trace.isEnabled(this.getClass(), level)) {
            return;
        }
        message = this.connection.getName() + " : " + (String)message;
        Trace.log(this, level, (String)message, args);
    }
}

