/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.admin.dfo;

import com.streamscape.Trace;
import com.streamscape.runtime.mf.admin.dfo.DatabaseConnectionDelegate;
import com.streamscape.runtime.mf.admin.dfo.JDBCFactoryObject;
import com.streamscape.runtime.mf.admin.dfo.ObserverThread;
import com.streamscape.runtime.mf.admin.dfo.SingleConnectionObserver;
import com.streamscape.sdo.excp.DatabaseSQLException;
import com.streamscape.sef.FabricException;
import com.streamscape.service.osf.jdbc.DatabaseConnection;
import com.streamscape.service.osf.jdbc.JDBCFactory;

class ReliableDatabaseConnection
extends DatabaseConnectionDelegate {
    private JDBCFactoryObject factory;
    protected ObserverThread observerThread;

    ReliableDatabaseConnection(DatabaseConnection connection, JDBCFactory factory) {
        super(connection);
        this.factory = (JDBCFactoryObject)factory;
    }

    @Override
    public void connect() throws DatabaseSQLException {
        if (this.observerThread != null) {
            return;
        }
        SingleConnectionObserver observer = new SingleConnectionObserver(this.factory, this.delegate);
        try {
            this.observerThread = new ObserverThread(this.factory, observer);
        }
        catch (FabricException error) {
            throw new DatabaseSQLException(1000, "Unable to create connection observer thread. " + error.getMessage());
        }
        this.observerThread.start();
    }

    @Override
    public void disconnect() throws DatabaseSQLException {
        if (this.observerThread != null && this.observerThread.isActive()) {
            Trace.logInfo(this, "Stopping reliable connection observer thread for connection '" + this.getName() + "'..");
            this.observerThread.stop();
            this.observerThread = null;
        }
    }

    @Override
    public void forceStateCheck() {
        if (this.observerThread != null) {
            this.observerThread.forceStateCheck();
        }
    }
}

