/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.admin.dfo;

import com.streamscape.Trace;
import com.streamscape.lib.concurrent.FabricThread;
import com.streamscape.lib.concurrent.FabricThreadManager;
import com.streamscape.runtime.mf.admin.dfo.Observer;
import com.streamscape.sef.FabricException;
import com.streamscape.service.osf.jdbc.JDBCFactory;

class ObserverThread
implements Runnable {
    private Observer observer = null;
    private boolean forceStateCheck = false;
    private FabricThread executor = null;
    private boolean runnable = false;
    private boolean stopWithDisconnect = true;
    private long checkInterval;
    private long reconnectInterval;
    private final Object mutex = new Object();

    ObserverThread(JDBCFactory factory, Observer observer) throws FabricException {
        this.observer = observer;
        this.checkInterval = factory.getConnectionCheckInterval();
        this.reconnectInterval = factory.getReconnectInterval() > 0L ? factory.getReconnectInterval() : this.checkInterval;
        this.executor = FabricThreadManager.getInstance().createThread("SVC:Database.Connection:Observer", "Database connection '" + observer.getName() + "' observer.", this);
    }

    public boolean isActive() {
        return this.runnable;
    }

    public void start() {
        this.runnable = true;
        this.executor.start();
    }

    public synchronized void stop() {
        if (!this.runnable && !this.executor.isRunning()) {
            this.observer.disconnect();
        }
        this.runnable = false;
        this.doNotify();
    }

    void join() {
        if (this.executor != null) {
            this.executor.join();
        }
    }

    public void forceStateCheck() {
        this.forceStateCheck = true;
        this.doNotify();
    }

    @Override
    public void run() {
        while (this.runnable) {
            try {
                this.doExecute();
                if (!this.forceStateCheck) continue;
                this.forceStateCheck = false;
            }
            catch (InterruptedException ex) {
                if (this.forceStateCheck) {
                    this.forceStateCheck = false;
                    continue;
                }
                this.runnable = false;
            }
        }
        if (this.stopWithDisconnect) {
            this.observer.disconnect();
        }
    }

    private void stopWithoutDisconnect() {
        Trace.logInfo(this, "Stopping Observer Thread '" + this.observer.getName() + "' without disconnect.");
        this.runnable = false;
        this.stopWithDisconnect = false;
    }

    public void doExecute() throws InterruptedException {
        this.observer.execute();
        if (this.observer.isReconnectRetriesExceeded()) {
            Trace.logInfo(this, "Reconnect retries for Database Connection '" + this.observer.getName() + "' exceeded. Stopping Observer Thread...");
            this.stop();
            return;
        }
        try {
            if (this.observer.isConnected()) {
                if (this.checkInterval > 0L) {
                    this.doWait(this.checkInterval);
                } else {
                    this.stopWithoutDisconnect();
                }
            } else if (this.reconnectInterval > 0L) {
                this.doWait(this.reconnectInterval);
            } else {
                this.stopWithoutDisconnect();
            }
        }
        catch (InterruptedException ex) {
            throw ex;
        }
        catch (Throwable ex) {
            Trace.logException(this, ex, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doWait(long timeout) throws InterruptedException {
        Object object = this.mutex;
        synchronized (object) {
            this.mutex.wait(timeout);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doNotify() {
        Object object = this.mutex;
        synchronized (object) {
            this.mutex.notifyAll();
        }
    }
}

