/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.admin.dfo;

import com.streamscape.runtime.mf.admin.dfo.Observer;
import com.streamscape.runtime.mf.admin.dfo.SingleConnectionObserver;
import com.streamscape.service.osf.jdbc.DatabaseConnection;
import com.streamscape.service.osf.jdbc.JDBCFactory;
import java.util.ArrayList;
import java.util.List;

class MultiConnectionsObserver
implements Observer {
    private JDBCFactory factory;
    private List<Observer> observers = new ArrayList<Observer>();

    MultiConnectionsObserver(JDBCFactory factory) {
        this.factory = factory;
    }

    public void addConnections(List<DatabaseConnection> connections) {
        for (DatabaseConnection connection : connections) {
            this.addConnection(connection);
        }
    }

    public void addConnection(DatabaseConnection connection) {
        this.observers.add(new SingleConnectionObserver(this.factory, connection));
    }

    @Override
    public void execute() {
        for (Observer observer : this.observers) {
            observer.execute();
        }
    }

    @Override
    public void disconnect() {
        for (Observer observer : this.observers) {
            observer.disconnect();
        }
    }

    @Override
    public boolean isReconnectRetriesExceeded() {
        boolean result = true;
        for (Observer observer : this.observers) {
            result &= observer.isReconnectRetriesExceeded();
        }
        return result;
    }

    @Override
    public boolean isConnected() {
        boolean result = true;
        for (Observer observer : this.observers) {
            result &= observer.isConnected();
        }
        return result;
    }

    @Override
    public String getName() {
        int pos = this.observers.get(0).getName().lastIndexOf(35);
        if (pos != -1) {
            return this.observers.get(0).getName().substring(0, pos) + "###";
        }
        return this.observers.get(0).getName();
    }
}

