/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.admin.dfo;

import com.streamscape.Trace;
import com.streamscape.lib.utils.Base64;
import com.streamscape.lib.utils.ClassUtils;
import com.streamscape.lib.utils.MacroProcessor;
import com.streamscape.lib.utils.UtilitiesException;
import com.streamscape.runtime.RuntimeContextException;
import com.streamscape.runtime.mf.admin.dfo.DatabaseConnectionImpl;
import com.streamscape.runtime.mf.admin.dfo.JDBCConfigurationException;
import com.streamscape.runtime.mf.admin.dfo.JDBCConfigurationFactory;
import com.streamscape.runtime.mf.admin.dfo.ReliableDatabaseConnection;
import com.streamscape.sdo.excp.DatabaseSQLException;
import com.streamscape.sef.FabricComponent;
import com.streamscape.service.osf.jdbc.DatabaseConnection;
import com.streamscape.service.osf.jdbc.JDBCFactory;
import java.sql.Driver;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.List;
import java.util.Properties;
import javax.naming.NamingException;
import javax.naming.Reference;

public class JDBCFactoryObject
implements JDBCFactory {
    private String dfltUserId = "";
    private String dfltPassword = "";
    private boolean isReliable = true;
    private boolean isManaged = false;
    private String factoryType = "";
    private String factoryName = "";
    private String factoryDesc = "";
    private long checkInterval = 10000L;
    private long reconnectInterval = 10000L;
    private int reconnectRetries = 3;
    private int loginTimeout = 3;
    private int queryTimeout = 5;
    private String url = "";
    private String databaseName = "";
    private String className = "";
    private int minorVersion = 1;
    private int majorVersion = 0;
    private String vendorString = "JDBC Factory Version ";
    private String pollingQuery = "select 1";
    private boolean autoCommit = true;
    private String catalog = "";
    private int holdability = 2;
    private boolean readOnly = false;
    private int txIsolationLevel = 2;
    private Properties driverProperties = new Properties();
    private transient Driver jdbcDriver = null;
    private transient Hashtable<String, DatabaseConnection> connectionPool = new Hashtable();
    protected transient boolean useTransientClassLoader = false;
    protected transient FabricComponent component = null;

    private Object readResolve() {
        this.useTransientClassLoader = false;
        this.connectionPool = new Hashtable();
        return this;
    }

    protected JDBCFactoryObject() {
    }

    protected ClassLoader getClassLoader() throws JDBCConfigurationException, RuntimeContextException {
        return JDBCConfigurationFactory.lookupClassLoader(this);
    }

    protected void setTransient(boolean useTransient) {
        this.useTransientClassLoader = useTransient;
    }

    public boolean isTransient() {
        return this.useTransientClassLoader;
    }

    public void setFabricComponent(FabricComponent component) {
        this.component = component;
    }

    public FabricComponent getFabricComponent() {
        return this.component;
    }

    @Override
    public String getDefaultPassword() {
        if (MacroProcessor.isMacro(this.dfltPassword)) {
            return this.dfltPassword;
        }
        return new String(Base64.decode(this.dfltPassword));
    }

    @Override
    public void setDefaultPassword(String password) {
        this.dfltPassword = MacroProcessor.isMacro(password) ? password : Base64.encodeBytes(password.getBytes());
    }

    @Override
    public String getDefaultUser() {
        return this.dfltUserId;
    }

    @Override
    public boolean isLifeCycleManaged() {
        return this.isManaged;
    }

    @Override
    public boolean isReliableConnection() {
        return this.isReliable;
    }

    @Override
    public void setDefaultUser(String userName) {
        this.dfltUserId = userName;
    }

    public void setFactoryName(String name) {
        this.factoryName = name;
    }

    @Override
    public void setLifeCycleManaged(boolean managed) {
        this.isManaged = managed;
    }

    @Override
    public void setReliableConnection(boolean reliable) {
        this.isReliable = reliable;
    }

    @Override
    public Reference getReference() throws NamingException {
        return null;
    }

    @Override
    public String getPollingQuery() {
        return this.pollingQuery;
    }

    @Override
    public int getReconnectRetries() {
        return this.reconnectRetries;
    }

    @Override
    public void setPollingQuery(String query) {
        this.pollingQuery = query;
    }

    @Override
    public void setReconnectRetries(int retry) {
        this.reconnectRetries = retry;
    }

    protected void initDriver(boolean noParms) throws JDBCConfigurationException, RuntimeContextException {
        try {
            this.jdbcDriver = (Driver)ClassUtils.createFromClassName((Object)this, this.getJDBCDriverClassName(), this.getClassLoader());
            if (!noParms) {
                this.initDriverParameters();
            }
        }
        catch (UtilitiesException ex) {
            throw new JDBCConfigurationException(ex);
        }
    }

    private void initDriverParameters() throws JDBCConfigurationException {
        try {
            if (this.jdbcDriver == null) {
                throw new JDBCConfigurationException("Null JDBC Driver reference.");
            }
            for (DriverPropertyInfo info : this.jdbcDriver.getPropertyInfo(this.getUrl(), null)) {
                this.driverProperties.setProperty(info.name, info.value == null ? "" : info.value);
            }
            this.minorVersion = this.jdbcDriver.getMinorVersion();
            this.majorVersion = this.jdbcDriver.getMajorVersion();
            this.vendorString = this.vendorString + this.majorVersion + "." + this.minorVersion + ", " + this.driverProperties.getProperty("applicationName") + ".";
        }
        catch (SQLException ex) {
            throw new JDBCConfigurationException(ex);
        }
    }

    @Override
    public void setProperty(String name, String value) throws JDBCConfigurationException {
        if (!this.driverProperties.containsKey(name)) {
            Trace.logInfo(this, "WARNING: Driver Property '" + name + "' does not exist. Skipped.");
        } else {
            this.driverProperties.setProperty(name, value);
        }
    }

    @Override
    public String getProperty(String name) {
        return this.driverProperties.getProperty(name);
    }

    public boolean existsProperty(String name) {
        return this.driverProperties.containsKey(name);
    }

    @Override
    public Properties getProperties() {
        return this.driverProperties;
    }

    protected Driver getJDBCDriver() {
        return this.jdbcDriver;
    }

    @Override
    public DatabaseConnection createConnection() throws JDBCConfigurationException {
        return this.createConnection("Sys$Default." + this.getFullName(), this.getDefaultUser(), this.getDefaultPassword());
    }

    @Override
    public DatabaseConnection createConnection(String connectionName) throws JDBCConfigurationException {
        return this.createConnection(connectionName, this.getDefaultUser(), this.getDefaultPassword());
    }

    @Override
    public DatabaseConnection createConnection(String connectionName, String userName, String password) throws JDBCConfigurationException {
        return this.doCreateConnection(connectionName, userName, password, false);
    }

    DatabaseConnection createConnectionForPool(String connectionName) throws JDBCConfigurationException {
        return this.doCreateConnection(connectionName, this.getDefaultUser(), this.getDefaultPassword(), true);
    }

    private DatabaseConnection doCreateConnection(String connectionName, String userName, String password, boolean isForPool) throws JDBCConfigurationException {
        if (connectionName == null || connectionName.equals("")) {
            throw new JDBCConfigurationException("Create Connection Exception: Connection Name is unspecified or null.");
        }
        if (this.connectionPool.containsKey(connectionName.trim())) {
            throw new JDBCConfigurationException("Create Connection Exception: Duplicate Connection Name specified.");
        }
        try {
            Trace.logDebug(this, "Validating JDBC Driver...");
            if (this.jdbcDriver == null) {
                this.initDriver(true);
            }
            this.setProperty("user", userName);
            this.setProperty("password", password);
            this.setProperty("loginTimeout", Integer.toString(this.getConnectionTimeout()));
            DatabaseConnection connection = new DatabaseConnectionImpl(connectionName, this);
            if (isForPool) {
                return connection;
            }
            if (this.isReliableConnection()) {
                connection = new ReliableDatabaseConnection(connection, this);
            }
            this.connectionPool.put(connectionName, connection);
            return connection;
        }
        catch (Exception ex) {
            throw new JDBCConfigurationException(ex);
        }
    }

    @Override
    public int getConnectionTimeout() {
        return this.loginTimeout;
    }

    @Override
    public void setConnectionTimeout(int seconds) {
        this.loginTimeout = seconds;
    }

    @Override
    public void setAutoCommit(boolean autoCommit) {
        this.autoCommit = autoCommit;
    }

    @Override
    public void setCatalog(String catalog) {
        this.catalog = catalog;
    }

    @Override
    public void setHoldability(int holdability) {
        this.holdability = holdability;
    }

    @Override
    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    @Override
    public void setTransactionIsolation(int level) {
        this.txIsolationLevel = level;
    }

    @Override
    public boolean getAutoCommit() {
        return this.autoCommit;
    }

    @Override
    public String getCatalog() {
        return this.catalog;
    }

    @Override
    public int getHoldability() {
        return this.holdability;
    }

    @Override
    public boolean getReadOnly() {
        return this.readOnly;
    }

    @Override
    public int getTransactionIsolation() {
        return this.txIsolationLevel;
    }

    @Override
    public String getFactoryName() {
        return this.factoryName;
    }

    @Override
    public String getFactoryType() {
        return this.factoryType;
    }

    public void setFactoryType(String type) {
        this.factoryType = type;
    }

    @Override
    public int getMajorVersion() {
        return this.majorVersion;
    }

    @Override
    public int getMinorVersion() {
        return this.minorVersion;
    }

    @Override
    public String getVendorString() {
        return this.vendorString;
    }

    @Override
    public void setUrl(String connectionURL) {
        this.url = connectionURL.trim();
    }

    @Override
    public String getUrl() {
        return this.url;
    }

    @Override
    public String getJDBCDriverClassName() {
        return this.className;
    }

    public void setJDBCDriverClassName(String driverClassName) {
        this.className = driverClassName.trim();
    }

    @Override
    public long getConnectionCheckInterval() {
        return this.checkInterval;
    }

    @Override
    public void setConnectionCheckInterval(long millis) {
        this.checkInterval = millis;
    }

    @Override
    public long getReconnectInterval() {
        return this.reconnectInterval;
    }

    @Override
    public void setReconnectInterval(long millis) {
        this.reconnectInterval = millis;
    }

    @Override
    public String getDescription() {
        return this.factoryDesc;
    }

    @Override
    public void setDescription(String desc) {
        this.factoryDesc = desc;
    }

    @Override
    public List<DriverPropertyInfo> listDriverProperties() throws JDBCConfigurationException, RuntimeContextException {
        if (this.jdbcDriver == null) {
            this.initDriver(true);
        }
        try {
            return Arrays.asList(this.jdbcDriver.getPropertyInfo(this.getUrl(), null));
        }
        catch (SQLException ex) {
            throw new JDBCConfigurationException(ex);
        }
    }

    @Override
    public void destroyAll() throws JDBCConfigurationException {
        for (String connectionName : new ArrayList<String>(this.connectionPool.keySet())) {
            this.removeConnection(connectionName);
        }
        if (this.connectionPool.size() != 0) {
            throw new JDBCConfigurationException("Error removing connection from pool.");
        }
        this.connectionPool = null;
    }

    @Override
    public int getQueryTimeout() {
        return this.queryTimeout;
    }

    @Override
    public void setQueryTimeout(int seconds) {
        this.queryTimeout = seconds;
    }

    @Override
    public void removeConnection(String connectionName) throws JDBCConfigurationException {
        DatabaseConnection conn = this.connectionPool.remove(connectionName);
        try {
            if (conn != null && conn.isActive()) {
                conn.disconnect();
            }
        }
        catch (DatabaseSQLException ex) {
            throw new JDBCConfigurationException(ex);
        }
    }

    @Override
    public DatabaseConnection lookupConnection(String connectionName) throws JDBCConfigurationException {
        if (!this.connectionPool.containsKey(connectionName)) {
            throw new JDBCConfigurationException("Connection not found.");
        }
        return this.connectionPool.get(connectionName);
    }

    public String toString() {
        return this.getFullName() + ".dfo";
    }

    public String getFullName() {
        return this.factoryType + "." + this.factoryName;
    }
}

