/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.admin.dfo;

import com.streamscape.Trace;
import com.streamscape.lib.utils.FileIOUtils;
import com.streamscape.omf.xml.XSerializer;
import com.streamscape.repository.RepositoryContext;
import com.streamscape.repository.RepositoryException;
import com.streamscape.repository.enums.PackageType;
import com.streamscape.repository.pkg.Package;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.runtime.RuntimeContextException;
import com.streamscape.runtime.mf.admin.dfo.JDBCConfigurationException;
import com.streamscape.runtime.mf.admin.dfo.JDBCFactoryObject;
import com.streamscape.runtime.mf.admin.glv.VariableFactory;
import com.streamscape.runtime.mf.admin.pkg.PackageStore;
import com.streamscape.sef.FabricComponent;
import com.streamscape.sef.dispatcher.AbstractRuntimeFactory;
import com.streamscape.sef.pkg.PackageManifestManager;
import com.streamscape.service.osf.config.JDBCFactoryPropertyValue;
import com.streamscape.service.osf.globals.GlobalVariablesResolverImpl;
import com.streamscape.service.osf.jdbc.DatabaseConnection;
import com.streamscape.service.osf.jdbc.JDBCFactory;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;

public class JDBCConfigurationFactory
extends AbstractRuntimeFactory {
    public static final String PROTOTYPE = "prototype";
    public static final String SHOW_CONNECTION_PANEL = "wizard.jdbc.connection.panel.show";
    public static final String DEFAULT_CONNECTION_FACTORY = "wizard.jdbc.connection.factory.default";
    public static final String CONFIG_EXISTS = "wizard.jdbc.config.exists";
    private static RepositoryContext repositoryContext = null;

    public JDBCConfigurationFactory(RepositoryContext repositoryContext) {
        JDBCConfigurationFactory.repositoryContext = repositoryContext;
    }

    public static JDBCFactory createFactory(FabricComponent component, String factoryName, String factoryType, String className, String url, boolean isTransient) throws JDBCConfigurationException, RuntimeContextException {
        return JDBCConfigurationFactory.createFactory(component, factoryName, factoryType, className, url, isTransient, true);
    }

    public static JDBCFactory createFactory(FabricComponent component, String factoryName, String factoryType, String className, String url, boolean isTransient, boolean withDriverLoad) throws JDBCConfigurationException, RuntimeContextException {
        JDBCConfigurationFactory.checkContext();
        JDBCFactoryObject factory = new JDBCFactoryObject();
        factory.setFactoryType(factoryType);
        factory.setFactoryName(factoryName);
        factory.setJDBCDriverClassName(className);
        factory.setUrl(url);
        factory.setTransient(isTransient);
        factory.setFabricComponent(component);
        if (withDriverLoad) {
            factory.initDriver(false);
        }
        return factory;
    }

    public static JDBCFactory createDefaultFactory(FabricComponent component, String factoryType, String className, String url) throws JDBCConfigurationException, RuntimeContextException {
        return JDBCConfigurationFactory.createFactory(component, PROTOTYPE, factoryType, className, url, true);
    }

    public static void saveFactoryObject(JDBCFactory dfo) throws JDBCConfigurationException, RuntimeContextException {
        JDBCConfigurationFactory.checkContext();
        JDBCConfigurationFactory.checkBoundRepository(JDBCConfigurationFactory.getContext());
        Trace.logDebug(JDBCConfigurationFactory.class, "Saving JDBC Factory '" + dfo.getFactoryType() + "." + dfo.getFactoryName() + "'...");
        try {
            repositoryContext.beginXact(JDBCConfigurationFactory.getContext(), JDBCConfigurationFactory.getContext().getRepositoryContextTxTimeout());
            repositoryContext.saveJDBCFactory(dfo);
            repositoryContext.commitXact();
        }
        catch (Exception ex) {
            repositoryContext.abortXactSafe();
            throw new JDBCConfigurationException(ex);
        }
        Trace.logInfo(JDBCConfigurationFactory.class, "JDBC Factory '" + dfo.getFactoryType() + "." + dfo.getFactoryName() + "' saved.");
    }

    public static void saveFactoryObject(String workingDir, JDBCFactory dfo) throws JDBCConfigurationException, RuntimeContextException {
        String wType = "JDBCFactory";
        JDBCConfigurationFactory.checkContext();
        Trace.logDebug(JDBCConfigurationFactory.class, "Saving JDBC Factory '" + dfo.getFactoryType() + "." + dfo.getFactoryName() + "' to '" + workingDir + "'...");
        try {
            XSerializer xf = JDBCConfigurationFactory.getContext().getXSerializer();
            String fileName = workingDir + System.getProperty("file.separator") + dfo.getFactoryType() + "." + dfo.getFactoryName() + ".dfo";
            String xdoc = xf.serialize(dfo);
            File dfoFile = FileIOUtils.newFile(fileName);
            RandomAccessFile artifact = new RandomAccessFile(dfoFile, "rw");
            FileChannel afc = artifact.getChannel();
            FileLock flock = afc.lock();
            artifact.writeBytes(xdoc);
            artifact.getFD().sync();
            flock.release();
            artifact.close();
        }
        catch (Exception ex) {
            throw new JDBCConfigurationException(ex);
        }
        Trace.logInfo(JDBCConfigurationFactory.class, "JDBC Factory '" + dfo.getFactoryType() + "." + dfo.getFactoryName() + "' saved to '" + workingDir + "'.");
    }

    public static JDBCFactory loadFactoryObject(FabricComponent component, String workingDir, String factoryName, String factoryType, boolean isTransient) throws JDBCConfigurationException, RuntimeContextException {
        Trace.logDebug(JDBCConfigurationFactory.class, "Loading JDBC Factory '" + factoryType + "." + factoryName + "'...");
        String className = JDBCFactoryObject.class.getName();
        JDBCConfigurationFactory.checkContext();
        try {
            XSerializer xf = JDBCConfigurationFactory.getContext().getXSerializer();
            File dfoFile = FileIOUtils.openFile(workingDir + System.getProperty("file.separator") + factoryType + "." + factoryName + ".dfo");
            RandomAccessFile artifact = new RandomAccessFile(dfoFile, "rw");
            FileChannel afc = artifact.getChannel();
            FileLock flock = afc.lock();
            BufferedInputStream bis = new BufferedInputStream(new FileInputStream(artifact.getFD()));
            byte[] bytes = new byte[(int)dfoFile.length()];
            bis.read(bytes);
            flock.release();
            bis.close();
            artifact.close();
            ClassLoader loader = xf.getClassLoader();
            xf.setClassLoader(Thread.currentThread().getContextClassLoader());
            JDBCFactoryObject dfo = (JDBCFactoryObject)xf.deserialize("JDBCFactory", bytes);
            xf.setClassLoader(loader);
            dfo.setTransient(isTransient);
            dfo.setFabricComponent(component);
            Trace.logInfo(JDBCConfigurationFactory.class, "JDBC Factory '" + dfo.getFactoryType() + "." + dfo.getFactoryName() + "' loaded.");
            return dfo;
        }
        catch (Exception ex) {
            throw new JDBCConfigurationException(ex);
        }
    }

    public static JDBCFactory loadJDBCFactory(FabricComponent component, JDBCFactoryPropertyValue scoParameterValue) throws JDBCConfigurationException, RuntimeContextException {
        if (scoParameterValue == null) {
            throw new JDBCConfigurationException("Null factory parameter specified.");
        }
        JDBCConfigurationFactory.checkContext();
        JDBCConfigurationFactory.checkBoundRepository(JDBCConfigurationFactory.getContext());
        try {
            repositoryContext.beginXact(JDBCConfigurationFactory.getContext(), JDBCConfigurationFactory.getContext().getRepositoryContextTxTimeout());
            JDBCFactory factory = repositoryContext.loadJDBCFactory(scoParameterValue);
            ((JDBCFactoryObject)factory).setFabricComponent(component);
            repositoryContext.commitXact();
            return factory;
        }
        catch (Exception ex) {
            repositoryContext.abortXactSafe();
            throw new JDBCConfigurationException(ex);
        }
    }

    public static boolean existsJDBCFactory(String factoryName, String factoryType) throws RepositoryException, JDBCConfigurationException {
        JDBCConfigurationFactory.checkContext();
        JDBCConfigurationFactory.checkBoundRepository(JDBCConfigurationFactory.getContext());
        try {
            repositoryContext.beginXact(JDBCConfigurationFactory.getContext(), JDBCConfigurationFactory.getContext().getRepositoryContextTxTimeout());
            boolean exists = repositoryContext.existsJDBCFactory(factoryName, factoryType);
            repositoryContext.commitXact();
            return exists;
        }
        catch (Exception ex) {
            repositoryContext.abortXactSafe();
            throw new JDBCConfigurationException(ex);
        }
    }

    public static JDBCFactory loadFactoryObject(FabricComponent component, String factoryName, String factoryType, boolean isTransient) throws RepositoryException, JDBCConfigurationException, RuntimeContextException {
        Trace.logDebug(JDBCConfigurationFactory.class, "Loading JDBC Factory '" + factoryType + "." + factoryName + "'...");
        JDBCConfigurationFactory.checkContext();
        JDBCConfigurationFactory.checkBoundRepository(JDBCConfigurationFactory.getContext());
        try {
            repositoryContext.beginXact(JDBCConfigurationFactory.getContext(), JDBCConfigurationFactory.getContext().getRepositoryContextTxTimeout());
            JDBCFactoryObject factory = (JDBCFactoryObject)repositoryContext.loadJDBCFactory(factoryName, factoryType);
            factory.setTransient(isTransient);
            factory.setFabricComponent(component);
            Trace.logInfo(JDBCConfigurationFactory.class, "JDBC Factory '" + factoryName + "." + factoryType + ".dfo' loaded.");
            repositoryContext.commitXact();
            return factory;
        }
        catch (Exception ex) {
            repositoryContext.abortXactSafe();
            throw new JDBCConfigurationException(ex);
        }
    }

    public static JDBCFactory getJDBCFactory(FabricComponent component, String factoryName, String factoryType) throws Exception {
        JDBCFactoryObject jdbcFactory = (JDBCFactoryObject)JDBCConfigurationFactory.loadFactoryObject(component, factoryName, factoryType, false);
        jdbcFactory = (JDBCFactoryObject)new GlobalVariablesResolverImpl(VariableFactory.getGlobalVariables()).resolveVariables(jdbcFactory);
        if (PackageStore.existsPackage(PackageType.jdbc, factoryType)) {
            String pkgName = Package.getFullName(PackageType.jdbc, factoryType);
            Trace.logInfo(JDBCConfigurationFactory.class, "Package '" + pkgName + "' found for JDBC Factory '" + jdbcFactory.getFullName() + "'.");
            PackageManifestManager manifestManager = component.getPackageManifestManager();
            if (component instanceof RuntimeContext && !manifestManager.existsPackage(pkgName)) {
                throw new JDBCConfigurationException("Package '" + pkgName + "' does not exist in Runtime Package Manifest.");
            }
            try {
                PackageStore.beginXact(component);
                Package pkg = PackageStore.loadPackage(PackageType.jdbc, factoryType);
                if (!manifestManager.getLoaderRegistry().isPackageRegistered(pkgName)) {
                    manifestManager.getLoaderRegistry().registerClassLoader(pkg, PackageStore.loadPackageURLs(pkg), true, true);
                }
                PackageStore.commitXact();
            }
            catch (Exception exception) {
                PackageStore.abortXact();
                throw exception;
            }
        } else {
            Trace.logInfo(JDBCConfigurationFactory.class, "Specific package for JDBC Factory '" + jdbcFactory.getFullName() + "' not found.");
        }
        return jdbcFactory;
    }

    public static void removeFactoryObject(String factoryName, String factoryType) throws JDBCConfigurationException, RuntimeContextException {
        if (factoryName == null) {
            throw new JDBCConfigurationException("Null JDBC factory name specified.");
        }
        if (factoryType == null) {
            throw new JDBCConfigurationException("Null JDBC factory type specified.");
        }
        JDBCConfigurationFactory.checkContext();
        JDBCConfigurationFactory.checkBoundRepository(JDBCConfigurationFactory.getContext());
        Trace.logDebug(JDBCConfigurationFactory.class, "Removing JDBC Factory '" + factoryName + "." + factoryType + ".dfo'...");
        try {
            repositoryContext.beginXact(JDBCConfigurationFactory.getContext(), JDBCConfigurationFactory.getContext().getRepositoryContextTxTimeout());
            repositoryContext.removeJDBCFactory(factoryName, factoryType);
            repositoryContext.commitXact();
        }
        catch (Exception ex) {
            repositoryContext.abortXactSafe();
            throw new JDBCConfigurationException(ex);
        }
        Trace.logInfo(JDBCConfigurationFactory.class, "JDBC Factory '" + factoryName + "." + factoryType + ".dfo' removed.");
    }

    protected static ClassLoader lookupClassLoader(JDBCFactoryObject dfo) throws RuntimeContextException, JDBCConfigurationException {
        if (dfo.getFactoryType() == null) {
            throw new JDBCConfigurationException("Invalid or null parameter specified.");
        }
        JDBCConfigurationFactory.checkContext();
        String pkgName = PackageType.jdbc.name() + "." + dfo.getFactoryType();
        ClassLoader loader = dfo.getFabricComponent().getPackageManifestManager().getLoaderRegistry().lookupClassLoader(pkgName, dfo.isTransient());
        if (loader == null) {
            Trace.logDebug(JDBCConfigurationFactory.class, "System class loader will be used for JDBC Factory '" + dfo.getFullName() + "'.");
            loader = JDBCConfigurationFactory.getContext().getSystemClassLoaderChain();
        }
        return loader;
    }

    public static DatabaseConnection createConnection(String factoryType, String factoryName) throws Exception {
        return JDBCConfigurationFactory.getJDBCFactory(JDBCConfigurationFactory.getContext(), factoryName, factoryType).createConnection();
    }

    public static DatabaseConnection createConnection(String factoryType, String factoryName, String connectionName, String userName, String password) throws Exception {
        return JDBCConfigurationFactory.getJDBCFactory(JDBCConfigurationFactory.getContext(), factoryName, factoryType).createConnection(connectionName, userName, password);
    }
}

