/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.admin.dfo;

import com.streamscape.Logger;
import com.streamscape.Trace;
import com.streamscape.runtime.mf.admin.dfo.DatabaseConnectionDelegate;
import com.streamscape.runtime.mf.admin.dfo.DatabaseConnectionPoolException;
import com.streamscape.runtime.mf.admin.dfo.JDBCConfigurationException;
import com.streamscape.runtime.mf.admin.dfo.JDBCFactoryObject;
import com.streamscape.runtime.mf.admin.dfo.MultiConnectionsObserver;
import com.streamscape.runtime.mf.admin.dfo.ObserverThread;
import com.streamscape.sdo.advisory.ConnectionStateChangeAdvisory;
import com.streamscape.sdo.enums.ConnectionState;
import com.streamscape.sdo.excp.DatabaseSQLException;
import com.streamscape.sef.FabricException;
import com.streamscape.service.osf.jdbc.DatabaseConnection;
import com.streamscape.service.osf.jdbc.ExceptionEventListener;
import com.streamscape.service.osf.jdbc.JDBCFactory;
import com.streamscape.service.osf.jdbc.StateNotificationEventListener;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class DatabaseConnectionsPool {
    private String name = null;
    private JDBCFactory factory = null;
    private int poolSize = 1;
    private boolean isRunning = false;
    private final Object mutex = new Object();
    private List<DatabaseConnection> allConnections;
    private Deque<DatabaseConnection> availableConnections;
    private ConcurrentHashMap<String, ConnectionState> connectionStates;
    private ConcurrentHashMap<String, DatabaseSQLException> connectionExceptions;
    private DatabaseSQLException lastException;
    private ObserverThread observerThread = null;
    private Logger logger = null;
    private ExceptionEventListener exceptionEventListener = null;
    private StateNotificationEventListener stateNotificationEventListener = null;

    public String getName() {
        return this.name;
    }

    public void setName(String name) throws DatabaseConnectionPoolException {
        this.checkIsNotRunning();
        this.name = name;
    }

    public void setFactory(JDBCFactory factory) throws DatabaseConnectionPoolException {
        this.checkIsNotRunning();
        this.factory = factory;
    }

    public JDBCFactory getFactory() {
        return this.factory;
    }

    public void setPoolSize(int poolSize) throws DatabaseConnectionPoolException {
        this.checkIsNotRunning();
        this.poolSize = poolSize;
    }

    public int getPoolSize() throws JDBCConfigurationException {
        return this.poolSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DatabaseConnection get() throws DatabaseConnectionPoolException, InterruptedException {
        Object object = this.mutex;
        synchronized (object) {
            DatabaseConnection connection;
            this.checkIsRunning();
            while ((connection = this.getFirst()) == null) {
                this.mutex.wait();
            }
            return connection;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DatabaseConnection getNoWait() throws DatabaseConnectionPoolException, InterruptedException {
        Object object = this.mutex;
        synchronized (object) {
            this.checkIsRunning();
            return this.getFirst();
        }
    }

    private DatabaseConnection getFirst() throws DatabaseConnectionPoolException {
        this.checkIsRunning();
        DatabaseConnection connection = this.availableConnections.poll();
        if (connection != null) {
            connection = new PooledDatabaseConnection(connection);
        }
        return connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release(DatabaseConnection connection) throws DatabaseConnectionPoolException {
        Object object = this.mutex;
        synchronized (object) {
            this.checkIsRunning();
            if (connection instanceof PooledDatabaseConnection) {
                connection = ((PooledDatabaseConnection)connection).delegate;
            }
            this.availableConnections.addLast(connection);
            Trace.logDebug(this, "Realising connection to connection pool " + this.getName() + ". Available connections count: " + this.availableConnections.size() + " of " + this.poolSize);
            this.mutex.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws DatabaseConnectionPoolException {
        Object object = this.mutex;
        synchronized (object) {
            this.checkIsNotRunning();
            if (this.name == null) {
                throw new DatabaseConnectionPoolException("Connection pool name is not set.");
            }
            if (this.factory == null) {
                throw new DatabaseConnectionPoolException("Connection pool jdbc factory is not set.");
            }
            if (this.poolSize == 0) {
                throw new DatabaseConnectionPoolException("Connection pool connections count is not set.");
            }
            Trace.logDebug(this, "Starting Database Connections Pool '" + this.getName() + "' (poolSize: " + this.poolSize + ", factory: " + this.factory.getFactoryType() + "." + this.factory.getFactoryName() + ")...");
            this.allConnections = new ArrayList<DatabaseConnection>(this.poolSize);
            this.connectionStates = new ConcurrentHashMap();
            this.connectionExceptions = new ConcurrentHashMap();
            try {
                for (int i = 0; i < this.poolSize; ++i) {
                    DatabaseConnection connection = ((JDBCFactoryObject)this.factory).createConnectionForPool(this.name + "$Connection#" + (i + 1));
                    connection.setServiceLogger(this.logger);
                    connection.setExceptionEventListener(new ConnectionsPoolExceptionEventListener(this.exceptionEventListener));
                    connection.setStateNotificationEventListener(new ConnectionsPoolStateNotificationEventListener(this.stateNotificationEventListener));
                    this.connectionStates.put(connection.getName(), ConnectionState.CLOSED);
                    this.allConnections.add(connection);
                }
                if (this.factory.isReliableConnection()) {
                    MultiConnectionsObserver observer = new MultiConnectionsObserver(this.factory);
                    observer.addConnections(this.allConnections);
                    try {
                        this.observerThread = new ObserverThread(this.factory, observer);
                    }
                    catch (FabricException error) {
                        throw new DatabaseSQLException(1000, "Creation of Connection Observer thread failed. Cause: " + error.getMessage());
                    }
                    this.observerThread.start();
                } else {
                    for (DatabaseConnection connection : this.allConnections) {
                        connection.connect();
                    }
                }
                this.availableConnections = new ArrayDeque<DatabaseConnection>(this.poolSize);
                this.availableConnections.addAll(this.allConnections);
                this.isRunning = true;
                Trace.logInfo(this, "Database Connections Pool '" + this.getName() + "' started.");
            }
            catch (JDBCConfigurationException exception) {
                this.stop();
                throw new DatabaseConnectionPoolException("Staring Database Connections Pool '" + this.getName() + "' failed. Cause: " + exception.getMessage(), exception);
            }
            catch (DatabaseSQLException exception) {
                this.stop();
                throw new DatabaseConnectionPoolException("Staring Database Connections Pool '" + this.getName() + "' failed. Cause: " + exception.getMessage(), exception);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() throws DatabaseConnectionPoolException {
        Object object = this.mutex;
        synchronized (object) {
            Trace.logDebug(this, "Stopping Database Connections Pool '" + this.getName() + "'...");
            this.isRunning = false;
            if (this.availableConnections != null) {
                Trace.logDebug(this, "Not released Database Connections count: " + (this.poolSize - this.availableConnections.size()) + ".");
                this.availableConnections.clear();
                this.availableConnections = null;
            }
            if (this.allConnections != null) {
                if (this.observerThread == null) {
                    for (DatabaseConnection connection : this.allConnections) {
                        if (connection == null) continue;
                        try {
                            connection.disconnect();
                        }
                        catch (Exception exception) {
                            Trace.logError(this, "Disconnecting Database Connection '" + connection.getName() + "' failed.");
                        }
                    }
                } else {
                    this.observerThread.stop();
                }
                this.allConnections.clear();
                this.allConnections = null;
            }
            if (this.observerThread != null && this.observerThread.isActive()) {
                this.observerThread.stop();
            }
            if (this.connectionStates != null) {
                this.connectionStates.clear();
                this.connectionStates = null;
            }
            if (this.connectionExceptions != null) {
                this.connectionExceptions.clear();
                this.connectionExceptions = null;
            }
            this.mutex.notifyAll();
            Trace.logInfo(this, "Database Connections Pool '" + this.getName() + "' stopped.");
        }
        if (this.observerThread != null) {
            this.observerThread.join();
            this.observerThread = null;
        }
    }

    public boolean isRunning() {
        return this.isRunning;
    }

    public ConnectionState getState() {
        Map<ConnectionState, Integer> map = this.getStatesMap();
        int maxCount = 0;
        ConnectionState result = ConnectionState.CLOSED;
        for (Map.Entry<ConnectionState, Integer> entry : map.entrySet()) {
            if (entry.getValue() <= maxCount) continue;
            maxCount = entry.getValue();
            result = entry.getKey();
        }
        return result;
    }

    public Map<ConnectionState, Integer> getStatesMap() {
        HashMap<ConnectionState, Integer> map = new HashMap<ConnectionState, Integer>();
        if (this.connectionStates != null) {
            for (ConnectionState state : this.connectionStates.values()) {
                Integer count = (Integer)map.get((Object)state);
                if (count == null) {
                    count = 0;
                }
                Integer n = count;
                count = count + 1;
                map.put(state, count);
            }
        }
        return map;
    }

    public Map<String, ConnectionState> getConnectionStates() {
        HashMap<String, ConnectionState> result = new HashMap<String, ConnectionState>();
        if (this.connectionStates != null) {
            result.putAll(this.connectionStates);
        }
        return result;
    }

    public DatabaseSQLException getLastException() {
        return this.lastException;
    }

    public Map<String, Integer> getExceptionErrorsMap() {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        if (this.connectionExceptions != null) {
            for (DatabaseSQLException exception : this.connectionExceptions.values()) {
                String message = exception.getMessage();
                Integer count = (Integer)map.get(message);
                if (count == null) {
                    count = 0;
                }
                Integer n = count;
                count = count + 1;
                map.put(message, count);
            }
        }
        return map;
    }

    public Map<String, DatabaseSQLException> getConnectionExceptions() {
        HashMap<String, DatabaseSQLException> result = new HashMap<String, DatabaseSQLException>();
        if (this.connectionExceptions != null) {
            result.putAll(this.connectionExceptions);
        }
        return result;
    }

    public void setStateNotificationEventListener(StateNotificationEventListener stateNotificationEventListener) {
        this.stateNotificationEventListener = stateNotificationEventListener;
    }

    public void setExceptionEventListener(ExceptionEventListener exceptionEventListener) {
        this.exceptionEventListener = exceptionEventListener;
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    private void checkIsRunning() throws DatabaseConnectionPoolException {
        if (!this.isRunning) {
            throw new DatabaseConnectionPoolException("Pool is not running.");
        }
    }

    private void checkIsNotRunning() throws DatabaseConnectionPoolException {
        if (this.isRunning) {
            throw new DatabaseConnectionPoolException("Pool is running.");
        }
    }

    class PooledDatabaseConnection
    extends DatabaseConnectionDelegate {
        PooledDatabaseConnection(DatabaseConnection connection) {
            super(connection);
        }

        @Override
        public void connect() throws DatabaseSQLException {
            throw new DatabaseSQLException(1000, "Connect method is forbidden for pooled Database Connection.");
        }

        @Override
        public void disconnect() throws DatabaseSQLException {
            throw new DatabaseSQLException(1000, "Disconnect method is forbidden for pooled Database Connection.");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void forceStateCheck() {
            Object object = DatabaseConnectionsPool.this.mutex;
            synchronized (object) {
                if (DatabaseConnectionsPool.this.observerThread != null) {
                    DatabaseConnectionsPool.this.observerThread.forceStateCheck();
                }
            }
        }
    }

    private class ConnectionsPoolExceptionEventListener
    implements ExceptionEventListener {
        private ExceptionEventListener listener;

        ConnectionsPoolExceptionEventListener(ExceptionEventListener listener) {
            this.listener = listener;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onEvent(DatabaseSQLException exception) {
            Object object = DatabaseConnectionsPool.this.mutex;
            synchronized (object) {
                if (DatabaseConnectionsPool.this.connectionExceptions != null) {
                    DatabaseConnectionsPool.this.connectionExceptions.put(exception.getConnectionName(), exception);
                }
            }
            DatabaseConnectionsPool.this.lastException = exception;
            if (this.listener != null) {
                this.listener.onEvent(exception);
            }
        }
    }

    private class ConnectionsPoolStateNotificationEventListener
    implements StateNotificationEventListener {
        private StateNotificationEventListener listener;

        ConnectionsPoolStateNotificationEventListener(StateNotificationEventListener listener) {
            this.listener = listener;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onEvent(ConnectionStateChangeAdvisory advisory) {
            Object object = DatabaseConnectionsPool.this.mutex;
            synchronized (object) {
                if (DatabaseConnectionsPool.this.connectionStates != null) {
                    DatabaseConnectionsPool.this.connectionStates.put(advisory.getConnectionName(), advisory.getState());
                }
            }
            if (this.listener != null) {
                this.listener.onEvent(advisory);
            }
        }
    }
}

