/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.admin.dfo;

import com.streamscape.Logger;
import com.streamscape.Trace;
import com.streamscape.runtime.mf.admin.dfo.DatabaseCallableConnectionStatement;
import com.streamscape.runtime.mf.admin.dfo.DatabaseConnectionStatement;
import com.streamscape.runtime.mf.admin.dfo.DatabasePreparedConnectionStatement;
import com.streamscape.runtime.mf.admin.dfo.JDBCConfigurationException;
import com.streamscape.runtime.mf.admin.dfo.JDBCFactoryObject;
import com.streamscape.sdo.advisory.ConnectionStateChangeAdvisory;
import com.streamscape.sdo.enums.ConnectionState;
import com.streamscape.sdo.enums.Severity;
import com.streamscape.sdo.excp.DatabaseSQLException;
import com.streamscape.service.osf.jdbc.DatabaseConnection;
import com.streamscape.service.osf.jdbc.ExceptionEventListener;
import com.streamscape.service.osf.jdbc.JDBCFactory;
import com.streamscape.service.osf.jdbc.StateNotificationEventListener;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.ClientInfoStatus;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Executor;

class DatabaseConnectionImpl
implements DatabaseConnection {
    private String name = "";
    private boolean primary = true;
    private Connection connection = null;
    private Logger logger = null;
    private ConnectionState conState = ConnectionState.CLOSED;
    private StateNotificationEventListener sneListener = null;
    private ExceptionEventListener excpListener = null;
    private Exception lastConnectionConnectException = null;
    private JDBCFactoryObject factory = null;
    protected final Object mutex = new Object();

    public DatabaseConnectionImpl(String name, JDBCFactory factory) throws DatabaseSQLException {
        this.name = name;
        this.factory = (JDBCFactoryObject)factory;
    }

    @Override
    public synchronized void connect() throws DatabaseSQLException {
        try {
            Properties properties;
            this.setState(ConnectionState.CONNECTING);
            this.logInfo("Opening connection '" + this.getName() + "' to url " + this.factory.getUrl() + ", catalog: " + this.factory.getCatalog() + ".");
            if (Trace.isDebugEnabled(this.getClass().getName())) {
                Enumeration<Object> keys = this.factory.getProperties().keys();
                while (keys.hasMoreElements()) {
                    String key = (String)keys.nextElement();
                    Trace.logDebug(this, key + "=" + this.factory.getProperties().getProperty(key));
                }
                Trace.logDebug(this, "\n");
            }
            if ((properties = this.factory.getProperties()).getProperty("portNumber") != null && properties.getProperty("portNumber").equals("")) {
                properties.remove("portNumber");
            }
            this.connection = this.factory.getJDBCDriver().connect(this.factory.getUrl(), this.factory.getProperties());
            if (this.connection == null) {
                throw new SQLException("Driver returned no connection, please verify driver settings.");
            }
            this.connection.setAutoCommit(this.factory.getAutoCommit());
            this.connection.setReadOnly(this.factory.getReadOnly());
            this.connection.setTransactionIsolation(this.factory.getTransactionIsolation());
            if (this.factory.getCatalog() != null && this.factory.getCatalog().trim().length() > 0) {
                this.connection.setCatalog(this.factory.getCatalog());
            }
            if (this.factory.getHoldability() > 0) {
                this.connection.setHoldability(this.factory.getHoldability());
            }
            this.lastConnectionConnectException = null;
            this.setState(ConnectionState.CONNECTED);
            this.logInfo("Connection '" + this.getName() + "' opened. Server URL: '" + this.factory.getUrl() + "'. Catalog: '" + this.factory.getCatalog() + "'. Autocommit: " + this.factory.getAutoCommit() + ". Transaction Isolation Level: " + this.getTransactionIsolationLevel(this.factory.getTransactionIsolation()) + ".");
        }
        catch (SQLException ex) {
            this.closeConnectionInternal();
            try {
                DatabaseSQLException error = new DatabaseSQLException(ex);
                error.setConnectionName(this.getName());
                error.setSeverity(Severity.SEVERE);
                this.raiseException(error);
                this.lastConnectionConnectException = ex;
                this.logError("Connection '" + this.getName() + "' Open Error: " + ex.getSQLState() + "SQL Code: " + ex.getErrorCode() + ", Reason: " + ex.getMessage());
                this.logLinkedErrors(ex);
                throw new DatabaseSQLException(ex);
            }
            catch (Throwable throwable) {
                this.setState(ConnectionState.RECONNECTING);
                throw throwable;
            }
        }
    }

    private void closeConnectionInternal() {
        if (this.connection != null) {
            try {
                this.connection.close();
            }
            catch (SQLException exception) {
                this.logError("Connection '" + this.getName() + "' Connection close Error: " + exception.getSQLState() + "SQL Code: " + exception.getErrorCode() + ", Reason: " + exception.getMessage());
                this.logLinkedErrors(exception);
            }
            this.connection = null;
        }
    }

    private String getTransactionIsolationLevel(int level) {
        switch (level) {
            case 0: {
                return "NONE";
            }
            case 2: {
                return "READ_COMMITTED";
            }
            case 1: {
                return "READ_UNCOMMITTED";
            }
            case 4: {
                return "REPEATABLE_READ";
            }
            case 8: {
                return "SERIALIZABLE";
            }
        }
        return "UNKNOWN";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void disconnect() throws DatabaseSQLException {
        DatabaseConnectionImpl databaseConnectionImpl = this;
        synchronized (databaseConnectionImpl) {
            try {
                if (this.connection != null) {
                    this.setState(ConnectionState.CLOSING);
                    this.lastConnectionConnectException = new Exception("Connection has been closed.");
                    this.connection.close();
                    this.connection = null;
                    this.setState(ConnectionState.CLOSED);
                } else {
                    this.setState(ConnectionState.CLOSED);
                }
                this.logInfo("Connection '" + this.getName() + "' closed.");
                this.factory.removeConnection(this.getName());
            }
            catch (SQLException ex) {
                this.raiseException(new DatabaseSQLException(ex));
                this.logError("Connection '" + this.getName() + "' close error: " + ex.getSQLState() + "SQL Code: " + ex.getErrorCode() + ", Reason: " + ex.getMessage());
                this.logLinkedErrors(ex);
                throw new DatabaseSQLException(ex);
            }
            catch (JDBCConfigurationException ex) {
                DatabaseSQLException excp = new DatabaseSQLException(1000, ex.getMessage(), Severity.SEVERE);
                excp.setConnectionName(this.getName());
                this.raiseException(excp);
                this.logError("Connection '" + this.getName() + "' close error: " + ex.getMessage());
            }
        }
    }

    protected void setState(ConnectionState state) {
        if (this.conState == state && state == ConnectionState.RECONNECTING) {
            return;
        }
        this.conState = state;
        if (this.sneListener != null) {
            ConnectionStateChangeAdvisory e = new ConnectionStateChangeAdvisory();
            e.setConnectionName(this.getName());
            e.setMessage("Connection State Changed to " + state.name());
            e.setState(state);
            e.setConnectionUrl(this.factory.getUrl());
            this.sneListener.onEvent(e);
        }
    }

    @Override
    public void raiseException(DatabaseSQLException e) {
        if (this.excpListener != null) {
            e.setConnectionName(this.getName());
            e.setSeverity(Severity.SEVERE);
            this.excpListener.onEvent(e);
        }
    }

    @Override
    public ConnectionState getState() {
        return this.conState;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Logger getServiceLogger() {
        return this.logger;
    }

    @Override
    public StateNotificationEventListener getStateNotificationEventListener() {
        return this.sneListener;
    }

    @Override
    public boolean isActive() {
        return this.conState != ConnectionState.CLOSED;
    }

    @Override
    public boolean isPrimary() {
        return this.primary;
    }

    @Override
    public synchronized void resume() {
        try {
            this.connection = this.factory.getJDBCDriver().connect(this.factory.getUrl(), this.factory.getProperties());
            this.connection.setAutoCommit(this.factory.getAutoCommit());
            this.connection.setReadOnly(this.factory.getReadOnly());
            this.connection.setTransactionIsolation(this.factory.getTransactionIsolation());
            if (this.factory.getCatalog() != null && this.factory.getCatalog().trim().length() > 0) {
                this.connection.setCatalog(this.factory.getCatalog());
            }
            if (this.factory.getHoldability() > 0) {
                this.connection.setHoldability(this.factory.getHoldability());
            }
            this.lastConnectionConnectException = null;
            this.setState(ConnectionState.CONNECTED);
            this.logInfo("Resumed active connection '" + this.getName() + "'.");
        }
        catch (SQLException ex) {
            this.closeConnectionInternal();
            this.raiseException(new DatabaseSQLException(ex));
            this.lastConnectionConnectException = ex;
            this.logError("Connection '" + this.getName() + "' Resume Error: " + ex.getSQLState() + "SQL Code: " + ex.getErrorCode() + ", Reason: " + ex.getMessage());
            this.logLinkedErrors(ex);
        }
    }

    @Override
    public void forceStateCheck() {
    }

    @Override
    public void setPrimary(boolean primaryCon) {
        this.primary = primaryCon;
    }

    @Override
    public void setServiceLogger(Logger logger) {
        this.logger = logger;
    }

    @Override
    public synchronized void suspend() {
        this.setState(ConnectionState.RECONNECTING);
        try {
            if (this.connection != null) {
                this.connection.close();
            }
            this.connection = null;
            if (this.lastConnectionConnectException == null) {
                this.lastConnectionConnectException = new Exception("Connection has been suspended.");
            }
            this.logInfo("Suspended active connection '" + this.getName() + "'.");
        }
        catch (SQLException ex) {
            this.raiseException(new DatabaseSQLException(ex));
            this.logError("Connection Suspend Error: " + ex.getSQLState() + "SQL Code: " + ex.getErrorCode() + ", Reason: " + ex.getMessage());
            this.logLinkedErrors(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearWarnings() throws SQLException {
        this.checkConnectionOpened();
        Object object = this.mutex;
        synchronized (object) {
            this.connection.clearWarnings();
        }
    }

    @Override
    public void close() throws SQLException {
        throw new SQLException("Fabric error: Operation not supported.  Use disconnect() instead.", "HZ400", -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void commit() throws SQLException {
        this.checkConnectionOpened();
        try {
            Object object = this.mutex;
            synchronized (object) {
                this.connection.commit();
            }
        }
        catch (SQLException ex) {
            this.raiseException(new DatabaseSQLException(ex));
            this.logError("Connection Commit Error: " + ex.getSQLState() + "SQL Code: " + ex.getErrorCode() + ", Reason: " + ex.getMessage());
            this.logLinkedErrors(ex);
            throw ex;
        }
    }

    private void logLinkedErrors(SQLException exception) {
        for (SQLException nextException = exception.getNextException(); nextException != null && nextException != exception; nextException = nextException.getNextException()) {
            this.logError("Linked Error: " + nextException.getSQLState() + "SQL Code: " + nextException.getErrorCode() + ", Reason: " + nextException.getMessage());
            exception = nextException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Statement createStatement() throws SQLException {
        this.checkConnectionOpened();
        Object object = this.mutex;
        synchronized (object) {
            return new DatabaseConnectionStatement(this, this.connection.createStatement());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        this.checkConnectionOpened();
        Object object = this.mutex;
        synchronized (object) {
            return new DatabaseConnectionStatement(this, this.connection.createStatement(resultSetType, resultSetConcurrency));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.checkConnectionOpened();
        Object object = this.mutex;
        synchronized (object) {
            return new DatabaseConnectionStatement(this, this.connection.createStatement(resultSetType, resultSetConcurrency, resultSetHoldability));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean getAutoCommit() throws SQLException {
        this.checkConnectionOpened();
        Object object = this.mutex;
        synchronized (object) {
            return this.connection.getAutoCommit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getCatalog() throws SQLException {
        this.checkConnectionOpened();
        Object object = this.mutex;
        synchronized (object) {
            String catalog = this.connection.getCatalog();
            if (catalog == null) {
                catalog = this.factory.getCatalog();
            }
            return catalog;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getHoldability() throws SQLException {
        this.checkConnectionOpened();
        Object object = this.mutex;
        synchronized (object) {
            return this.connection.getHoldability();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        this.checkConnectionOpened();
        Object object = this.mutex;
        synchronized (object) {
            return this.connection.getMetaData();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getTransactionIsolation() throws SQLException {
        this.checkConnectionOpened();
        Object object = this.mutex;
        synchronized (object) {
            return this.connection.getTransactionIsolation();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, Class<?>> getTypeMap() throws SQLException {
        this.checkConnectionOpened();
        Object object = this.mutex;
        synchronized (object) {
            return this.connection.getTypeMap();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SQLWarning getWarnings() throws SQLException {
        this.checkConnectionOpened();
        Object object = this.mutex;
        synchronized (object) {
            return this.connection.getWarnings();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isClosed() throws SQLException {
        Object object = this.mutex;
        synchronized (object) {
            return this.connection == null || this.connection.isClosed();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isReadOnly() throws SQLException {
        this.checkConnectionOpened();
        Object object = this.mutex;
        synchronized (object) {
            return this.connection.isReadOnly();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String nativeSQL(String sql) throws SQLException {
        this.checkConnectionOpened();
        Object object = this.mutex;
        synchronized (object) {
            return this.connection.nativeSQL(sql);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CallableStatement prepareCall(String sql) throws SQLException {
        this.checkConnectionOpened();
        Object object = this.mutex;
        synchronized (object) {
            return new DatabaseCallableConnectionStatement(this, this.connection.prepareCall(sql));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        this.checkConnectionOpened();
        Object object = this.mutex;
        synchronized (object) {
            return new DatabaseCallableConnectionStatement(this, this.connection.prepareCall(sql, resultSetType, resultSetConcurrency));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.checkConnectionOpened();
        Object object = this.mutex;
        synchronized (object) {
            return new DatabaseCallableConnectionStatement(this, this.connection.prepareCall(sql, resultSetType, resultSetConcurrency, resultSetHoldability));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        this.checkConnectionOpened();
        Object object = this.mutex;
        synchronized (object) {
            return new DatabasePreparedConnectionStatement(this, this.connection.prepareStatement(sql));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        this.checkConnectionOpened();
        Object object = this.mutex;
        synchronized (object) {
            return new DatabasePreparedConnectionStatement(this, this.connection.prepareStatement(sql, autoGeneratedKeys));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        this.checkConnectionOpened();
        Object object = this.mutex;
        synchronized (object) {
            return new DatabasePreparedConnectionStatement(this, this.connection.prepareStatement(sql, columnIndexes));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        this.checkConnectionOpened();
        Object object = this.mutex;
        synchronized (object) {
            return new DatabasePreparedConnectionStatement(this, this.connection.prepareStatement(sql, columnNames));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        this.checkConnectionOpened();
        Object object = this.mutex;
        synchronized (object) {
            return new DatabasePreparedConnectionStatement(this, this.connection.prepareStatement(sql, resultSetType, resultSetConcurrency));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.checkConnectionOpened();
        Object object = this.mutex;
        synchronized (object) {
            return new DatabasePreparedConnectionStatement(this, this.connection.prepareStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        this.checkConnectionOpened();
        Object object = this.mutex;
        synchronized (object) {
            this.connection.releaseSavepoint(savepoint);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rollback() throws SQLException {
        this.checkConnectionOpened();
        try {
            Object object = this.mutex;
            synchronized (object) {
                this.connection.rollback();
            }
        }
        catch (SQLException ex) {
            this.raiseException(new DatabaseSQLException(ex));
            this.logError("Connection Rollback Error: " + ex.getSQLState() + "SQL Code: " + ex.getErrorCode() + ", Reason: " + ex.getMessage());
            this.logLinkedErrors(ex);
            throw ex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        this.checkConnectionOpened();
        try {
            Object object = this.mutex;
            synchronized (object) {
                this.connection.rollback(savepoint);
            }
        }
        catch (SQLException ex) {
            this.raiseException(new DatabaseSQLException(ex));
            this.logError("Connection Rollback Error: " + ex.getSQLState() + "SQL Code: " + ex.getErrorCode() + ", Reason: " + ex.getMessage());
            this.logLinkedErrors(ex);
            throw ex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setAutoCommit(boolean autoCommit) throws SQLException {
        this.checkConnectionOpened();
        Object object = this.mutex;
        synchronized (object) {
            this.connection.setAutoCommit(autoCommit);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setCatalog(String catalog) throws SQLException {
        this.checkConnectionOpened();
        Object object = this.mutex;
        synchronized (object) {
            this.connection.setCatalog(catalog);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setHoldability(int holdability) throws SQLException {
        this.checkConnectionOpened();
        Object object = this.mutex;
        synchronized (object) {
            this.connection.setHoldability(holdability);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setReadOnly(boolean readOnly) throws SQLException {
        this.checkConnectionOpened();
        Object object = this.mutex;
        synchronized (object) {
            this.connection.setReadOnly(readOnly);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Savepoint setSavepoint() throws SQLException {
        this.checkConnectionOpened();
        Object object = this.mutex;
        synchronized (object) {
            return this.connection.setSavepoint();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Savepoint setSavepoint(String name) throws SQLException {
        this.checkConnectionOpened();
        Object object = this.mutex;
        synchronized (object) {
            return this.connection.setSavepoint(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setTransactionIsolation(int level) throws SQLException {
        this.checkConnectionOpened();
        Object object = this.mutex;
        synchronized (object) {
            this.connection.setTransactionIsolation(level);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
        this.checkConnectionOpened();
        Object object = this.mutex;
        synchronized (object) {
            this.connection.setTypeMap(map);
        }
    }

    @Override
    public void setStateNotificationEventListener(StateNotificationEventListener listener) {
        this.sneListener = listener;
    }

    protected void logDebug(String msg) {
        if (this.logger != null) {
            this.logger.logDebug(msg);
        } else {
            Trace.logDebug(this, msg);
        }
    }

    protected void logInfo(String msg) {
        if (this.logger != null) {
            this.logger.logInfo(msg);
        } else {
            Trace.logInfo(this, msg);
        }
    }

    protected void logError(String msg) {
        if (this.logger != null) {
            this.logger.logError(msg);
        } else {
            Trace.logError(this, msg);
        }
    }

    @Override
    public void setExceptionEventListener(ExceptionEventListener listener) {
        this.excpListener = listener;
    }

    @Override
    public ExceptionEventListener getExceptionEventListener() {
        return this.excpListener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
        this.checkConnectionOpened();
        Object object = this.mutex;
        synchronized (object) {
            return this.connection.createArrayOf(typeName, elements);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Blob createBlob() throws SQLException {
        this.checkConnectionOpened();
        Object object = this.mutex;
        synchronized (object) {
            return this.connection.createBlob();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Clob createClob() throws SQLException {
        this.checkConnectionOpened();
        Object object = this.mutex;
        synchronized (object) {
            return this.connection.createClob();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
        this.checkConnectionOpened();
        Object object = this.mutex;
        synchronized (object) {
            return this.connection.createStruct(typeName, attributes);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Properties getClientInfo() throws SQLException {
        this.checkConnectionOpened();
        Object object = this.mutex;
        synchronized (object) {
            return this.connection.getClientInfo();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getClientInfo(String name) throws SQLException {
        this.checkConnectionOpened();
        Object object = this.mutex;
        synchronized (object) {
            return this.connection.getClientInfo(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isValid(int timeout) throws SQLException {
        if (this.connection == null) {
            return false;
        }
        Object object = this.mutex;
        synchronized (object) {
            return this.connection.isValid(timeout);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        this.checkConnectionOpened();
        Object object = this.mutex;
        synchronized (object) {
            return this.connection.isWrapperFor(iface);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        this.checkConnectionOpened();
        Object object = this.mutex;
        synchronized (object) {
            return this.connection.unwrap(iface);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
        if (this.connection == null) {
            throw new SQLClientInfoException("Connection not open (Illegal State).", "08003", -1, new HashMap<String, ClientInfoStatus>());
        }
        Object object = this.mutex;
        synchronized (object) {
            this.connection.setClientInfo(properties);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setClientInfo(String name, String value) throws SQLClientInfoException {
        if (this.connection == null) {
            throw new SQLClientInfoException("Connection not open (Illegal State).", "08003", -1, new HashMap<String, ClientInfoStatus>());
        }
        Object object = this.mutex;
        synchronized (object) {
            this.connection.setClientInfo(name, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NClob createNClob() throws SQLException {
        this.checkConnectionOpened();
        Object object = this.mutex;
        synchronized (object) {
            return this.connection.createNClob();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SQLXML createSQLXML() throws SQLException {
        this.checkConnectionOpened();
        Object object = this.mutex;
        synchronized (object) {
            return this.connection.createSQLXML();
        }
    }

    @Override
    public Connection getRawConnection() {
        return this.connection;
    }

    @Override
    public void setSchema(String schema) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String getSchema() throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void abort(Executor executor) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setNetworkTimeout(Executor executor, int milliseconds) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public int getNetworkTimeout() throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    private void checkConnectionOpened() throws SQLException {
        if (this.connection == null) {
            throw new SQLException("Connection not open (Illegal State).", "08003", -1, this.lastConnectionConnectException);
        }
    }

    protected JDBCFactoryObject getFactory() {
        return this.factory;
    }
}

