/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.admin.cfo;

import com.streamscape.Trace;
import com.streamscape.lib.concurrent.FabricThread;
import com.streamscape.lib.concurrent.FabricThreadManager;
import com.streamscape.lib.utils.Base64;
import com.streamscape.lib.utils.ClassUtils;
import com.streamscape.lib.utils.MacroProcessor;
import com.streamscape.lib.utils.UtilitiesException;
import com.streamscape.runtime.mf.admin.cfo.ClientConfigurationException;
import com.streamscape.runtime.mf.admin.cfo.ClientConfigurationFactory;
import com.streamscape.sdo.excp.ClientException;
import com.streamscape.sef.FabricComponent;
import com.streamscape.service.osf.clients.AbstractClientConnection;
import com.streamscape.service.osf.clients.ClientConnection;
import com.streamscape.service.osf.clients.ClientFactory;
import com.streamscape.service.osf.clients.ClientFactoryConfigurationException;
import java.lang.constant.Constable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import javax.naming.NamingException;
import javax.naming.Reference;

public class ClientFactoryObject
implements ClientFactory {
    private String defaultUserId = "";
    private String defaultPassword = "";
    private boolean isReliable = true;
    private boolean isManaged = false;
    private String factoryType = "";
    private String factoryName = "";
    private String factoryDesc = "";
    private long checkInterval = 10000L;
    private int reconnectRetries = 3;
    private int connectionTimeout = 3;
    private String className = "";
    private String validatorClassName = "";
    private String url = "";
    private int minorVersion = 1;
    private int majorVersion = 0;
    private String vendorString = "Client Factory Version ";
    protected Properties factoryProperties = new Properties();
    protected transient ClientConnection defaultConnection = null;
    protected transient Map<String, ClientConnection> connectionsPool = new ConcurrentHashMap<String, ClientConnection>();
    protected transient boolean useTransientClassLoader = false;
    protected transient FabricComponent component = null;
    protected transient ConnectionMonitor connectionMonitor = null;

    private Object readResolve() {
        this.useTransientClassLoader = false;
        this.connectionsPool = new ConcurrentHashMap<String, ClientConnection>();
        return this;
    }

    protected ClientFactoryObject() {
    }

    @Override
    public void setUrl(String url) {
        this.url = url;
    }

    @Override
    public String getUrl() {
        return this.url;
    }

    @Override
    public String getDefaultUser() {
        return this.defaultUserId;
    }

    @Override
    public void setDefaultUser(String userName) {
        this.defaultUserId = userName;
    }

    @Override
    public void setDefaultPassword(String password) {
        this.defaultPassword = MacroProcessor.isMacro(password) ? password : Base64.encodeBytes(password.getBytes());
    }

    @Override
    public String getDefaultPassword() {
        if (this.defaultPassword == null || MacroProcessor.isMacro(this.defaultPassword)) {
            return this.defaultPassword;
        }
        return new String(Base64.decode(this.defaultPassword));
    }

    @Override
    public long getCheckInterval() {
        return this.checkInterval;
    }

    @Override
    public void setCheckInterval(long checkInterval) {
        this.checkInterval = checkInterval;
    }

    @Override
    public int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    @Override
    public String getConnectionClassName() {
        return this.className;
    }

    @Override
    public void setConnectionClassName(String factoryClassName) {
        this.className = factoryClassName.trim();
    }

    @Override
    public int getReconnectRetries() {
        return this.reconnectRetries;
    }

    @Override
    public String getVendorString() {
        return this.vendorString;
    }

    @Override
    public boolean isManaged() {
        return this.isManaged;
    }

    @Override
    public boolean isReliable() {
        return this.isReliable;
    }

    @Override
    public void setManaged(boolean isManaged) {
        this.isManaged = isManaged;
    }

    @Override
    public void setReliable(boolean isReliable) {
        this.isReliable = isReliable;
    }

    @Override
    public void setReconnectRetries(int reconnectRetries) {
        this.reconnectRetries = reconnectRetries;
    }

    @Override
    public void setConnectionTimeout(int connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    @Override
    public void setFactoryName(String factoryName) {
        this.factoryName = factoryName;
    }

    @Override
    public String getFactoryName() {
        return this.factoryName;
    }

    @Override
    public String getFactoryType() {
        return this.factoryType;
    }

    @Override
    public void setFactoryType(String type) {
        this.factoryType = type;
    }

    @Override
    public String getDescription() {
        return this.factoryDesc;
    }

    @Override
    public void setDescription(String desc) {
        this.factoryDesc = desc;
    }

    protected void setTransient(boolean useTransient) {
        this.useTransientClassLoader = useTransient;
    }

    public boolean isTransient() {
        return this.useTransientClassLoader;
    }

    @Override
    public int getMajorVersion() {
        return this.majorVersion;
    }

    @Override
    public int getMinorVersion() {
        return this.minorVersion;
    }

    @Override
    public ClassLoader getClassLoader() {
        try {
            return ClientConfigurationFactory.lookupClassLoader(this);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public ClientConnection createConnection(String connectionName, String userName, String password) throws ClientException {
        ClientConnection connection;
        try {
            connection = (ClientConnection)ClassUtils.createFromClassName((Object)this, this.className, this.getClassLoader());
        }
        catch (Exception ex) {
            throw new ClientException(1000, (Throwable)ex);
        }
        if (connection instanceof AbstractClientConnection) {
            ((AbstractClientConnection)connection).setName(connectionName);
        }
        connection.init(this);
        this.connectionsPool.put(connectionName, connection);
        Trace.logInfo(this, "Client Connection '" + connectionName + "' created in factory '" + this.getFullName() + "' (connections count: " + this.connectionsPool.size() + ").");
        this.startConnectionMonitor();
        return connection;
    }

    @Override
    public ClientConnection createConnection() throws ClientException {
        return this.createConnection("Sys$Default." + this.getFullName(), this.getDefaultUser(), this.getDefaultPassword());
    }

    @Override
    public Reference getReference() throws NamingException {
        return null;
    }

    @Override
    public int pingConnection(String connectionName) throws ClientException {
        ClientConnection con;
        try {
            con = this.lookupConnection(connectionName);
        }
        catch (ClientFactoryConfigurationException ex) {
            throw new ClientException(1000, (Throwable)ex);
        }
        return con.ping();
    }

    protected void initFactory(boolean noParms) throws RuntimeException {
        try {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(this.getClassLoader());
            this.defaultConnection = (ClientConnection)ClassUtils.createFromClassName((Object)this, this.getConnectionClassName(), this.getClassLoader());
            Thread.currentThread().setContextClassLoader(loader);
            if (!noParms) {
                this.setParameters();
            }
        }
        catch (UtilitiesException ex) {
            ex.printStackTrace();
            throw new RuntimeException(ex);
        }
    }

    private Class<?> loadConnectionClass() {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.getClassLoader());
            Class clazz = ClassUtils.loadClass(this.getConnectionClassName(), this.getClassLoader());
            return clazz;
        }
        catch (ClassNotFoundException exception) {
            Trace.logException(this, exception, false);
        }
        finally {
            Thread.currentThread().setContextClassLoader(loader);
        }
        return null;
    }

    public Class<?> getClientConnectionClass() {
        if (this.defaultConnection == null) {
            return this.loadConnectionClass();
        }
        return this.defaultConnection.getClass();
    }

    private void setParameters() {
        if (this.defaultConnection != null) {
            HashMap<String, Method> setters = ClientFactoryObject.getSetters(this.defaultConnection.getClass());
            Set<String> keys = setters.keySet();
            for (String key : keys) {
                String value = this.factoryProperties.getProperty(key);
                if (value == null || value.length() <= 0) continue;
                try {
                    Method method = setters.get(key);
                    Class<?> paramClass = method.getParameterTypes()[0];
                    method.invoke((Object)this.defaultConnection, ClientFactoryObject.convertValue(value, paramClass));
                }
                catch (InvocationTargetException error) {
                    Trace.logError(this, "Unable to set Client Factory parameter: " + error.getMessage());
                }
                catch (IllegalAccessException error) {
                    Trace.logError(this, "Unable to set Client Factory parameter: " + error.getMessage());
                }
            }
        }
    }

    protected void initParameterList() throws ClientConfigurationException {
        if (this.defaultConnection != null) {
            HashMap<String, Method> setters = ClientFactoryObject.getSetters(this.defaultConnection.getClass());
            for (String key : setters.keySet()) {
                this.factoryProperties.put(key, "");
            }
        }
    }

    private static HashMap<String, Method> getSetters(Class clazz) {
        HashMap<String, Method> setters = new HashMap<String, Method>();
        for (Method method : clazz.getMethods()) {
            if (!method.getName().startsWith("set") || method.getParameterTypes().length != 1) continue;
            setters.put(method.getName().substring("set".length()), method);
        }
        return setters;
    }

    private static Object convertValue(String value, Class toClass) {
        Constable result = null;
        if (String.class.equals((Object)toClass)) {
            return value;
        }
        if (Integer.TYPE.equals(toClass) || Integer.class.equals((Object)toClass)) {
            result = new Integer(value);
        } else if (Boolean.TYPE.equals(toClass) || Boolean.class.equals((Object)toClass)) {
            result = Boolean.valueOf(value);
        } else if (Double.TYPE.equals(toClass) || Double.class.equals((Object)toClass)) {
            result = new Double(value);
        } else if (Long.TYPE.equals(toClass) || Long.class.equals((Object)toClass)) {
            result = new Long(value);
        } else if (Byte.TYPE.equals(toClass) || Byte.class.equals((Object)toClass)) {
            result = new Byte(value);
        } else if (Float.TYPE.equals(toClass) || Float.class.equals((Object)toClass)) {
            result = new Float(value);
        }
        return result;
    }

    @Override
    public void destroyAll() throws ClientFactoryConfigurationException {
        for (String connectionName : this.listConnections()) {
            this.removeConnection(connectionName);
        }
        Trace.logDebug(this, "Destroyed all client connections in pool for factory '" + this.getFullName() + "'.");
    }

    @Override
    public ClientConnection lookupConnection(String connectionName) throws ClientFactoryConfigurationException {
        if (!this.connectionsPool.containsKey(connectionName)) {
            throw new ClientFactoryConfigurationException("Connection '" + connectionName + "' is not in pool.");
        }
        return this.connectionsPool.get(connectionName);
    }

    @Override
    public void removeConnection(String connectionName) throws ClientFactoryConfigurationException {
        if (!this.connectionsPool.containsKey(connectionName)) {
            throw new ClientFactoryConfigurationException("Connection '" + connectionName + "' is not in pool.");
        }
        ClientConnection connection = this.connectionsPool.remove(connectionName);
        Trace.logDebug(this, "Removed connection '" + connectionName + "' in factory '" + this.getFullName() + "'. Connections count: " + this.connectionsPool.size() + ".");
        this.stopConnectionMonitor();
        try {
            connection.disconnect();
        }
        catch (ClientException ex) {
            Trace.logError(this, "Disconnecting '" + connection.getName() + "' failed. Cause: " + ex.getMessage());
        }
    }

    @Override
    public String getProperty(String name) {
        return this.factoryProperties.getProperty(name);
    }

    @Override
    public void setProperty(String name, String value) throws ClientFactoryConfigurationException {
        if (!this.factoryProperties.containsKey(name)) {
            Trace.logDebug(this, "Factory Property '" + name + "' does not exist and will be created.");
        }
        this.factoryProperties.setProperty(name, value);
    }

    @Override
    public List<String> listProperties() {
        return this.factoryProperties.keySet().stream().map(Object::toString).sorted().collect(Collectors.toList());
    }

    @Override
    public List<String> listConnections() {
        ArrayList<String> result = new ArrayList<String>(this.connectionsPool.keySet());
        Collections.sort(result);
        return result;
    }

    public void setConnectionStateValidatorClass(String validatorClassName) {
        this.validatorClassName = validatorClassName;
    }

    public String getConnectionStateValidatorClass() {
        return this.validatorClassName;
    }

    protected void setFabricComponent(FabricComponent component) {
        this.component = component;
    }

    public FabricComponent getFabricComponent() {
        return this.component;
    }

    public String toString() {
        return this.getFullName() + ".cfo";
    }

    public String getFullName() {
        return this.factoryType + "." + this.factoryName;
    }

    @Override
    public Properties getProperties() {
        return this.factoryProperties;
    }

    private void startConnectionMonitor() {
        if (this.isReliable() && this.connectionsPool.size() == 1 && this.connectionMonitor == null) {
            Trace.logInfo(this, "Starting connection monitoring thread for factory '" + this.getFullName() + "'.");
            this.connectionMonitor = new ConnectionMonitor();
            this.connectionMonitor.start();
        }
    }

    private void stopConnectionMonitor() {
        if (this.isReliable() && this.connectionsPool.isEmpty() && this.connectionMonitor != null) {
            Trace.logDebug(this, "Stopping connection monitoring thread for factory '" + this.getFullName() + "'.");
            this.connectionMonitor.stop();
            this.connectionMonitor = null;
        }
    }

    private class ConnectionMonitor
    implements Runnable {
        private FabricThread executor = null;
        private volatile boolean isRunning = false;

        ConnectionMonitor() {
            this.executor = FabricThreadManager.getInstance().createDaemonThread("SVC:Client.Connection:Monitor", "Monitors connection for factory '" + ClientFactoryObject.this.getFullName() + "'.", this);
        }

        public synchronized void start() {
            this.isRunning = true;
            this.executor.start();
        }

        public synchronized void stop() {
            this.isRunning = false;
            this.executor.interrupt();
        }

        @Override
        public void run() {
            while (this.isRunning) {
                try {
                    Thread.sleep(ClientFactoryObject.this.getCheckInterval());
                    if (!this.isRunning || ClientFactoryObject.this.connectionsPool.isEmpty()) continue;
                    ArrayList<ClientConnection> removedConnections = new ArrayList<ClientConnection>();
                    for (ClientConnection clientConnection : ClientFactoryObject.this.connectionsPool.values()) {
                        try {
                            if (clientConnection.ping() != -999) continue;
                            removedConnections.add(clientConnection);
                        }
                        catch (Exception exception) {
                            Trace.logError(this, "Ping failed for connection '" + clientConnection.getName() + "'. Cause: " + exception.getMessage());
                        }
                    }
                    for (ClientConnection clientConnection : removedConnections) {
                        try {
                            ClientFactoryObject.this.removeConnection(clientConnection.getName());
                        }
                        catch (ClientFactoryConfigurationException clientFactoryConfigurationException) {}
                    }
                }
                catch (InterruptedException exception) {
                    this.stop();
                }
            }
            this.executor.stop();
        }
    }
}

