/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.admin.cfo;

import com.streamscape.Trace;
import com.streamscape.lib.utils.FileIOUtils;
import com.streamscape.omf.xml.XSerializer;
import com.streamscape.repository.RepositoryContext;
import com.streamscape.repository.RepositoryException;
import com.streamscape.repository.enums.PackageType;
import com.streamscape.repository.pkg.Package;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.runtime.RuntimeContextException;
import com.streamscape.runtime.mf.admin.cfo.ClientConfigurationException;
import com.streamscape.runtime.mf.admin.cfo.ClientFactoryObject;
import com.streamscape.sef.FabricComponent;
import com.streamscape.sef.dispatcher.AbstractFabricContextFactory;
import com.streamscape.sef.pkg.PackageManifestManager;
import com.streamscape.service.osf.clients.ClientFactory;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;

public class ClientConfigurationFactory
extends AbstractFabricContextFactory {
    public static final String PROTOTYPE = "prototype";
    public static final String SHOW_CONNECTION_PANEL = "wizard.client.connection.panel.show";
    public static final String DEFAULT_CONNECTION_FACTORY = "wizard.client.connection.factory.default";
    public static final String CONFIG_EXISTS = "wizard.client.config.exists";
    private static RepositoryContext repositoryContext = null;

    public ClientConfigurationFactory(RepositoryContext repositoryContext) {
        ClientConfigurationFactory.repositoryContext = repositoryContext;
    }

    public static ClientFactory createDefaultFactory(FabricComponent component, String factoryType, String className, String url) throws ClientConfigurationException {
        return ClientConfigurationFactory.createFactory(component, factoryType, PROTOTYPE, className, url, true);
    }

    public static ClientFactory createFactory(FabricComponent component, String factoryType, String factoryName, String providerClass, String url, boolean isTransient, boolean withLoad) throws ClientConfigurationException {
        ClientConfigurationFactory.checkContext();
        ClientFactoryObject factory = new ClientFactoryObject();
        factory.setFactoryType(factoryType);
        factory.setFactoryName(factoryName);
        factory.setConnectionClassName(providerClass);
        factory.setUrl(url);
        factory.setTransient(isTransient);
        factory.setFabricComponent(component);
        if (withLoad) {
            factory.initFactory(true);
        }
        factory.initParameterList();
        return factory;
    }

    public static ClientFactory createFactory(FabricComponent component, String factoryType, String factoryName, String providerClass, String url, boolean isTransient) throws ClientConfigurationException {
        return ClientConfigurationFactory.createFactory(component, factoryType, factoryName, providerClass, url, isTransient, true);
    }

    public static boolean existsClientFactory(String factoryName, String factoryType) throws RepositoryException, ClientConfigurationException {
        ClientConfigurationFactory.checkContext();
        ClientConfigurationFactory.checkBoundRepository(ClientConfigurationFactory.getContext());
        try {
            ClientConfigurationFactory.beginXact();
            boolean exists = repositoryContext.existsClientFactory(factoryName, factoryType);
            repositoryContext.commitXact();
            return exists;
        }
        catch (Exception ex) {
            repositoryContext.abortXactSafe();
            throw new ClientConfigurationException(ex);
        }
    }

    public static ClientFactory loadFactoryObject(FabricComponent component, String factoryName, String factoryType, boolean isTransient) throws RepositoryException, ClientConfigurationException {
        Trace.logDebug(ClientConfigurationFactory.class, "Loading Client Factory '" + factoryType + "." + factoryName + "'...");
        ClientConfigurationFactory.checkContext();
        ClientConfigurationFactory.checkBoundRepository(ClientConfigurationFactory.getContext());
        try {
            ClientConfigurationFactory.beginXact();
            ClientFactoryObject factory = (ClientFactoryObject)repositoryContext.loadClientFactory(factoryName, factoryType);
            ClientConfigurationFactory.initClientFactoryObject(factory, component, isTransient);
            repositoryContext.commitXact();
            Trace.logDebug(ClientConfigurationFactory.class, "Client Factory '" + factoryType + "." + factoryName + "' loaded.");
            return factory;
        }
        catch (Exception ex) {
            repositoryContext.abortXactSafe();
            throw new ClientConfigurationException(ex);
        }
    }

    public static ClientFactory loadFactoryObject(FabricComponent component, String workingDir, String factoryType, String factoryName, boolean isTransient) throws ClientConfigurationException {
        Trace.logDebug(ClientConfigurationFactory.class, "Loading Client Factory '" + factoryType + "." + factoryName + "'...");
        try {
            ClientConfigurationFactory.checkContext();
            XSerializer xf = context.getXSerializer();
            File cfoFile = FileIOUtils.openFile(workingDir + System.getProperty("file.separator") + factoryType + "." + factoryName + ".cfo");
            RandomAccessFile artifact = new RandomAccessFile(cfoFile, "rw");
            FileChannel afc = artifact.getChannel();
            FileLock flock = afc.lock();
            BufferedInputStream bis = new BufferedInputStream(new FileInputStream(artifact.getFD()));
            byte[] bytes = new byte[(int)cfoFile.length()];
            bis.read(bytes);
            flock.release();
            bis.close();
            artifact.close();
            ClientFactoryObject cfo = (ClientFactoryObject)xf.deserialize("ClientFactory", bytes);
            ClientConfigurationFactory.initClientFactoryObject(cfo, component, isTransient);
            Trace.logDebug(ClientConfigurationFactory.class, "Client Factory '" + cfo.getFactoryType() + "." + cfo.getFactoryName() + "' loaded.");
            return cfo;
        }
        catch (Exception ex) {
            throw new ClientConfigurationException(ex);
        }
    }

    private static void initClientFactoryObject(ClientFactoryObject factory, FabricComponent component, boolean isTransient) {
        factory.setTransient(isTransient);
        factory.setFabricComponent(component);
        if (factory.getDefaultUser() == null) {
            factory.setDefaultUser("");
        }
        if (factory.getDefaultPassword() == null) {
            factory.setDefaultPassword("");
        }
    }

    protected static ClassLoader lookupClassLoader(ClientFactoryObject cfo) throws RuntimeContextException, ClientConfigurationException {
        ClassLoader loader;
        if (cfo.getFactoryType() == null) {
            throw new ClientConfigurationException("Invalid or null parameter specified.");
        }
        ClientConfigurationFactory.checkContext();
        PackageManifestManager mm = cfo.getFabricComponent().getPackageManifestManager();
        ClassLoader classLoader = loader = mm != null ? mm.getLoaderRegistry().lookupClassLoader(Package.getFullName(PackageType.client, cfo.getFactoryType()), cfo.isTransient()) : null;
        if (loader == null) {
            Trace.logDebug(ClientConfigurationFactory.class, "System class loader will be used for Client Factory '" + cfo.getFullName() + "'.");
            loader = ClientConfigurationFactory.getContext().getSystemClassLoaderChain();
        }
        return loader;
    }

    public static void saveFactoryObject(ClientFactory cfo) throws ClientConfigurationException, RuntimeContextException {
        ClientConfigurationFactory.checkContext();
        ClientConfigurationFactory.checkBoundRepository(ClientConfigurationFactory.getContext());
        Trace.logDebug(ClientConfigurationFactory.class, "Saving Client Factory '" + cfo.getFactoryType() + "." + cfo.getFactoryName() + "'...");
        try {
            ClientConfigurationFactory.beginXact();
            repositoryContext.saveClientFactory(cfo);
            repositoryContext.commitXact();
        }
        catch (Exception ex) {
            repositoryContext.abortXactSafe();
            throw new ClientConfigurationException(ex);
        }
        Trace.logDebug(ClientConfigurationFactory.class, "Client Factory '" + cfo.getFactoryType() + "." + cfo.getFactoryName() + "' saved.");
    }

    private static void beginXact() throws Exception {
        repositoryContext.beginXact((RuntimeContext)ClientConfigurationFactory.getContext(), ((RuntimeContext)ClientConfigurationFactory.getContext()).getRepositoryContextTxTimeout());
    }

    public static void saveFactoryObject(String workingDir, ClientFactory cfo) throws ClientConfigurationException, RuntimeContextException {
        ClientConfigurationFactory.checkContext();
        Trace.logDebug(ClientConfigurationFactory.class, "Saving Client Factory '" + cfo.getFactoryType() + "." + cfo.getFactoryName() + "' to '" + workingDir + "'...");
        try {
            XSerializer xf = context.getXSerializer();
            String fileName = workingDir + System.getProperty("file.separator") + cfo.getFactoryType() + "." + cfo.getFactoryName() + ".cfo";
            String xdoc = xf.serialize(cfo);
            File cfoFile = FileIOUtils.newFile(fileName);
            RandomAccessFile artifact = new RandomAccessFile(cfoFile, "rw");
            FileChannel afc = artifact.getChannel();
            FileLock flock = afc.lock();
            artifact.writeBytes(xdoc);
            artifact.getFD().sync();
            flock.release();
            artifact.close();
        }
        catch (Exception ex) {
            throw new ClientConfigurationException(ex);
        }
        Trace.logDebug(ClientConfigurationFactory.class, "Client Factory '" + cfo.getFactoryType() + "." + cfo.getFactoryName() + "' saved to '" + workingDir + "'.");
    }
}

