/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.deploy;

import com.streamscape.lib.utils.FileIOUtils;
import com.streamscape.lib.utils.JARUtils;
import com.streamscape.omf.xml.XSerializer;
import com.streamscape.omf.xml.XSerializerFactory;
import com.streamscape.runtime.deploy.CtxDeploymentDescriptor;
import com.streamscape.runtime.deploy.DeployUtils;
import java.io.File;
import java.util.Calendar;
import java.util.LinkedHashMap;

public class StDeployGenerator {
    public static final String RTCONTEXT_CDX = "rtcontext.cdx";

    public static void generate(File cdxLocation) throws Exception {
        LinkedHashMap<String, byte[]> entries = new LinkedHashMap<String, byte[]>();
        entries.put("/rtcontext.cdx", DeployUtils.encrypt(new File(cdxLocation, RTCONTEXT_CDX)));
        JARUtils.createNewJarFromEntriesMap(new File(cdxLocation, "stdeploy.jar"), entries);
    }

    public static void generate(File ddx, byte[] cdx) throws Exception {
        LinkedHashMap<String, byte[]> entries = new LinkedHashMap<String, byte[]>();
        entries.put("/rtcontext.cdx", DeployUtils.encrypt(cdx));
        JARUtils.createNewJarFromEntriesMap(ddx, entries);
    }

    public static void generate(File location, CtxDeploymentDescriptor descriptor) throws Exception {
        File cdx = null;
        try {
            cdx = StDeployGenerator.generateCdx(location, descriptor);
            StDeployGenerator.generate(cdx.getParentFile());
        }
        finally {
            if (cdx != null) {
                cdx.delete();
            }
        }
    }

    public static File generateCdx(File location, CtxDeploymentDescriptor descriptor) throws Exception {
        if (!location.exists()) {
            location.mkdirs();
        }
        FileIOUtils.putFile(location.getAbsolutePath(), RTCONTEXT_CDX, XSerializerFactory.getInstance().getDefaultSerializer().serialize("RuntimeContextDescriptor", descriptor).getBytes());
        return new File(location, RTCONTEXT_CDX);
    }

    public static void main(String[] args) {
        if (args.length < 2) {
            System.err.println("Usage: java StDeployGenerator <DirectoriesToScan> true|false");
            System.exit(1);
        }
        try {
            boolean trial = Boolean.parseBoolean(args[args.length - 1]);
            for (int i = 0; i < args.length - 1; ++i) {
                StDeployGenerator.scan(new File(args[i]), trial);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(1);
        }
    }

    private static void scan(File location, boolean trial) throws Exception {
        if (new File(location, RTCONTEXT_CDX).exists()) {
            StDeployGenerator.generate(location, trial);
        }
        for (File file : location.listFiles()) {
            if (!file.isDirectory()) continue;
            StDeployGenerator.scan(file, trial);
        }
    }

    private static void generate(File cdxLocation, boolean trial) throws Exception {
        XSerializer serializer = XSerializerFactory.getInstance().getDefaultSerializer();
        CtxDeploymentDescriptor ctx = (CtxDeploymentDescriptor)serializer.deserialize("RuntimeContextDescriptor", FileIOUtils.getFileContent(new File(cdxLocation, RTCONTEXT_CDX)));
        CtxDeploymentDescriptor.setDefaultSTRoot(ctx);
        if (trial) {
            Calendar calendar = Calendar.getInstance();
            calendar.add(2, 6);
            ctx.setLicenseTs(calendar.getTime().getTime());
        }
        StDeployGenerator.generate(new File(cdxLocation, "stdeploy.jar"), serializer.serialize("RuntimeContextDescriptor", ctx).getBytes());
    }
}

