/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.deploy;

import com.streamscape.Trace;
import com.streamscape.lib.utils.CryptoUtils;
import com.streamscape.lib.utils.FileIOUtils;
import com.streamscape.lib.utils.JARUtils;
import com.streamscape.lib.utils.UtilitiesException;
import com.streamscape.omf.xml.XSerializer;
import com.streamscape.omf.xml.XSerializerFactory;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.runtime.deploy.CtxDeploymentDescriptor;
import com.streamscape.sef.FabricException;
import java.io.File;
import java.util.LinkedHashMap;

public class DeployUtils {
    private static final byte[] KEY = new byte[]{13, 65, -28, -40, 108, 119, -80, -70, -103, 32, 29, -27, 85, 13, 4, 109};

    public static File getDdxLocation(RuntimeContext context) throws FabricException {
        File ddxLocation = new File(context.getDeploymentDescriptorFilename()).getParentFile();
        if (ddxLocation == null) {
            throw new FabricException("Location of Deployment Descriptor not found.");
        }
        return ddxLocation;
    }

    public static CtxDeploymentDescriptor getDeploymentDescriptor(String filename) throws UtilitiesException {
        return DeployUtils.getDeploymentDescriptor(filename, XSerializerFactory.getInstance().getDefaultSerializer());
    }

    public static CtxDeploymentDescriptor getDeploymentDescriptor(File ddxLocation) throws Exception {
        File ddxFile = new File(ddxLocation, "stdeploy.jar");
        if (!ddxFile.exists()) {
            throw new FabricException("Deployment descriptor archive not found.");
        }
        return DeployUtils.getDeploymentDescriptor(ddxFile.getPath());
    }

    public static CtxDeploymentDescriptor getDeploymentDescriptor(String filename, XSerializer serializer) throws UtilitiesException {
        byte[] cdx;
        byte[] data;
        Trace.logDebug(DeployUtils.class, "Extracting Deployment Descriptor...");
        try {
            data = JARUtils.getEntriesMapFromJarFile(filename).get("/rtcontext.cdx");
        }
        catch (Exception exception) {
            throw new UtilitiesException("Opening Deployment Descriptor Archive failed.", exception, -3);
        }
        if (data == null) {
            throw new UtilitiesException("Archive does not contain a valid Deployment Descriptor.", -1);
        }
        if (data.length == 0) {
            throw new UtilitiesException("Archive contains an empty Deployment Descriptor.", -2);
        }
        try {
            cdx = CryptoUtils.decrypt(data, KEY);
        }
        catch (Exception exception) {
            throw new UtilitiesException("Decrypting Deployment Descriptor Archive failed.", exception, -4);
        }
        try {
            CtxDeploymentDescriptor result = (CtxDeploymentDescriptor)serializer.deserialize("RuntimeContextDescriptor", new String(cdx).replace("NV__ROOT", "ST__ROOT"));
            Trace.logInfo(DeployUtils.class, "Deployment Descriptor extracted.");
            return result;
        }
        catch (Exception exception) {
            throw new UtilitiesException("Deserialization of Deployment Descriptor Archive failed.", exception, -5);
        }
    }

    static byte[] encrypt(File cdx) throws Exception {
        return CryptoUtils.encrypt(FileIOUtils.getFileContent(cdx), KEY);
    }

    static byte[] encrypt(byte[] cdx) throws Exception {
        return CryptoUtils.encrypt(cdx, KEY);
    }

    public static void main(String[] args) {
        if (args.length < 3) {
            System.err.println("Usage: java -jar StDeployConverter.jar <source> <destination> ENCRYPT|DECRYPT");
            System.exit(1);
        }
        try {
            DeployUtils.convert(args[0], args[1], args[2].equalsIgnoreCase("ENCRYPT"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(1);
        }
    }

    static void convert(String sourceFilename, String destinationFilename, boolean encrypt) throws Exception {
        byte[] cdx = JARUtils.getEntriesMapFromJarFile(sourceFilename).get("/rtcontext.cdx");
        if (cdx == null) {
            cdx = JARUtils.getEntriesMapFromJarFile(sourceFilename).get("rtcontext.cdx");
        }
        LinkedHashMap<String, byte[]> entries = new LinkedHashMap<String, byte[]>();
        entries.put("/rtcontext.cdx", encrypt ? CryptoUtils.encrypt(cdx, KEY) : CryptoUtils.decrypt(cdx, KEY));
        JARUtils.createNewJarFromEntriesMap(new File(destinationFilename), entries);
    }
}

