/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.deploy;

import com.streamscape.lib.utils.ClassUtils;
import com.streamscape.lib.utils.JVM;
import com.streamscape.repository.cache.MFContext;
import com.streamscape.runtime.Context;
import com.streamscape.runtime.deploy.DeploymentDescriptor;
import com.streamscape.sef.container.Container;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;

public class CtxDeploymentDescriptor
implements DeploymentDescriptor {
    public static final String DEFAULT_INSTALL_DIR_WIN = "C:/StreamScape";
    public static final String DEFAULT_INSTALL_DIR_LIN = "/opt/streamscape";
    protected String ST_ROOT = "";
    protected String INITIAL_CONTEXT_FACTORY = MFContext.class.getName();
    protected String BATCHSIZE = "";
    protected String PROVIDER_URL = "";
    protected String PROVIDER_ARCHIVE = ".";
    protected String SECURITY_PRINCIPAL = "";
    protected String SECURITY_CREDENTIALS = "";
    protected boolean SECURITY_ENABLED = true;
    protected String AUTHENTICATION_MODULE = "Default";
    protected String CONNECTION_RETRY = "";
    protected String CONNECTION_TIMEOUT = "";
    protected String IO_TIMEOUT = "";
    protected String DISCOVERY_PROTOCOL = "Default";
    protected String CTX_TIMEOUT = "";
    protected String REFERRAL = "";
    protected String ctxType = Context.CTX_TF_CONTAINER.name();
    protected String cxtName = "";
    protected String vendorString = "";
    protected String ctxContainerClass = Container.class.getName();
    protected String startupDir = ".";
    protected boolean DSPACE_AUTO_BIND = true;
    protected boolean REPO_AUTO_BIND = true;
    protected boolean COHERENCE_AUTO_BIND = false;
    protected boolean RUNTIME_AUTO_UNLOAD = false;
    protected boolean RUNTIME_FORCE_LOCK = false;
    protected boolean PRESENCE = false;
    protected boolean CLUSTER_ENABLED = false;
    protected String CLUSTER_NAME = "";
    protected long LICENSE_TS = 0L;
    protected String LICENSE_KEY = "";
    protected Hashtable<String, String> repoParameters = new Hashtable();

    public void setContainerClass(String className) {
        this.ctxContainerClass = className;
    }

    @Override
    public String getContainerClass() {
        return this.ctxContainerClass;
    }

    @Override
    public String getStartupDir() {
        return this.startupDir;
    }

    public void setStartupDir(String startupDir) {
        this.startupDir = startupDir;
    }

    public void setRuntimeCacheForceLock(boolean forceLock) {
        this.RUNTIME_FORCE_LOCK = forceLock;
    }

    @Override
    public boolean isRuntimeCacheForceLock() {
        return this.RUNTIME_FORCE_LOCK;
    }

    @Override
    public boolean isClusterEnabled() {
        return this.CLUSTER_ENABLED;
    }

    public void setClusterEnabled(boolean isClusterEnabled) {
        this.CLUSTER_ENABLED = isClusterEnabled;
    }

    @Override
    public String getClusterName() {
        return this.CLUSTER_NAME;
    }

    public void setClusterName(String clusterName) {
        this.CLUSTER_NAME = clusterName;
    }

    public void setContextName(String name) {
        this.cxtName = name;
    }

    @Override
    public String getContextName() {
        return this.cxtName;
    }

    public void setVendorString(String str) {
        this.vendorString = str;
    }

    @Override
    public String getVendorString() {
        return this.vendorString;
    }

    public boolean isContainerValid() {
        return ClassUtils.isClassOnPath(this.ctxContainerClass, this.getClass(), true);
    }

    public void addRepositoryParameter(String name, String value) {
        this.repoParameters.put(name, value);
    }

    @Override
    public String getAuthenticationModule() {
        return this.AUTHENTICATION_MODULE;
    }

    @Override
    public String getBatchSize() {
        return this.BATCHSIZE;
    }

    @Override
    public String getConnectionRetry() {
        return this.CONNECTION_RETRY;
    }

    @Override
    public String getConnectionTimeout() {
        return this.CONNECTION_TIMEOUT;
    }

    @Override
    public String getContextTimeout() {
        return this.CTX_TIMEOUT;
    }

    public void setRuntimeContextAutoUnload(boolean autoUnload) {
        this.RUNTIME_AUTO_UNLOAD = autoUnload;
    }

    @Override
    public boolean isRuntimeContextAutoUnload() {
        return this.RUNTIME_AUTO_UNLOAD;
    }

    @Override
    public Context getContextType() {
        if (this.ctxType.equals("CTX_APPLICATION")) {
            return Context.CTX_APPLICATION;
        }
        if (this.ctxType.equals("CTX_EX_CONTAINER")) {
            return Context.CTX_EX_CONTAINER;
        }
        if (this.ctxType.equals("CTX_TF_CONTAINER")) {
            return Context.CTX_TF_CONTAINER;
        }
        return Context.CTX_APPLICATION;
    }

    public void setContextType(Context ctx) {
        this.ctxType = ctx.name();
    }

    public void setProviderArchive(String jar) {
        this.PROVIDER_ARCHIVE = jar;
    }

    @Override
    public String getProviderArchive() {
        return this.PROVIDER_ARCHIVE;
    }

    @Override
    public String getDiscoveryProtocol() {
        return this.DISCOVERY_PROTOCOL;
    }

    @Override
    public String getIOTimeout() {
        return this.IO_TIMEOUT;
    }

    @Override
    public String getInitialContextFactory() {
        return this.INITIAL_CONTEXT_FACTORY;
    }

    @Override
    public String getSTRoot() {
        return this.ST_ROOT;
    }

    @Override
    public String getProviderURL() {
        return this.PROVIDER_URL;
    }

    @Override
    public String getReferral() {
        return this.REFERRAL;
    }

    @Override
    public String getRepositoryParameter(String name) {
        return this.repoParameters.get(name);
    }

    @Override
    public List<String> getRepositoryParameters() {
        return new ArrayList<String>(this.repoParameters.keySet());
    }

    @Override
    public int getRepositoryParametersCount() {
        return this.repoParameters.size();
    }

    public String getSecurityCredentials() {
        return this.SECURITY_CREDENTIALS;
    }

    @Override
    public String getSecurityPrincipal() {
        return this.SECURITY_PRINCIPAL;
    }

    @Override
    public boolean isRepositoryAutoBind() {
        return this.REPO_AUTO_BIND;
    }

    @Override
    public boolean isDataspaceAutoBind() {
        return this.DSPACE_AUTO_BIND;
    }

    @Override
    public boolean isCoherenceAutoBind() {
        return this.COHERENCE_AUTO_BIND;
    }

    public void removeRepositoryParameter(String name) {
        this.repoParameters.remove(name);
    }

    public void setAuthenticationModule(String moduleName) {
        this.AUTHENTICATION_MODULE = moduleName;
    }

    public void setCoherenceAutoBind(boolean autoBind) {
        this.COHERENCE_AUTO_BIND = autoBind;
    }

    public void setBatchSize(String size) {
        this.BATCHSIZE = size;
    }

    public void setConnectionRetry(String retry) {
        this.CONNECTION_RETRY = retry;
    }

    public void setConnectionTimeout(String timeout) {
        this.CONNECTION_TIMEOUT = timeout;
    }

    public void setContextTimeout(String timeout) {
        this.CTX_TIMEOUT = timeout;
    }

    public void setDiscoveryProtocol(String protocol) {
        this.DISCOVERY_PROTOCOL = protocol;
    }

    public void setIOTimeout(String timeout) {
        this.IO_TIMEOUT = timeout;
    }

    public void setInitialContextFactory(String ctx) {
        this.INITIAL_CONTEXT_FACTORY = ctx;
    }

    public void setSTRoot(String root) {
        this.ST_ROOT = root;
    }

    public void setProviderURL(String url) {
        this.PROVIDER_URL = url;
    }

    public void setReferral(String ref) {
        this.REFERRAL = ref;
    }

    public void setSecurityCredentials(String credentials) {
        this.SECURITY_CREDENTIALS = credentials;
    }

    public void setSecurityPrincipal(String principal) {
        this.SECURITY_PRINCIPAL = principal;
    }

    @Override
    public boolean isPresence() {
        return this.PRESENCE;
    }

    public void setPresence(boolean value) {
        this.PRESENCE = value;
    }

    @Override
    public boolean isSecurityEnabled() {
        return this.SECURITY_ENABLED;
    }

    @Override
    public long getLicenseTs() {
        return this.LICENSE_TS;
    }

    public void setLicenseTs(long licenseTs) {
        this.LICENSE_TS = licenseTs;
    }

    @Override
    public String getLicenseKey() {
        return this.LICENSE_KEY;
    }

    public void setLicenseKey(String licenseKey) {
        this.LICENSE_KEY = licenseKey;
    }

    public static void setDefaultSTRoot(CtxDeploymentDescriptor ctx) {
        if (JVM.isWindowsOS()) {
            ctx.setSTRoot(DEFAULT_INSTALL_DIR_WIN);
        } else if (JVM.isLinuxOS()) {
            ctx.setSTRoot(DEFAULT_INSTALL_DIR_LIN);
        }
    }
}

