/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime;

import com.streamscape.Trace;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.runtime.RuntimeState;
import com.streamscape.sdo.advisory.RuntimeAdvisory;

class ShutdownHandler
extends Thread {
    private RuntimeContext context;

    public ShutdownHandler(RuntimeContext context) {
        super("FSYS:Shutdown.Handler");
        this.context = context;
        Trace.logDebug(this, "Fabric Runtime Shutdown Handler Enabled.");
    }

    @Override
    public void run() {
        if (RuntimeState.isActive()) {
            Trace.logDebug(this, "Fabric Runtime Context Shutdown initiated...");
            try {
                this.context.raiseRuntimeAdvisory(new RuntimeAdvisory("Fabric Runtime Context '" + this.context.getName() + "' is shutting down."));
            }
            catch (Exception exception) {
                Trace.logException(this, exception, true);
                Trace.logError(this, "Raising RuntimeAdvisory failed.");
            }
            this.context.shutdownOnExit();
            Trace.logInfo(this, "Stopped.");
        }
    }
}

