/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime;

import com.streamscape.Trace;
import com.streamscape.omf.java.SerialSchema;
import com.streamscape.repository.cache.SystemTableFile;
import com.streamscape.sdo.CloneableDataObject;
import com.streamscape.sdo.enums.ArtifactState;
import com.streamscape.sdo.rowset.RowSet;
import com.streamscape.sef.dispatcher.AbstractOMFManager;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class RuntimeOMFManager
extends AbstractOMFManager {
    private SerialSchemas serialSchemas;

    RuntimeOMFManager() {
    }

    void initSerialSchemas() throws Exception {
        this.serialSchemas = new SerialSchemas();
        this.serialSchemas.load(false);
        if (!this.serialSchemas.store().isEmpty() && this.serialSchemas.store().values().iterator().next() instanceof Map) {
            Map<String, ClassSerialSchemas> oldStore = this.serialSchemas.store();
            Trace.logInfo(this, "WARNING: Serial Schemas store has old format and will be converted...");
            this.serialSchemas.recreate();
            for (Map.Entry<String, ClassSerialSchemas> externalEntry : oldStore.entrySet()) {
                for (Map.Entry internalEntry : ((Map)((Object)externalEntry.getValue())).entrySet()) {
                    this.addSerialSchema(externalEntry.getKey(), (Long)internalEntry.getKey(), (SerialSchema)internalEntry.getValue());
                }
            }
        }
    }

    @Override
    protected synchronized void addSerialSchema(String className, long serialVersion, SerialSchema schema) {
        ClassSerialSchemas classSchemas;
        Long referenceSerialVersion;
        if (!this.serialSchemas.store().containsKey(className)) {
            this.serialSchemas.store().put(className, new ClassSerialSchemas());
        }
        if ((referenceSerialVersion = (classSchemas = this.serialSchemas.store().get(className)).findReference(schema)) != null) {
            classSchemas.putReference(serialVersion, referenceSerialVersion);
        } else {
            classSchemas.putSchema(serialVersion, schema);
        }
        this.updateSerialSchemasInRepository();
    }

    @Override
    protected synchronized SerialSchema getSerialSchema(String className, long serialVersion) {
        Long referenceSerialVersion;
        SerialSchema result = null;
        ClassSerialSchemas classSchemas = this.serialSchemas.store().get(className);
        if (classSchemas != null && (result = classSchemas.getSchema(serialVersion)) == null && (referenceSerialVersion = classSchemas.getReference(serialVersion)) != null) {
            result = classSchemas.getSchema(referenceSerialVersion);
        }
        return result;
    }

    @Override
    protected synchronized void clearSerialSchemas() {
        this.serialSchemas.store().clear();
        this.updateSerialSchemasInRepository();
    }

    private void updateSerialSchemasInRepository() {
        try {
            this.serialSchemas.save();
        }
        catch (Exception exception) {
            Trace.logException(this, exception, true);
            Trace.logError(this, "Saving Serial Schemas failed.");
        }
    }

    synchronized ClassSerialSchemas getClassSchemas(String className) {
        ClassSerialSchemas result = this.serialSchemas.store().get(className);
        return result != null ? result.clone() : null;
    }

    synchronized Map<String, ClassSerialSchemas> getAllSchemas() {
        return this.serialSchemas.cloneStore();
    }

    @Override
    protected void fillSerialSchemas(String className, RowSet result) throws Exception {
        block5: {
            block4: {
                if (className == null) break block4;
                ClassSerialSchemas classSchemas = this.getClassSchemas(className);
                if (classSchemas == null) break block5;
                if (classSchemas.schemas != null) {
                    for (Map.Entry<Long, Serializable> entry : classSchemas.schemas.entrySet()) {
                        result.addToRowSet(new Object[]{entry.getKey(), true, ""});
                    }
                }
                if (classSchemas.references == null) break block5;
                for (Map.Entry<Long, Serializable> entry : classSchemas.references.entrySet()) {
                    result.addToRowSet(new Object[]{entry.getKey(), false, entry.getValue()});
                }
                break block5;
            }
            ArrayList<Map.Entry<String, ClassSerialSchemas>> entries = new ArrayList<Map.Entry<String, ClassSerialSchemas>>(this.getAllSchemas().entrySet());
            entries.sort(Comparator.comparing(Map.Entry::getKey));
            for (Map.Entry entry : entries) {
                result.addToRowSet(new Object[]{entry.getKey(), this.formatSemanticType((String)entry.getKey()), this.getCount(((ClassSerialSchemas)entry.getValue()).schemas), this.getCount(((ClassSerialSchemas)entry.getValue()).references)});
            }
        }
    }

    private String formatSemanticType(String className) {
        String result = RuntimeOMFManager.getContext().getSemanticTypeCache().resolveSemanticClass(className);
        return result != null ? result : "n/a";
    }

    @Override
    protected Map<String, Integer> getSerialSchemaCount() throws Exception {
        HashMap<String, Integer> result = new HashMap<String, Integer>();
        for (Map.Entry<String, ClassSerialSchemas> entry : this.getAllSchemas().entrySet()) {
            result.put(entry.getKey(), this.getCount(entry.getValue().schemas) + this.getCount(entry.getValue().references));
        }
        return result;
    }

    private int getCount(Map<?, ?> map) {
        return map != null ? map.size() : 0;
    }

    @Override
    protected List<Long> getSerialSchemaVersions(String className) {
        ArrayList<Long> result = new ArrayList<Long>();
        ClassSerialSchemas classSchemas = this.getClassSchemas(className);
        if (classSchemas != null) {
            if (classSchemas.schemas != null) {
                result.addAll(classSchemas.schemas.keySet());
            }
            if (classSchemas.references != null) {
                result.addAll(classSchemas.references.keySet());
            }
        }
        return result;
    }

    private static class SerialSchemas
    extends SystemTableFile<Map<String, ClassSerialSchemas>> {
        protected SerialSchemas() {
            super("SerialSchemas", SerialSchema.TABLE_PATH_IN_CACHE, ArtifactState.RECOVER_SERIAL_SCHEMAS_TABLE);
        }

        @Override
        protected void createStore() {
            this.store = new HashMap();
        }

        @Override
        protected void recreate() {
            super.recreate(false);
        }

        @Override
        protected Map<String, ClassSerialSchemas> cloneStore() {
            HashMap<String, ClassSerialSchemas> result = new HashMap<String, ClassSerialSchemas>();
            for (Map.Entry entry : ((Map)this.store).entrySet()) {
                result.put((String)entry.getKey(), ((ClassSerialSchemas)entry.getValue()).clone());
            }
            return result;
        }

        Map<String, ClassSerialSchemas> store() {
            return (Map)this.store;
        }
    }

    static class ClassSerialSchemas
    extends CloneableDataObject {
        private HashMap<Long, SerialSchema> schemas;
        private HashMap<Long, Long> references;

        ClassSerialSchemas() {
        }

        SerialSchema getSchema(long serialVersion) {
            return this.schemas != null ? this.schemas.get(serialVersion) : null;
        }

        void putSchema(long serialVersion, SerialSchema schema) {
            if (this.schemas == null) {
                this.schemas = new HashMap();
            }
            this.schemas.put(serialVersion, schema);
        }

        Long getReference(long serialVersion) {
            return this.references != null ? this.references.get(serialVersion) : null;
        }

        void putReference(long serialVersion, long referenceSerialVersion) {
            if (this.references == null) {
                this.references = new HashMap();
            }
            this.references.put(serialVersion, referenceSerialVersion);
        }

        Long findReference(SerialSchema schema) {
            if (this.schemas != null) {
                return this.schemas.entrySet().stream().filter(entry -> ((SerialSchema)entry.getValue()).equals(schema)).findFirst().map(Map.Entry::getKey).orElse(null);
            }
            return null;
        }

        void clear() {
            if (this.schemas != null) {
                this.schemas.clear();
                this.schemas = null;
            }
            if (this.references != null) {
                this.references.clear();
                this.references = null;
            }
        }

        @Override
        public ClassSerialSchemas clone() {
            ClassSerialSchemas result = (ClassSerialSchemas)super.clone();
            if (this.schemas != null) {
                result.schemas = new HashMap();
                for (Map.Entry<Long, SerialSchema> entry : this.schemas.entrySet()) {
                    result.schemas.put(entry.getKey(), entry.getValue().clone());
                }
            }
            result.references = this.references != null ? (HashMap)this.references.clone() : null;
            return result;
        }
    }
}

