/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime;

import com.streamscape.Trace;
import com.streamscape.repository.enums.PackageType;
import com.streamscape.repository.object.ReferenceContext;
import com.streamscape.repository.pkg.Package;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.runtime.RuntimePackageManifest;
import com.streamscape.runtime.mf.admin.obj.ObjectConfigurationException;
import com.streamscape.runtime.mf.admin.obj.SemanticObjectReferenceStore;
import com.streamscape.sef.dispatcher.AbstractPackageManifestManager;
import com.streamscape.sef.dispatcher.ComponentManifestManager;
import com.streamscape.sef.dispatcher.RuntimeLoaderRegistryImpl;
import com.streamscape.sef.enums.ComponentModel;
import com.streamscape.sef.moderator.ModeratorUtils;
import com.streamscape.sef.pkg.PackageDescriptor;
import com.streamscape.sef.pkg.PackageManifestException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import javax.naming.NamingException;

public class RuntimeManifestManager
extends AbstractPackageManifestManager {
    private Map<String, ComponentManifestManager> componentManifestManagers = new ConcurrentHashMap<String, ComponentManifestManager>();

    RuntimeManifestManager(RuntimeContext context) throws PackageManifestException {
        super(context);
        this.loaderRegistry = new RuntimeLoaderRegistryImpl(context, context.getClass().getClassLoader());
        this.manifest = new RuntimePackageManifest();
    }

    @Override
    protected void addComponentManifestManager(ComponentManifestManager componentManifestManager) {
        this.componentManifestManagers.put(ModeratorUtils.makeComponentFullName(componentManifestManager.getComponent()), componentManifestManager);
    }

    @Override
    protected void removeComponentManifestManager(ComponentManifestManager componentManifestManager) {
        this.componentManifestManagers.remove(ModeratorUtils.makeComponentFullName(componentManifestManager.getComponent()));
    }

    public List<ComponentManifestManager> getComponentManifestManagers() {
        return this.getComponentManifestManagers(null);
    }

    public List<ComponentManifestManager> getComponentManifestManagers(ComponentModel model) {
        if (model == null) {
            return new ArrayList<ComponentManifestManager>(this.componentManifestManagers.values());
        }
        return this.componentManifestManagers.values().stream().filter(manifest -> manifest.getComponent().getComponentModel() == model).collect(Collectors.toList());
    }

    @Override
    public void addPackageAt(int position, PackageDescriptor descriptor) throws PackageManifestException {
        this.doAddPackageAt(position, descriptor, true);
    }

    @Override
    protected void checkPackageType(PackageDescriptor descriptor) throws PackageManifestException {
        if (descriptor.getPackageType() == PackageType.service) {
            throw new PackageManifestException("Service package cannot be registered in Runtime Package Manifest.");
        }
    }

    @Override
    public void updatePackage(PackageDescriptor descriptor, Package pkg) throws PackageManifestException {
        this.doUpdatePackageAt(null, descriptor, pkg, true);
    }

    @Override
    public void updatePackageAt(int position, PackageDescriptor descriptor, Package pkg) throws PackageManifestException {
        this.doUpdatePackageAt(position, descriptor, pkg, true);
    }

    @Override
    public void removePackage(String name) throws NamingException, PackageManifestException {
        this.doRemovePackage(name, true);
    }

    @Override
    public void loadPackage(String name, boolean checkDependencies) throws NamingException, PackageManifestException {
        this.doLoadPackage(name, checkDependencies, true);
    }

    @Override
    public void unloadPackage(String name, boolean checkDependencies) throws NamingException, PackageManifestException {
        this.doUnloadPackage(name, checkDependencies, true);
    }

    @Override
    protected void checkDependentPackages(PackageDescriptor descriptor) {
    }

    @Override
    protected void doSaveManifest() throws PackageManifestException {
        try {
            ReferenceContext ref = SemanticObjectReferenceStore.lookupReferenceContext("/sys/package/manifest");
            if (ref == null) {
                Trace.logError(this, "System Package Manifest Area not found.");
                throw new PackageManifestException("System Package Manifest Area not found.");
            }
            SemanticObjectReferenceStore.beginXact();
            SemanticObjectReferenceStore.setReferenceContext(ref);
            if (SemanticObjectReferenceStore.lookup(RuntimePackageManifest.class.getSimpleName()) == null) {
                Trace.logDebug(this, "Creating Runtime Context Manifest...");
                SemanticObjectReferenceStore.bind(RuntimePackageManifest.class.getSimpleName(), this.manifest);
            } else {
                Trace.logDebug(this, "Updating Runtime Context Manifest...");
                SemanticObjectReferenceStore.rebind(RuntimePackageManifest.class.getSimpleName(), this.manifest);
            }
            SemanticObjectReferenceStore.commitXact();
        }
        catch (ObjectConfigurationException exception) {
            throw new PackageManifestException("Saving Runtime Package Manifest failed.", exception);
        }
    }

    @Override
    protected void doLoadManifest() throws PackageManifestException {
        try {
            ReferenceContext ref = SemanticObjectReferenceStore.lookupReferenceContext("/sys/package/manifest");
            if (ref == null) {
                Trace.logError(this, "Runtime Package Manifest area not found.");
                throw new PackageManifestException("Runtime Package Manifest area not found.");
            }
            SemanticObjectReferenceStore.beginXact();
            SemanticObjectReferenceStore.setReferenceContext(ref);
            RuntimePackageManifest manifest = (RuntimePackageManifest)SemanticObjectReferenceStore.lookup(RuntimePackageManifest.class.getSimpleName());
            if (manifest == null) {
                Trace.logDebug(this, "Creating default Runtime Package Manifest...");
                SemanticObjectReferenceStore.bind(RuntimePackageManifest.class.getSimpleName(), this.manifest);
                manifest = (RuntimePackageManifest)SemanticObjectReferenceStore.lookup(RuntimePackageManifest.class.getSimpleName());
            }
            this.manifest = manifest;
            SemanticObjectReferenceStore.commitXact();
        }
        catch (ObjectConfigurationException exception) {
            throw new PackageManifestException("Loading Runtime Package Manifest failed.", exception);
        }
    }

    @Override
    protected String getManifestType() {
        return "Runtime";
    }
}

