/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime;

import com.streamscape.ds.DataspaceException;
import com.streamscape.ds.mf.DataspaceLexiconProcessor;
import com.streamscape.ds.mf.DataspaceSLOperation;
import com.streamscape.ds.parser.statement.Statement;
import com.streamscape.ds.session.Session;
import com.streamscape.ds.trigger.event.SysFunctionUnit;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.runtime.RuntimeDSLProvider;
import com.streamscape.runtime.RuntimeHelpSLResponse;
import com.streamscape.runtime.RuntimeMFSession;
import com.streamscape.sdo.operation.HelpSLResponse;
import com.streamscape.sdo.operation.Operation;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sef.dispatcher.AbstractRuntimeServiceMFSession;
import com.streamscape.sef.dispatcher.ServiceMFSession;
import com.streamscape.slex.AbstractLexiconProcessor;
import com.streamscape.slex.DSLComponent;
import com.streamscape.slex.DSLProvider;
import com.streamscape.slex.HelpOperation;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.UnsupportedRequestException;
import com.streamscape.slex.lang.completion.DSLCompletion;
import com.streamscape.slex.system.SystemDSLProvider;
import com.streamscape.slex.system.SystemHelpOperation;
import com.streamscape.tools.console.autocompletion.CompoundCompleter;
import java.util.Set;

public class RuntimeLexiconProcessor
extends AbstractLexiconProcessor<RuntimeContext> {
    protected RuntimeDSLProvider runtimeProvider;

    public RuntimeLexiconProcessor(RuntimeContext context) {
        super(context.getLexiconManager(), context);
    }

    @Override
    protected DSLProvider createBaseProvider(DSLComponent<RuntimeContext> component) {
        return this.createRuntimeProvider(component);
    }

    protected DSLProvider createRuntimeProvider(DSLComponent<RuntimeContext> component) {
        this.runtimeProvider = new RuntimeDSLProvider(component.getCallable(), this.isMnode());
        return this.runtimeProvider;
    }

    @Override
    protected DSLProvider createSystemProvider() {
        return new SystemDSLProvider(this, this){

            @Override
            protected SystemHelpOperation createHelpOperation() {
                return new RuntimeSystemHelpOperation();
            }
        };
    }

    protected boolean isMnode() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public SLResponse invoke(String operation, MFSession session, long timeout) throws Exception {
        try {
            SLResponse response = super.invoke(operation, session, timeout);
            if (!(response.getException() instanceof UnsupportedRequestException)) return response;
            throw (UnsupportedRequestException)response.getException();
        }
        catch (UnsupportedRequestException exception) {
            if (!(session instanceof AbstractRuntimeServiceMFSession)) throw exception;
            Session dataspaceSDSSession = ((AbstractRuntimeServiceMFSession)session).getDataspaceSDSSession();
            if (dataspaceSDSSession == null) {
                if (!(session instanceof ServiceMFSession)) throw exception;
                throw new UnsupportedRequestException(exception.getMessage() + " Or default session dataspace is not set or invalid.");
            }
            dataspaceSDSSession.setRequestTimeout(timeout);
            if (dataspaceSDSSession == null) throw exception;
            Session session2 = dataspaceSDSSession;
            synchronized (session2) {
                DataspaceSLOperation dataspaceSLOperation = DataspaceLexiconProcessor.lookupOperationForRuntimeByQuery(operation, session, true);
                if (dataspaceSLOperation != null && !dataspaceSLOperation.isAvailableInRuntime()) {
                    throw new Exception("Operation '" + dataspaceSLOperation.getName() + "' is not available in Runtime context.");
                }
                boolean lexiconProcessorSet = SysFunctionUnit.AbstractGetQueryEntry.setLexiconProcessorIfNotSet(this, session);
                try {
                    Statement statement;
                    try {
                        statement = dataspaceSDSSession.compileStatement(operation);
                    }
                    catch (DataspaceException dataspaceException) {
                        if (!(dataspaceException.getCause() instanceof UnsupportedRequestException)) throw dataspaceException;
                        throw exception;
                    }
                    try {
                        if (statement == null) throw exception;
                        SLResponse dataspaceException = DataspaceLexiconProcessor.buildResponse(dataspaceSDSSession, dataspaceSDSSession.executeCompiledStatement(statement, new Object[0]), session);
                    }
                    catch (DataspaceException dataspaceException) {
                        throw dataspaceException;
                    }
                    catch (Exception error) {
                        throw exception;
                    }
                    return dataspaceException;
                }
                finally {
                    if (lexiconProcessorSet) {
                        SysFunctionUnit.AbstractGetQueryEntry.resetServiceLexiconProcessor();
                    }
                }
            }
        }
    }

    @Override
    public DSLCompletion completeDsl(String command, MFSession session) {
        DSLCompletion completion = null;
        completion = session instanceof RuntimeMFSession ? super.completeDsl(command, session) : this.doCompleteDsl(command, session, this.baseProvider);
        if (session instanceof AbstractRuntimeServiceMFSession) {
            completion = CompoundCompleter.mergeCompletions(command, completion, DataspaceLexiconProcessor.completeDslForRuntime(command, session));
            DataspaceSLOperation dataspaceSLOperation = DataspaceLexiconProcessor.lookupOperationForRuntimeByQuery(command, session, true);
            if ((dataspaceSLOperation == null || dataspaceSLOperation.isAvailableInRuntime()) && ((AbstractRuntimeServiceMFSession)session).getDataspaceSDSSession() != null) {
                completion = CompoundCompleter.mergeCompletions(command, completion, ((AbstractRuntimeServiceMFSession)session).getDataspaceSDSSession().complete(command));
            }
        }
        return completion;
    }

    @Override
    public Operation<?> getForeignOperation(String operationName, MFSession session) {
        return DataspaceLexiconProcessor.lookupOperationForRuntimeByQuery(operationName, session, false);
    }

    @Override
    public Set<String> listForeignOperations(MFSession session, String pattern) {
        return session != null && session.isDiagnostic() ? null : DataspaceLexiconProcessor.listRuntimeOperations(pattern, session);
    }

    @Override
    public Set<String> listForeignOperationsByTag(String tag, MFSession session) {
        return DataspaceLexiconProcessor.listRuntimeOperationsByTag(tag, session);
    }

    @Override
    public Set<String> listForeignTags(MFSession session) {
        return DataspaceLexiconProcessor.listRuntimeOperationTags();
    }

    @Override
    public Operation<?> getExportableOperation(String operationName, MFSession session) {
        return this.runtimeProvider.getVisibleOperation(operationName, session);
    }

    @Override
    public Set<String> listExportableOperations(MFSession session, String pattern) {
        return this.runtimeProvider.listExportableOperations(session, pattern);
    }

    @Override
    public Set<String> listExportableOperationsByTag(String tag, MFSession session) {
        return this.runtimeProvider.listExportableOperationsByTag(tag, session);
    }

    @Override
    public Set<String> listExportableTags(MFSession session) {
        return this.runtimeProvider.listExportableTags(session);
    }

    private static class RuntimeSystemHelpOperation
    extends SystemHelpOperation {
        private RuntimeSystemHelpOperation() {
        }

        @Override
        protected HelpSLResponse createSLResponse(Set<String> contextOperations) {
            return new RuntimeHelpSLResponse(contextOperations);
        }

        @Override
        protected HelpSLResponse createSLResponse(Set<String> contextOperations, Set<String> foreignOperations) {
            return new RuntimeHelpSLResponse(contextOperations, foreignOperations);
        }

        @Override
        protected HelpSLResponse createSLResponse(Set<String> contextOperations, Set<String> foreignOperations, Set<String> sessionOperations) {
            return new RuntimeHelpSLResponse(contextOperations, foreignOperations, sessionOperations);
        }

        @Override
        protected Operation getOperation(HelpOperation.Definition definition, MFSession session) throws Exception {
            Operation result = super.getOperation(definition, session);
            if (result instanceof DataspaceSLOperation && !((DataspaceSLOperation)result).isAvailableInRuntime()) {
                throw new Exception("Dataspace operation '" + result.getName() + "' not available in Runtime context.");
            }
            return result;
        }
    }
}

