/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime;

import com.streamscape.lib.utils.ClassUtils;
import com.streamscape.repository.object.ReferenceContext;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.runtime.mf.admin.obj.ObjectConfigurationException;
import com.streamscape.runtime.mf.admin.obj.SemanticObjectReferenceStore;
import com.streamscape.sdo.AbstractDatagramFactoryManager;
import com.streamscape.sdo.AbstractDatagramPrototypeFactory;
import com.streamscape.sdo.IAbstractDatagramFactory;
import com.streamscape.sdo.mf.admin.DatagramFactory;
import com.streamscape.sdo.mf.admin.DatagramFactoryException;
import com.streamscape.sdo.mf.admin.DatagramFactoryManagerException;
import java.util.Collections;
import java.util.List;

class RuntimeDatagramFactoryManager
extends AbstractDatagramFactoryManager {
    RuntimeDatagramFactoryManager(RuntimeContext context, AbstractDatagramPrototypeFactory prototypeFactory) throws Exception {
        super(context, prototypeFactory);
        this.createReferenceContext("/sys/datagram/factory", "factory reference context");
        this.createReferenceContext("/sys/datagram/prototype", "datagram prototype cache");
        this.addFactories();
        this.logDebug("Datagram Factory Manager initialized.");
    }

    @Override
    protected void doInitDatagramFactory(IAbstractDatagramFactory factory) throws DatagramFactoryException {
        super.doInitDatagramFactory(factory);
        this.initFactoryInstance(factory);
    }

    protected void createReferenceContext(String namespace, String debugMessage) throws ObjectConfigurationException {
        if (SemanticObjectReferenceStore.lookupReferenceContext(namespace) == null) {
            this.logDebug("Creating " + debugMessage + "...");
            SemanticObjectReferenceStore.beginXact();
            SemanticObjectReferenceStore.createSubcontextFromNamespace(namespace);
            SemanticObjectReferenceStore.commitXact();
        }
    }

    @Override
    protected void registerDatagramFactory(IAbstractDatagramFactory factory) throws DatagramFactoryManagerException {
        if (!this.isDatagramFactoryRegistered(factory.getName())) {
            this.doRegisterDatagramFactory(factory);
        }
        this.validateDatagramFactory(factory, this.loadDatagramFactory(factory.getName()));
    }

    protected void validateDatagramFactory(IAbstractDatagramFactory factory, DatagramFactory registeredFactory) throws DatagramFactoryManagerException {
        this.logDebug("Validating datagram factory version for '" + factory.getName() + "'...");
        if (factory.getSerialVersionUID() != registeredFactory.getSerialVersionUID()) {
            this.logDebug("Warning: Serial Version mismatch for factory '" + factory.getName() + "'. Synchronizing...");
            this.clearDatagramFactory(factory);
            this.doRegisterDatagramFactory(factory);
        }
    }

    protected void clearDatagramFactory(IAbstractDatagramFactory factory) throws DatagramFactoryManagerException {
        this.logDebug("Clearing datagram factory '" + factory.getName() + "'...");
        try {
            this.removeSystemPrototypes(factory);
        }
        catch (Exception exception) {
            throw new DatagramFactoryManagerException(5002, (Throwable)exception);
        }
        this.removePrototypesFromCache(factory);
        this.removeFactoryContext(factory.getName());
        this.logDebug("Datagram factory '" + factory.getName() + "' cleared.");
    }

    protected DatagramFactory getDatagramFactoryInstance(Class factoryClass) throws DatagramFactoryManagerException {
        this.checkFactoryClass(factoryClass);
        try {
            return (DatagramFactory)ClassUtils.invokeMethod(factoryClass, factoryClass.getDeclaredMethod("getInstance", new Class[0]), null);
        }
        catch (Exception exception) {
            throw new DatagramFactoryManagerException(5071, (Throwable)exception);
        }
    }

    public void registerDatagramFactory(Class factoryClass) throws DatagramFactoryManagerException {
        this.checkFactoryClass(factoryClass);
        this.logDebug("Registering datagram factory class '" + factoryClass.getName() + "'...");
        DatagramFactory factory = this.getDatagramFactory(factoryClass);
        if (this.isDatagramFactoryRegistered(factory.getName())) {
            throw new DatagramFactoryManagerException(5067, "Datagram Factory '" + factory.getName() + "' already registered.");
        }
        this.doRegisterDatagramFactory(factory);
    }

    protected void doRegisterDatagramFactory(DatagramFactory factory) throws DatagramFactoryManagerException {
        this.logDebug("Registering datagram factory '" + factory.getName() + "'...");
        try {
            SemanticObjectReferenceStore.beginXact();
            SemanticObjectReferenceStore.setReferenceContext(SemanticObjectReferenceStore.lookupReferenceContext("/sys/datagram/factory"));
            SemanticObjectReferenceStore.bind(factory.getName(), factory);
            SemanticObjectReferenceStore.commitXact();
        }
        catch (Exception exception) {
            throw new DatagramFactoryManagerException(5073, (Throwable)exception);
        }
        this.logDebug("Datagram factory '" + factory.getName() + "' registered.");
    }

    public void unregisterDatagramFactory(String factoryName) throws DatagramFactoryManagerException {
        this.logDebug("Un-registering datagram factory '" + factoryName + "'...");
        if (factoryName == null) {
            throw new DatagramFactoryManagerException(5004, "Datagram factory name is null.");
        }
        if (!this.isDatagramFactoryRegistered(factoryName)) {
            throw new DatagramFactoryManagerException(5068, "Datagram factory '" + factoryName + "' is not registered.");
        }
        try {
            DatagramFactory factory = (DatagramFactory)this.factories.remove(factoryName);
            if (factory == null) {
                factory = this.loadDatagramFactory(factoryName);
                factory = this.getDatagramFactoryInstance(factory.getClass());
            }
            for (String eventId : this.context.getDatagramPrototypeCache().listEventIdsByAncestor(factory.getAncestorType())) {
                this.context.getDatagramPrototypeFactory().removePrototype(eventId);
            }
            SemanticObjectReferenceStore.beginXact();
            SemanticObjectReferenceStore.destroySubcontext(SemanticObjectReferenceStore.lookupReferenceContext(factory.getPrototypeNamespace()));
            SemanticObjectReferenceStore.commitXact();
            this.removeFactoryContext(factoryName);
            this.logDebug("Datagram factory '" + factoryName + "' unregistered.");
        }
        catch (Exception exception) {
            throw new DatagramFactoryManagerException(5074, (Throwable)exception);
        }
    }

    protected void removeFactoryContext(String factoryName) throws DatagramFactoryManagerException {
        try {
            SemanticObjectReferenceStore.beginXact();
            SemanticObjectReferenceStore.setReferenceContext(SemanticObjectReferenceStore.lookupReferenceContext("/sys/datagram/factory"));
            if (SemanticObjectReferenceStore.existsBinding(factoryName)) {
                SemanticObjectReferenceStore.unbind(factoryName);
            }
            SemanticObjectReferenceStore.commitXact();
        }
        catch (Exception exception) {
            throw new DatagramFactoryManagerException(5002, (Throwable)exception);
        }
    }

    public boolean isDatagramFactoryRegistered(String factoryName) throws DatagramFactoryManagerException {
        boolean registered = false;
        try {
            SemanticObjectReferenceStore.beginXact();
            ReferenceContext ref = SemanticObjectReferenceStore.lookupReferenceContext("/sys/datagram/factory");
            SemanticObjectReferenceStore.setReferenceContext(ref);
            if (SemanticObjectReferenceStore.existsBinding(factoryName)) {
                registered = true;
            }
            SemanticObjectReferenceStore.commitXact();
        }
        catch (Exception exception) {
            throw new DatagramFactoryManagerException(4002, (Throwable)exception);
        }
        return registered;
    }

    protected DatagramFactory loadDatagramFactory(String factoryName) throws DatagramFactoryManagerException {
        this.logDebug("Loading datagram factory '" + factoryName + "'...");
        try {
            SemanticObjectReferenceStore.beginXact();
            SemanticObjectReferenceStore.setReferenceContext(SemanticObjectReferenceStore.lookupReferenceContext("/sys/datagram/factory"));
            DatagramFactory factory = (DatagramFactory)SemanticObjectReferenceStore.lookup(factoryName);
            SemanticObjectReferenceStore.commitXact();
            return factory;
        }
        catch (Exception exception) {
            throw new DatagramFactoryManagerException(4002, (Throwable)exception);
        }
    }

    public List<String> listRegisteredFactories() throws DatagramFactoryManagerException {
        try {
            SemanticObjectReferenceStore.beginXact();
            SemanticObjectReferenceStore.setReferenceContext(SemanticObjectReferenceStore.lookupReferenceContext("/sys/datagram/factory"));
            List<String> names = SemanticObjectReferenceStore.listBoundNames(null);
            SemanticObjectReferenceStore.commitXact();
            Collections.sort(names);
            return names;
        }
        catch (ObjectConfigurationException exception) {
            throw new DatagramFactoryManagerException(4002, (Throwable)exception);
        }
    }
}

