/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime;

import com.streamscape.Logger;
import com.streamscape.Trace;
import com.streamscape.Version;
import com.streamscape.cli.ClientState;
import com.streamscape.cli.tlp.PingResult;
import com.streamscape.cli.tlp.PingState;
import com.streamscape.ds.DataspaceLogger;
import com.streamscape.lib.analyzer.TypeAnalyzerFactory;
import com.streamscape.lib.concurrent.worker.SingleTaskWorker;
import com.streamscape.lib.loader.ClassLoaderRegistry;
import com.streamscape.lib.loader.PackageLoaderRegistry;
import com.streamscape.lib.utils.Banner;
import com.streamscape.lib.utils.FileIOUtils;
import com.streamscape.lib.utils.JARUtils;
import com.streamscape.lib.utils.StringUtils;
import com.streamscape.lib.utils.Utils;
import com.streamscape.omf.java.JSerializer;
import com.streamscape.omf.java.JSerializerFactory;
import com.streamscape.omf.json.JSONSerializerFactory;
import com.streamscape.omf.json.jackson.JSONSerializer;
import com.streamscape.omf.mapper.mf.ConverterPluginManager;
import com.streamscape.omf.mf.admin.ObjectMediationFactoryManager;
import com.streamscape.omf.serializer.AliasManager;
import com.streamscape.omf.xml.XSerializer;
import com.streamscape.omf.xml.XSerializerFactory;
import com.streamscape.repository.RepositoryContextFactory;
import com.streamscape.repository.cli.RepositoryAccessor;
import com.streamscape.runtime.ConfigurationState;
import com.streamscape.runtime.Context;
import com.streamscape.runtime.ContextId;
import com.streamscape.runtime.ExpirationTimer;
import com.streamscape.runtime.PeerState;
import com.streamscape.runtime.RuntimeContextException;
import com.streamscape.runtime.RuntimeConverterManager;
import com.streamscape.runtime.RuntimeDatagramFactoryManager;
import com.streamscape.runtime.RuntimeDataspaceManager;
import com.streamscape.runtime.RuntimeEIMPluginManager;
import com.streamscape.runtime.RuntimeLexiconManager;
import com.streamscape.runtime.RuntimeLexiconProcessor;
import com.streamscape.runtime.RuntimeManifestManager;
import com.streamscape.runtime.RuntimeOMFManager;
import com.streamscape.runtime.RuntimeSessionManager;
import com.streamscape.runtime.RuntimeState;
import com.streamscape.runtime.ShutdownController;
import com.streamscape.runtime.ShutdownHandler;
import com.streamscape.runtime.ShutdownListener;
import com.streamscape.runtime.deploy.CtxDeploymentDescriptor;
import com.streamscape.runtime.deploy.DeployUtils;
import com.streamscape.runtime.deploy.DeploymentDescriptor;
import com.streamscape.runtime.listeners.RuntimeAdvisoryListener;
import com.streamscape.runtime.mf.admin.cfo.ClientConfigurationFactory;
import com.streamscape.runtime.mf.admin.dfo.JDBCConfigurationFactory;
import com.streamscape.runtime.mf.admin.glv.GlobalVariableFactory;
import com.streamscape.runtime.mf.admin.obj.SemanticObjectReferenceStore;
import com.streamscape.runtime.mf.admin.pkg.PackageStore;
import com.streamscape.runtime.mf.admin.sco.ServiceConfigurationFactory;
import com.streamscape.runtime.mf.admin.tfo.TransportConfigurationFactory;
import com.streamscape.runtime.stats.StatsMonitor;
import com.streamscape.runtime.stats.SystemEnvironment;
import com.streamscape.sdo.AbstractDatagramFactoryManager;
import com.streamscape.sdo.AnnotationManager;
import com.streamscape.sdo.advisory.AdvisoryDatagramFactory;
import com.streamscape.sdo.advisory.RuntimeAdvisory;
import com.streamscape.sdo.enums.Severity;
import com.streamscape.sdo.event.EventDatagramFactory;
import com.streamscape.sdo.event.OpaqueDatagramFactory;
import com.streamscape.sdo.excp.ExceptionDatagramFactory;
import com.streamscape.sdo.mf.admin.DatagramFactoryManager;
import com.streamscape.sdo.mf.admin.DatagramPrototypeCache;
import com.streamscape.sdo.mf.admin.DatagramPrototypeFactory;
import com.streamscape.sdo.mf.admin.SDRManagerFactory;
import com.streamscape.sdo.mf.admin.SemanticTypeCache;
import com.streamscape.sdo.mf.admin.SemanticTypeFactory;
import com.streamscape.sef.FabricComponent;
import com.streamscape.sef.FabricException;
import com.streamscape.sef.FabricManagedComponent;
import com.streamscape.sef.container.ContainerLockSupport;
import com.streamscape.sef.container.FabricContainer;
import com.streamscape.sef.dataspace.DataspaceManager;
import com.streamscape.sef.discovery.DiscoveryModule;
import com.streamscape.sef.discovery.DiscoveryModuleFactory;
import com.streamscape.sef.dispatcher.AbstractOMFManager;
import com.streamscape.sef.dispatcher.AbstractRuntimeContext;
import com.streamscape.sef.dispatcher.ReservedNames;
import com.streamscape.sef.dropbox.DropBoxManager;
import com.streamscape.sef.dropbox.DropBoxManagerImpl;
import com.streamscape.sef.dropbox.DropBoxManagerRemoteImpl;
import com.streamscape.sef.enums.ComponentModel;
import com.streamscape.sef.enums.EventScope;
import com.streamscape.sef.exchange.FabricExchange;
import com.streamscape.sef.group.FabricGroupManager;
import com.streamscape.sef.mf.admin.FabricContext;
import com.streamscape.sef.moderator.FabricNodeRole;
import com.streamscape.sef.moderator.Moderator;
import com.streamscape.sef.network.LinkAddress;
import com.streamscape.sef.network.http.acceptor.HTTPAcceptorFactory;
import com.streamscape.sef.network.http.server.authentication.runtime.HTTPAuthenticationManager;
import com.streamscape.sef.network.http.server.authentication.runtime.HTTPAuthenticationManagerCoreImpl;
import com.streamscape.sef.network.http.server.authentication.runtime.HTTPAuthenticationManagerImpl;
import com.streamscape.sef.network.mf.admin.AcceptorFactoryManager;
import com.streamscape.sef.network.mf.admin.AcceptorFactoryManagerException;
import com.streamscape.sef.network.tlp.acceptor.TLPAcceptorFactory;
import com.streamscape.sef.scheduler.Scheduler;
import com.streamscape.sef.security.AuthenticationModuleFactory;
import com.streamscape.sef.security.SecurityManager;
import com.streamscape.sef.security.SecurityManagerException;
import com.streamscape.sef.service.ServiceContext;
import com.streamscape.sef.service.ServiceManager;
import com.streamscape.service.osf.Service;
import com.streamscape.service.osf.eim.mf.EventIdentityPluginManager;
import com.streamscape.slex.DSLComponent;
import com.streamscape.slex.SemanticLexiconManager;
import com.streamscape.slex.SemanticLexiconProcessor;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.file.FileSystems;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.StringTokenizer;
import java.util.TimeZone;
import java.util.UUID;
import java.util.jar.JarFile;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class RuntimeContext
extends AbstractRuntimeContext
implements FabricComponent,
FabricContext,
DSLComponent<RuntimeContext> {
    protected static RuntimeContext instance = null;
    protected static boolean initialized = false;
    private static boolean printBanner = true;
    private ConfigurationState configurationState = ConfigurationState.OK;
    private boolean unloadInProgress = false;
    private int runLevel = 0;
    private ExpirationTimer expirationTimer = null;
    private HashMap<String, Object> repoParameters = new HashMap();
    private RuntimeEIMPluginManager eimManager = null;
    private RuntimeConverterManager converterManager = null;
    private AcceptorFactoryManager accManager = null;
    private RuntimeLexiconManager lexiconManager = new RuntimeLexiconManager();
    private RuntimeLexiconProcessor lexiconProcessor = null;
    private ShutdownController shutdownController = null;
    private ShutdownListener shutdownListener = null;
    private boolean isStandalone = true;
    private boolean isClustered = false;
    public ClientConfigurationFactory ClientConfigurationFactory = null;
    public JDBCConfigurationFactory JDBCConfigurationFactory = null;
    public TransportConfigurationFactory TransportConfigurationFactory = null;
    public ServiceConfigurationFactory ServiceConfigurationFactory = null;
    public SemanticObjectReferenceStore ObjectReferenceStore = null;
    public PackageStore RuntimePackageStore = null;
    private DropBoxManager dropBoxManager = null;
    private DropBoxManagerRemoteImpl dropBoxManagerRemote = null;
    public static final long DEFAULT_SHUTDOWN_TIMEOUT = 10L;
    public static final String STROOT = "streamscape.install.root";
    public static final String STARTUP_DIR = "streamscape.runtime.startup.dir";
    public static final String NAME = "streamscape.runtime.context.name";
    public static final String CLUSTER = "streamscape.runtime.cluster";
    public static final String DEPLOYMENT = "streamscape.runtime.deployment.dir";
    public static final String AUTO_UNLOAD = "streamscape.runtime.unload.on.last.unbind";
    public static final String AUTOBIND_DATASPACE = "streamscape.dataspace.auto.bind";
    public static final String AUTOBIND_COHERENCE = "streamscape.coherence.auto.bind";
    public static final String PRESENTITY_KEY = "streamscape.runtime.enable.persistent.entity";
    public static final String SECURITY_ENABLED_KEY = "streamscape.runtime.enable.security";
    public static final String SEPARATOR = FileSystems.getDefault().getSeparator();
    public static final String STRUNTIME_ACTIVE_KEY = "struntime.active";
    public static final String STRUNTIME_INITIALIZED = "struntime.initialized";
    public static final String STRUNTIME_INITIALIZING = "struntime.initializing";
    public static final String STRUNTIME_NOT_INITIALIZED = "struntime.not.initialized";
    private String ST_ROOT = System.getenv("STROOT");
    private String CLUSTER_NAME = System.getProperty("streamscape.runtime.cluster");
    private String CDX = System.getProperty("streamscape.runtime.deployment.dir");
    private String UNLOAD_ON_LAST_UNBIND = System.getProperty("streamscape.runtime.unload.on.last.unbind");
    private String INITIAL_CONTEXT_FACTORY = System.getProperty("streamscape.naming.factory.initial");
    private String BATCHSIZE = System.getProperty("streamscape.naming.batchsize");
    private String PROVIDER_URL = System.getProperty("streamscape.naming.provider.url");
    private String PROVIDER_JAR = System.getProperty("streamscape.repository.provider.jar");
    private String SECURITY_PRINCIPAL = System.getProperty("streamscape.naming.security.principal");
    private String SECURITY_CREDENTIALS = System.getProperty("streamscape.naming.security.credentials");
    private String AUTHENTICATION_MODULE = System.getProperty("streamscape.repository.authentication.module");
    private String CONNECTION_RETRY = System.getProperty("streamscape.repository.connection.retry");
    private String CONNECTION_TIMEOUT = System.getProperty("streamscape.repository.connection.timeout");
    private String IO_TIMEOUT = System.getProperty("streamscape.repository.io.timeout");
    private String DISCOVERY_PROTOCOL = System.getProperty("streamscape.repository.discovery.protocol");
    private String REPO_AUTO_BIND = System.getProperty("streamscape.repository.auto.bind");
    private String DATASPACE_AUTO_BIND = System.getProperty("streamscape.dataspace.auto.bind");
    private String COHERENCE_AUTO_BIND = System.getProperty("streamscape.coherence.auto.bind");
    private String CACHE_FORCE_LOCK = System.getProperty("streamscape.runtime.cache.forcelock");
    private String CTX_TIMEOUT = System.getProperty("streamscape.repository.tx.timeout");
    private String REFERRAL = System.getProperty("streamscape.naming.referral");
    private String PRESENTITY = System.getProperty("streamscape.runtime.enable.persistent.entity");
    private String SECURITY_ENABLED = System.getProperty("streamscape.runtime.enable.security");
    private String REPO_PARAMETERS = System.getProperty("streamscape.repository.parameters");
    private static final String DDX_JAR_NAME = FileSystems.getDefault().getSeparator() + "stdeploy.jar";

    public static void setInitMode(boolean initMode) {
        RuntimeContext.initMode = initMode;
    }

    public static void setMaintainMode(boolean maintainMode) {
        RuntimeContext.maintainMode = maintainMode;
    }

    public static void setNoTlpMode(boolean noTlpMode) {
        RuntimeContext.noTlpMode = noTlpMode;
    }

    public static void setNoJoinMode(boolean noJoinMode) {
        RuntimeContext.noJoinMode = noJoinMode;
    }

    public static void setAdminMode(boolean adminMode, String adminURL) {
        RuntimeContext.adminMode = adminMode;
        RuntimeContext.adminURL = adminURL;
    }

    public static void setPrintBanner(boolean printBanner) {
        RuntimeContext.printBanner = printBanner;
    }

    public static void setDefaultServiceLogger(Logger defaultServiceLogger) {
        RuntimeContext.defaultServiceLogger = defaultServiceLogger;
    }

    public static void setDefaultDataspaceLogger(DataspaceLogger defaultDataspaceLogger) {
        RuntimeContext.defaultDataspaceLogger = defaultDataspaceLogger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected RuntimeContext() {
        String string = STRUNTIME_ACTIVE_KEY;
        synchronized (STRUNTIME_ACTIVE_KEY) {
            if (STRUNTIME_INITIALIZED.equalsIgnoreCase(System.getProperty(STRUNTIME_ACTIVE_KEY))) {
                throw new RuntimeException("Runtime Context already initialized in current JVM.");
            }
            if (STRUNTIME_INITIALIZING.equalsIgnoreCase(System.getProperty(STRUNTIME_ACTIVE_KEY))) {
                throw new RuntimeException("Runtime Context is already being initialized in current JVM.");
            }
            System.setProperty(STRUNTIME_ACTIVE_KEY, STRUNTIME_INITIALIZING);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            try {
                if (ClientState.isActive()) {
                    throw new RuntimeException("Runtime Context failed to initialize. Active Client Context detected.");
                }
                RuntimeState.setState(true);
                this.initFabricContextFactory();
                this.initRunLevel0();
                this.initRunLevel1();
                this.initRunLevel2();
                this.initRunLevel3();
                this.initRunLevel4();
                this.printVariousInfo();
                initialized = true;
                string = STRUNTIME_ACTIVE_KEY;
            }
            catch (Throwable throwable) {
                String string2 = STRUNTIME_ACTIVE_KEY;
                synchronized (STRUNTIME_ACTIVE_KEY) {
                    System.setProperty(STRUNTIME_ACTIVE_KEY, initialized ? STRUNTIME_INITIALIZED : STRUNTIME_NOT_INITIALIZED);
                    // ** MonitorExit[var5_5] (shouldn't be in output)
                    throw throwable;
                }
            }
            synchronized (STRUNTIME_ACTIVE_KEY) {
                System.setProperty(STRUNTIME_ACTIVE_KEY, initialized ? STRUNTIME_INITIALIZED : STRUNTIME_NOT_INITIALIZED);
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
        }
    }

    private void printVariousInfo() {
        this.printAllClassPaths();
        if (printBanner) {
            Banner.printBanner(System.out);
        }
        if (Trace.isEnabled(this.getClass().getName())) {
            this.printEnvironment();
        }
    }

    private void printAllClassPaths() {
        try {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            this.manifestManager.getLoaderRegistry().printAllClassPaths(new PrintStream(outputStream, true));
            outputStream.close();
            Trace.logDebug(PackageLoaderRegistry.class, outputStream.toString());
        }
        catch (Exception exception) {
            this.logException(exception, false);
        }
    }

    public int getRunLevel() {
        return this.runLevel;
    }

    public int getInitLevel() {
        return this.initLevel;
    }

    private void putToEnvironment(String key, String value) {
        if (value != null && !value.isEmpty()) {
            this.environment.put(key, value);
        }
    }

    public ConfigurationState getConfigurationState() {
        return this.configurationState;
    }

    public synchronized void setConfigurationState(ConfigurationState configurationState) {
        this.configurationState = configurationState;
    }

    private void initRunLevel0() {
        this.logInfo("------------------------------------------------");
        this.logInfo("Runtime Context Initializing... Run Level 0.");
        this.logInfo("------------------------------------------------");
        this.initPackageManifestManager();
        this.initSemanticTypeFactory();
        this.initOMFManager();
        this.initDeploymentDescriptor();
        this.initExpirationTimer();
        this.initSTRoot();
        this.initEnvironment();
        this.initSystemSemanticTypes();
        this.runLevel = 0;
        this.logInfo("------------------------------------------------");
        this.logInfo("Runtime Context Initialized. Run Level 0. OK");
        this.logInfo("------------------------------------------------");
    }

    private void initDeploymentDescriptor() {
        try {
            this.ctxDescriptorFilename = this.findDeploymentDescriptor();
            this.logInfo("Deployment Descriptor Archive: " + this.ctxDescriptorFilename + ".");
        }
        catch (Throwable exception) {
            this.processInitDDXException(exception, -1002);
        }
        try {
            this.ctxDescriptor = DeployUtils.getDeploymentDescriptor(this.ctxDescriptorFilename, this.xSerializer);
        }
        catch (Throwable exception) {
            this.processInitDDXException(exception, -1003);
        }
        if (this.ctxDescriptor.getContextType().equals((Object)Context.CTX_APPLICATION)) {
            this.logInfo("Runtime Context type is Application.");
        } else if (this.ctxDescriptor.getContextType().equals((Object)Context.CTX_EX_CONTAINER)) {
            this.logInfo("Runtime Context type is External Container.");
        } else if (this.ctxDescriptor.getContextType().equals((Object)Context.CTX_TF_CONTAINER)) {
            this.logInfo("Runtime Context type is Service Event Fabric Container.");
        } else {
            this.processInitDDXError("Unsupported Context Type '" + String.valueOf((Object)this.ctxDescriptor.getContextType()) + "'.", -1004);
        }
        this.logInfo("Deployment Descriptor Vendor: " + this.ctxDescriptor.getVendorString() + ".");
        if (this.ctxDescriptor.getContextName() == null || this.ctxDescriptor.getContextName().isEmpty()) {
            this.processInitDDXError("Context Name is empty or null.", -1005);
        }
        if (!this.ctxDescriptor.isContainerValid()) {
            this.processInitDDXError("Container class '" + this.ctxDescriptor.getContainerClass() + "' not found.", -1006);
        }
        this.logDebug("Container class '" + this.ctxDescriptor.getContainerClass() + "'.");
    }

    private void processInitDDXException(Throwable exception, int errorCode) {
        this.processInitException(exception, "Deployment Descriptor", errorCode);
    }

    private void processInitDDXError(String errorMessage, int errorCode) {
        this.processInitDDXException(new RuntimeContextException(errorMessage), errorCode);
    }

    private String findDeploymentDescriptor() throws Exception {
        if (this.CDX != null) {
            String result = this.CDX + DDX_JAR_NAME;
            if (FileIOUtils.fileAvailable(result)) {
                this.logInfo("Runtime deployment descriptor set by JVM parameter.");
                return result;
            }
        } else {
            for (String loadedJar : JARUtils.getClassPath()) {
                if (loadedJar.toLowerCase().endsWith(DDX_JAR_NAME)) {
                    return loadedJar;
                }
                File jarFile = new File(loadedJar);
                if (!jarFile.isFile()) continue;
                try (JarFile jar = new JarFile(jarFile);){
                    if (jar.getEntry("/rtcontext.cdx") == null) continue;
                    String string = loadedJar;
                    return string;
                }
            }
        }
        throw new RuntimeContextException("Deployment archive not found.");
    }

    private void initSTRoot() {
        if (this.ctxDescriptor.getSTRoot() != null) {
            this.ST_ROOT = this.ctxDescriptor.getSTRoot();
            if (!new File(this.ST_ROOT).exists()) {
                this.logInfo("WARNING: STROOT of Deployment Descriptor is invalid: path does not exist.");
                String STROOT_ENV = System.getenv("STROOT");
                if (STROOT_ENV != null && new File(STROOT_ENV).exists()) {
                    this.logInfo("Environment variable STROOT is used.");
                    this.ST_ROOT = STROOT_ENV;
                }
            }
        }
        if (this.ST_ROOT == null) {
            this.processInitError("Variable STROOT is undefined.", "Environment", -1007);
        }
        this.environment.put(STROOT, this.ST_ROOT);
    }

    private void initEnvironment() {
        String repositoryIoTimeout;
        this.environment.put("streamscape.naming.factory.initial", this.ctxDescriptor.getInitialContextFactory());
        this.environment.put("streamscape.naming.batchsize", this.ctxDescriptor.getBatchSize());
        this.environment.put("streamscape.naming.provider.url", this.ctxDescriptor.getProviderURL());
        this.environment.put("streamscape.repository.provider.jar", this.ctxDescriptor.getProviderArchive());
        this.environment.put("streamscape.naming.security.principal", this.ctxDescriptor.getSecurityPrincipal());
        this.environment.put("streamscape.naming.security.credentials", this.ctxDescriptor.getSecurityCredentials());
        this.environment.put("streamscape.repository.authentication.module", this.ctxDescriptor.getAuthenticationModule());
        this.environment.put("streamscape.repository.connection.retry", this.ctxDescriptor.getConnectionRetry());
        this.environment.put("streamscape.repository.connection.timeout", this.ctxDescriptor.getConnectionTimeout());
        this.environment.put("streamscape.repository.io.timeout", this.ctxDescriptor.getIOTimeout());
        this.environment.put("streamscape.repository.discovery.protocol", this.ctxDescriptor.getDiscoveryProtocol());
        this.environment.put("streamscape.repository.auto.bind", this.ctxDescriptor.isRepositoryAutoBind());
        this.environment.put("streamscape.repository.tx.timeout", Long.parseLong(this.ctxDescriptor.getContextTimeout()));
        this.environment.put("streamscape.naming.referral", this.ctxDescriptor.getReferral());
        this.environment.put(NAME, this.ctxDescriptor.getContextName());
        this.environment.put(AUTOBIND_DATASPACE, this.ctxDescriptor.isDataspaceAutoBind());
        this.environment.put(AUTOBIND_COHERENCE, this.ctxDescriptor.isCoherenceAutoBind());
        this.environment.put("streamscape.runtime.cache.forcelock", this.ctxDescriptor.isRuntimeCacheForceLock());
        this.environment.put(AUTO_UNLOAD, this.ctxDescriptor.isRuntimeContextAutoUnload());
        this.environment.put(PRESENTITY_KEY, this.ctxDescriptor.isPresence());
        this.environment.put(SECURITY_ENABLED_KEY, this.ctxDescriptor.isSecurityEnabled());
        this.environment.put(CLUSTER, this.ctxDescriptor.getClusterName());
        if (this.CDX != null) {
            this.environment.put(DEPLOYMENT, this.CDX);
        }
        if (this.INITIAL_CONTEXT_FACTORY != null) {
            this.environment.put("streamscape.naming.factory.initial", this.INITIAL_CONTEXT_FACTORY);
        }
        if (this.BATCHSIZE != null) {
            this.environment.put("streamscape.naming.batchsize", this.BATCHSIZE);
        }
        if (this.PROVIDER_URL != null) {
            this.environment.put("streamscape.naming.provider.url", this.PROVIDER_URL);
        }
        if (this.PROVIDER_JAR != null) {
            this.environment.put("streamscape.repository.provider.jar", this.PROVIDER_JAR);
        }
        if (this.SECURITY_PRINCIPAL != null) {
            this.environment.put("streamscape.naming.security.principal", this.SECURITY_PRINCIPAL);
        }
        if (this.SECURITY_CREDENTIALS != null) {
            this.environment.put("streamscape.naming.security.credentials", this.SECURITY_CREDENTIALS);
        }
        if (this.AUTHENTICATION_MODULE != null) {
            this.environment.put("streamscape.repository.authentication.module", this.AUTHENTICATION_MODULE);
        }
        if (this.CONNECTION_RETRY != null) {
            this.environment.put("streamscape.repository.connection.retry", this.CONNECTION_RETRY);
        }
        if (this.CONNECTION_TIMEOUT != null) {
            this.environment.put("streamscape.repository.connection.timeout", this.CONNECTION_TIMEOUT);
        }
        if (this.IO_TIMEOUT != null) {
            this.environment.put("streamscape.repository.io.timeout", this.IO_TIMEOUT);
        }
        if (this.DISCOVERY_PROTOCOL != null) {
            this.environment.put("streamscape.repository.discovery.protocol", this.DISCOVERY_PROTOCOL);
        }
        if (this.REPO_AUTO_BIND != null) {
            this.environment.put("streamscape.repository.auto.bind", Boolean.valueOf(this.REPO_AUTO_BIND));
        }
        if (this.CTX_TIMEOUT != null) {
            this.environment.put("streamscape.repository.tx.timeout", Long.parseLong(this.CTX_TIMEOUT));
        }
        if (this.REFERRAL != null) {
            this.environment.put("streamscape.naming.referral", this.REFERRAL);
        }
        if (this.DATASPACE_AUTO_BIND != null) {
            this.environment.put(AUTOBIND_DATASPACE, Boolean.valueOf(this.DATASPACE_AUTO_BIND));
        }
        if (this.COHERENCE_AUTO_BIND != null) {
            this.environment.put(AUTOBIND_COHERENCE, Boolean.valueOf(this.COHERENCE_AUTO_BIND));
        }
        if (this.CACHE_FORCE_LOCK != null) {
            this.environment.put("streamscape.runtime.cache.forcelock", Boolean.valueOf(this.CACHE_FORCE_LOCK));
        }
        if (this.UNLOAD_ON_LAST_UNBIND != null) {
            this.environment.put(AUTO_UNLOAD, Boolean.valueOf(this.UNLOAD_ON_LAST_UNBIND));
        }
        if (this.PRESENTITY != null) {
            this.environment.put(PRESENTITY_KEY, Boolean.valueOf(this.PRESENTITY));
        }
        if (this.SECURITY_ENABLED != null) {
            this.environment.put(SECURITY_ENABLED_KEY, Boolean.valueOf(this.SECURITY_ENABLED));
        }
        if (this.PRESENTITY != null) {
            this.environment.put(PRESENTITY_KEY, Boolean.valueOf(this.PRESENTITY));
        }
        if (this.CLUSTER_NAME != null) {
            this.environment.put(CLUSTER, this.CLUSTER_NAME);
        }
        try {
            this.environment.put(STARTUP_DIR, RuntimeContext.getStartupDir(this.ctxDescriptor));
            this.logInfo("Startup directory: '" + this.getStartupDir() + "'.");
        }
        catch (IOException exception) {
            this.processInitError("Invalid startup directory '" + exception.getMessage() + "'.", "Environment", -1008);
        }
        this.name = (String)this.environment.get(NAME);
        if (!this.validateName(this.name)) {
            this.processInitError("Context name '" + this.name + "' has invalid format.", "Environment", -1009);
        }
        this.type = "RuntimeContext";
        this.model = ComponentModel.CTX_RUNTIME;
        this.eventScope = EventScope.GLOBAL;
        this.domain = (String)this.environment.get("streamscape.naming.referral");
        if (StringUtils.isEmpty(this.domain)) {
            this.processInitError("DOMAIN (REFERRAL) is undefined.", "Environment", -1010);
        }
        this.isClustered = this.ctxDescriptor.isClusterEnabled();
        if (this.isClustered && StringUtils.isEmpty(this.getClusterName())) {
            this.processInitError("Cluster is enabled, but CLUSTER_NAME is undefined.", "Environment", -1011);
        }
        this.isSecurityEnabled = (Boolean)this.environment.get(SECURITY_ENABLED_KEY);
        if (this.isPresenceEnabled() && !((Boolean)this.environment.get(AUTOBIND_DATASPACE)).booleanValue()) {
            this.processInitError("Incompatible parameters: PRESENCE = true and DSPACE_AUTO_BIND = false.", "Environment", -1012);
        }
        if (this.ctxDescriptor.getContextType().equals((Object)Context.CTX_TF_CONTAINER)) {
            this.logInfo("Runtime Context is Service Event Fabric Container. Caching disabled.");
            this.logInfo("Runtime Cache disabled..");
            this.logInfo("Persistence core auto-loaded..");
            this.logInfo("Dataspace core auto-loaded..");
        }
        if ((repositoryIoTimeout = (String)this.environment.get("streamscape.repository.io.timeout")) != null && !repositoryIoTimeout.isEmpty()) {
            this.addRepositoryParameter("IoThreadCycle", repositoryIoTimeout);
        }
        for (String parameterName : this.ctxDescriptor.getRepositoryParameters()) {
            String parameterValue = this.ctxDescriptor.getRepositoryParameter(parameterName);
            this.logDebug("Adding Repository Parameter from descriptor: " + parameterName + "=" + parameterValue + "...");
            this.addRepositoryParameter(parameterName, parameterValue);
        }
        if (this.REPO_PARAMETERS != null) {
            StringTokenizer tokenizer = new StringTokenizer(this.REPO_PARAMETERS, "&");
            while (tokenizer.hasMoreTokens()) {
                String[] parameters = tokenizer.nextToken().split("=");
                if (parameters.length != 2) continue;
                String parameterName = parameters[0];
                String parameterValue = parameters[1];
                this.logDebug("Adding JVM Repository Parameter: " + parameterName + "=" + parameterValue + "...");
                this.addRepositoryParameter(parameterName, parameterValue);
            }
        }
    }

    public static String getStartupDir(CtxDeploymentDescriptor deploymentDescriptor) throws IOException {
        String result = System.getProperty(STARTUP_DIR);
        if (result == null) {
            result = !StringUtils.isEmpty(deploymentDescriptor.getStartupDir()) ? deploymentDescriptor.getStartupDir() : ".";
        }
        try {
            File startupDir = new File(result).getCanonicalFile();
            if (!startupDir.exists() || !startupDir.isDirectory()) {
                throw new IOException();
            }
            return startupDir.getAbsolutePath();
        }
        catch (IOException exception) {
            throw new IOException(result);
        }
    }

    private boolean validateName(String name) {
        return name != null && !name.isEmpty() && IntStream.range(0, name.length()).noneMatch(i -> Character.isSpaceChar(name.charAt(i)));
    }

    private void addRepositoryParameter(String name, String value) {
        if (value.equalsIgnoreCase("true") || value.equalsIgnoreCase("false")) {
            this.repoParameters.put(name, Boolean.valueOf(value));
        } else if (value.endsWith("%L")) {
            this.repoParameters.put(name, new Long(value.substring(0, value.length() - 2)));
        } else if (value.endsWith("%I")) {
            this.repoParameters.put(name, new Integer(value.substring(0, value.length() - 2)));
        } else if (value.endsWith("%D")) {
            this.repoParameters.put(name, new Double(value.substring(0, value.length() - 2)));
        } else if (value.endsWith("%F")) {
            this.repoParameters.put(name, new Float(value.substring(0, value.length() - 2)));
        } else {
            this.repoParameters.put(name, value);
        }
    }

    private void initExpirationTimer() {
        if (this.ctxDescriptor.getLicenseTs() > 0L) {
            this.expirationTimer = new ExpirationTimer(this, this.ctxDescriptor.getLicenseTs());
            this.expirationTimer.check();
        }
    }

    private void startExpirationTimer() {
        if (this.expirationTimer != null) {
            this.expirationTimer.start();
            this.logInfo("Expiration Timer started.");
        }
    }

    private void destroyExpirationTimer() {
        try {
            if (this.expirationTimer != null) {
                this.expirationTimer.stop();
                this.expirationTimer = null;
                this.logInfo("Expiration Timer destroyed.");
            }
        }
        catch (Throwable exception) {
            this.logException(exception, true, "Destroying Expiration Timer failed.");
        }
    }

    private void initRunLevel1() {
        this.logInfo("------------------------------------------------");
        this.logInfo("Runtime Context Initializing... Run Level 1.");
        this.logInfo("------------------------------------------------");
        if (this.environment.get("streamscape.repository.auto.bind") != null && ((Boolean)this.environment.get("streamscape.repository.auto.bind")).booleanValue()) {
            this.logDebug("Repository Autobind is 'true'.");
            try {
                this.logInfo("Initializing Repository.");
                this.repoParameters.put("PACKAGE_LOAD_REGISTRY_OBJ", this.manifestManager.getLoaderRegistry());
                this.repoParameters.put("LOADED_PACKAGES_PROVIDER", this.loadedPackagesProvider);
                this.repositoryContext = RepositoryContextFactory.createRepositoryContext(this.environment, this.repoParameters);
                this.logDebug("Opening Repository...");
                this.repositoryToken = this.repositoryContext.open(!this.repositoryContext.exists());
                this.repositoryContext.beginXact(this, this.getRepositoryContextTxTimeout());
                this.logInfo("Repository Vendor: " + this.repositoryContext.getVendorString() + ".");
                this.logDebug("Registering Repository State Change Listener...");
                this.repositoryContext.setRepositoryStateChangeListener(this.rscListener);
                this.logDebug("Registering Artifact State Change Listener...");
                this.repositoryContext.setRepositoryArtifactChangeListener(this.ascListener);
                this.repositoryContext.commitXact();
                this.isRepositoryBound = true;
                this.logInfo("Repository initialized.");
            }
            catch (Throwable exception) {
                if (this.repositoryContext != null) {
                    this.repositoryContext.abortXactSafe();
                }
                this.processInitException(exception, "Repository", -1100);
            }
        } else {
            this.logDebug("Repository Autobind is 'false'. Repository Context will not be bound.");
            this.isRepositoryBound = false;
        }
        this.initRepositoryAccessor();
        this.runLevel = 1;
        this.logInfo("------------------------------------------------");
        this.logInfo("Runtime Context Initialized. Run Level 1. OK");
        this.logInfo("------------------------------------------------");
    }

    private void destroyRepository() {
        try {
            if (this.isRepositoryBound && this.repositoryContext != null && this.repositoryContext.isOpen()) {
                this.repositoryContext.close(this.repositoryToken);
                this.repositoryContext = null;
                this.repositoryAccessor = null;
                this.logInfo("Repository closed.");
            }
        }
        catch (Throwable exception) {
            this.logException(exception, true, "Destroying Repository failed.");
        }
    }

    private void initRunLevel2() {
        this.logInfo("------------------------------------------------");
        this.logInfo("Runtime Context Initializing... Run Level 2.");
        this.logInfo("------------------------------------------------");
        this.ClientConfigurationFactory = new ClientConfigurationFactory(this.repositoryContext);
        this.JDBCConfigurationFactory = new JDBCConfigurationFactory(this.repositoryContext);
        this.TransportConfigurationFactory = new TransportConfigurationFactory(this.repositoryContext);
        this.ServiceConfigurationFactory = new ServiceConfigurationFactory(this.repositoryContext);
        this.logDebug("Initialized Context Factories.");
        this.ObjectReferenceStore = new SemanticObjectReferenceStore(this.repositoryContext);
        this.RuntimePackageStore = new PackageStore(this.repositoryContext);
        this.logDebug("Initialized Context Stores.");
        this.runLevel = 2;
        this.logInfo("------------------------------------------------");
        this.logInfo("Runtime Context Initialized. Run Level 2. OK");
        this.logInfo("------------------------------------------------");
    }

    private void initRunLevel3() {
        this.logInfo("------------------------------------------------");
        this.logInfo("Runtime Context Initializing. Run Level 3.");
        this.logInfo("------------------------------------------------");
        this.initModule(() -> this.initGlobalVariableFactory(), "Global Variable Factory", 1300);
        this.initModule(() -> this.initSecurityManager(), "Security Manager", 1301);
        this.initModule(this::initSerialSchemas, "Serial Schemas", 1302);
        this.initModule(() -> this.initPackageManifest(), "Runtime Package Manifest", 1303);
        this.initModule(() -> this.initCustomSemanticTypes(), "Custom Semantic Types", 1304);
        this.initModule(() -> this.initDatagramFactories(), "Datagram Factories", 1305);
        this.initModule(this::initTypeAnalyzerFactory, "Type Analyzer Factory", 1306);
        this.initModule(() -> this.initDiscoveryModule(), "Discovery Module", 1307);
        this.initModule(this::initAcceptorFactoryManager, "Acceptor Factories", 1308);
        this.initModule(() -> this.initExchange(), "Fabric Exchange", 1309);
        this.initModule(() -> this.startExchange(), "Fabric Exchange", "starting", 1310);
        this.initModule(() -> this.initAdminAcceptor(), "Admin HTTP Acceptor", 1311, adminMode);
        this.initModule(() -> this.initRuntimeEventDispatcher(), "Runtime Event Dispatcher", 1312, !initMode);
        this.initModule(this::startTLPAcceptors, "TLP Acceptors", "starting", 1313, !initMode && !noTlpMode);
        this.initModule(() -> this.initLogEventSender(), "Log Event Sender", 1314);
        this.runLevel = 3;
        this.logInfo("------------------------------------------------");
        this.logInfo("Runtime Context Initialized. Run Level 3. OK");
        this.logInfo("------------------------------------------------");
    }

    private void initRunLevel4() {
        this.logInfo("------------------------------------------------");
        this.logInfo("Runtime Context Initializing. Run Level 4.");
        this.logInfo("------------------------------------------------");
        this.initModule(this::initEIMPluginManager, "Event Identity Plugins", 1400);
        this.initModule(this::initConverterManager, "Converter Plugins", 1401);
        this.initModule(this::initDropBoxManager, "Drop Box Manager", 1402);
        this.initModule(this::initDropBoxManagerRemote, "Drop Box Manager Remote", 1403, !initMode);
        this.initModule(this::initDataspaceManager, "Dataspace Manager", 1404);
        this.initModule(this::validateDropBoxPaths, "Drop Box Manager Paths", 1405);
        this.initModule(this::initHTTPAuthenticationManager, "HTTP Authentication Manager", 1406);
        this.initModule(this::initDSLProcessor, "DSL Processor", 1407);
        this.initModule(() -> this.initSessionManager(), "Runtime Session Manager", 1408, !initMode);
        this.initModule(() -> this.completeSecurityManagerInitialization(), "Complete Security Manager", 1409);
        this.initModule(() -> this.initCoherenceAgent(), "Coherence Agent", 1410);
        this.initModule(() -> this.initSecurityKeyStore(), "Security Key Store", 1411);
        this.initModule(() -> this.initScheduler(), "Scheduler", 1412);
        this.initModule(() -> this.loadDataConstraints(), "Data Constraints", "loading", 1413);
        this.initStartTime();
        this.initModule(() -> this.joinSysplex(), "Join", "sysplex", 1414, !initMode && !maintainMode);
        this.runLevel = 4;
        this.logInfo("------------------------------------------------");
        this.logInfo("Runtime Context Initialized. Run Level 4. OK");
        this.logInfo("------------------------------------------------");
    }

    protected void completeInitialization() {
        this.initModule(() -> this.openDataspaceManager(), "Dataspace Manager", "opening", 1415);
        this.initModule(() -> this.initServiceManager(), "Service Manager", 1416);
        this.initModule(() -> this.openScheduler(), "Scheduler", "recovery", 1417);
        this.initModule(this::startAcceptorFactoryManager, "Acceptors", "starting", 1418, !initMode && !maintainMode);
        this.initModule(() -> this.initStatsMonitor(), "Stats Monitor", 1419, !initMode);
        this.registerShutdownStuff();
        this.startExpirationTimer();
        this.initLevel = -1;
    }

    private void initModule(InitMethod initMethod, String moduleName, int initLevel) {
        this.initModule(initMethod, moduleName, "initialization", initLevel, true);
    }

    private void initModule(InitMethod initMethod, String moduleName, int initLevel, boolean condition) {
        this.initModule(initMethod, moduleName, "initialization", initLevel, condition);
    }

    private void initModule(InitMethod initMethod, String moduleName, String action, int initLevel) {
        this.initModule(initMethod, moduleName, action, initLevel, true);
    }

    private void initModule(InitMethod initMethod, String moduleName, String action, int initLevel, boolean condition) {
        if (condition) {
            this.initLevel = initLevel;
            try {
                this.clearInitProperties();
                initMethod.run();
            }
            catch (Throwable exception) {
                this.processInitException(exception, moduleName, action, -initLevel);
            }
        }
    }

    public PingResult ping() {
        return this.ping(null);
    }

    public PingResult ping(String version) {
        PingResult result = this.initLevel < 0 ? (version != null && !Version.getVersion().equals(version) ? this.createPingResult(PingState.AVAILABLE_VERSION_MISMATCH, -1) : this.createPingResult(PingState.AVAILABLE, -1)) : this.createPingResult(PingState.INITIALIZING, this.initLevel);
        return result;
    }

    private PingResult createPingResult(PingState state, int initStage) {
        return new PingResult(state, this.getName(), this.getNodeRole(), Version.getVersion(), this.getPeerState(), this.getModerator().getFabricNode().getProcessID(), this.getDomain(), this.listOrganizations(), initStage, this.initProperties);
    }

    boolean isUnloadInProgress() {
        return this.unloadInProgress;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void unload() {
        if (this.unloadInProgress) return;
        this.unloadInProgress = true;
        this.stopRunLevel4();
        RuntimeState.setState(false);
        this.stopRunLevel3();
        this.stopRunLevel2();
        this.stopRunLevel1();
        this.destroyFabricContextFactory();
        if (instance != null) {
            instance = null;
            initialized = false;
            String string = STRUNTIME_ACTIVE_KEY;
            // MONITORENTER : "struntime.active"
            System.setProperty(STRUNTIME_ACTIVE_KEY, STRUNTIME_NOT_INITIALIZED);
            // MONITOREXIT : string
        }
        this.unloadInProgress = false;
    }

    private void stopRunLevel1() {
        this.logInfo("Runtime Context Shutdown. Downgrade to Run Level 0...");
        this.destroyOMFManager();
    }

    private void stopRunLevel2() {
        this.logInfo("Runtime Context Shutdown. Downgrade to Run Level 1...");
        try {
            if (this.shutdownController != null) {
                this.shutdownController.shutdown();
            }
            this.destroyRepository();
        }
        catch (Throwable exception) {
            this.logException(exception, true);
            this.logError("Downgrade failed.");
        }
    }

    private void stopRunLevel3() {
        this.logInfo("Runtime Context Shutdown. Downgrade to Run Level 2...");
        try {
            Utils.sleep(500L);
            this.destroyLogEventSender();
            this.destroySessionManager();
            this.destroyRuntimeEventDispatcher();
            this.destroyDiscoveryModule();
            this.destroyExchange();
            this.destroyPackageManifestManager();
            this.destroySecurityManager();
        }
        catch (Throwable exception) {
            this.logException(exception, true);
            this.logError("Downgrade failed.");
        }
    }

    private void stopRunLevel4() {
        this.logInfo("Runtime Context Shutdown. Downgrade to Run Level 3...");
        try {
            this.destroyExpirationTimer();
            this.destroyAdminAcceptor();
            this.destroyStatsMonitor();
            this.detachFromSysplex();
            this.destroyServiceManager();
            this.destroySecurityKeyStore();
            this.destroyScheduler();
            this.destroyDropBoxManagerRemote();
            this.destroyDropBoxManager();
            this.destroyCoherenceAgent();
            this.destroyAcceptorFactoryManager();
            this.destroySystemConnection();
            this.destroyDataspaceManager();
            this.destroyTypeAnalyzerFactory();
        }
        catch (Throwable exception) {
            this.logException(exception, true);
            this.logError("Downgrade failed.");
        }
    }

    public final boolean isStandalone() {
        return this.isStandalone;
    }

    public final boolean isClustered() {
        return this.isClustered;
    }

    public final String getClusterName() {
        return (String)this.environment.get(CLUSTER);
    }

    protected void setStandalone(boolean standalone) {
        this.isStandalone = standalone;
    }

    public final String getSTRootDir() {
        return this.ST_ROOT;
    }

    @Override
    public final String getStartupDir() {
        return (String)this.environment.get(STARTUP_DIR);
    }

    public final File getFileInStartupDir(String path) {
        return new File(this.getStartupDir(), path);
    }

    public final Map<String, Object> getEnvironment() {
        return this.environment;
    }

    public final long getRepositoryContextTxTimeout() {
        return (Long)this.environment.get("streamscape.repository.tx.timeout");
    }

    public void printEnvironment() {
        int maxNameLength = 0;
        int maxValueLength = 0;
        ArrayList names = new ArrayList(this.environment.keySet());
        Collections.sort(names);
        ArrayList<String> values = new ArrayList<String>(names.size());
        for (String name : names) {
            String value;
            String string = value = this.environment.get(name) != null ? this.environment.get(name).toString() : "";
            if (name.equals("streamscape.naming.security.credentials") && !value.isEmpty()) {
                value = "*****";
            }
            values.add(value);
            if (name.length() > maxNameLength) {
                maxNameLength = name.length();
            }
            if (value.length() <= maxValueLength) continue;
            maxValueLength = value.length();
        }
        char[] borderArray = new char[maxNameLength + maxValueLength + 3];
        Arrays.fill(borderArray, '-');
        String border = new String(borderArray);
        System.out.println("\t" + border);
        String format = "\t%1$-" + maxNameLength + "s   %2$s \n";
        for (int i = 0; i < names.size(); ++i) {
            System.out.printf(format, names.get(i), values.get(i));
        }
        System.out.println("\t" + border + "\n");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static RuntimeContext getInstance() {
        if (instance != null) return instance;
        Class<RuntimeContext> clazz = RuntimeContext.class;
        synchronized (RuntimeContext.class) {
            if (instance != null) return instance;
            instance = new RuntimeContext();
            instance.completeInitialization();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public static boolean isInitialized() {
        return initialized;
    }

    public final PackageLoaderRegistry getPackageLoaderRegistry() {
        return this.manifestManager.getLoaderRegistry();
    }

    @Override
    public final ClassLoaderRegistry getClassLoaderRegistry() {
        return super.getClassLoaderRegistry();
    }

    @Override
    public final ClassLoader getSystemClassLoaderChain() {
        return this.getPackageLoaderRegistry().getSystemClassLoaderChain();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void bind(FabricComponent component) throws RuntimeContextException {
        if (component == null) {
            throw new RuntimeContextException("Bind Error: null component specified.");
        }
        switch (this.ctxDescriptor.getContextType()) {
            case CTX_APPLICATION: {
                this.checkComponentModel(component, "Application Context");
                break;
            }
            case CTX_EX_CONTAINER: {
                this.checkComponentModel(component, "External Container Context");
                break;
            }
            case CTX_TF_CONTAINER: {
                this.checkComponentModel(component, "Fabric Container Context");
            }
        }
        Map map = this.boundComponents;
        synchronized (map) {
            if (this.boundComponents.containsKey(component.getContextId())) {
                throw new RuntimeContextException("Bind Error: Component already bound. Use unbind first.");
            }
            this.checkComponentUniqueness(component.getType(), component.getName());
            if (component.getEventScope() != EventScope.LOCAL) {
                this.bindToExchange(component);
            }
            this.boundComponents.put(component.getContextId(), component);
        }
    }

    private void checkComponentModel(FabricComponent component, String contextName) throws RuntimeContextException {
        if (!(component.getComponentModel().equals((Object)ComponentModel.CTX_CLIENT) || component.getComponentModel().equals((Object)ComponentModel.CTX_DATASPACE) || component.getComponentModel().equals((Object)ComponentModel.CTX_SERVICE) || component.getComponentModel().equals((Object)ComponentModel.CTX_FACTORY_CONNECTION))) {
            throw new RuntimeContextException("Bind Error: Component Model '" + String.valueOf((Object)component.getComponentModel()) + "' not supported by " + contextName + ".");
        }
    }

    private void checkComponentUniqueness(String type, String name) throws RuntimeContextException {
        for (FabricComponent component : this.boundComponents.values()) {
            if (!component.getType().equals(type) || !component.getName().equals(name)) continue;
            throw new RuntimeContextException("Component with type '" + type + "' and name '" + name + "' already bound.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final FabricComponent unbind(ContextId id) throws RuntimeContextException {
        FabricComponent component;
        if (id == null) {
            throw new RuntimeContextException("Unbind Error: 'Context Id' is are null.");
        }
        Map map = this.boundComponents;
        synchronized (map) {
            component = (FabricComponent)this.boundComponents.remove(id);
            if (component != null) {
                if (component.getEventScope() != EventScope.LOCAL) {
                    this.unbindFromExchange(component);
                }
                this.checkAutoUnload();
            }
        }
        return component;
    }

    private void checkAutoUnload() {
        if (RuntimeState.isActive() && !this.isUnloadInProgress() && ((Boolean)this.environment.get(AUTO_UNLOAD)).booleanValue() && !this.hasNonSystemComponents()) {
            this.logInfo("Runtime Context has no more bound components. It will be unloaded.");
            this.beacon(Severity.INFO, "Unloading Runtime Context...");
            new SingleTaskWorker("FSYS:ShutdownInitiator.AutoUnload", "Initiates a shutdown of the node."){

                @Override
                protected void doExecute() throws FabricException {
                    Utils.sleep(500L);
                    RuntimeContext.this.unload();
                }
            }.start();
        }
    }

    private boolean hasNonSystemComponents() {
        return this.boundComponents.values().stream().anyMatch(component -> !this.isSystemComponent((FabricComponent)component));
    }

    private boolean isSystemComponent(FabricComponent component) {
        return ReservedNames.isReserved(component.getName()) || component.getType().equals("TSPACE") && (component.getName().equals("SDS") || component.getName().equals("SYS") || component.getName().equals("SCH"));
    }

    public final FabricComponent lookupComponent(ContextId contextId) throws RuntimeContextException {
        if (contextId == null) {
            throw new RuntimeContextException("Lookup Error: 'Context Id' is null.");
        }
        return (FabricComponent)this.boundComponents.get(contextId);
    }

    public final FabricComponent lookupComponentByFQName(String fqName) throws RuntimeException {
        if (fqName == null) {
            throw new RuntimeException("Lookup Error: 'Component Name' is null.");
        }
        if (fqName.indexOf(46) == -1) {
            throw new RuntimeException("Naming Exception: Invalid component name specified '" + fqName + "'");
        }
        fqName = fqName.trim();
        for (FabricComponent component : this.getBoundComponents()) {
            if (!fqName.equals(component.getType() + "." + component.getName())) continue;
            return component;
        }
        return null;
    }

    public final FabricComponent lookupComponentByName(String name) throws RuntimeContextException {
        if (name == null) {
            throw new RuntimeContextException("Lookup Error: 'Component Name' is null.");
        }
        name = name.trim();
        for (FabricComponent component : this.getBoundComponents()) {
            if (!name.equals(component.getName())) continue;
            return component;
        }
        return null;
    }

    public final ServiceContext lookupServiceContext(Service service) throws RuntimeContextException {
        if (service == null) {
            throw new RuntimeContextException("Lookup Error: Service instance is null.");
        }
        return this.getBoundComponents().stream().filter(component -> component instanceof ServiceContext && ((ServiceContext)component).isContainerFor(service)).findFirst().orElse(null);
    }

    public final List<FabricComponent> getFabricComponentsByModel(ComponentModel model) {
        return this.getBoundComponents().stream().filter(component -> component.getComponentModel().equals((Object)model)).collect(Collectors.toList());
    }

    @Override
    public final RepositoryAccessor getRepositoryAccessor() throws RuntimeException {
        return super.getRepositoryAccessor();
    }

    public final boolean isRepositoryBound() {
        return this.isRepositoryBound;
    }

    @Override
    public final List<FabricComponent> getBoundComponents() {
        return super.getBoundComponents();
    }

    public List<FabricManagedComponent> getManagedComponents() {
        return this.getBoundComponents().stream().filter(component -> (component.getComponentModel().equals((Object)ComponentModel.CTX_SERVICE) || component.getComponentModel().equals((Object)ComponentModel.CTX_DATASPACE) || component.getComponentModel().equals((Object)ComponentModel.REMOTE_SERVICE) || component.getComponentModel().equals((Object)ComponentModel.REMOTE_DATASPACE)) && component instanceof FabricManagedComponent).map(component -> (FabricManagedComponent)((Object)component)).collect(Collectors.toList());
    }

    public final void printRuntimeContext() {
        System.out.println("\n");
        System.out.println("Component Class              \t Component Name                    \t Context Id");
        System.out.println("---------------------------- \t --------------------------------- \t -------------------------");
        for (Map.Entry entry : this.boundComponents.entrySet()) {
            FabricComponent component = (FabricComponent)entry.getValue();
            String name = component.getName();
            String type = component.getType();
            String componentModel = component.getComponentModel().name();
            if (!Trace.isEnabled(this.getClass().getName()) && component.getComponentModel().equals((Object)ComponentModel.CTX_UNBOUND)) break;
            componentModel = componentModel.trim().length() > 25 ? componentModel.substring(0, 25) + " >>" : componentModel;
            String componentName = type + ":" + name;
            componentName = componentName.trim().length() > 30 ? componentName.substring(0, 30) + " >>" : componentName;
            String format = "%1$-28s \t %2$-33s \t %3$-30s \n";
            System.out.format(format, componentModel, componentName, ((ContextId)entry.getKey()).toString());
        }
        System.out.println("\n");
    }

    private void beacon(Severity severity, String message) {
        this.beacon(severity, message, EventScope.OBSERVABLE);
    }

    private void beacon(Severity severity, String message, EventScope eventScope) {
        try {
            this.raiseRuntimeAdvisory(new RuntimeAdvisory(message, severity), eventScope);
        }
        catch (Exception exception) {
            this.logException(exception, true);
            this.logError("Raising of RuntimeAdvisory failed.");
        }
    }

    public final SemanticLexiconProcessor getLexiconProcessor() {
        return this.lexiconProcessor;
    }

    @Override
    public RuntimeContext getCallable() {
        return this;
    }

    @Override
    public final void raiseRuntimeAdvisory(RuntimeAdvisory event, EventScope eventScope) throws RuntimeException {
        super.raiseRuntimeAdvisory(event, eventScope);
    }

    public final void raiseRuntimeAdvisory(RuntimeAdvisory event) throws RuntimeException {
        this.raiseRuntimeAdvisory(event, EventScope.OBSERVABLE);
    }

    public void shutdown() {
        if (RuntimeState.isActive()) {
            new ShutdownInitiatorWorker().start();
        }
    }

    public void shutdownAll() {
        this.shutdown();
    }

    public void restart() {
        this.shutdown();
    }

    public final long getShutdownTimeout() {
        return this.shutdownTimeout;
    }

    public final void setShutdownTimeout(long timeout) {
        this.shutdownTimeout = timeout;
    }

    void shutdownOnExit() {
        if (RuntimeState.isActive() && this.shutdownListener != null) {
            this.shutdownListener.onShutdown();
        }
    }

    public final void setShutdownController(ShutdownController shutdownController) {
        this.shutdownController = shutdownController;
    }

    public final ShutdownController getShutdownController() {
        return this.shutdownController;
    }

    public final EventIdentityPluginManager getEventIdentityPluginManager() {
        return this.eimManager;
    }

    public final ConverterPluginManager getConverterPluginManager() {
        return this.converterManager;
    }

    public SystemEnvironment getSystemEnvironment() {
        return this.statsMonitor.getSystemEnvironment();
    }

    public final StatsMonitor getStatsMonitor() {
        return this.statsMonitor;
    }

    @Override
    public final ObjectMediationFactoryManager getObjectMediationFactoryManager() {
        return this.omfManager;
    }

    @Override
    public final XSerializer getXSerializer() {
        return this.xSerializer;
    }

    @Override
    public final JSerializer getJSerializer() {
        return this.jSerializer;
    }

    @Override
    public final JSONSerializer getJSONSerializer() {
        return this.jsonSerializer;
    }

    @Override
    public final XSerializerFactory getXSerializerFactory() {
        return (XSerializerFactory)this.omfManager.lookupSerializerFactory("XSerializer");
    }

    @Override
    public final JSerializerFactory getJSerializerFactory() {
        return (JSerializerFactory)this.omfManager.lookupSerializerFactory("JSerializer");
    }

    @Override
    public final JSONSerializerFactory getJSONSerializerFactory() {
        return (JSONSerializerFactory)this.omfManager.lookupSerializerFactory("JSONSerializer");
    }

    public final SemanticLexiconManager getLexiconManager() {
        return this.lexiconManager;
    }

    @Override
    public final boolean isDataspaceBound() {
        return super.isDataspaceBound();
    }

    public final DataspaceManager getDataspaceManager() throws RuntimeException {
        if (!this.isDataspaceBound()) {
            throw new RuntimeException("Dataspace is not available in the Runtime.");
        }
        return this.dsManager;
    }

    public final ServiceManager getServiceManager() {
        return this.serviceManager;
    }

    public final boolean isPresenceEnabled() {
        return (Boolean)this.environment.get(PRESENTITY_KEY);
    }

    @Override
    public final boolean isSecurityEnabled() {
        return super.isSecurityEnabled();
    }

    public final SecurityManager getSecurityManager() throws SecurityManagerException {
        return this.doGetSecurityManager();
    }

    public final DropBoxManager getDropBoxManager() {
        return this.dropBoxManager;
    }

    public final DropBoxManagerRemoteImpl getDropBoxManagerRemote() {
        return this.dropBoxManagerRemote;
    }

    public final AuthenticationModuleFactory getAuthenticationModuleFactory() throws SecurityManagerException {
        if (this.authenticationModuleFactory == null) {
            throw new SecurityManagerException(6081, "Security is disabled.");
        }
        return (AuthenticationModuleFactory)this.authenticationModuleFactory;
    }

    public final AcceptorFactoryManager getAcceptorManager() {
        return this.accManager;
    }

    @Override
    public final TLPAcceptorFactory getTLPAcceptorFactory() {
        return (TLPAcceptorFactory)this.accManager.lookupFactory(TLPAcceptorFactory.class.getSimpleName());
    }

    @Override
    public final FabricContainer getContainer() {
        return super.getContainer();
    }

    @Override
    public final FabricExchange getExchange() {
        return super.getExchange();
    }

    @Override
    public final Moderator getModerator() {
        return super.getModerator();
    }

    @Override
    public final void addAdvisoryListener(RuntimeAdvisoryListener listener) throws RuntimeContextException {
        super.addAdvisoryListener(listener);
    }

    @Override
    public final void removeAdvisoryListener(String listenerName) throws RuntimeContextException {
        super.removeAdvisoryListener(listenerName);
    }

    @Override
    public final List<String> listAdvisoryListeners() {
        return super.listAdvisoryListeners();
    }

    @Override
    public final DatagramFactoryManager getDatagramFactoryManager() {
        return super.getDatagramFactoryManager();
    }

    @Override
    public final DatagramPrototypeCache getDatagramPrototypeCache() {
        return super.getDatagramPrototypeCache();
    }

    @Override
    public final DatagramPrototypeFactory getDatagramPrototypeFactory() {
        return super.getDatagramPrototypeFactory();
    }

    @Override
    public final SemanticTypeCache getSemanticTypeCache() {
        return super.getSemanticTypeCache();
    }

    @Override
    public final SemanticTypeFactory getSemanticTypeFactory() {
        return super.getSemanticTypeFactory();
    }

    @Override
    public final AliasManager getSemanticAliasManager() {
        return super.getSemanticAliasManager();
    }

    @Override
    public final DiscoveryModuleFactory getDiscoveryModuleFactory() {
        return super.getDiscoveryModuleFactory();
    }

    @Override
    public final DiscoveryModule getDiscoveryModule() {
        return super.getDiscoveryModule();
    }

    @Override
    public final TypeAnalyzerFactory getTypeAnalyzerFactory() {
        return super.getTypeAnalyzerFactory();
    }

    @Override
    public final SDRManagerFactory getSDRManagerFactory() {
        return super.getSDRManagerFactory();
    }

    @Override
    public final AdvisoryDatagramFactory getAdvisoryDatagramFactory() {
        return (AdvisoryDatagramFactory)this.getDatagramFactoryManager().lookupDatagramFactory("AdvisoryDatagramFactory");
    }

    @Override
    public final OpaqueDatagramFactory getOpaqueDatagramFactory() {
        return (OpaqueDatagramFactory)this.getDatagramFactoryManager().lookupDatagramFactory("OpaqueDatagramFactory");
    }

    @Override
    public final EventDatagramFactory getEventDatagramFactory() {
        return (EventDatagramFactory)this.getDatagramFactoryManager().lookupDatagramFactory("EventDatagramFactory");
    }

    @Override
    public final ExceptionDatagramFactory getExceptionDatagramFactory() {
        return (ExceptionDatagramFactory)this.getDatagramFactoryManager().lookupDatagramFactory("ExceptionDatagramFactory");
    }

    public final HTTPAuthenticationManager getHTTPAuthenticationManager() {
        return new HTTPAuthenticationManagerImpl(this.httpAuthenticationManagerCore);
    }

    private void registerShutdownStuff() {
        Runtime.getRuntime().addShutdownHook(new ShutdownHandler(this));
        this.shutdownListener = new DefaultShutdownListener();
    }

    @Override
    protected AbstractOMFManager createOMFManager() throws Exception {
        return new RuntimeOMFManager();
    }

    @Override
    protected AbstractDatagramFactoryManager createDatagramFactoryManager() throws Exception {
        return new RuntimeDatagramFactoryManager(this, this.datagramPrototypeFactory);
    }

    private void initDataspaceManager() {
        if (((Boolean)this.environment.get(AUTOBIND_DATASPACE)).booleanValue()) {
            this.logInfo("Initializing Dataspace Manager...");
            this.dsManager = new RuntimeDataspaceManager();
            this.dsManager.setDefaultLogger(defaultDataspaceLogger);
            this.dsManager.init();
            this.logInfo("Dataspace Manager initialized.");
            this.setTimeZone();
        }
    }

    private void destroyDataspaceManager() {
        try {
            if (this.dsManager != null) {
                this.dsManager.close();
                this.dsManager = null;
                this.logInfo("Dataspace Manager destroyed.");
            }
        }
        catch (Throwable exception) {
            this.logException(exception, true, "Destroying Dataspace Manager failed.");
        }
    }

    private void setTimeZone() {
        TimeZone nodeTimeZone = this.getNodeTimezone();
        if (!Objects.equals(nodeTimeZone, this.getHostTimezone())) {
            this.logInfo("Node time zone is '" + nodeTimeZone.getID() + "'. Applying to Traces...");
            Trace.setTimeZone(nodeTimeZone);
        }
    }

    private void initDropBoxManager() throws Exception {
        this.logInfo("Initializing DropBox Manager...");
        this.dropBoxManager = this.createDropBoxManager();
        HTTPAcceptorFactory factory = (HTTPAcceptorFactory)this.getAcceptorManager().lookupFactory("HTTPAcceptorFactory");
        if (factory != null) {
            factory.updateDropBox(this);
        } else {
            Trace.logError(this, "Cannot get HTTPAcceptorFactory.");
        }
        this.logInfo("DropBox Manager initialized.");
    }

    protected DropBoxManager createDropBoxManager() throws Exception {
        return new DropBoxManagerImpl(this);
    }

    protected void destroyDropBoxManager() {
        try {
            if (this.dropBoxManager != null) {
                this.dropBoxManager.destroy();
                this.dropBoxManager = null;
                this.logInfo("DropBox Manager destroyed.");
            }
        }
        catch (Throwable exception) {
            this.logException(exception, true, "Destroying DropBox Manager failed.");
        }
    }

    private void validateDropBoxPaths() throws Exception {
        this.logInfo("Validation of DropBox paths...");
        ((DropBoxManagerImpl)this.dropBoxManager).validateDropBoxPaths();
        this.logInfo("DropBox paths validated.");
    }

    private void initDropBoxManagerRemote() throws Exception {
        this.logInfo("Initializing DropBox Manager Remote...");
        this.dropBoxManagerRemote = this.createDropBoxManagerRemote();
        this.dropBoxManagerRemote.open();
        this.logInfo("DropBox Manager Remote initialized.");
    }

    protected DropBoxManagerRemoteImpl createDropBoxManagerRemote() throws Exception {
        return new DropBoxManagerRemoteImpl(this, this.dropBoxManager);
    }

    protected void destroyDropBoxManagerRemote() {
        try {
            if (this.dropBoxManagerRemote != null) {
                this.dropBoxManagerRemote.destroy();
                this.dropBoxManagerRemote = null;
                this.logInfo("DropBox Manager Remote destroyed.");
            }
        }
        catch (Throwable exception) {
            this.logException(exception, true, "Destroying DropBox Manager Remote failed.");
        }
    }

    private void initHTTPAuthenticationManager() {
        this.logInfo("Initializing HTTP Authentication Manager...");
        this.httpAuthenticationManagerCore = new HTTPAuthenticationManagerCoreImpl(this);
        this.httpAuthenticationManagerCore.init();
        this.logInfo("HTTP Authentication Manager initialized.");
    }

    private void destroyHTTPAuthenticationManager() {
        try {
            if (this.httpAuthenticationManagerCore != null) {
                this.httpAuthenticationManagerCore.destroy();
                this.httpAuthenticationManagerCore = null;
                this.logInfo("HTTP Authentication Manager destroyed.");
            }
        }
        catch (Throwable exception) {
            this.logException(exception, true, "Destroying HTTP Authentication Manager failed.");
        }
    }

    private void initAcceptorFactoryManager() throws Exception {
        this.logInfo("Initializing Acceptor Factory Manager...");
        this.accManager = this.createAcceptorFactoryManager();
        this.logInfo("Acceptor Factory Manager initialized.");
    }

    protected AcceptorFactoryManager createAcceptorFactoryManager() throws AcceptorFactoryManagerException {
        return new AcceptorFactoryManager(this);
    }

    private void startAcceptorFactoryManager() throws Exception {
        for (String factoryName : this.accManager.listRegisteredFactories()) {
            if (factoryName.equals(TLPAcceptorFactory.class.getSimpleName())) continue;
            this.accManager.lookupFactory(factoryName).startAcceptors();
        }
    }

    private void startTLPAcceptors() throws Exception {
        this.getTLPAcceptorFactory().startAcceptors();
    }

    protected void destroyAcceptorFactoryManager() {
        try {
            if (this.accManager != null) {
                this.accManager.stop();
                this.accManager.destroy();
                this.accManager = null;
                this.logInfo("Acceptor Factory Manager destroyed.");
            }
        }
        catch (Throwable exception) {
            this.logException(exception, true, "Destroying Acceptor Factory Manager failed.");
        }
    }

    @Override
    protected RuntimeSessionManager createSessionManager() {
        return new RuntimeSessionManager(this);
    }

    @Override
    public final RuntimeManifestManager getPackageManifestManager() {
        return (RuntimeManifestManager)super.getPackageManifestManager();
    }

    @Override
    public final AnnotationManager getAnnotationManager() {
        return this.omfManager.getAnnotationManager();
    }

    public void setShutdownListener(ShutdownListener shutdownListener) {
        this.shutdownListener = shutdownListener;
    }

    public ShutdownListener getShutdownListener() {
        return this.shutdownListener;
    }

    public FabricNodeRole getNodeRole() {
        return FabricNodeRole.TASK_NODE;
    }

    @Override
    public List<LinkAddress> getTLPAcceptors() {
        return super.getTLPAcceptors();
    }

    @Override
    public final PeerState getPeerState() {
        return super.getPeerState();
    }

    public final String getDeploymentDescriptorFilename() {
        return this.ctxDescriptorFilename;
    }

    public final DeploymentDescriptor getDeploymentDescriptor() {
        return this.ctxDescriptor;
    }

    @Override
    public final String getDomain() {
        return super.getDomain();
    }

    @Override
    public final UUID getFabricUID() {
        return super.getFabricUID();
    }

    @Override
    public final String getUserName() {
        return super.getUserName();
    }

    @Override
    protected void initTypeAnalyzerFactory() {
        super.initTypeAnalyzerFactory();
    }

    protected void initDSLProcessor() {
        this.logInfo("Initializing DSL Processor...");
        this.lexiconProcessor = this.createLexiconProcessor();
        this.lexiconManager.init(this.lexiconProcessor);
        this.logInfo("DSL Processor initialized.");
    }

    protected RuntimeLexiconProcessor createLexiconProcessor() {
        return new RuntimeLexiconProcessor(this);
    }

    private void initEIMPluginManager() throws Exception {
        this.logInfo("Initializing EIM Plugin Manager...");
        this.eimManager = new RuntimeEIMPluginManager();
        this.logInfo("EIM Plugin Manager initialized.");
    }

    private void initConverterManager() throws Exception {
        this.logInfo("Initializing Converter Plugin Manager...");
        this.converterManager = new RuntimeConverterManager(this);
        this.converterManager.init();
        this.logInfo("Converter Plugin Manager initialized.");
    }

    @Override
    protected void initPackageManifestManager() {
        try {
            this.manifestManager = new RuntimeManifestManager(this);
        }
        catch (Throwable exception) {
            this.processInitException(exception, "Package Manifest Manager", -1000);
        }
    }

    private void initSerialSchemas() throws Exception {
        ((RuntimeOMFManager)this.omfManager).initSerialSchemas();
        this.logInfo("Serial Schemas initialized.");
    }

    @Override
    public final boolean isCoherenceAgentBound() {
        return super.isCoherenceAgentBound();
    }

    public final GlobalVariableFactory getGlobalVariableFactory() {
        return this.globalVariableFactory;
    }

    public final Scheduler getScheduler() {
        return this.scheduler;
    }

    @Override
    public final FabricGroupManager getGroupManager() {
        return super.getGroupManager();
    }

    @Override
    public final TimeZone getNodeTimezone() {
        return super.getNodeTimezone();
    }

    @Override
    protected void processInitException(Throwable exception, String entity, int errorCode) {
        this.processInitException(exception, entity, "initialization", errorCode);
    }

    @Override
    protected void processInitException(Throwable exception, String entity, String action, int errorCode) {
        this.logException(exception, true, entity + " " + action + " failed. Exiting (" + errorCode + ")...");
        Utils.sleep(50L);
        exception.printStackTrace();
        System.out.println(entity + " " + action + " failed. Exiting (" + errorCode + ")...");
        ContainerLockSupport.getCurrentNodeLock().writeToLockFailFile(entity + " " + action + " failed. " + exception.getMessage() + " Exiting (" + errorCode + ")...");
        Utils.sleep(50L);
        this.destroyOnFailure();
        System.exit(errorCode);
    }

    private void processInitError(String errorMessage, String entity, int errorCode) {
        this.processInitException(new RuntimeContextException(errorMessage), entity, errorCode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void destroyOnFailure() {
        this.destroyExpirationTimer();
        this.detachFromSysplex();
        this.destroyServiceManager();
        this.destroyCoherenceAgent();
        this.destroyAcceptorFactoryManager();
        this.destroySystemConnection();
        this.destroyHTTPAuthenticationManager();
        this.destroyDataspaceManager();
        this.destroyTypeAnalyzerFactory();
        this.destroyStatsMonitor();
        RuntimeState.setState(false);
        this.destroyLogEventSender();
        this.destroySessionManager();
        this.destroyRuntimeEventDispatcher();
        this.destroyDiscoveryModule();
        this.destroyExchange();
        this.destroyPackageManifestManager();
        this.destroySecurityManager();
        this.destroyRepository();
        this.destroyOMFManager();
        this.destroyFabricContextFactory();
        ContainerLockSupport.getCurrentNodeLock().removeLockFileIfNoRestartRequired();
        if (instance == null) return;
        instance = null;
        String string = STRUNTIME_ACTIVE_KEY;
        synchronized (STRUNTIME_ACTIVE_KEY) {
            System.setProperty(STRUNTIME_ACTIVE_KEY, STRUNTIME_NOT_INITIALIZED);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    protected static interface InitMethod {
        public void run() throws Exception;
    }

    static class ShutdownInitiatorWorker {
        ShutdownInitiatorWorker() {
        }

        void start() {
            new Worker().start();
        }

        static class Worker
        extends SingleTaskWorker {
            Worker() {
                super("FSYS:Shutdown.Executor", "Executes a shutdown of the node.");
            }

            @Override
            protected void doExecute() throws FabricException {
                Utils.sleep(500L);
                System.exit(0);
            }
        }
    }

    class DefaultShutdownListener
    implements ShutdownListener {
        DefaultShutdownListener() {
            Trace.logDebug(this, "Fabric Runtime Shutdown Listener Enabled.");
        }

        @Override
        public void onShutdown() {
            Trace.logDebug(this, "Fabric Runtime Context Shutdown initiated...");
            RuntimeContext.this.unload();
            Trace.logInfo(this, "Stopped.");
        }
    }
}

