/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime;

import com.streamscape.Trace;
import com.streamscape.lib.http.client.HTTPConnection;
import com.streamscape.lib.utils.ClassUtils;
import com.streamscape.lib.utils.Pair;
import com.streamscape.repository.RepositoryException;
import com.streamscape.repository.cli.RepositoryAccessor;
import com.streamscape.repository.cli.RepositoryAccessorException;
import com.streamscape.repository.enums.PackageType;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.runtime.RuntimeMFSession;
import com.streamscape.runtime.mf.admin.cfo.ClientConfigurationFactory;
import com.streamscape.sdo.ImmutableEventDatagram;
import com.streamscape.sdo.event.OpaqueEvent;
import com.streamscape.sdo.operation.SLClientFactoriesMessage;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sef.FabricRequestException;
import com.streamscape.sef.dispatcher.AbstractAccessorProxy;
import com.streamscape.sef.factory.connection.UsableClientConnection;
import com.streamscape.sef.pkg.PackageLoaderHelper;
import com.streamscape.sef.security.ComponentOwner;
import com.streamscape.service.osf.clients.ClientFactory;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.SLSessionData;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.List;

class RuntimeAccessorProxy
extends AbstractAccessorProxy {
    private RuntimeMFSession session;
    private RuntimeContext context;
    private UsableFactoriesProvider clientFactoriesProvider;

    RuntimeAccessorProxy(String sessionName, String componentName, ComponentOwner owner, boolean isRouted, boolean isInstant, RuntimeContext context, String slSessionName, SLSessionData slSessionData) {
        super(context.getLexiconProcessor());
        this.context = context;
        this.session = new RuntimeMFSession(sessionName, componentName, owner, isRouted, isInstant, context, slSessionName, context.getName());
        this.session.setSLSessionData(slSessionData);
        this.clientFactoriesProvider = new UsableFactoriesProvider();
    }

    @Override
    protected void logError(Throwable exception) {
        Trace.logException(this, exception, true);
        Trace.logError(this, "Processing of SLANG statement failed.");
    }

    @Override
    protected ImmutableEventDatagram invokeOtherRequest(ImmutableEventDatagram request) throws FabricRequestException {
        if (request.getEventId().equals("e.sys.sl.ClientFactoriesMessage")) {
            SLResponse response = new SLResponse();
            try {
                SLClientFactoriesMessage data = (SLClientFactoriesMessage)((OpaqueEvent)request).getData();
                if (data.isFactories()) {
                    response.setObject(this.clientFactoriesProvider.listUsableClientFactories(this.context));
                } else {
                    response.setObject(new ArrayList<String>(this.context.getDropBoxManagerRemote().listDropBoxesVisibleBy(data.getUsername())));
                }
            }
            catch (Exception exception) {
                response = new SLResponse(exception.getMessage(), false);
            }
            try {
                return RuntimeAccessorProxy.createResponseEvent(response);
            }
            catch (Exception exception) {
                this.logError(exception);
                throw new FabricRequestException(exception);
            }
        }
        return super.invokeOtherRequest(request);
    }

    @Override
    protected MFSession getMFSession() {
        return this.session;
    }

    @Override
    public void close() {
        this.session.close();
    }

    private static class UsableFactoriesProvider {
        private List<String> usableClasses = new ArrayList<String>();
        private List<String> unusableClasses = new ArrayList<String>();

        private UsableFactoriesProvider() {
        }

        List<Pair<String, String>> listUsableClientFactories(RuntimeContext context) throws RepositoryAccessorException, RepositoryException {
            ArrayList<Pair<String, String>> factories = new ArrayList<Pair<String, String>>();
            RepositoryAccessor repositoryAccessor = context.getRepositoryAccessor();
            for (String type : repositoryAccessor.listJDBCFactoryTypes()) {
                for (String name : repositoryAccessor.listJDBCFactoriesByType(type)) {
                    this.addFactoryNotPrototype(factories, "db", type, name);
                }
            }
            for (String type : repositoryAccessor.listClientFactoryTypes()) {
                for (String name : repositoryAccessor.listClientFactoriesByType(type)) {
                    try {
                        ClientFactory factory = ClientConfigurationFactory.loadFactoryObject(context, name, type, false);
                        String className = factory.getConnectionClassName();
                        boolean isUsable = this.usableClasses.contains(className);
                        boolean notUsable = this.unusableClasses.contains(className);
                        if (!isUsable && !notUsable) {
                            String packageName = PackageType.client.toString() + "." + type;
                            try {
                                if (!PackageLoaderHelper.loadPackageIfRegistered(context, packageName)) {
                                    Trace.logDebug(this, "Package '" + packageName + "' is not registered.");
                                }
                            }
                            catch (Exception exception) {
                                Trace.logError(this, "Loading package '" + packageName + "' for factory '" + type + "." + name + " failed. Cause: " + exception.getMessage());
                            }
                            Class connectionClass = ClassUtils.loadClass(factory.getConnectionClassName(), factory.getClassLoader());
                            if (UsableClientConnection.class.isAssignableFrom(connectionClass) && connectionClass != HTTPConnection.class) {
                                isUsable = true;
                                this.usableClasses.add(className);
                            } else {
                                notUsable = true;
                                this.unusableClasses.add(className);
                            }
                        }
                        if (!isUsable) continue;
                        this.addFactoryNotPrototype(factories, "client", type, name);
                    }
                    catch (Exception exception) {
                        Trace.logDebug(this, "WARNING: Loading connection class for factory '" + type + "." + name + " failed. Cause: " + exception.getMessage());
                    }
                }
            }
            return factories;
        }

        private void addFactoryNotPrototype(List<Pair<String, String>> factories, String type1, String type, String name) {
            if (!name.equalsIgnoreCase("prototype")) {
                factories.add(new Pair<String, CallSite>(type1, (CallSite)((Object)(type + "." + name))));
            }
        }
    }
}

