/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime;

import com.streamscape.Trace;
import com.streamscape.lib.concurrent.worker.SingleTaskWorker;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.runtime.RuntimeState;
import com.streamscape.sef.FabricException;
import java.util.Date;

class ExpirationTimer
extends SingleTaskWorker {
    private RuntimeContext context;
    private long expirationTime;
    private long waitingTime;
    private volatile boolean shutdownInProgress = false;

    ExpirationTimer(RuntimeContext context, long expirationTime) {
        super("FSYS:ExpirationTimer", "Shuts down the program after license expiration.");
        this.context = context;
        this.expirationTime = expirationTime;
        Trace.logInfo(this, "Expiration Timer enabled. Deployment Descriptor License will expire at " + Trace.DATE_FORMAT.format(new Date(expirationTime)) + ".");
    }

    void check() {
        if (this.expirationTime - System.currentTimeMillis() <= 0L) {
            this.shutdownInProgress = true;
            Trace.logInfo(this, "Deployment Descriptor License has Expired. Runtime Context is Shutting Down...");
            System.out.println("Deployment Descriptor License has Expired. Runtime Context is Shutting Down...");
            this.context.destroyOnFailure();
            System.exit(-999);
        }
    }

    @Override
    protected void doExecute() throws FabricException {
        this.waitingTime = this.expirationTime - System.currentTimeMillis();
        if (this.waitingTime <= 0L) {
            this.shutdown();
        } else {
            this.doWait();
        }
    }

    private void doShutdown() {
        this.shutdownInProgress = true;
        Trace.logInfo(this, "Deployment Descriptor License has Expired. Runtime Context is Shutting Down...");
        System.out.println("Deployment Descriptor License has Expired. Runtime Context is Shutting Down...");
        System.exit(-999);
    }

    @Override
    protected synchronized boolean doWait() {
        while (this.waitingTime > 0L) {
            try {
                this.wait(this.waitingTime);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.waitingTime = this.expirationTime - System.currentTimeMillis();
        }
        this.shutdown();
        return true;
    }

    private void shutdown() {
        if (RuntimeState.isActive() && !this.context.isUnloadInProgress()) {
            this.doShutdown();
        }
    }

    @Override
    public void stop() {
        if (!this.shutdownInProgress) {
            super.stop();
        }
    }
}

