/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime;

import com.streamscape.lib.numalloc.LongNumberAllocatorSimple;
import com.streamscape.sef.exchange.FabricAddress;
import java.net.InetAddress;
import java.net.UnknownHostException;

public class ContextId {
    private long uuid = UUID_ALLOCATOR.getNumber();
    private FabricAddress fabricAddress = FabricAddress.NULL;
    private InetAddress ipAddress = null;
    private static final LongNumberAllocatorSimple UUID_ALLOCATOR = new LongNumberAllocatorSimple();

    public ContextId() {
    }

    public ContextId(FabricAddress address) {
        this.acquire(address);
    }

    public void acquire(FabricAddress address) {
        this.fabricAddress = address;
        this.ipAddress = this.getLocalIPAddress();
    }

    public void release() {
        this.fabricAddress = FabricAddress.NULL;
        this.ipAddress = null;
    }

    public long getUUID() {
        return this.uuid;
    }

    public InetAddress getIpAddress() {
        return this.ipAddress;
    }

    public FabricAddress getFabricAddress() {
        return this.fabricAddress;
    }

    public String toString() {
        return this.fabricAddress.toString() + ":" + this.uuid;
    }

    public boolean equals(Object other) {
        if (this != other) {
            if (other == null || !(other instanceof ContextId)) {
                return false;
            }
            ContextId otherId = (ContextId)other;
            return this.uuid == otherId.uuid;
        }
        return true;
    }

    public int hashCode() {
        return (int)this.uuid;
    }

    private InetAddress getLocalIPAddress() {
        try {
            return InetAddress.getLocalHost();
        }
        catch (UnknownHostException exception) {
            return null;
        }
    }
}

