/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.repository.types;

import com.streamscape.omf.java.SerialSupport;
import com.streamscape.sdo.CloneableDataObject;
import com.streamscape.sef.utils.SemanticTypeInfo;

public class SemanticType
extends CloneableDataObject {
    private String typeName = "";
    private String typeClass = "";
    private boolean typeIsVerified = false;
    private boolean sysType = false;
    private boolean typeIsInterface = false;
    private String typeAncestor = "object";
    private long serialVersionUID = 9969000000302071L;
    private boolean typeIsValid = true;
    private String description = "";
    private long timestamp = -1L;
    private transient boolean isDirty = false;
    private transient short serialId = (short)-1;
    private transient SerialSupport serialSupport;
    private transient SemanticTypeInfo info;

    public SemanticType(String name, String className) {
        this(name, className, false);
    }

    SemanticType(String name, String className, boolean isSysType) {
        this.typeName = name;
        this.typeClass = className;
        this.sysType = isSysType;
        if (!isSysType) {
            this.serialVersionUID = 0L;
        }
        this.touch();
    }

    public boolean isValid() {
        return this.typeIsValid;
    }

    void setValid(boolean isValid) {
        this.typeIsValid = isValid;
        if (isValid) {
            this.setSerialVersionUID(++this.serialVersionUID);
            this.setDirty(true);
        }
        this.touch();
    }

    public boolean isVerified() {
        return this.typeIsVerified;
    }

    void setVerified() {
        this.typeIsVerified = true;
        this.touch();
    }

    void setSerialVersionUID(long serialVersionUID) {
        this.serialVersionUID = serialVersionUID;
        this.touch();
    }

    @Override
    public long getSerialVersionUID() {
        return this.serialVersionUID;
    }

    public boolean isSystem() {
        return this.sysType;
    }

    public boolean isInterface() {
        return this.typeIsInterface;
    }

    public void setInterface(boolean isInterface) {
        this.typeIsInterface = isInterface;
        this.touch();
    }

    public void setAncestorType(String typeAncestor) {
        this.typeAncestor = typeAncestor;
        this.touch();
    }

    public String getAncestorType() {
        return this.typeAncestor;
    }

    public void setDescription(String description) {
        this.description = description;
        this.touch();
    }

    public String getDescription() {
        return this.description;
    }

    public String getClassName() {
        return this.typeClass;
    }

    void setClassName(String className) {
        this.typeClass = className;
        this.touch();
    }

    public String getTypeName() {
        return this.typeName;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public boolean isDirty() {
        return this.isDirty;
    }

    void setDirty(boolean isDirty) {
        this.isDirty = isDirty;
    }

    private void touch() {
        this.timestamp = System.currentTimeMillis();
    }

    public String toString() {
        return (this.isSystem() ? "sys." : "") + this.typeName + ".type";
    }

    @Override
    public SemanticType clone() {
        return (SemanticType)super.clone();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof SemanticType) {
            SemanticType otherType = (SemanticType)other;
            return this.typeName.equals(otherType.typeName) && this.typeClass.equals(otherType.typeClass) && this.sysType == otherType.sysType && this.typeIsValid == otherType.typeIsValid && this.serialVersionUID == otherType.serialVersionUID;
        }
        return false;
    }

    short getSerialId() {
        return this.serialId;
    }

    void setSerialId(short serialId) {
        this.serialId = serialId;
    }

    SerialSupport getSerialSupport() {
        return this.serialSupport;
    }

    void setSerialSupport(SerialSupport serialSupport) {
        this.serialSupport = serialSupport;
    }

    SemanticTypeInfo getInfo() {
        return this.info;
    }

    void setInfo(SemanticTypeInfo info) {
        this.info = info;
    }
}

