/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.repository.types;

import com.streamscape.lib.utils.StringUtils;
import com.streamscape.repository.types.TypeNamingException;
import com.streamscape.sdo.CloneableDataObject;

public class Prototype
extends CloneableDataObject {
    private String prototypeModel;
    private String prototypeInstance;
    private boolean isValid = true;
    private String error;
    private String payloadType;
    private transient String stringForm;

    public static Prototype parseName(String qualifiedName) throws TypeNamingException {
        return Prototype.parseName(qualifiedName, false);
    }

    public static Prototype parseName(String qualifiedName, boolean withExtension) throws TypeNamingException {
        String[] name = qualifiedName.split("\\.");
        if (withExtension && (name.length < 2 || name.length > 3) || !withExtension && name.length != 2) {
            throw new TypeNamingException("Invalid number of items in name '" + qualifiedName + "'.");
        }
        return new Prototype(name[0], name[1]);
    }

    public Prototype(String modelName, String instanceName) throws TypeNamingException {
        if (!StringUtils.validateSemanticName(modelName)) {
            throw new TypeNamingException("Invalid model name '" + modelName + "'.");
        }
        if (!StringUtils.validateSemanticName(instanceName)) {
            throw new TypeNamingException("Invalid instance name '" + instanceName + "'.");
        }
        this.prototypeModel = modelName;
        this.prototypeInstance = instanceName;
        this.setStringForm();
    }

    public String getModelName() {
        return this.prototypeModel;
    }

    public String getInstanceName() {
        return this.prototypeInstance;
    }

    public boolean isValid() {
        return this.isValid;
    }

    public String getError() {
        return this.error;
    }

    public String getPayloadType() {
        return this.payloadType;
    }

    void setError(String error, String payloadType) {
        this.isValid = error == null;
        this.error = error;
        this.payloadType = payloadType;
    }

    public String toString() {
        if (this.stringForm == null) {
            this.setStringForm();
        }
        return this.stringForm;
    }

    public static String toString(String modelName, String instanceName) {
        return modelName + "." + instanceName;
    }

    void setStringForm() {
        this.stringForm = Prototype.toString(this.prototypeModel, this.prototypeInstance);
    }

    public boolean equals(Object other) {
        return this == other || other instanceof Prototype && this.toString().equals(other.toString());
    }

    public int hashCode() {
        return this.toString().hashCode();
    }
}

