/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.repository.types;

import com.streamscape.Trace;
import com.streamscape.omf.java.SerialSupport;
import com.streamscape.repository.types.Prototype;
import com.streamscape.repository.types.SemanticType;
import com.streamscape.sdo.CloneableDataObject;
import com.streamscape.sdo.StructuredDataObject;
import com.streamscape.sdo.mf.admin.SemanticTypeFactoryException;
import com.streamscape.sef.utils.SemanticTypeInfo;
import com.streamscape.sef.utils.Utils;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;

public abstract class AbstractSemanticFactory
extends CloneableDataObject {
    protected static SemanticType createSemanticType(Class typeClass, boolean isSystem) {
        return AbstractSemanticFactory.createSemanticType(typeClass.getSimpleName(), typeClass, isSystem);
    }

    protected static SemanticType createSemanticType(String typeName, String className, boolean isSystem) {
        return new SemanticType(typeName, className, isSystem);
    }

    protected static SemanticType createSemanticType(String typeName, Class typeClass, boolean isSystem) {
        SemanticType result = AbstractSemanticFactory.createSemanticType(typeName, typeClass.getName(), isSystem);
        if (StructuredDataObject.class.isAssignableFrom(typeClass)) {
            result.setAncestorType("StructuredDataObject");
        }
        result.setInterface(typeClass.isInterface());
        return result;
    }

    protected static SemanticType createSemanticType(String typeName, StructuredDataObject object, boolean isSystem) {
        return AbstractSemanticFactory.createSemanticType(typeName, object.getClass(), isSystem);
    }

    protected static void setVerified(SemanticType semanticType) {
        semanticType.setVerified();
    }

    protected static void setSerialVersionUID(SemanticType semanticType, long serialVersionUID) {
        semanticType.setSerialVersionUID(serialVersionUID);
    }

    protected static void setValid(SemanticType type, boolean isValid) {
        type.setValid(isValid);
    }

    protected static void invalidatePrototype(Prototype prototype, String error, String payloadType) {
        prototype.setError(error, payloadType);
    }

    protected static void validatePrototype(Prototype prototype) {
        prototype.setError(null, null);
    }

    protected static short getSerialId(SemanticType type) {
        return type.getSerialId();
    }

    protected static void setSerialId(SemanticType type, short serialId) {
        type.setSerialId(serialId);
    }

    protected static SerialSupport getSerialSupport(SemanticType type) {
        return type.getSerialSupport();
    }

    protected static void setSerialSupport(SemanticType type, SerialSupport serialSupport) {
        type.setSerialSupport(serialSupport);
    }

    protected static void setClassName(SemanticType type, String className) {
        type.setClassName(className);
    }

    protected static SemanticTypeInfo getInfo(SemanticType type) {
        return type.getInfo();
    }

    protected static void setInfo(SemanticType type, SemanticTypeInfo info) {
        type.setInfo(info);
    }

    protected static void checkTypeExistence(String typeName, SemanticType type) throws SemanticTypeFactoryException {
        if (type == null) {
            AbstractSemanticFactory.throwFactoryException(5014, "Semantic type [" + typeName + "] does not exist.");
        }
    }

    protected static void throwTypeAlreadyExists(String typeName) throws SemanticTypeFactoryException {
        AbstractSemanticFactory.throwFactoryException(5013, "Semantic type [" + typeName + "] already exists.");
    }

    protected static void throwTypeAlreadyExists(String typeName, String className) throws SemanticTypeFactoryException {
        AbstractSemanticFactory.throwFactoryException(5015, "Semantic type [" + typeName + "] already exists for class '" + className + "'.");
    }

    protected static <T extends Throwable> void throwException(Class<T> objectClass, int errorCode, String message) throws T {
        throw (Throwable)AbstractSemanticFactory.createProtectedObject(objectClass, new Class[]{Integer.TYPE, String.class}, errorCode, message);
    }

    protected static <T extends Throwable> void throwException(Class<T> objectClass, int errorCode, Throwable cause) throws T {
        throw (Throwable)AbstractSemanticFactory.createProtectedObject(objectClass, new Class[]{Integer.TYPE, Throwable.class}, errorCode, cause);
    }

    protected static <T extends Throwable> void throwException(Class<T> objectClass, int errorCode, String message, Throwable cause) throws T {
        throw (Throwable)AbstractSemanticFactory.createProtectedObject(objectClass, new Class[]{Integer.TYPE, String.class, Throwable.class}, errorCode, message, cause);
    }

    protected static <T> T createProtectedObject(Class<T> objectClass, Class[] parameterTypes, Object ... parameters) {
        try {
            Constructor<T> constructor = objectClass.getDeclaredConstructor(parameterTypes);
            constructor.setAccessible(true);
            return constructor.newInstance(parameters);
        }
        catch (Exception exception) {
            Trace.logException(Utils.class, exception, true);
            return null;
        }
    }

    protected static Object invokeProtectedMethod(Object object, String methodName, Class[] parameterTypes, Object ... parameters) {
        try {
            Method method = object.getClass().getDeclaredMethod(methodName, parameterTypes);
            method.setAccessible(true);
            return method.invoke(object, parameters);
        }
        catch (Exception exception) {
            Trace.logException(Utils.class, exception, true);
            return null;
        }
    }

    protected static void throwFactoryException(int errorCode, String message) throws SemanticTypeFactoryException {
        AbstractSemanticFactory.throwException(SemanticTypeFactoryException.class, errorCode, message);
    }

    protected static void throwFactoryException(int errorCode, Throwable cause) throws SemanticTypeFactoryException {
        AbstractSemanticFactory.throwException(SemanticTypeFactoryException.class, errorCode, cause);
    }

    protected static void throwFactoryException(int errorCode, String message, Throwable cause) throws SemanticTypeFactoryException {
        AbstractSemanticFactory.throwException(SemanticTypeFactoryException.class, errorCode, message, cause);
    }
}

