/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.repository.pkg;

import com.streamscape.lib.utils.Pair;
import com.streamscape.omf.java.Utils;
import com.streamscape.repository.enums.PackageType;
import com.streamscape.sef.dispatcher.AbstractPackage;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.naming.NamingException;

public class Package
extends AbstractPackage {
    private String name = "";
    private PackageType type = PackageType.service;
    private String description = "";
    private int version = 1;
    private List<String> pkgCollectionJARs = new ArrayList<String>();
    private boolean packageDirty = false;
    private long timestamp = -1L;
    private Boolean global;
    private Boolean autoload;
    private List<String> dependencies;
    private static Pattern PACKAGE_PATTERN = Pattern.compile("(?i)([^\\.]+)\\.([^\\.]+)");

    protected Package() {
        this.touch();
    }

    protected Package(PackageType type, String name) {
        this.setType(type);
        this.setName(name);
    }

    private void setType(PackageType type) {
        this.type = type;
        this.touch();
    }

    public PackageType getType() {
        return this.type;
    }

    private void setName(String name) {
        this.name = name;
        this.touch();
    }

    public String getName() {
        return this.name;
    }

    public void setDescription(String description) {
        this.description = description;
        this.touch();
    }

    public String getDescription() {
        return this.description;
    }

    void setVersion(int version) {
        this.version = version;
        this.touch();
    }

    public int getVersion() {
        return this.version;
    }

    @Override
    protected void nextVersion() {
        ++this.version;
        this.touch();
    }

    public synchronized void addJAR(String jar) {
        if (!this.containsJAR(jar)) {
            this.pkgCollectionJARs.add(jar);
            this.touch();
        }
    }

    public synchronized void removeJAR(String jar) {
        if (this.pkgCollectionJARs.remove(jar)) {
            this.touch();
        }
    }

    public synchronized boolean containsJAR(String jar) {
        return this.pkgCollectionJARs.contains(jar);
    }

    public synchronized void clearJARs() {
        this.pkgCollectionJARs.clear();
        this.touch();
    }

    public synchronized List<String> listJARs() {
        return new ArrayList<String>(this.pkgCollectionJARs);
    }

    void setDirty(boolean dirty) {
        this.packageDirty = dirty;
        this.touch();
    }

    public boolean isValid() {
        return !this.packageDirty;
    }

    public static String getFullName(PackageType type, String name) {
        return String.valueOf((Object)type) + "." + name;
    }

    public String getFullName() {
        return Package.getFullName(this.type, this.name);
    }

    public static String getArtifactName(PackageType type, String name) {
        return Package.getFullName(type, name) + ".pkg";
    }

    public String getArtifactName() {
        return Package.getArtifactName(this.type, this.name);
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    private void touch() {
        this.timestamp = System.currentTimeMillis();
    }

    @Override
    protected void setGlobal() {
        this.setGlobal(Package.isAutoGlobal(this.type));
    }

    @Override
    protected void setGlobal(boolean global) {
        this.global = global;
    }

    @Override
    public boolean isGlobal() {
        return this.global != null && this.global != false;
    }

    @Override
    protected boolean isGlobalNotSet() {
        return this.global == null;
    }

    @Override
    protected boolean isGlobalNotMatch(Package other) {
        return this.global != other.global;
    }

    public static boolean isAutoGlobal(PackageType type) {
        return type == PackageType.sdo;
    }

    @Override
    public boolean isGeneric() {
        return Package.isGeneric(this.type);
    }

    public static boolean isGeneric(PackageType type) {
        return type == PackageType.sdo || type == PackageType.collection;
    }

    public boolean isReplicable() {
        return this.isGeneric() && this.isGlobal();
    }

    @Override
    protected void setAutoload(boolean autoload) {
        this.autoload = autoload;
    }

    @Override
    protected boolean isAutoloadNotSet() {
        return this.autoload == null;
    }

    @Override
    public boolean isAutoload() {
        return this.autoload != null && this.autoload != false;
    }

    public synchronized void addDependency(PackageType pkgType, String pkgName) {
        String pkgFullName;
        if (this.dependencies == null) {
            this.dependencies = new ArrayList<String>();
        }
        if (!this.containsDependency(pkgFullName = Package.getFullName(pkgType, pkgName))) {
            this.dependencies.add(pkgFullName);
            this.touch();
        }
    }

    public synchronized void removeDependency(String pkgFullName) {
        if (this.dependencies != null && this.dependencies.remove(pkgFullName)) {
            this.touch();
        }
    }

    public synchronized boolean containsDependency(String pkgFullName) {
        return this.dependencies != null && this.dependencies.contains(pkgFullName);
    }

    public synchronized void clearDependencies() {
        if (this.dependencies != null) {
            this.dependencies.clear();
            this.touch();
        }
    }

    public synchronized List<String> listDependencies() {
        return this.dependencies != null ? new ArrayList<String>(this.dependencies) : new ArrayList();
    }

    public String toString() {
        return this.getFullName();
    }

    @Override
    protected void update(Package other) {
        this.description = other.description;
        this.pkgCollectionJARs = other.pkgCollectionJARs != null ? new ArrayList<String>(other.pkgCollectionJARs) : null;
        ArrayList<String> arrayList = this.dependencies = other.dependencies != null ? new ArrayList<String>(other.dependencies) : null;
        if (other.global != null) {
            this.global = other.global;
        }
        if (other.autoload != null) {
            this.autoload = other.autoload;
        }
        this.nextVersion();
    }

    @Override
    public Package clone() {
        Package result = (Package)super.clone();
        result.pkgCollectionJARs = this.pkgCollectionJARs != null ? (ArrayList)((ArrayList)this.pkgCollectionJARs).clone() : null;
        result.dependencies = this.dependencies != null ? (ArrayList)((ArrayList)this.dependencies).clone() : null;
        return result;
    }

    public boolean equals(Object other) {
        return this == other || other instanceof Package && this.type.equals((Object)((Package)other).type) && this.name.equals(((Package)other).name);
    }

    public boolean equalsFully(Package other) {
        return this.equals(other) && this.version == other.version && Utils.equalsNullSafe(this.description, other.description) && Utils.equalsNullSafe(this.pkgCollectionJARs, other.pkgCollectionJARs) && Utils.equalsNullSafe(this.global, other.global) && Utils.equalsNullSafe(this.autoload, other.autoload) && Utils.equalsNullSafe(this.dependencies, other.dependencies);
    }

    public static Pair<PackageType, String> parseFullName(String fullName) throws NamingException {
        Matcher matcher = PACKAGE_PATTERN.matcher(fullName);
        if (!matcher.find()) {
            throw new NamingException("Package name '" + fullName + "' is invalid.");
        }
        return new Pair<PackageType, String>(PackageType.valueOf(matcher.group(1)), matcher.group(2));
    }

    public static Package create(PackageType type, String name) {
        return Package.create(type, name, null, null);
    }

    public static Package create(PackageType type, String name, String jarName) {
        Package result = Package.create(type, name);
        result.addJAR(jarName);
        return result;
    }

    public static Package create(PackageType type, String name, Boolean autoload, Boolean global) {
        Package result = new Package(type, name);
        result.setAutoload(autoload == null || autoload != false);
        if (global != null) {
            result.setGlobal(global);
        } else if (result.isGeneric()) {
            result.setGlobal();
        }
        return result;
    }
}

