/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.repository.pkg;

import com.streamscape.repository.RepositoryException;
import com.streamscape.repository.enums.PackageType;
import com.streamscape.repository.pkg.Package;
import com.streamscape.repository.types.SemanticType;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.util.List;

public interface IPackageRepository {
    public static final boolean DIRTY = true;
    public static final boolean CLEAN = false;

    public void initPackageRepository() throws RepositoryException;

    public void clearPackageRepository() throws RepositoryException;

    public boolean existsPackage(PackageType var1, String var2) throws RepositoryException;

    public List<String> listPackagesByType(PackageType var1) throws RepositoryException;

    public List<String> listPackages() throws RepositoryException;

    public void removePackage(PackageType var1, String var2, boolean var3) throws RepositoryException;

    public void importPackage(String var1, PackageType var2, String var3) throws RepositoryException;

    public void exportPackage(String var1, PackageType var2, String var3) throws RepositoryException;

    public void savePackage(Package var1) throws RepositoryException;

    public void savePackage(Package var1, File[] var2) throws RepositoryException;

    public void updatePackage(Package var1) throws RepositoryException;

    public Package loadPackage(PackageType var1, String var2) throws RepositoryException;

    public boolean existsArchive(String var1) throws RepositoryException;

    public boolean existsExtensionArchive(String var1) throws RepositoryException;

    public Package addArchive(File var1) throws RepositoryException;

    public Package addArchive(String var1, byte[] var2) throws RepositoryException;

    public List<SemanticType> addExtensionArchive(File var1) throws RepositoryException;

    public List<SemanticType> addExtensionArchive(String var1, byte[] var2) throws RepositoryException;

    public Package removeArchive(String var1) throws RepositoryException;

    public List<SemanticType> removeExtensionArchive(String var1, boolean var2) throws RepositoryException;

    public byte[] getArchive(String var1) throws RepositoryException;

    public InputStream getArchiveStream(String var1) throws RepositoryException;

    public URL getArchiveURL(String var1) throws RepositoryException;

    public List<URL> getArchiveURLs() throws RepositoryException;

    public byte[] getExtensionArchive(String var1) throws RepositoryException;

    public URL getExtensionArchiveURL(String var1) throws RepositoryException;

    public List<URL> getExtensionArchiveURLs() throws RepositoryException;

    public List<String> listArchives() throws RepositoryException;

    public List<String> listExtensionArchives() throws RepositoryException;
}

