/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.repository.object;

import com.streamscape.Trace;
import com.streamscape.lib.utils.StringUtils;
import java.io.File;
import java.util.Arrays;
import java.util.StringTokenizer;
import javax.naming.NamingException;

public class ReferenceContext {
    public static ReferenceContext ROOT;
    public static ReferenceContext NULL;
    private ReferenceContext parent = null;
    private String ctxName = "/";
    private byte[] refObject = null;

    public ReferenceContext(ReferenceContext parentContext, String ctxNamespace) throws NamingException {
        if (parentContext != null && ctxNamespace != null) {
            StringTokenizer ns = new StringTokenizer(ctxNamespace = ctxNamespace.replace(File.separator, "/"), "/");
            if (ns.countTokens() == 1) {
                String nsName = ns.nextToken();
                if (!StringUtils.validateString(nsName)) {
                    throw new NamingException("Name space element contains invalid characters '" + nsName + "'.");
                }
                this.parent = parentContext;
                this.ctxName = nsName;
            } else {
                String nsName = ns.nextToken();
                if (!StringUtils.validateString(nsName)) {
                    throw new NamingException("Name space element contains invalid characters '" + nsName + "'.");
                }
                ReferenceContext ctx = new ReferenceContext(parentContext, nsName);
                while (ns.hasMoreTokens()) {
                    nsName = ns.nextToken();
                    if (!StringUtils.validateString(nsName)) {
                        throw new NamingException("Name space contains invalid characters '" + ctxNamespace + "'.");
                    }
                    ctx = new ReferenceContext(ctx, nsName);
                }
                this.parent = ctx.getParentContext();
                this.ctxName = ctx.getContextName();
            }
        }
    }

    public boolean isRoot() {
        return this.parent == null;
    }

    public String getContextName() {
        return this.ctxName;
    }

    public ReferenceContext getParentContext() {
        return this.parent;
    }

    public String getContextNameSpace() {
        if (this.getContextName().equals("/")) {
            return this.getContextName();
        }
        StringBuffer ctxNameSpace = new StringBuffer();
        ReferenceContext ctx = this;
        while (ctx.getParentContext() != null) {
            ctxNameSpace.insert(0, "/" + ctx.getContextName());
            ctx = ctx.getParentContext();
        }
        return ctxNameSpace.toString();
    }

    public byte[] getRefObject() {
        return new byte[0];
    }

    public void setRefObject(byte[] ref) {
        this.refObject = ref;
    }

    public String toString() {
        return this.getContextNameSpace();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof ReferenceContext) {
            ReferenceContext otherContext = (ReferenceContext)other;
            return this.equals(this.ctxName, otherContext.ctxName) && this.equals(this.parent, otherContext.parent) && Arrays.equals(this.refObject, otherContext.refObject);
        }
        return false;
    }

    private boolean equals(Object str1, Object str2) {
        return str1 != null ? str1.equals(str2) : str2 == null;
    }

    public int hashCode() {
        int result = this.parent != null ? this.parent.hashCode() : 0;
        result = 31 * result + (this.ctxName != null ? this.ctxName.hashCode() : 0);
        result = 31 * result + (this.refObject != null ? Arrays.hashCode(this.refObject) : 0);
        return result;
    }

    static {
        try {
            ROOT = new ReferenceContext(null, "/");
            NULL = new ReferenceContext(null, null);
        }
        catch (NamingException e) {
            Trace.logException(ReferenceContext.class, e, true);
            Trace.logError(ReferenceContext.class, "INTERNAL ERROR");
        }
    }
}

