/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.repository.namespace;

import com.streamscape.lib.utils.StringUtils;
import com.streamscape.repository.namespace.IEntityName;
import com.streamscape.repository.object.ReferenceContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import javax.naming.InvalidNameException;
import javax.naming.Name;

public class EntityName
implements IEntityName {
    private List<String> components = new ArrayList<String>();
    private ReferenceContext context;

    public EntityName() {
        this.context = ReferenceContext.NULL;
    }

    public EntityName(String s) throws InvalidNameException {
        if (s.length() > 0) {
            for (String comp : s.split("\\.")) {
                this.checkComponentName(comp);
                this.components.add(comp);
            }
        }
        this.context = ReferenceContext.NULL;
    }

    public EntityName(ReferenceContext context, String s) throws InvalidNameException {
        this(s);
        this.context = context;
    }

    private void checkComponentName(String component) throws InvalidNameException {
        if (component.contains(".") || component.contains("/")) {
            throw new InvalidNameException("'.' and '/' characters are not allowed in component name: '" + component + "'");
        }
    }

    @Override
    public EntityName add(int position, String component) throws InvalidNameException {
        this.checkComponentName(component);
        this.components.add(position, component);
        return this;
    }

    @Override
    public EntityName add(String component) throws InvalidNameException {
        this.checkComponentName(component);
        this.components.add(component);
        return this;
    }

    @Override
    public EntityName addAll(Name suffix) throws InvalidNameException {
        if (suffix instanceof IEntityName && !((IEntityName)suffix).getReferenceContext().equals(ReferenceContext.NULL)) {
            throw new InvalidNameException("Addition of entity names with non-empty reference context is not supported");
        }
        for (int i = 0; i < suffix.size(); ++i) {
            String comp = suffix.get(i);
            this.checkComponentName(comp);
            this.components.add(comp);
        }
        return this;
    }

    @Override
    public EntityName addAll(int position, Name n) throws InvalidNameException {
        if (n instanceof IEntityName && !((IEntityName)n).getReferenceContext().equals(ReferenceContext.NULL)) {
            throw new InvalidNameException("Addition of entity names with non-empty reference context is not supported");
        }
        for (int i = 0; i < n.size(); ++i) {
            String comp = n.get(i);
            this.checkComponentName(comp);
            this.components.add(position, comp);
            ++position;
        }
        return this;
    }

    @Override
    public int compareTo(Object o) {
        if (o instanceof IEntityName) {
            return this.compareTo((IEntityName)o);
        }
        throw new ClassCastException("Not a IEntityName");
    }

    @Override
    public int compareTo(IEntityName o) {
        if (this.context.equals(o.getReferenceContext())) {
            int len1 = this.components.size();
            int len2 = o.size();
            int len = Math.min(len1, len2);
            for (int i = 0; i < len; ++i) {
                String comp2;
                String comp1 = this.components.get(i);
                int result = comp1.compareTo(comp2 = o.get(i));
                if (result == 0) continue;
                return result;
            }
            return len1 - len2;
        }
        return this.context.getContextNameSpace().compareTo(o.getReferenceContext().getContextNameSpace());
    }

    @Override
    public boolean endsWith(Name n) {
        if (n instanceof IEntityName && !((IEntityName)n).getReferenceContext().equals(ReferenceContext.NULL)) {
            return this.context.getContextNameSpace().endsWith(((IEntityName)n).getReferenceContext().getContextNameSpace()) && this.equals(n);
        }
        if (n.size() <= this.components.size()) {
            int i = this.components.size() - 1;
            for (int j = n.size() - 1; j >= 0; --j) {
                if (!this.components.get(i).equals(n.get(j))) {
                    return false;
                }
                --i;
            }
            return true;
        }
        return false;
    }

    @Override
    public String get(int position) {
        return this.components.get(position);
    }

    @Override
    public List<String> getAllAsList() {
        return Collections.unmodifiableList(this.components);
    }

    @Override
    public Enumeration<String> getAll() {
        return Collections.enumeration(this.components);
    }

    @Override
    public EntityName getPrefix(int position) {
        EntityName result = new EntityName();
        result.context = this.context;
        for (int i = 0; i < position; ++i) {
            result.components.add(this.components.get(i));
        }
        return result;
    }

    @Override
    public EntityName getSuffix(int position) {
        EntityName result = new EntityName();
        for (int i = position; i < this.components.size(); ++i) {
            result.components.add(this.components.get(i));
        }
        return result;
    }

    @Override
    public boolean isEmpty() {
        return this.components.isEmpty();
    }

    @Override
    public String remove(int position) throws InvalidNameException {
        return this.components.remove(position);
    }

    @Override
    public int size() {
        return this.components.size();
    }

    @Override
    public boolean startsWith(Name n) {
        if (n instanceof IEntityName && !this.context.getContextNameSpace().startsWith(((IEntityName)n).getReferenceContext().getContextNameSpace())) {
            return false;
        }
        if (n.size() <= this.components.size()) {
            for (int i = 0; i < n.size(); ++i) {
                if (this.components.get(i).equals(n.get(i))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public ReferenceContext getReferenceContext() {
        return this.context;
    }

    @Override
    public String getType() {
        return StringUtils.deNormalizeObjectName(this.components.size() > 0 ? this.components.get(0) : "");
    }

    @Override
    public String getName() {
        return StringUtils.deNormalizeObjectName(this.components.size() > 2 ? this.components.get(1) : this.getType());
    }

    @Override
    public String getExtension() {
        return this.components.size() > 1 ? this.components.get(this.components.size() - 1) : "";
    }

    @Override
    public String getFullName() {
        int i;
        StringBuffer s = new StringBuffer();
        for (i = 0; i < this.components.size() - 1; ++i) {
            s.append(this.components.get(i));
            s.append('.');
        }
        if (i < this.components.size()) {
            s.append(this.components.get(i));
        }
        return s.toString();
    }

    public String toString() {
        return (String)(this.getReferenceContext().equals(ReferenceContext.NULL) ? "" : (this.getReferenceContext().equals(ReferenceContext.ROOT) ? "/" : this.getReferenceContext().getContextNameSpace() + "/")) + this.getFullName();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EntityName that = (EntityName)o;
        if (this.context != null ? !this.context.equals(that.context) : that.context != null) {
            return false;
        }
        return !(this.components != null ? !this.components.equals(that.components) : that.components != null);
    }

    public int hashCode() {
        int result = this.components != null ? this.components.hashCode() : 0;
        result = 31 * result + (this.context != null ? this.context.hashCode() : 0);
        return result;
    }

    @Override
    public Object clone() {
        EntityName result = new EntityName();
        result.context = this.context;
        result.components = new ArrayList<String>();
        result.components.addAll(this.components);
        return result;
    }
}

